/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.IOrientable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.geom.Inter2D;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;

public class OccTarget
extends NamedMerlinObj
implements Serializable,
IEgressObj,
IOrientable,
ISurrogate {
    private static final long serialVersionUID = 1L;
    public static final TopologyProp<Point3d> LOCATION = new TopologyProp<Point3d>(128448899, new Point3d(0.0, 0.0, 0.0));
    public static final IPropertySet.Prop<Vector3d> ROOM_NORMAL = new IPropertySet.Prop<Vector3d>(92873722, new Vector3d(0.0, 0.0, 1.0));
    public static final IPropertySet.Prop<UnitDouble> RADIUS = new IPropertySet.Prop<UnitDouble>(199365103, new UnitDouble(0.5, SI.METER));
    public static final IPropertySet.Prop<UnitDouble> ORIENT = new IPropertySet.Prop<UnitDouble>(37401378, new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
    public static final IPropertySet.Prop<Double> PRIORITY = new IPropertySet.Prop<Double>(121055651, 0.0);
    public static final Set<Object> PROPS = Sets.appendLHS(new LinkedHashSet(IPropertySet.getAllDeclaredPublicStaticProps(OccTarget.class)), NamedMerlinObj.NAME, MerlinData.VISIBILITY, MerlinData.ENABLED);
    @SkipDep
    private transient IEgressOccupiable d_room;
    private PropertySet d_props = new PropertySet();
    private boolean d_visible = true;
    private boolean d_enabled = true;

    public OccTarget(String name) {
        super(name);
    }

    @Override
    public OccTarget clone() {
        OccTarget clone = (OccTarget)super.clone();
        clone.d_props = this.d_props.clone();
        clone.d_room = null;
        return clone;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof OccTarget)) {
            return;
        }
        OccTarget a = (OccTarget)obj;
        this.pauseUpdates();
        this.setName(a.getName());
        this.d_props = a.d_props;
        this.d_room = a.d_room;
        this.d_enabled = a.d_enabled;
        this.d_visible = a.d_visible;
        this.changedEvt(MerlinData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        OccTarget ol = (OccTarget)comparable;
        return this.getName().equals(ol.getName()) && this.get(LOCATION).equals(ol.get(LOCATION)) && this.get(ORIENT).equals(ol.get(ORIENT)) && this.get(RADIUS).equals(ol.get(RADIUS)) && this.get(PRIORITY).equals(ol.get(PRIORITY));
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROPS;
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.pauseUpdates();
            if (prop instanceof TopologyProp) {
                this.changedEvt(MerlinData.TOPOLOGY);
            }
            this.changedEvt(prop);
            this.resumeUpdates();
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL, MerlinData.TOPOLOGY);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room != null ? Collections.singleton(this.d_room) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.pauseUpdates();
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public boolean updateTopo() {
        Point3d loc = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(loc.x, loc.y, loc.z + 1.0E-6), new Point3d(loc.x, loc.y, loc.z - 1.0E-6), 1);
        if (room != null) {
            this.pauseUpdates();
            this.d_room = room.room;
            this.set(ROOM_NORMAL, room.faceNormal);
            loc = room.p;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
        return true;
    }

    @Override
    public void setOrientTarget(Point3d target) {
        this.setOrient(GeomUtil.getOccOrient(this.get(LOCATION), target));
    }

    @Override
    public void setOrient(UnitDouble angle) {
        this.set(ORIENT, angle);
    }

    @Override
    public Point3d astarGetTestPoint() {
        return this.get(LOCATION);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.get(LOCATION);
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.get(LOCATION);
    }

    public void setLocation(IEgressOccupiable room, Vector3d roomNormal, Point3d loc) {
        if (loc.equals(this.d_props.get(LOCATION)) && roomNormal.equals(this.d_props.get(ROOM_NORMAL)) && this.d_room == room) {
            return;
        }
        this.d_props.set(LOCATION, loc);
        this.d_props.set(ROOM_NORMAL, roomNormal);
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(new Object[0]);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getTargetGeom());
    }

    private OccTargetGeometry getTargetGeom() {
        return new OccTargetGeometry(this.d_room, this.get(ROOM_NORMAL), this.get(LOCATION), this.get(RADIUS).getValue(Geometry.LENGTH_UNIT), this.get(ORIENT).getValue(Geometry.ANGLE_UNIT));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof OccTargetGeometry) {
            OccTargetGeometry wgeom = (OccTargetGeometry)geom;
            this.pauseUpdates();
            this.set(RADIUS, new UnitDouble(wgeom.radius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.set(ORIENT, new UnitDouble(wgeom.orient, Geometry.ANGLE_UNIT));
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.set(LOCATION, p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IGeomNode geom = this.getGeom();
        IMerlinDispProps dprops = (IMerlinDispProps)props;
        PropsBuilder gprops = new PropsBuilder();
        IPrimProps edgeProps = dprops.getEdgeProps(this, IMerlinDispProps.EgressType.OCC_TARGET, null, 1.0f);
        gprops.add(edgeProps);
        gprops.add(dprops.getFaceProps(this, IMerlinDispProps.EgressType.OCC_TARGET, null, null, 1.0f));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        gprops.add(edgeProps);
        return new DisplayGeom(geom, gprops);
    }

    private static LineSeg getOrientGeom(Point3d location, double angle, double length) {
        Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
        Inter.rotateTuple2D(orient, angle, new Point3d(0.0, 0.0, 0.0));
        orient.scale(length);
        orient.add(location);
        Point3d orientPoint = new Point3d(orient);
        return new LineSeg(location, orientPoint);
    }

    public static class OrientHandle
    implements IHandle {
        private OccTargetGeometry d_geom;
        private final double handleLength = 1.0;

        public OrientHandle(OccTargetGeometry geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof OrientHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(OccTarget.getOrientGeom(this.d_geom.location, this.d_geom.orient, 1.0));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(new Plane3d(this.d_geom.normal, this.d_geom.location));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public OccTargetGeometry modify(Point3d newLoc) throws ManipException {
            Point3d agentLoc = this.d_geom.location;
            Point3d agentOrient = new Point3d(agentLoc);
            agentOrient.add(new Point3d(1.0, 0.0, 0.0));
            double newAngle = Inter2D.getAngle(agentLoc, agentOrient, newLoc);
            this.d_geom = new OccTargetGeometry(this.d_geom.room, this.d_geom.normal, this.d_geom.location, this.d_geom.radius, newAngle);
            return this.d_geom;
        }

        @Override
        public OccTargetGeometry end() {
            return this.d_geom;
        }
    }

    public static class OccTargetGeometry
    extends GeomUtil.ACircleGeometry {
        private static final long serialVersionUID = -5574029433922814496L;
        public final double orient;

        public OccTargetGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double arriveRadius, double orient) {
            super(room, normal, location, arriveRadius, true, OccTarget.getOrientGeom(location, orient, 1.0));
            this.orient = orient;
        }

        @Override
        protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double newRadius) {
            if (find == null) {
                return new OccTargetGeometry(null, GeomConstants.VEC3D_ZPOS, newLoc, newRadius, this.orient);
            }
            return new OccTargetGeometry(find.room, find.faceNormal, newLoc, newRadius, this.orient);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new OrientHandle(this), new GeomUtil.LocationHandle(this));
        }

        @Override
        public GeomUtil.ACircleGeometry getConstructedTransform(IEgressOccupiable room, Vector3d normal, Point3d location, double radius) {
            return new OccTargetGeometry(room, normal, location, radius, this.orient);
        }
    }

    public static class TopologyProp<T>
    extends IPropertySet.Prop<T> {
        public TopologyProp(Object key, T defVal) {
            super(key, defVal);
        }
    }
}

