/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import merlin.data.MerlinData;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.LinkedIdentityHashSet;

public class EgressTopology {
    private static final boolean DEBUG_PROGRESS = false;
    private final MerlinData d_domain;
    private final boolean d_enabled;
    private Set<IEgressObj> d_adds;
    private Set<IEgressObj> d_changes;
    private Set<IEgressObj> d_removes;
    private boolean d_updateLock = false;

    public EgressTopology(MerlinData domain, boolean enabled) {
        this.d_domain = domain;
        this.d_enabled = enabled;
        this.reset();
    }

    public synchronized void add(IEgressObj obj) {
        if (!this.d_enabled) {
            return;
        }
        if (!this.d_removes.remove(obj)) {
            this.d_adds.add(obj);
        } else {
            this.changed(obj);
        }
    }

    public synchronized void remove(IEgressObj obj) {
        if (!this.d_enabled) {
            return;
        }
        if (!this.d_adds.remove(obj)) {
            this.d_changes.remove(obj);
            this.d_removes.add(obj);
        }
    }

    public synchronized void changed(IEgressObj obj) {
        if (!this.d_enabled) {
            return;
        }
        if (!this.d_adds.contains(obj) && !this.d_removes.contains(obj)) {
            this.d_changes.add(obj);
        }
    }

    private void markDirty(IEgressObj obj) {
        for (IEgressObj iEgressObj : obj.getConnections()) {
            iEgressObj.disconnectFrom(obj);
            obj.disconnectFrom(iEgressObj);
        }
    }

    private static boolean isDescendent(Class<?> type, Class<?>[] types) {
        for (Class<?> parent : types) {
            if (!parent.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return !this.d_adds.isEmpty() || !this.d_changes.isEmpty() || !this.d_removes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() {
        if (this.d_updateLock || !this.isDirty()) {
            return;
        }
        this.d_updateLock = true;
        this.d_domain.pauseUpdates();
        try {
            ArrayList<IEgressObj> added = new ArrayList<IEgressObj>(this.d_adds);
            ArrayList<IEgressObj> changed = new ArrayList<IEgressObj>(this.d_changes);
            ArrayList<IEgressObj> removed = new ArrayList<IEgressObj>(this.d_removes);
            for (IEgressObj add : added) {
                this.markDirty(add);
            }
            for (IEgressObj changedObj : changed) {
                this.markDirty(changedObj);
            }
            for (IEgressObj remove : removed) {
                for (IEgressObj iEgressObj : remove.getConnections()) {
                    iEgressObj.disconnectFrom(remove);
                }
            }
            LinkedIdentityHashSet<IEgressObj> dirtyObjs = new LinkedIdentityHashSet<IEgressObj>();
            dirtyObjs.addAll(added);
            dirtyObjs.addAll(changed);
            if (!dirtyObjs.isEmpty()) {
                this.d_domain.updateSearches();
                Set<PotentialConn> potConns = this.findPotentialConns(dirtyObjs);
                this.makeConnections(potConns);
            }
            this.reset();
        }
        finally {
            this.d_domain.resumeUpdates();
            this.d_updateLock = false;
        }
    }

    private void reset() {
        this.d_adds = new LinkedIdentityHashSet<IEgressObj>();
        this.d_changes = new LinkedIdentityHashSet<IEgressObj>();
        this.d_removes = new LinkedIdentityHashSet<IEgressObj>();
    }

    private Set<PotentialConn> findPotentialConns(Set<IEgressObj> dirtyObjs) {
        LinkedHashSet<PotentialConn> potConns = new LinkedHashSet<PotentialConn>();
        for (IEgressObj dirtyObj : dirtyObjs) {
            this.findPotentialConns(dirtyObj, potConns);
        }
        return potConns;
    }

    private void findPotentialConns(final IEgressObj obj, final Set<PotentialConn> potConns) {
        AABox searchBox = obj.getBounds();
        final Class[] topoTypes = obj.getTopoTypes();
        AABoxTest test = new AABoxTest(searchBox, 1.0E-6);
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src != obj && EgressTopology.isDescendent(src.getClass(), topoTypes) && ((IEgressObj)src).hasOpenSpots(obj.getClass())) {
                    potConns.add(new PotentialConn(obj, (IEgressObj)src));
                }
            }
        };
        this.d_domain.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        if (EgressTopology.isDescendent(EgressAgent.class, topoTypes)) {
            this.d_domain.agentOverlapDetector.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        }
    }

    private void makeConnections(Set<PotentialConn> potConns) {
        LinkedIdentityHashSet updateObjs = new LinkedIdentityHashSet(potConns.size() * 2);
        for (PotentialConn potConn : potConns) {
            updateObjs.add(potConn.obj1);
            updateObjs.add(potConn.obj2);
        }
        boolean counter = false;
        for (IEgressObj obj : updateObjs) {
            if (!obj.updateTopo()) continue;
            for (IEgressObj iEgressObj : obj.getConnections()) {
                if (iEgressObj == null) continue;
                iEgressObj.connectTo(obj);
            }
        }
    }

    private static final class PotentialConn {
        public final IEgressObj obj1;
        public final IEgressObj obj2;

        public PotentialConn(IEgressObj o1, IEgressObj o2) {
            this.obj1 = o1;
            this.obj2 = o2;
        }

        public int hashCode() {
            return this.obj1.hashCode() + this.obj2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PotentialConn)) {
                return false;
            }
            PotentialConn c1 = (PotentialConn)obj;
            return this.obj1 == c1.obj1 && this.obj2 == c1.obj2 || this.obj1 == c1.obj2 && this.obj2 == c1.obj1;
        }
    }
}

