/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.BackupHandler;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.DisplayFilter;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.JsonGroup;
import merlin.data.MeasurementRegions;
import merlin.data.MerlinHierarchy;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Proxies;
import merlin.data.RestorableProperties;
import merlin.data.SeqOccNameGen;
import merlin.data.SequentialNameGen;
import merlin.data.SimParams;
import merlin.data.ViewProps;
import merlin.data.camera.CameraList;
import merlin.data.egress.EgressTopology;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.FloorSort;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.IOccNameGen;
import merlin.data.egress.agents.OccAreaMgr;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.OccTargetComp;
import merlin.data.egress.agents.OccupancySpec;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.data.egress.elevators.ElevatorRoot;
import merlin.data.egress.geom.EgressBlockage;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.RoomUtil;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.material.Material;
import merlin.data.material.MaterialDB;
import merlin.data.scripting.ScriptGroup;
import merlin.events.EventUtil;
import merlin.events.NonModifyingEvent;
import merlin.geom.AgentOverlapDetector;
import merlin.geom.GeomLocation;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.guiUtil;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.util.BitOptions;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TaskProgress;

public class MerlinData
extends Mediator
implements Serializable,
IMerlinObj {
    public static final long serialVersionUID = 1L;
    public static final boolean PROFILE_EVENTS = false;
    public static final Object MODEL_RESET = "MODEL_RESET";
    public static final Object MODEL_LOADED = "MODEL_LOADED";
    public static final Object MODEL_BACKUP_RESTORED = "MODEL_BACKUP_RESTORED";
    public static final Object MODEL_SAVED = "MODEL_SAVED";
    public static final Object MODIFIED_CHANGED = "MODIFIED_CHANGED";
    public static final Object SELECTION_CHANGED = new NonModifyingEvent("SELECTION_CHANGED");
    public static final Object MESH_CHANGED = "MESH_CHANGED";
    public static final Object VISIBILITY = "VISIBILITY";
    public static final Object CHILD_REMOVED = "CHILD_REMOVED";
    public static final Object CHILDREN_CHANGED = "CHILDREN_CHANGED";
    public static final Object CHILD_ADDED = "CHILD_ADDED";
    public static final Object PARENT_CHANGED = "PARENT_CHANGED";
    public static final Object UNITSYSTEM_CHANGED = new NonModifyingEvent("UNITSYSTEM_CHANGED");
    public static final Object SIM_PARAMS_CHANGED = "SIM_PARAMS_CHANGED";
    public static final Object PREFS_CHANGED = new NonModifyingEvent("PREFS_CHANGED");
    public static final Object COLOR = "MerlinData.COLOR";
    public static final Object OPACITY = "MerlinData.OPACITY";
    public static final IPropertySet.Prop<IMaterial[]> MATERIAL = new IPropertySet.Prop<IMaterial[]>("MATERIAL", new IMaterial[0]);
    public static final Object TOPOLOGY = "TOPOLOGY";
    public static final Object CONNECTION = "CONNECTION";
    public static final Object ENABLED = "ENABLED";
    public transient String filename = null;
    public transient boolean modified = false;
    private final transient IEventObserver d_modifiedListener = new ModifiedListener();
    public GeomComposite<ICompElement> sceneGeom = new GeomComposite(Intl.intl("Imported Geometry"));
    public FloorComposite floors = new FloorComposite();
    public OccProfileComp profiles = new OccProfileComp();
    public VehicleShapeComp vehicleShapes = new VehicleShapeComp();
    public AssistedEvacTeamComp assistedEvacTeams = new AssistedEvacTeamComp();
    public EgressAgentComp agents = new EgressAgentComp(Intl.intl("Occupants"));
    public BehaviorRoot behaviors = new BehaviorRoot();
    public QueueObjectComp queues = new QueueObjectComp();
    public ElevatorRoot elevators = new ElevatorRoot();
    public CameraList cameras = new CameraList(Intl.intl("Views"));
    public JsonGroup json = new JsonGroup("");
    public ScriptGroup customScripts = new ScriptGroup("");
    public MeasurementRegions regions = new MeasurementRegions(Intl.intl("Measurement Regions"));
    public OccSourceObj.OccSourceComp occSources = new OccSourceObj.OccSourceComp();
    public OccGroupObj.OccGroupComp occGroups = new OccGroupObj.OccGroupComp();
    public OccGroupTypeObj.OccGroupTypeComp occGroupTypes = new OccGroupTypeObj.OccGroupTypeComp();
    public AttractorComp attractors = new AttractorComp();
    @Deprecated
    public OccTargetComp occLocations = new OccTargetComp();
    public OccTargetComp occTargets = new OccTargetComp();
    public OccAreaMgr occAreas = new OccAreaMgr();
    public final int defaultOccSpacing = 1;
    public final IOccCount defaultOccCount = new ConstOccCount(0);
    public final FloorSort floorSortOptions;
    public final ViewProps viewProps;
    public final RestorableProperties actionProps;
    public INameGenerator roomNameGen;
    public INameGenerator doorNameGen;
    public INameGenerator stairNameGen;
    public INameGenerator rampNameGen;
    public INameGenerator blockageNameGen;
    public IOccNameGen occNameGen;
    public SequentialNameGen profNameGen;
    public INameGenerator vehicleShapeNameGen;
    public INameGenerator assistedEvacTeamNameGen;
    public INameGenerator cameraNameGen;
    public INameGenerator cameraTourNameGen;
    public INameGenerator densityNameGen;
    public INameGenerator occSourceNameGen;
    public INameGenerator occGroupNameGen;
    public INameGenerator occGroupTypeNameGen;
    public INameGenerator customScriptNameGen;
    public INameGenerator queueObjectNameGen;
    public INameGenerator queueServiceNameGen;
    public INameGenerator queuePathNameGen;
    public INameGenerator attractorsNameGen;
    public INameGenerator behaviorNameGen;
    public INameGenerator occTargetsNameGen;
    public MerlinSelectionModel selection = new MerlinSelectionModel();
    public transient MerlinHierarchy hierarchy = new MerlinHierarchy();
    public Proxies proxies = new Proxies();
    public SimParams simParams = new SimParams();
    public MaterialDB materials;
    public final transient GeomLocation geomLocation;
    public final transient AgentOverlapDetector agentOverlapDetector;
    public final transient EgressTopology topology;
    public final transient DisplayFilter displayFilter;
    public final transient ModelBackup backup = new ModelBackup("Pathfinder", "pth", new BackupHandler());
    private transient BackupEvtListener d_backupListener;
    private transient UnitSystem d_unitSystem;
    private int d_unitSystemInt = 0;
    private final transient ReadWriteLock d_lock = new ReentrantReadWriteLock();
    public static final int FOPT_SUPPRESS_BOUNDARIES = 2;
    public static final int FOPT_ATTACHED_POSITIONS = 4;
    public static final int FOPT_VISIBLE_GEOM_ONLY = 8;

    public MerlinData(boolean autosave) {
        this(autosave, true);
    }

    public MerlinData(boolean autosave, boolean topologyEnabled) {
        this.setEvents(new MerlinEvents());
        this.initNameGenerators();
        this.floorSortOptions = new FloorSort();
        this.floorSortOptions.setDomain(this);
        this.viewProps = new ViewProps();
        this.viewProps.setDomain(this);
        this.actionProps = new RestorableProperties();
        this.actionProps.setDomain(this);
        this.geomLocation = new GeomLocation(this);
        this.agentOverlapDetector = new AgentOverlapDetector(this);
        this.topology = new EgressTopology(this, topologyEnabled);
        this.displayFilter = new DisplayFilter(this);
        File libDir = null;
        if (Application.getApp() != null) {
            libDir = new File(Application.getApp().getInstallDir(), "lib");
        }
        this.materials = new MaterialDB(libDir, Intl.intl("Materials"));
        this.setDomain();
        if (autosave) {
            this.d_backupListener = new BackupEvtListener();
            this.getEvents().addObserver(this.d_backupListener);
            this.updateBackup();
        }
    }

    @Override
    public Object clone() {
        assert (false);
        return null;
    }

    public void beginRead() {
        this.d_lock.readLock().lock();
    }

    public void endRead() {
        this.d_lock.readLock().unlock();
    }

    public void beginWrite() {
        assert (!EventQueue.isDispatchThread()) : "Workers should not be run from the event queue thread except at program termination.";
        this.pauseUpdates();
        this.d_lock.writeLock().lock();
    }

    public void endWrite() {
        this.d_lock.writeLock().unlock();
        this.resumeUpdates();
    }

    public void downgradeWriteLock() {
        this.d_lock.readLock().lock();
        this.d_lock.writeLock().unlock();
    }

    public void upgradeReadLock() {
        this.d_lock.readLock().unlock();
        this.d_lock.writeLock().lock();
    }

    public List<IEgressConnector> getAllExits() {
        ArrayList connectors = new ArrayList();
        for (IEgressComp comp : this.floors.getDeepMembers(IEgressComp.class)) {
            comp.getConnectors(connectors);
        }
        ArrayList<IEgressConnector> exits = new ArrayList<IEgressConnector>();
        for (IEgressConnector connector : connectors) {
            if (!connector.isExit()) continue;
            exits.add(connector);
        }
        return exits;
    }

    public <T> T ui(Callable<T> worker) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                return worker.call();
            }
            Object[] result = new Object[1];
            EventQueue.invokeAndWait(() -> {
                objectArray[0] = this.call(worker);
            });
            return (T)result[0];
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            MerlinApp.crash(e);
            return null;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            MerlinApp.crash(e);
            return null;
        }
    }

    public void ui(Runnable worker) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                worker.run();
            } else {
                EventQueue.invokeAndWait(worker);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            MerlinApp.crash(e);
        }
    }

    public void uiLater(Runnable worker) {
        assert (!EventQueue.isDispatchThread());
        EventQueue.invokeLater(worker);
    }

    private <T> T call(Callable<T> worker) throws CancellationException {
        try {
            return worker.call();
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            MerlinApp.crash(e);
            return null;
        }
    }

    public void setDomain() {
        this.pauseUpdates();
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(this, this);
        }
        this.selection.setDomain(this);
        this.json.setDomain(this);
        this.customScripts.setDomain(this);
        this.floorSortOptions.setDomain(this);
        this.viewProps.setDomain(this);
        this.actionProps.setDomain(this);
        this.resumeUpdates();
    }

    public void initNameGenerators() {
        if (this.roomNameGen == null) {
            this.roomNameGen = new SequentialNameGen(Intl.intl("Room"), 2);
        }
        if (this.doorNameGen == null) {
            this.doorNameGen = new SequentialNameGen(Intl.intl("Door"), 2);
        }
        if (this.stairNameGen == null) {
            this.stairNameGen = new SequentialNameGen(Intl.intl("Stair"), 2);
        }
        if (this.rampNameGen == null) {
            this.rampNameGen = new SequentialNameGen(Intl.intl("Ramp"), 2);
        }
        if (this.blockageNameGen == null) {
            this.blockageNameGen = new SequentialNameGen(Intl.intl("Blockage"), 2);
        }
        if (this.occNameGen == null) {
            this.occNameGen = new SeqOccNameGen("", 5);
        }
        if (this.profNameGen == null) {
            this.profNameGen = new SequentialNameGen(Intl.intl("Profile"), 2);
        }
        if (this.vehicleShapeNameGen == null) {
            this.vehicleShapeNameGen = new SequentialNameGen(Intl.intl("VehicleShape"), 2);
        }
        if (this.assistedEvacTeamNameGen == null) {
            this.assistedEvacTeamNameGen = new SequentialNameGen(Intl.intl("AETeam"), 2);
        }
        if (this.cameraNameGen == null) {
            this.cameraNameGen = new SequentialNameGen(Intl.intl("View"), 2);
        }
        if (this.cameraTourNameGen == null) {
            this.cameraTourNameGen = new SequentialNameGen(Intl.intl("Tour"), 2);
        }
        if (this.densityNameGen == null) {
            this.densityNameGen = new SequentialNameGen(Intl.intl("Region"), 2);
        }
        if (this.occSourceNameGen == null) {
            this.occSourceNameGen = new SequentialNameGen(Intl.intl("OccSource"), 2);
        }
        if (this.occGroupNameGen == null) {
            this.occGroupNameGen = new SequentialNameGen(Intl.intl("MovementGroup"), 2);
        }
        if (this.occGroupTypeNameGen == null) {
            this.occGroupTypeNameGen = new SequentialNameGen(Intl.intl("MovementGroupTemplate"), 2);
        }
        if (this.customScriptNameGen == null) {
            this.customScriptNameGen = new SequentialNameGen("Script", 2);
        }
        if (this.queueObjectNameGen == null) {
            this.queueObjectNameGen = new SequentialNameGen(Intl.intl("Queue"), 2);
        }
        if (this.queuePathNameGen == null) {
            this.queuePathNameGen = new SequentialNameGen(Intl.intl("Path"), 2);
        }
        if (this.queueServiceNameGen == null) {
            this.queueServiceNameGen = new SequentialNameGen(Intl.intl("Service"), 2);
        }
        if (this.attractorsNameGen == null) {
            this.attractorsNameGen = new SequentialNameGen(Intl.intl("Attractor"), 2);
        }
        if (this.behaviorNameGen == null) {
            this.behaviorNameGen = new SequentialNameGen(Intl.intl("Behavior"), 2);
        }
        if (this.occTargetsNameGen == null) {
            this.occTargetsNameGen = new SequentialNameGen(Intl.intl("OccTarget"), 5);
        }
    }

    public void reset() {
        this.pauseUpdates();
        this.floors.reset();
        this.profiles.reset();
        this.vehicleShapes.reset();
        this.assistedEvacTeams.reset();
        this.agents.clear();
        this.behaviors.reset();
        this.queues.clear();
        this.elevators.clear();
        this.sceneGeom.clear();
        this.selection.clear();
        this.occNameGen.reset();
        this.densityNameGen.reset();
        this.vehicleShapeNameGen.reset();
        this.queueObjectNameGen.reset();
        this.queueServiceNameGen.reset();
        this.queuePathNameGen.reset();
        this.assistedEvacTeamNameGen.reset();
        this.occSourceNameGen.reset();
        this.occGroupNameGen.reset();
        this.occGroupTypeNameGen.reset();
        this.roomNameGen.reset();
        this.doorNameGen.reset();
        this.stairNameGen.reset();
        this.rampNameGen.reset();
        this.blockageNameGen.reset();
        this.simParams.reset();
        this.displayFilter.reset();
        this.floorSortOptions.reset();
        this.viewProps.reset();
        this.actionProps.clear();
        this.materials.reset();
        this.cameras.clear();
        this.cameraNameGen.reset();
        this.json.clear();
        this.customScripts.clear();
        this.regions.clear();
        this.occSources.clear();
        this.occGroups.clear();
        this.occGroupTypes.clear();
        this.attractors.clear();
        this.attractorsNameGen.reset();
        this.occTargets.clear();
        this.occTargetsNameGen.reset();
        this.modified = false;
        this.getEvents().changed(this, MODIFIED_CHANGED);
        this.getEvents().changed(this, MODEL_RESET);
        this.resumeUpdates();
        this.modified = false;
        this.filename = null;
        System.gc();
    }

    private void replaceInSel(Object old, Object repl) {
        if (this.selection.isSelected(old)) {
            this.selection.deselect(old);
            this.selection.select(repl);
        }
    }

    public void loadFrom(MerlinData md) {
        this.pauseUpdates();
        this.displayFilter.reset();
        this.geomLocation.getLocator().reset();
        this.sceneGeom.restoreFrom(md.sceneGeom);
        this.floors.restoreFrom(md.floors);
        this.profiles.restoreFrom(md.profiles);
        this.vehicleShapes.restoreFrom(md.vehicleShapes);
        this.assistedEvacTeams.restoreFrom(md.assistedEvacTeams);
        this.agents.restoreFrom(md.agents);
        this.behaviors.restoreFrom(md.behaviors);
        this.queues.restoreFrom(md.queues);
        this.elevators.restoreFrom(md.elevators);
        this.cameras.restoreFrom(md.cameras);
        this.json.restoreFrom(md.json);
        this.customScripts.restoreFrom(md.customScripts);
        this.regions.restoreFrom(md.regions);
        this.occSources.restoreFrom(md.occSources);
        this.occGroups.restoreFrom(md.occGroups);
        this.occGroupTypes.restoreFrom(md.occGroupTypes);
        this.attractors.restoreFrom(md.attractors);
        this.occTargets.restoreFrom(md.occTargets);
        this.selection.restoreFrom(md.selection);
        this.replaceInSel(md.agents, this.agents);
        this.replaceInSel(md.behaviors, this.behaviors);
        this.replaceInSel(md.queues, this.queues);
        this.replaceInSel(md.elevators, this.elevators);
        this.replaceInSel(md.sceneGeom, this.sceneGeom);
        this.replaceInSel(md.floors, this.floors);
        this.replaceInSel(md.profiles, this.profiles);
        this.replaceInSel(md.vehicleShapes, this.vehicleShapes);
        this.replaceInSel(md.assistedEvacTeams, this.assistedEvacTeams);
        this.replaceInSel(md.cameras, this.cameras);
        this.replaceInSel(md.json, this.json);
        this.replaceInSel(md.customScripts, this.customScripts);
        this.replaceInSel(md.regions, this.regions);
        this.replaceInSel(md.occSources, this.occSources);
        this.replaceInSel(md.occGroups, this.occGroups);
        this.replaceInSel(md.occGroupTypes, this.occGroupTypes);
        this.replaceInSel(md.attractors, this.attractors);
        this.replaceInSel(md.occTargets, this.occTargets);
        this.simParams.restoreFrom(md.simParams);
        this.occNameGen = md.occNameGen;
        this.roomNameGen = md.roomNameGen;
        this.doorNameGen = md.doorNameGen;
        this.stairNameGen = md.stairNameGen;
        this.rampNameGen = md.rampNameGen;
        this.blockageNameGen = md.blockageNameGen;
        this.cameraNameGen = md.cameraNameGen;
        this.densityNameGen = md.densityNameGen;
        this.occSourceNameGen = md.occSourceNameGen;
        this.occGroupNameGen = md.occGroupNameGen;
        this.occGroupTypeNameGen = md.occGroupTypeNameGen;
        this.attractorsNameGen = md.attractorsNameGen;
        this.occTargetsNameGen = md.occTargetsNameGen;
        this.floorSortOptions.restoreFrom(md.floorSortOptions);
        this.viewProps.restoreFrom(md.viewProps);
        this.actionProps.restoreFrom(md.actionProps);
        this.materials.loadFrom(md.materials);
        this.setUnitSystem(md.getUnitSystem());
        this.modified = md.modified;
        this.getEvents().changed(this, MODIFIED_CHANGED);
        this.getEvents().changed(this, MODEL_LOADED);
        this.resumeUpdates();
        this.filename = null;
        System.gc();
    }

    public String getNewFilename(String suffix) {
        this.beginRead();
        try {
            String string = this.filename == null ? Intl.intl("untitled") + suffix : guiUtil.getFileNameNoExt(this.filename) + suffix;
            return string;
        }
        finally {
            this.endRead();
        }
    }

    public OccupancySpec getDefaultOccupancySpec() {
        OccupancySpec occ = new OccupancySpec();
        occ.setSpacing(1);
        occ.setOccCount(this.defaultOccCount);
        return occ;
    }

    public void updateSearches() {
        this.agentOverlapDetector.updateDirty();
        this.geomLocation.updateDirty();
    }

    public void updateTopology() {
        this.topology.update();
    }

    public Floor activeFloor() {
        return this.floors.getActive();
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return Arrays.asList(this.materials, this.cameras, this.sceneGeom, this.profiles, this.vehicleShapes, this.assistedEvacTeams, this.behaviors, this.queues, this.occSources, this.agents, this.occGroups, this.occGroupTypes, this.occTargets, this.attractors, this.elevators, this.floors, this.regions);
    }

    @Override
    public MerlinData getDomain() {
        return this;
    }

    @Override
    public void setDomain(MerlinData domain, IMerlinObj parent) {
    }

    @Override
    public void setDomain(MerlinData owner) {
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        return false;
    }

    @Override
    public void pauseUpdates() {
        this.getEvents().pause();
    }

    @Override
    public boolean resumeUpdates() {
        return this.getEvents().resume();
    }

    public AgentOverlapDetector getOverlapDetector() {
        return this.agentOverlapDetector;
    }

    public OccLocation findValidOccLocation(OccProfile prof, long profileSeed, Point3d loc, double orient, int options, Predicate<EgressAgent> toIgnore) {
        return this.findValidOccLocation(prof.getProperty(OccProfile.PROP_SHAPE), loc, EgressAgent.getShoulderWidth(prof, profileSeed), orient, options, EgressAgent.getRoomFilter(prof), toIgnore);
    }

    public OccLocation findValidOccLocation(OccProfile.OccShape shape, Point3d loc, UnitDouble shoulderWidth, double angle, int options, Predicate<IEgressOccupiable> roomFilter) {
        return this.findValidOccLocation(shape, loc, shoulderWidth, angle, options, roomFilter, Filters.alwaysFalse());
    }

    public OccLocation findValidOccLocation(OccProfile.OccShape shape, Point3d loc, UnitDouble shoulderWidth, double angle, int options, Predicate<IEgressOccupiable> roomFilter, Predicate<EgressAgent> toIgnore) {
        Point3d begin = new Point3d(loc.x, loc.y, loc.z + 1.0E-6);
        double shoulderWidthVal = shoulderWidth.getValue(Geometry.LENGTH_UNIT);
        Point3d end = new Point3d(begin.x, begin.y, loc.z - shoulderWidthVal);
        OccLocation occLoc = this.findValidOccLocation(shape, begin, end, shoulderWidth, angle, options, roomFilter, toIgnore);
        if (occLoc == null) {
            double radius = shoulderWidthVal * 0.5;
            occLoc = this.getValidOccLoc(shape, null, loc, radius, angle, options |= 2, roomFilter, toIgnore);
        }
        return occLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OccLocation findValidOccLocation(OccProfile.OccShape shape, Point3d rayBegin, Point3d rayEnd, UnitDouble shoulderWidth, double angle, int options, Predicate<IEgressOccupiable> roomFilter, Predicate<EgressAgent> toIgnore) {
        double shoulderWidthVal = shoulderWidth.getValue(Geometry.LENGTH_UNIT);
        double radius = shoulderWidthVal * 0.5;
        this.beginRead();
        try {
            int finderOptions = (options & 8) == 0 ? 3 : 0;
            Collection<Pair<IEgressOccupiable, Point3d>> isects = this.findLineSegIsects(rayBegin, rayEnd, IEgressOccupiable.class, finderOptions);
            if (!isects.isEmpty()) {
                OccLocation first = null;
                for (Pair<IEgressOccupiable, Point3d> isect : isects) {
                    if (!((IEgressOccupiable)isect.v1).getOccupantsAllowed()) {
                        OccLocation occLocation = null;
                        return occLocation;
                    }
                    OccLocation loc = this.getDomain().getValidOccLoc(shape, (IEgressOccupiable)isect.v1, (Point3d)isect.v2, radius, angle, options, roomFilter, toIgnore);
                    if (loc.room != null && !loc.overlapsWalls && !loc.failsFilter && loc.getOverlappingAgents().isEmpty()) {
                        OccLocation occLocation = loc;
                        return occLocation;
                    }
                    if (first != null) continue;
                    first = loc;
                }
                assert (first != null);
                Iterator<Pair<IEgressOccupiable, Point3d>> iterator = first;
                return iterator;
            }
            OccLocation occLocation = null;
            return occLocation;
        }
        finally {
            this.endRead();
        }
    }

    private <T extends IMerlinGeomSrc> Collection<Pair<T, Point3d>> findLineSegIsects(final Point3d p1, final Point3d p2, final Class<T> type, int options) {
        final Vector3d rayDirN = Util3D.vectorN(p1, p2);
        final TreeMap isects = new TreeMap();
        final LineSegRTreeTest tester = new LineSegRTreeTest(p1, p2);
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){
            List<Point3d> d_points = new ArrayList<Point3d>();
            IIsectCollector d_isects = new IIsectCollector(){
                private final TaskProgress d_progress = new TaskProgress();

                @Override
                public TaskProgress getProgress() {
                    return this.d_progress;
                }

                @Override
                public void addNonFace(Object obj, Point3d p, GeomType type) {
                    d_points.add(p);
                }

                @Override
                public void addFace(Object obj, Point3d p, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimProps faceProps) {
                    d_points.add(p);
                }

                @Override
                public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                    d_points.add(p);
                }
            };
            DefaultFilter d_filter = new DefaultFilter(GeomType.FACE);

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                if (!type.isInstance(obj)) {
                    return;
                }
                this.d_points.clear();
                ((IMerlinGeomSrc)type.cast(obj)).pickPoints(this.d_isects, this.d_filter, p1, p2, rayDirN, tester);
                for (Point3d p : this.d_points) {
                    double dist = p1.distanceSquared(p);
                    isects.put(dist, new Pair(type.cast(obj), p));
                }
            }
        };
        this.geomLocation.getLocator().find(tester, (IResult<? super IDisplayableGeomSrc>)result, options);
        return isects.values();
    }

    private OccLocation getValidOccLoc(OccProfile.OccShape shape, IEgressOccupiable room, Point3d loc, double radius, double angle, int options, Predicate<IEgressOccupiable> roomFilter, Predicate<EgressAgent> toIgnore) {
        boolean overlapsWall;
        boolean failsFilter;
        Collection<EgressAgent> overlappingOccs;
        block8: {
            BitOptions opts = new BitOptions(options);
            overlappingOccs = this.agentOverlapDetector.detectOverlap(shape, loc, radius, angle, opts.get(4L), toIgnore);
            failsFilter = room != null && !roomFilter.test(room);
            overlapsWall = false;
            if (room == null || opts.get(2L)) break block8;
            if (shape == null || shape.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
                BoundingSphere test = new BoundingSphere(loc, radius);
                List<? extends ICurve> nearBounds = RoomUtil.findBoundaries(room, test);
                for (ICurve iCurve : nearBounds) {
                    Point3d point3d = iCurve.project(loc, 1.0E-6);
                    if (!(loc.distance(point3d) < radius)) continue;
                    overlapsWall = true;
                    break;
                }
            } else {
                Point3d[] pointsOnFace = shape.vehicleShape.getBodyPoints(loc, angle);
                if (opts.get(4L)) {
                    pointsOnFace = shape.vehicleShape.getOuterPoints(loc, angle);
                }
                AABox test = new AABox(pointsOnFace);
                List<? extends ICurve> nearBounds = RoomUtil.findBoundaries(room, test);
                for (ICurve iCurve : nearBounds) {
                    Mesh segments = iCurve.getSegments(1.0E-6);
                    for (Point3d p : segments.vertices) {
                        if (!Inter3D.pointInPoly(1.0E-6, p, pointsOnFace)) continue;
                        overlapsWall = true;
                        break;
                    }
                    Collection<IGeom> lineSegs = segments.explode(new ArrayList<IGeom>());
                    block3: for (IGeom l : lineSegs) {
                        if (!(l instanceof LineSeg)) continue;
                        LineSeg lineSeg = (LineSeg)l;
                        for (int i = 0; i < pointsOnFace.length; ++i) {
                            Point3d p1 = pointsOnFace[i];
                            Point3d p2 = pointsOnFace[(i + 1) % pointsOnFace.length];
                            if (Inter3D.getLineSegLineSegIntersection(lineSeg.p1, lineSeg.p2, p1, p2, 1.0E-6, 1.0E-6) == null) continue;
                            overlapsWall = true;
                            continue block3;
                        }
                    }
                }
            }
        }
        return new OccLocation(room, overlappingOccs, overlapsWall, failsFilter, loc);
    }

    public boolean isVisible(Object obj) {
        if (obj instanceof IMerlinObj) {
            return this.isVisible((IMerlinObj)obj);
        }
        if (obj instanceof IDisplayableGeomSrc) {
            return ((IDisplayableGeomSrc)obj).isVisible();
        }
        return true;
    }

    public boolean isVisible(IMerlinObj obj) {
        return EntryPointFactory.get(obj).isVisible(this, obj);
    }

    public void setInitialUnitSystem(UnitSystem us) {
        this.d_unitSystem = us;
    }

    public void setUnitSystem(UnitSystem us) {
        this.d_unitSystem = us;
        this.d_unitSystemInt = us == SIUS.getInstance() ? 0 : 1;
        this.getEvents().changed(this, UNITSYSTEM_CHANGED);
    }

    public UnitSystem getUnitSystem() {
        return this.d_unitSystem;
    }

    public Set<Material> getMaterialsInUse() {
        LinkedIdentityHashSet<Material> usedMats = new LinkedIdentityHashSet<Material>();
        for (EgressBlockage eb : MerlinUtil.flatten(this.floors.getMembers(), EgressBlockage.class)) {
            Material tex = eb.getTexture();
            if (tex == null) continue;
            usedMats.add(tex);
        }
        LinkedIdentityHashSet<Material> refMats = Dependencies.getObjReferences(this, Material.class, Predicates.alwaysTrue());
        usedMats.addAll(refMats);
        return usedMats;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_unitSystem = this.d_unitSystemInt == 0 ? SIUS.getInstance() : EnglishUS.getInstance();
    }

    private void updateBackup() {
        UnitDouble autosavePeriod = MerlinPrefs.getUnitDouble(MerlinPrefs.BACKUP_AUTOSAVE_INTERVAL, NonSI.MINUTE);
        this.backup.setAutosavePeriod(autosavePeriod);
        this.beginRead();
        this.backup.setFilename(this.filename);
        this.endRead();
        boolean autosaveEnabled = MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_AUTOSAVE);
        this.backup.setAutosaveEnabled(autosaveEnabled);
        boolean backupEnabled = MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_BACKUPONOPEN);
        this.backup.setBackupEnabled(backupEnabled);
        boolean customBackDirEnabled = MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_CUSTOMDIR);
        this.backup.setUseCustomBackupDir(customBackDirEnabled);
        if (customBackDirEnabled) {
            String customBackupDir = MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH);
            this.backup.setCustomBackupDir(customBackupDir);
        }
    }

    private class BackupEvtListener
    implements IEventObserver {
        private BackupEvtListener() {
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(MerlinData.class, new Class[0]).hasChangedObjs(MODEL_RESET, MODEL_LOADED, MODEL_SAVED, PREFS_CHANGED)) {
                MerlinData.this.updateBackup();
            }
        }
    }

    private class MerlinEvents
    extends Events {
        private MerlinEvents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireNotice() {
            Application app = Application.getApp();
            if (app != null) {
                app.beginWaitCursor();
            }
            try {
                MerlinData.this.d_lock.writeLock().lock();
                try {
                    MerlinData.this.updateTopology();
                }
                finally {
                    MerlinData.this.d_lock.writeLock().unlock();
                }
                MerlinData.this.pauseUpdates(false);
                MerlinData.this.d_lock.writeLock().lock();
                try {
                    for (EventChannel<Object> channel : this.getAffectedChannels(Object.class, new Class[0])) {
                        MerlinData.this.selection.deselectAll(channel.getRemovedObjs());
                    }
                }
                finally {
                    MerlinData.this.d_lock.writeLock().unlock();
                }
                MerlinData.this.resumeUpdates();
                MerlinData.this.d_modifiedListener.update(this);
                MerlinData.this.beginRead();
                try {
                    this.fireNotification2();
                }
                finally {
                    MerlinData.this.endRead();
                }
            }
            finally {
                if (app != null) {
                    app.endWaitCursor();
                }
            }
        }

        protected void fireNotification2() {
            super.fireNotification();
        }

        @Override
        protected void fireNotification() {
            Runnable noticer = new Runnable(){

                @Override
                public void run() {
                    MerlinEvents.this.fireNotice();
                }
            };
            MerlinData.this.ui(noticer);
        }
    }

    private class ModifiedListener
    implements IEventObserver {
        private ModifiedListener() {
        }

        private boolean isModifiedEvt(Events events) {
            IEventRecord<Object> oevts = events.getEvents(Object.class, new Class[0]);
            return !oevts.getChangedObjs(EventUtil.acceptOnlyModifying()).isEmpty();
        }

        private boolean hasExplicitModify(Events events) {
            IEventRecord<MerlinData> mevts = events.getEvents(MerlinData.class, new Class[0]);
            return mevts.hasChangedObjs(MODIFIED_CHANGED);
        }

        @Override
        public void update(Events events) {
            if (this.hasExplicitModify(events)) {
                MerlinData.this.backup.setModified(MerlinData.this.modified);
            } else if (this.isModifiedEvt(events)) {
                MerlinData.this.modified = true;
                MerlinData.this.backup.setModified(true);
            }
        }
    }
}

