/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.egress.Floor;
import merlin.geom.Geometry;
import merlin.gui.MerlinUDF;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IPropEditor;
import thunderheadeng.gui.PropEditors;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;

public class CompElementUtil {
    private static final int U = 0;
    private static final int L = 1;
    private static final int B = 2;
    private static final int R = 3;

    public static Map<Object, IPropEditor<?>> getEditorMap(ICompElement ce) {
        Set<Object> propTypes = ce.getPropTypes(0);
        Hashtable editors = new Hashtable();
        for (Object propID : propTypes) {
            MerlinUDF udf;
            UnitDouble udVal;
            Object val = ce.getProperty(propID);
            String label = propID.toString();
            IPropEditor<String> ed = null;
            if (val instanceof UnitDouble) {
                udVal = (UnitDouble)val;
                ed = new PropEditors.UnitDoublePropEditor(label, new MerlinUDF(udVal.getUnit(), UnitDoubleVR.UNBOUNDED));
            } else if (val instanceof Double) {
                udVal = new UnitDouble((Double)val, Unit.ONE);
                ed = new PropEditors.UnitDoublePropEditor(label, new MerlinUDF(udVal.getUnit(), UnitDoubleVR.UNBOUNDED));
            } else if (val instanceof String) {
                ed = new PropEditors.StringPropEditor(label);
            } else if (val instanceof Point3d) {
                Unit u = Geometry.LENGTH_UNIT;
                ed = new PropEditors.Point3dPropEditor(label, u, MerlinUDF.class);
            } else if (val instanceof Boolean) {
                ed = new PropEditors.BoolPropEditor(label);
            } else if (propID == Floor.ZMAX_FILTER) {
                udf = new MerlinUDF(Geometry.LENGTH_UNIT, DoubleVR.UNBOUNDED);
                udf.aliasValue(Floor.NEXT_FLOOR, Intl.intl("NEXT_FLOOR"));
                ed = new PropEditors.UnitDoublePropEditor(label, udf);
            } else if (propID == Floor.ZMIN_FILTER) {
                udf = new MerlinUDF(Geometry.LENGTH_UNIT, DoubleVR.UNBOUNDED);
                udf.aliasValue(Floor.CURR_FLOOR, Intl.intl("CURR_FLOOR"));
                ed = new PropEditors.UnitDoublePropEditor(label, udf);
            } else {
                System.err.printf("no editor for [%s,%s]\n", propID.toString(), val);
            }
            if (ed == null) continue;
            editors.put(propID, ed);
        }
        return editors;
    }

    public static void loadValues(ICompElement ce, Map<Object, IPropEditor<Object>> edMap) {
        for (Object prop : edMap.keySet()) {
            IPropEditor<Object> ed = edMap.get(prop);
            Object val = ce.getProperty(prop);
            if (val instanceof Double) {
                val = new UnitDouble((Double)val, Unit.ONE);
            }
            ed.setValue(val);
        }
    }

    private static int i(int ulbr, boolean rowLast, boolean colLast) {
        switch (ulbr) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return rowLast ? 0 : 12;
            }
            case 3: {
                return colLast ? 0 : 12;
            }
        }
        return 0;
    }

    public static JComponent getEditorPanel(List<IPropEditor<?>> eds) {
        guiPanel edPanel = new guiPanel(new GridBagLayout());
        for (int r = 0; r < eds.size(); ++r) {
            IPropEditor<?> ed = eds.get(r);
            boolean rowLast = r == eds.size() - 1;
            for (int c = 0; c < ed.getNumComponents(); ++c) {
                boolean colLast = c == ed.getNumComponents() - 1;
                GridBagUtil.add(edPanel, ed.getEditorComponent(c), c, r, ed.getComponentWidth(c), 1, CompElementUtil.i(0, rowLast, colLast), CompElementUtil.i(1, rowLast, colLast), CompElementUtil.i(2, rowLast, colLast), CompElementUtil.i(3, rowLast, colLast), 0, 0.0, 0.0, 17);
            }
        }
        GridBagUtil.addGlue(edPanel);
        return edPanel;
    }

    public static guiDialog getEditorDialog(JFrame owner, List<IPropEditor<?>> eds) {
        int options = 9;
        guiDialog dlg = new guiDialog((Window)owner, "Editor", options);
        guiPanel content = dlg.getDialogPane();
        content.setLayout(new BorderLayout());
        JComponent edPanel = CompElementUtil.getEditorPanel(eds);
        content.add((Component)edPanel, "Center");
        return dlg;
    }

    public static void saveData(ICompElement ce, Map<Object, IPropEditor<?>> edMap) {
        for (Object prop : edMap.keySet()) {
            IPropEditor<?> ed = edMap.get(prop);
            Object oldVal = ce.getProperty(prop);
            Object newVal = ed.getValue();
            if (oldVal instanceof Double) {
                newVal = ((UnitDouble)newVal).getValueNoUnit();
            }
            if (Objects.equals(oldVal, newVal)) continue;
            ce.setProperty(prop, ed.getValue());
        }
    }
}

