/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.actions.importgeom.ImportOptions;
import merlin.actions.importgeom.PyroUtil;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.material.Material;
import merlin.data.material.MaterialCache;
import merlin.geom.GeomUtil;
import org.jscience.physics.units.SI;
import pyroloader.IPyroDataStore;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroGeomSrc;
import pyroloader.IPyroPrimProps;
import pyroloader.IPyroSurface;
import pyroloader.PyroPoint2d;
import pyroloader.PyroPoint3d;
import pyroloader.PyroTexture;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.ByteArrayStreamSrc;
import thunderheadeng.io.streamsrc.DecryptStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.HashPool;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class PyroGeomConverter {
    private static final String OPEN_NAME = "OPEN";
    private final Map<PyroPoint3d, Point3d> d_pointMap = new IdentityHashMap<PyroPoint3d, Point3d>();
    private final HashPool<Vector3d> d_normalPool;
    private final HashPool<Point2d> d_uvPool;
    private final Map<IPyroSurface, Material> d_matMap;
    private final Collection<IPyroGeomSrc> d_geomObjs;
    private final HashPool<IPrimProps> d_propsPool;
    private final Map<IPyroGeom, Pair<IGeom, List<Pair<IGeom, Integer>>>> d_geomMap = new IdentityHashMap<IPyroGeom, Pair<IGeom, List<Pair<IGeom, Integer>>>>();
    private final Map<Matrix4d, ITransform> d_transformPool;
    private static IPropsSrc s_defProps = new UniformProps(new IPrimProps.GenericProps(Color.WHITE, null, 1.0, IPrimProps.DEF_STIPPLE, 1.0, 0));

    public PyroGeomConverter(IPropertySet ioptions, IPyroDataStore data) {
        this.d_propsPool = new HashPool();
        this.d_transformPool = new HashMap<Matrix4d, ITransform>();
        this.d_normalPool = new HashPool();
        this.d_uvPool = new HashPool();
        this.d_transformPool.put(GeomConstants.IDENTITY4d, TransformUtil.IDENTITY);
        MaterialCache matCache = ioptions.get(ImportOptions.MAT_CACHE).get();
        this.d_matMap = PyroGeomConverter.convertMaterials(matCache, data.getSurfaces());
        this.d_geomObjs = data.getGeomObjs();
    }

    public Collection<Material> getMaterials() {
        return this.d_matMap.values();
    }

    private Point3d getPoint(PyroPoint3d pp) {
        Point3d p = this.d_pointMap.get(pp);
        if (p == null) {
            p = PyroGeomConverter.convert(pp);
            this.d_pointMap.put(pp, p);
        }
        return p;
    }

    private Point3d[] getPoints(PyroPoint3d[] ppoints) {
        Point3d[] points = new Point3d[ppoints.length];
        for (int m = 0; m < points.length; ++m) {
            points[m] = this.getPoint(ppoints[m]);
        }
        return points;
    }

    private static Point3d convert(PyroPoint3d pp) {
        return new Point3d(pp.x, pp.y, pp.z);
    }

    public static int[] getSupportedPyroGeomTypes() {
        return new int[]{4, 1, 3, 7, 5, 6};
    }

    public List<ICompElement> convertGrids() {
        List<IPyroGeomSrc> vents = this.getVents();
        List<IPyroGeomSrc> grids = this.getGrids();
        ArrayList<AABox> gridBBs = new ArrayList<AABox>(grids.size());
        for (IPyroGeomSrc grid : grids) {
            IPyroGeomNode node = grid.getGeomRoot();
            assert (node.getChildren().length == 0 && node.getGeom().getType() == 4);
            IPyroGeom geom = node.getGeom();
            PyroPoint3d[] corners = geom.getCorners();
            gridBBs.add(new AABox(this.getPoint(corners[0]), this.getPoint(corners[1])));
        }
        Model mergedGrids = PyroUtil.mergeGrids(gridBBs);
        this.subtractGridVents(mergedGrids, vents);
        ArrayList<ICompElement> result = new ArrayList<ICompElement>(grids.size());
        for (int m = 0; m < gridBBs.size(); ++m) {
            List<Face> faces = PyroUtil.getGridFaces(mergedGrids, m);
            if (faces.isEmpty()) continue;
            IPyroGeomSrc grid = grids.get(m);
            GeomComposite gridGroup = new GeomComposite(grid.getName());
            Pair<IPrimProps, IElemSource<Point2d>> props = this.getGridMeta(grid, this.d_propsPool);
            Map uvs = Collections.emptyMap();
            if (((IPrimProps)props.v1).getMaterial() != null && props.v2 != Elements.NO_UV) {
                uvs = new ListMap();
                for (String uvset : ((IPrimProps)props.v1).getMaterial().getAttributes().getUVSets()) {
                    uvs.put(uvset, props.v2);
                }
            }
            Point3d gridCenter = gridBBs.get(m).getCenter();
            UniformProps propsSrc = new UniformProps((IPrimProps)props.v1);
            int faceix = 1;
            for (Face face : faces) {
                Triangulation tri = face.triangulate(Face.NO_REFINEMENT);
                if (tri == null) continue;
                Mesh mesh = new Mesh(tri.verts, tri.tris, 2);
                IElemSource<Elements.Orient> orient = face.plane.dot(gridCenter) < 0.0 ? Elements.CW : Elements.CCW;
                IElemSource<Boolean> creases = Elements.generateCreasesFromFacets(mesh, propsSrc, orient);
                IPropertySet elements = Elements.newElements();
                elements.setIfNotDefault(Elements.UV, uvs);
                elements.setIfNotDefault(Elements.CREASE, creases);
                elements.setIfNotDefault(Elements.ORIENT, orient);
                elements = Elements.finalizeElements(elements);
                ImportedGeom ig = new ImportedGeom(String.format(Intl.intl("%s face %d"), grid.getName(), faceix++), new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(mesh, elements), propsSrc));
                gridGroup.add(ig);
            }
            if (gridGroup.isEmpty()) continue;
            result.add(gridGroup);
        }
        return result;
    }

    private void subtractGridVents(Model model, List<IPyroGeomSrc> vents) {
        for (IPyroGeomSrc vent : vents) {
            DisplayGeom dg = this.convertGeomSrc(vent, null);
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(dg.node.flatten().getLocalGeom(), IFace.class)) {
                GeomUtil.addFaceToModel(face, model, Integer.MAX_VALUE, MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR), MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR));
            }
        }
        Model.Group delGroup = model.getGroup(Integer.MAX_VALUE, true, false, false);
        for (Face delFace : delGroup.faces) {
            model.deleteFace(delFace, true, true);
        }
    }

    private Pair<IPrimProps, IElemSource<Point2d>> getGridMeta(IPyroGeomSrc grid, HashPool<IPrimProps> propsPool) {
        IPyroPrimProps[] pprops = grid.getPrimProps();
        if (pprops.length == 0) {
            return new Pair<IPrimProps, IElemSource<Point2d>>(s_defProps.get(0), Elements.NO_UV);
        }
        IPrimProps props = this.convertPrimProps(pprops[0]);
        props = props.setOptions(2);
        props = propsPool.getExisting(props);
        return new Pair<IPrimProps, IElemSource<Point2d>>(props, ImportedGeom.DEFUV);
    }

    public static List<IPyroGeomSrc> filterObjs(Collection<IPyroGeomSrc> allObjs, Predicate<IPyroGeomSrc> filter) {
        ArrayList<IPyroGeomSrc> result = new ArrayList<IPyroGeomSrc>();
        PyroGeomConverter.filterObjs(allObjs, filter, result);
        return result;
    }

    private static void filterObjs(Collection<IPyroGeomSrc> objs, Predicate<IPyroGeomSrc> filter, List<IPyroGeomSrc> result) {
        for (IPyroGeomSrc geom : objs) {
            if (geom.getType() == 1) {
                PyroGeomConverter.filterObjs(geom.getChildren(), filter, result);
                continue;
            }
            if (!filter.test(geom)) continue;
            result.add(geom);
        }
    }

    private static <PyroT, NatT> void convert(IPyroSurface surf, List<Object> nprops, IPyroSurface.Prop<PyroT> pprop, IPropertySet.Prop<NatT> nprop, Function<PyroT, NatT> mapper) {
        PyroT pval = surf.getAttribute(pprop);
        Object nval = pval != null ? (Object)mapper.apply(pval) : null;
        nprops.add(nprop);
        nprops.add(nval);
    }

    private static <T extends Enum<T>> void enumConvert(IPyroSurface surf, List<Object> nprops, IPyroSurface.Prop<String> pprop, IPropertySet.Prop<T> nprop, Class<T> type) {
        PyroGeomConverter.convert(surf, nprops, pprop, nprop, i -> Enum.valueOf(type, i));
    }

    private static <PyroT, NatT> MatAttrs convert(IPyroSurface surf, Function<PyroTexture, Texture> texMapper) {
        Function<Double, Double> dmapper = d -> d;
        Function<Color, Color> cmapper = c -> c;
        ArrayList<Object> nprops = new ArrayList<Object>();
        BiConsumer<IPyroSurface.Prop, IPropertySet.Prop> tconvert = (pprop, nprop) -> PyroGeomConverter.convert(surf, nprops, pprop, nprop, texMapper);
        BiConsumer<IPyroSurface.Prop, IPropertySet.Prop> cconvert = (pprop, nprop) -> PyroGeomConverter.convert(surf, nprops, pprop, nprop, cmapper);
        BiConsumer<IPyroSurface.Prop, IPropertySet.Prop> dconvert = (pprop, nprop) -> PyroGeomConverter.convert(surf, nprops, pprop, nprop, dmapper);
        BiConsumer<IPyroSurface.Prop, IPropertySet.Prop> iconvert = (pprop, nprop) -> PyroGeomConverter.convert(surf, nprops, pprop, nprop, i -> i);
        tconvert.accept(IPyroSurface.BUMP, IMatAttrs.BUMP);
        dconvert.accept(IPyroSurface.BUMP_SCALE, IMatAttrs.BUMP_SCALE);
        cconvert.accept(IPyroSurface.AMBIENT_COLOR, IMatAttrs.AMBIENT_COLOR);
        tconvert.accept(IPyroSurface.AMBIENT_TEXTURE, IMatAttrs.AMBIENT_TEXTURE);
        dconvert.accept(IPyroSurface.AMBIENT_FADE, IMatAttrs.AMBIENT_FADE);
        PyroGeomConverter.enumConvert(surf, nprops, IPyroSurface.AMBIENT_REDIRECT, IMatAttrs.AMBIENT_REDIRECT, MatChannel.class);
        cconvert.accept(IPyroSurface.DIFFUSE_COLOR, IMatAttrs.DIFFUSE_COLOR);
        tconvert.accept(IPyroSurface.DIFFUSE_TEXTURE, IMatAttrs.DIFFUSE_TEXTURE);
        dconvert.accept(IPyroSurface.DIFFUSE_FADE, IMatAttrs.DIFFUSE_FADE);
        PyroGeomConverter.enumConvert(surf, nprops, IPyroSurface.DIFFUSE_FADE_SRC, IMatAttrs.DIFFUSE_FADE_SOURCE, IMatAttrs.ChannelFadeSrc.class);
        cconvert.accept(IPyroSurface.EMISSIVE_COLOR, IMatAttrs.EMISSIVE_COLOR);
        tconvert.accept(IPyroSurface.EMISSIVE_TEXTURE, IMatAttrs.EMISSIVE_TEXTURE);
        dconvert.accept(IPyroSurface.EMISSIVE_FADE, IMatAttrs.EMISSIVE_FADE);
        tconvert.accept(IPyroSurface.NORMAL, IMatAttrs.NORMAL);
        cconvert.accept(IPyroSurface.OPACITY_COLOR, IMatAttrs.OPACITY_COLOR);
        tconvert.accept(IPyroSurface.OPACITY_TEXTURE, IMatAttrs.OPACITY_TEXTURE);
        dconvert.accept(IPyroSurface.OPACITY_FADE, IMatAttrs.OPACITY_FADE);
        cconvert.accept(IPyroSurface.REFLECTION_COLOR, IMatAttrs.REFLECTION_COLOR);
        tconvert.accept(IPyroSurface.REFLECTION_TEXTURE, IMatAttrs.REFLECTION_TEXTURE);
        dconvert.accept(IPyroSurface.REFLECTION_FADE, IMatAttrs.REFLECTION_FADE);
        cconvert.accept(IPyroSurface.SPECULAR_COLOR, IMatAttrs.SPECULAR_COLOR);
        tconvert.accept(IPyroSurface.SPECULAR_TEXTURE, IMatAttrs.SPECULAR_TEXTURE);
        dconvert.accept(IPyroSurface.SPECULAR_FADE, IMatAttrs.SPECULAR_FADE);
        dconvert.accept(IPyroSurface.SHININESS, IMatAttrs.SHININESS);
        tconvert.accept(IPyroSurface.SHININESS_TEXTURE, IMatAttrs.SHININESS_TEXTURE);
        iconvert.accept(IPyroSurface.OPTIONS, IMatAttrs.OPTIONS);
        cconvert.accept(IPyroSurface.METALLIC_COLOR, IMatAttrs.METALLIC_COLOR);
        tconvert.accept(IPyroSurface.METALLIC_TEXTURE, IMatAttrs.METALLIC_TEXTURE);
        cconvert.accept(IPyroSurface.ROUGHNESS_COLOR, IMatAttrs.ROUGHNESS_COLOR);
        tconvert.accept(IPyroSurface.ROUGHNESS_TEXTURE, IMatAttrs.ROUGHNESS_TEXTURE);
        cconvert.accept(IPyroSurface.AMBIENT_OCCLUSION_COLOR, IMatAttrs.AMBIENT_OCCLUSION_COLOR);
        tconvert.accept(IPyroSurface.AMBIENT_OCCLUSION_TEXTURE, IMatAttrs.AMBIENT_OCCLUSION_TEXTURE);
        cconvert.accept(IPyroSurface.GLOSSINESS_COLOR, IMatAttrs.GLOSSINESS_COLOR);
        tconvert.accept(IPyroSurface.GLOSSINESS_TEXTURE, IMatAttrs.GLOSSINESS_TEXTURE);
        tconvert.accept(IPyroSurface.PARALLAX_TEXTURE, IMatAttrs.PARALLAX_TEXTURE);
        dconvert.accept(IPyroSurface.PARALLAX_SCALE, IMatAttrs.PARALLAX_SCALE);
        PyroGeomConverter.enumConvert(surf, nprops, IPyroSurface.WORKFLOW, IMatAttrs.WORKFLOW, IMatAttrs.Workflow.class);
        return new MatAttrs(nprops);
    }

    private static Texture.Mode convert(PyroTexture.Mode mode) {
        switch (mode) {
            case BLEND: {
                return Texture.Mode.BLEND;
            }
            case DECAL: {
                return Texture.Mode.DECAL;
            }
            case MODULATE: {
                return Texture.Mode.MODULATE;
            }
            case REPLACE: {
                return Texture.Mode.REPLACE;
            }
        }
        assert (false);
        return Texture.Mode.MODULATE;
    }

    private static Texture.Wrap convert(PyroTexture.Wrap wrap) {
        switch (wrap) {
            case CLAMP: {
                return Texture.Wrap.CLAMP;
            }
            case CLAMP_TO_EDGE: {
                return Texture.Wrap.CLAMP_TO_EDGE;
            }
            case REPEAT: {
                return Texture.Wrap.REPEAT;
            }
        }
        assert (false);
        return Texture.Wrap.REPEAT;
    }

    protected static Map<IPyroSurface, Material> convertMaterials(MaterialCache matCache, Collection<IPyroSurface> surfaces) {
        HashMap imgCache = new HashMap();
        LinkedHashMap<IPyroSurface, Material> materials = new LinkedHashMap<IPyroSurface, Material>();
        Function<PyroTexture, Texture> texCvt = ptex -> {
            IImage img = PyroGeomConverter.getImage(imgCache, ptex.filename, ptex.data);
            if (img == null) {
                return null;
            }
            return new Texture(img, PyroGeomConverter.convert(ptex.mode), PyroGeomConverter.convert(ptex.wrap), ptex.borderColor, ptex.uvset);
        };
        for (IPyroSurface surface : surfaces) {
            MatAttrs matAttrs = PyroGeomConverter.convert(surface, texCvt);
            double[] dim = surface.getDimensions();
            if (dim == null) {
                dim = new double[]{1.0, 1.0};
            }
            UnitDouble width = new UnitDouble(dim[0], SI.METER);
            UnitDouble height = new UnitDouble(dim[1], SI.METER);
            Material mat = new Material(surface.getName(), matAttrs, width, height);
            mat = matCache.add(mat);
            materials.put(surface, mat);
        }
        return materials;
    }

    private static IImage getImage(Map<Pair<String, byte[]>, IImage> cache, String filename, byte[] imgData) {
        return cache.computeIfAbsent(new Pair<String, byte[]>(filename, imgData), p -> {
            if (imgData != null) {
                try {
                    DecryptStreamSrc src = new DecryptStreamSrc(new ByteArrayStreamSrc(imgData));
                    Image img = Image.load(filename, src);
                    assert (img != null);
                    if (!new File(filename).exists()) {
                        return img;
                    }
                    IStreamSrc existingSrc = FileSystem.INSTANCE.getStreamSrc(filename, 3);
                    Image existing = Image.loadUnchecked(filename, existingSrc);
                    if (!new HashableImage(img).equals(existing)) {
                        return img;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ImageManager.getImage(filename, 3, 0);
        });
    }

    public List<IPyroGeomSrc> getGrids() {
        return PyroGeomConverter.filterObjs(this.d_geomObjs, o -> o.getType() == 5);
    }

    public List<IPyroGeomSrc> getOpenVents() {
        return PyroGeomConverter.filterObjs(this.d_geomObjs, o -> PyroGeomConverter.isOpenVent(o));
    }

    public List<IPyroGeomSrc> getVents() {
        return PyroGeomConverter.filterObjs(this.d_geomObjs, o -> o.getType() == 2);
    }

    public List<IPyroGeomSrc> getObstructions(Collection<IPyroGeomSrc> allObjs) {
        return PyroGeomConverter.filterObjs(this.d_geomObjs, o -> o.getType() == 3);
    }

    public static boolean isHole(IPyroGeomSrc obj) {
        return obj.getType() == 4;
    }

    public static boolean isOpenVent(IPyroGeomSrc obj) {
        if (obj.getType() != 2) {
            return false;
        }
        IPyroSurface[] surfs = obj.getSurfaces();
        if (surfs == null || surfs.length == 0) {
            return false;
        }
        return surfs[0].getName().equals(OPEN_NAME);
    }

    public ICompElement convertObjects(String name) {
        return this.convertObjects(name, this.d_geomObjs);
    }

    private ICompElement convertObjects(String name, Collection<IPyroGeomSrc> allObjs) {
        GeomComposite merGroup = new GeomComposite(name);
        for (IPyroGeomSrc obj : allObjs) {
            DisplayGeom dg;
            if (obj.getType() == 1) {
                merGroup.add(this.convertObjects(obj.getName(), obj.getChildren()));
                continue;
            }
            if (obj.getType() != 3 && (obj.getType() != 2 || PyroGeomConverter.isOpenVent(obj)) || PyroGeomConverter.isEmpty(dg = this.convertGeomSrc(obj, this.d_propsPool))) continue;
            ImportedGeom ig = new ImportedGeom(obj.getName(), dg);
            merGroup.add(ig);
        }
        return merGroup;
    }

    private IGeom convertAABox(IPyroGeom obj) {
        PyroPoint3d[] corners = obj.getCorners();
        return new AABoxGeom(this.getPoint(corners[0]), this.getPoint(corners[1]), 0);
    }

    private static <PType, NType> IElemSource<NType> getElemMesh(Class<NType> nclazz, List<PType[]> pelems, Function<PType, NType> mapper) {
        assert (!pelems.isEmpty());
        int vertsPerPrim = pelems.get(0).length;
        assert (vertsPerPrim > 0 && vertsPerPrim <= 4);
        LinkedHashMap<Object, Integer> elemIxMap = new LinkedHashMap<Object, Integer>();
        Function<Object, Integer> newIx = n -> elemIxMap.size();
        int[] elemIxes = new int[vertsPerPrim * pelems.size()];
        int uvix = 0;
        for (PType[] pelem : pelems) {
            for (int m = 0; m < pelem.length; ++m) {
                NType nval = mapper.apply(pelem[m]);
                elemIxes[uvix++] = elemIxMap.computeIfAbsent(nval, newIx);
            }
        }
        ElementMesh mesh = new ElementMesh(ElementMesh.Mapping.PER_PRIM_VERTEX, theUtil.toArray(elemIxMap.keySet(), nclazz), elemIxes, vertsPerPrim);
        return mesh.optimize(nclazz);
    }

    private static <PType, NType> IElemSource<NType> getElemPoly(Class<NType> nclazz, PType[] ppoly, Function<PType, NType> mapper) {
        Object[] nelems = (Object[])Array.newInstance(nclazz, ppoly.length);
        for (int m = 0; m < ppoly.length; ++m) {
            nelems[m] = mapper.apply(ppoly[m]);
        }
        if (theUtil.isUniform(nelems)) {
            return new ElementUniform<Object>(nelems[0]);
        }
        return new ElementPoly<Object>(nelems);
    }

    private IPropsSrc convertPrimProps(HashPool<IPrimProps> propsPool, IPyroPrimProps[] pprops) {
        if (propsPool != null) {
            PropsBuilder src = new PropsBuilder();
            for (int m = 0; m < pprops.length; ++m) {
                IPrimProps props = this.convertPrimProps(pprops[m]);
                props = propsPool.getExisting(props);
                src.add(props);
            }
            return src.finalizeProps();
        }
        return s_defProps;
    }

    private IPrimProps convertPrimProps(IPyroPrimProps pprops) {
        IMaterial mat;
        IPyroPrimProps.Type type = pprops.getType();
        switch (type) {
            case VERTEX: {
                return new IPrimProps.Vertex(pprops.getColor(), pprops.getPointSize());
            }
            case EDGE: {
                return new IPrimProps.Edge(pprops.getColor(), pprops.getEdgeWidth(), pprops.getEdgeStipple(), 0);
            }
        }
        IPyroSurface surf = pprops.getMaterial();
        IMaterial iMaterial = mat = surf != null ? (IMaterial)this.d_matMap.get(surf) : null;
        if (type == IPyroPrimProps.Type.FACE) {
            return new IPrimProps.Face(pprops.getColor(), mat, 0);
        }
        return new IPrimProps.GenericProps(pprops.getColor(), mat, pprops.getEdgeWidth(), pprops.getEdgeStipple(), pprops.getPointSize(), 0);
    }

    private IGeom convertPolygon(IPyroGeom pgeom) {
        PyroPoint3d[][] ploops = pgeom.getLoops();
        if (ploops.length == 0 || ploops[0].length < 3) {
            return EmptyGeom.INSTANCE;
        }
        Point3d[][] loops = new Point3d[ploops.length][];
        for (int m = 0; m < ploops.length; ++m) {
            loops[m] = this.getPoints(ploops[m]);
        }
        return PolyUtil.newPoly(loops);
    }

    private Pair<IGeom, List<Pair<IGeom, Integer>>> convertComposite(IPyroGeom pgeom) {
        Collection<? extends IPyroGeom> pchildren = pgeom.getChildren();
        ArrayList children = new ArrayList(pchildren.size());
        ArrayList geoms = new ArrayList(pchildren.size());
        for (IPyroGeom iPyroGeom : pchildren) {
            Pair<IGeom, List<Pair<IGeom, Integer>>> converted = this.convert(iPyroGeom);
            children.addAll((Collection)converted.v2);
            if (converted.v1 == EmptyGeom.INSTANCE) continue;
            geoms.add(converted.v1);
        }
        geoms.trimToSize();
        return new Pair<IGeom, List<Pair<IGeom, Integer>>>(thunderheadeng.geometry.objs.GeomUtil.group(geoms), children);
    }

    private IGeom convertMesh(IPyroGeom pgeom) {
        byte type;
        switch (pgeom.getSubType()) {
            case 1: {
                type = 0;
                break;
            }
            case 2: {
                type = 1;
                break;
            }
            case 3: {
                type = 2;
                break;
            }
            case 4: {
                type = 3;
                break;
            }
            default: {
                return EmptyGeom.INSTANCE;
            }
        }
        Point3d[] points = this.getPoints(pgeom.getVerts());
        int[] indices = pgeom.getIndices();
        return new Mesh(points, indices, type);
    }

    private Pair<IGeom, List<Pair<IGeom, Integer>>> convert(IPyroGeom pgeom) {
        return this.d_geomMap.computeIfAbsent(pgeom, pg -> {
            int numPrims = pg.getNumPrims();
            IGeom geom = null;
            switch (pg.getType()) {
                case 4: {
                    geom = this.convertAABox((IPyroGeom)pg);
                    break;
                }
                case 5: {
                    geom = this.convertPolygon((IPyroGeom)pg);
                    break;
                }
                case 3: {
                    geom = this.convertMesh((IPyroGeom)pg);
                    break;
                }
                case 1: {
                    return this.convertComposite((IPyroGeom)pg);
                }
            }
            return new Pair<EmptyGeom, List<Pair<IGeom, Integer>>>((EmptyGeom)(geom == null ? EmptyGeom.INSTANCE : geom), Collections.singletonList(new Pair<IGeom, Integer>(geom, numPrims)));
        });
    }

    private ITransform convertTransform(double[] xform) {
        Matrix4d pxform = new Matrix4d(xform);
        return this.d_transformPool.computeIfAbsent(pxform, p -> new MatrixXform(pxform));
    }

    private <PType, NType> IElemSource<NType> convertElements(PType[][] pelems, IElemSource<NType> defElems, Class<NType> nclazz, Function<PType, NType> mapper) {
        List elemList = Arrays.asList(pelems);
        Function<Object[], Integer> lenFunc = arr -> arr == null ? 0 : ((Object[])arr).length;
        ElementBuilder builder = new ElementBuilder(defElems);
        theUtil.groupSequentialMatches(elemList, lenFunc, (items, offset, Integer2) -> {
            int len = (Integer)lenFunc.apply((Object[])items.get(0));
            if (len == 0) {
                builder.add(defElems, items.size());
            } else if (len >= 1 && len <= 4) {
                builder.add(PyroGeomConverter.getElemMesh(nclazz, items, mapper), items.size());
            } else {
                for (Object[] pelem : items) {
                    builder.add(PyroGeomConverter.getElemPoly(nclazz, pelem, mapper), 1);
                }
            }
        });
        return builder.finish();
    }

    private <PType, NType> void convertElements(double[] parentXform, IPropertySet elems, IPyroGeomNode node, IPyroGeomNode.Elem<PType> pelem, Elements.ElemProp<NType> nelem, Function<PType, NType> mapper, List<IPyroPrimProps> props) {
        PType[][] pelems = node.getElements(parentXform, pelem, props);
        IElemSource result = this.convertElements(pelems, (IElemSource)nelem.defVal, nelem.type, mapper);
        elems.setIfNotDefault(nelem, result);
    }

    private Map<String, IElemSource<Point2d>> convertUVElements(double[] parentXform, IPyroGeomNode node, List<IPyroPrimProps> pprops, IPropsSrc nprops) {
        Function<PyroPoint2d, Point2d> uvMapper = puv -> {
            Point2d p = new Point2d(puv.x, puv.y);
            return this.d_uvPool.getExisting(p);
        };
        Map<String, PyroPoint2d[][]> puvs = node.getUVElements(parentXform, pprops);
        if (puvs.isEmpty()) {
            return Collections.emptyMap();
        }
        ListMap<String, IElemSource<Point2d>> uvs = new ListMap<String, IElemSource<Point2d>>();
        for (Map.Entry<String, PyroPoint2d[][]> entry : puvs.entrySet()) {
            String uvsetName = entry.getKey();
            IElemSource<Point2d> uv = this.convertElements((Object[][])entry.getValue(), ImportedGeom.DEFUV, Point2d.class, uvMapper);
            if (uv.equals(Elements.NO_UV)) continue;
            uvs.put(uvsetName, uv);
        }
        return uvs;
    }

    private IPropertySet convertElements(double[] parentXform, IPyroGeomNode node, List<IPyroPrimProps> pprops, IPropsSrc nprops) {
        Function<Boolean, Elements.Orient> ccwMapper = b -> b != false ? Elements.Orient.CCW : Elements.Orient.CW;
        Function<PyroPoint3d, Vector3d> normMapper = pnorm -> {
            Vector3d n = new Vector3d(pnorm.x, pnorm.y, pnorm.z);
            return this.d_normalPool.getExisting(n);
        };
        IPropertySet elements = Elements.newElements();
        this.convertElements(parentXform, elements, node, IPyroGeomNode.CREASE, Elements.CREASE, b -> b, pprops);
        this.convertElements(parentXform, elements, node, IPyroGeomNode.CCW, Elements.ORIENT, ccwMapper, pprops);
        this.convertElements(parentXform, elements, node, IPyroGeomNode.NORMAL, Elements.NORMAL, normMapper, pprops);
        elements.setIfNotDefault(Elements.UV, this.convertUVElements(parentXform, node, pprops, nprops));
        return Elements.finalizeElements(elements);
    }

    private static double[] getElements(Matrix4d xform) {
        double[] elems = new double[16];
        for (int m = 0; m < 4; ++m) {
            for (int n = 0; n < 4; ++n) {
                elems[m * 4 + n] = xform.getElement(m, n);
            }
        }
        return elems;
    }

    private IGeomNode convert(double[] parentXform, IPyroGeomNode pnode, IPyroPrimProps[] pprops, IPropsSrc nprops, int propOffset, PropsBuilder propsBuilder) {
        ITransform xform = this.convertTransform(pnode.getTransform());
        Pair<IGeom, List<Pair<IGeom, Integer>>> geoms = this.convert(pnode.getGeom());
        int numPrims = pnode.getGeom().getNumPrims();
        List<IPyroPrimProps> propsList = pprops.length == 1 ? Collections.nCopies(numPrims, pprops[0]) : Arrays.asList(pprops).subList(propOffset, propOffset + numPrims);
        IPropertySet elems = this.convertElements(parentXform, pnode, propsList, nprops.subset(propOffset, numPrims));
        IGeom geom = (IGeom)geoms.v1;
        if (((List)geoms.v2).stream().noneMatch(p -> p.v1 == null)) {
            propsBuilder.add(nprops.subset(propOffset, numPrims), numPrims);
            propOffset += numPrims;
        } else {
            ElementsBuilder elemBuilder = new ElementsBuilder();
            int eoffset = 0;
            int poffset = propOffset;
            for (Pair entry : (List)geoms.v2) {
                if (entry.v1 != null) {
                    elemBuilder.add(Elements.subset(elems, eoffset, (Integer)entry.v2), (Integer)entry.v2);
                    propsBuilder.add(nprops.subset(poffset, (Integer)entry.v2), (int)((Integer)entry.v2));
                }
                eoffset += ((Integer)entry.v2).intValue();
                poffset += ((Integer)entry.v2).intValue();
            }
            assert (poffset == propOffset + numPrims);
            propOffset = poffset;
            elems = elemBuilder.finish();
        }
        Matrix4d wlxform = new Matrix4d(parentXform);
        wlxform.mul(new Matrix4d(pnode.getTransform()));
        double[] wlxformArr = PyroGeomConverter.getElements(wlxform);
        IPyroGeomNode[] pchildren = pnode.getChildren();
        ArrayList<IGeomNode> children = new ArrayList<IGeomNode>(pchildren.length);
        for (int m = 0; m < pchildren.length; ++m) {
            IPyroGeomNode pchild = pchildren[m];
            IGeomNode cnode = this.convert(wlxformArr, pchild, pprops, nprops, propOffset, propsBuilder);
            if (cnode != GeomNodeUtil.EMPTY_NODE) {
                children.add(cnode);
            }
            propOffset += PyroGeomConverter.getNumPrims(pchild);
        }
        return GeomNodeUtil.newNode(xform, geom, elems, children);
    }

    private static int getNumPrims(IPyroGeomNode node) {
        int count = node.getGeom().getNumPrims();
        for (IPyroGeomNode child : node.getChildren()) {
            count += PyroGeomConverter.getNumPrims(child);
        }
        return count;
    }

    private DisplayGeom convertDisplay(IPyroGeomNode pgeom, IPyroPrimProps[] pprops, HashPool<IPrimProps> propsPool) {
        IPropsSrc props = this.convertPrimProps(propsPool, pprops);
        PropsBuilder propsBuilder = new PropsBuilder();
        IGeomNode node = this.convert(PyroGeomConverter.getElements(GeomConstants.IDENTITY4d), pgeom, pprops, props, 0, propsBuilder);
        return new DisplayGeom(node, propsBuilder.finalizeProps());
    }

    private DisplayGeom convertGeomSrc(IPyroGeomSrc obj, HashPool<IPrimProps> propsPool) {
        return this.convertDisplay(obj.getGeomRoot(), obj.getPrimProps(), propsPool);
    }

    private static boolean isEmpty(DisplayGeom dg) {
        return dg == DisplayGeom.EMPTY || dg.node == GeomNodeUtil.EMPTY_NODE || dg.node.getNumPrims(7) == 0;
    }
}

