/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CancelledException;
import merlin.actions.importgeom.IImporter;
import merlin.actions.importgeom.ImportOptions;
import merlin.data.GeomComposite;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.DistributionEditor;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IUrn;

public class ImportCSV
implements IImporter {
    private static final IPropertySet.Prop<IUrn<OccProfile>> PROFILE_PROP = new IPropertySet.Prop<Object>("PROFILE", null);
    private static final IPropertySet.Prop<IUrn<Behavior>> BEHAVIOR_PROP = new IPropertySet.Prop<Object>("BEHAVIOR", null);

    @Override
    public String[] getFileFilters() {
        return new String[]{"csv", Intl.intl("Occupant Positions CSV")};
    }

    @Override
    public void initDefaultOptions(MerlinData md, String ext, IPropertySet options) {
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        MerlinData md = options.get(ImportOptions.MD);
        return new AgentPositionsImportCard(md);
    }

    @Override
    public void cleanup(IPropertySet options) {
    }

    @Override
    public IImporter.Result read(MerlinApp app, String fn, IPropertySet options) throws IOException, CancelledException {
        ArrayList<EgressAgent> agents = new ArrayList<EgressAgent>();
        IUrn<Behavior> behavior = options.get(BEHAVIOR_PROP);
        IUrn<OccProfile> profile = options.get(PROFILE_PROP);
        MerlinData md = options.get(ImportOptions.MD);
        long rseed = 0L;
        if (System.getProperty("csvimport_rseed") != null) {
            try {
                rseed = Long.parseLong(System.getProperty("csvimport_rseed"));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        Random rand = new Random(rseed);
        try (BufferedReader r = new BufferedReader(new FileReader(fn));){
            String line = r.readLine();
            while (line != null) {
                List<String> toks = CSVLineParser.parse(line, ", ", "");
                try {
                    Point3d pt = new Point3d(Double.parseDouble(toks.get(0)), Double.parseDouble(toks.get(1)), Double.parseDouble(toks.get(2)));
                    Behavior behav = behavior.getValue(rand);
                    OccProfile op = new OccProfile(profile.getValue(rand));
                    EgressAgent agent = new EgressAgent(op, behav);
                    agent.setLocation(new OccLocation(pt));
                    agent.setName(md.occNameGen.nextName(true));
                    agents.add(agent);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                line = r.readLine();
            }
        }
        if (!agents.isEmpty()) {
            EgressAgentComp comp = new EgressAgentComp(Intl.intl("Imported Occupants"));
            comp.addAll(agents);
            return new IImporter.Result(new GeomComposite(""), new Pair<EgressAgentComp, EgressAgentComp>(md.agents, comp));
        }
        return IImporter.Result.EMPTY;
    }

    private static class AgentPositionsImportCard
    extends AWizardCard<IPropertySet> {
        private static final long serialVersionUID = -5480141221455494060L;
        private final DistributionEditor<OccProfile> d_profileDistEd;
        private final DistributionEditor<Behavior> d_behaviorDistEd;

        public AgentPositionsImportCard(MerlinData md) {
            super(Intl.intl("Import occupants from CSV positions."));
            this.d_profileDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
            this.d_behaviorDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Profile:"), this.d_profileDistEd, GridBagHelper.REMAINING, 1.0);
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorDistEd, GridBagHelper.REMAINING, 1.0);
            gb.finalizeRows();
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            boolean configured = this.d_profileDistEd.getValue() != null && this.d_behaviorDistEd.getValue() != null;
            switch (action) {
                case 0: {
                    return true;
                }
                case 4: {
                    return configured;
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet data) {
            if (data.get(PROFILE_PROP) != null) {
                this.d_profileDistEd.setValue((OccProfile)data.get(PROFILE_PROP));
            }
            if (data.get(BEHAVIOR_PROP) != null) {
                this.d_behaviorDistEd.setValue((Behavior)data.get(BEHAVIOR_PROP));
            }
        }

        @Override
        public void saveTo(IPropertySet data) {
            data.set(PROFILE_PROP, this.d_profileDistEd.getValue());
            data.set(BEHAVIOR_PROP, this.d_behaviorDistEd.getValue());
        }

        @Override
        public AWizardCard<?> getNext() {
            return null;
        }

        @Override
        public void cancel() {
        }
    }
}

