/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.GeomPasteHandler;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class OccSourceObjPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return OccSourceObj.OccSourceComp.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        IEgressComp component = this.getComponent(pasteObj);
        if (component != null) {
            return CopyPasteUtil.getGeomPasteHints(md, pasteObjMap, pasteObj);
        }
        return new PasteHints();
    }

    private IEgressComp getComponent(IDomainObject<MerlinData> pasteObj) {
        IEgressComp component = null;
        if (pasteObj instanceof OccSourceObj) {
            OccSourceObj oso = (OccSourceObj)pasteObj;
            component = oso.getComponent();
        }
        return component;
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<IDomainObject> selectAccum, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Collection<Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, selectedLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, hints, selectAccum, insertRoot, true);
        IEgressComp component = this.getComponent(pasteObj);
        if (component != null && !pasteObjMap.containsKey(component)) {
            GeomPasteHandler componentHandler = new GeomPasteHandler();
            AbstractMap.SimpleEntry<IDomainObject, String> newEntry = new AbstractMap.SimpleEntry<IDomainObject, String>(component, FloorComposite.class.getName());
            componentHandler.pasteApply(md, app, pasteObjMap, newEntry, hints, selectAccum, selectedComposites, selectedLeaves, warnings);
        }
    }
}

