/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Collection;
import java.util.Map;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.EgressAgentComp;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class GeomPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName) || EgressAgentComp.class.getName().equals(mdRootClassName) || OccSourceObj.OccSourceComp.class.getName().equals(mdRootClassName);
    }

    public boolean shouldRename(String mdRootClassName) {
        return EgressAgentComp.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return CopyPasteUtil.getGeomPasteHints(md, pasteObjMap, pasteObj);
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<IDomainObject> selectAccum, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Collection<Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, selectedLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        boolean shouldRename = this.shouldRename(insertRoot.getClass().getName());
        CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, hints, selectAccum, insertRoot, shouldRename);
    }
}

