/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.egress.scripting.IBehaviorAction;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class BehaviorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return BehaviorRoot.class.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<IDomainObject> selectAccum, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Collection<Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, selectedLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
        CopyPasteUtil.renamePasteObj(nameSibs, pasteObj);
        if (pasteEntry.getKey() instanceof IBehaviorAction) {
            int ix = ((IBehaviorAction)pasteEntry.getKey()).mustBeLast() ? insertRoot.getMembers().size() : insertRoot.getMembers().size() - 1;
            Undo.InsertOp op = new Undo.InsertOp(insertRoot, Arrays.asList(pasteEntry.getKey()), ix);
            Undo.insertEntry(md, op.perform(md.selection));
        } else {
            CopyPasteUtil.pasteInto(md, insertRoot, pasteEntry.getKey());
        }
        selectAccum.add(pasteObj);
    }
}

