/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.FloorSortActions;
import merlin.actions.SubtractAction;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.OccSourceObj;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.geom.GeomUtil;
import merlin.geom.IMerlinGeomSrc;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class TransformAction
extends AMerlinOp {
    @Override
    public void run(MerlinApp app, MerlinData md) {
    }

    public static Collection<IMerlinGeomSrc> getGeom(MerlinData md, Collection<? extends IMerlinObj> objs) {
        return QueuePath.pruneQueueTransforms(md, MerlinUtil.flatten(objs, IMerlinGeomSrc.class));
    }

    public static Set<IMerlinObj> getValidObjs(MerlinData md) {
        Set<IMerlinObj> selObjs = md.selection.getSelected(IMerlinObj.class);
        TransformAction.flattenRoots(md, selObjs);
        TransformAction.modifySelElevatorComponents(md, selObjs);
        return MerlinUtil.filter(selObjs, new Predicate<IMerlinObj>(){

            @Override
            public boolean test(IMerlinObj o) {
                if (o instanceof Composite) {
                    return !((Composite)o).getDeepMembers(IMerlinGeomSrc.class).isEmpty();
                }
                return o instanceof IMerlinGeomSrc;
            }
        });
    }

    private static Collection<? extends IMerlinObj> promoteSelection(MerlinData md, Set<IMerlinObj> selection) {
        LinkedIdentityHashSet<IMerlinObj> newSelObjs = new LinkedIdentityHashSet<IMerlinObj>();
        ArrayList<Object> remSelObjs = new ArrayList<Object>();
        LinkedIdentityHashSet testParents = new LinkedIdentityHashSet();
        while (true) {
            for (IMerlinObj obj : selection) {
                Object parent;
                if (newSelObjs.contains(obj) || !((parent = md.hierarchy.getParent(obj)) instanceof IMerlinObj)) continue;
                testParents.add((IMerlinObj)parent);
            }
            for (IMerlinObj parent : testParents) {
                if (TransformAction.containsAncestor(newSelObjs, selection, md, parent) || !selection.containsAll(md.hierarchy.getChildren(parent))) continue;
                newSelObjs.add(parent);
                remSelObjs.addAll(md.hierarchy.getChildren(parent));
            }
            if (newSelObjs.isEmpty() && remSelObjs.isEmpty()) break;
            selection.removeAll(remSelObjs);
            selection.addAll(newSelObjs);
            newSelObjs.clear();
            remSelObjs.clear();
            testParents.clear();
        }
        return selection;
    }

    private static boolean containsAncestor(Set<IMerlinObj> set1, Set<IMerlinObj> set2, MerlinData md, Object obj) {
        while (obj instanceof IMerlinObj) {
            if (set1.contains(obj) || set2.contains(obj)) {
                return true;
            }
            obj = md.hierarchy.getParent(obj);
        }
        return false;
    }

    private static void flattenRoots(MerlinData md, Set<IMerlinObj> objs) {
        ArrayList<IMerlinObj> toAdd = new ArrayList<IMerlinObj>();
        ArrayList<IMerlinObj> toRemove = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : objs) {
            TransformAction.flattenRoots(md, obj, toAdd, toRemove);
        }
        objs.removeAll(toRemove);
        objs.addAll(toAdd);
    }

    private static boolean flattenRoots(MerlinData md, IMerlinObj obj, List<IMerlinObj> addObjs, List<IMerlinObj> removeObjs) {
        if (!(obj instanceof Composite)) {
            return false;
        }
        Composite group = (Composite)obj;
        if (TransformAction.isDuplicateRoot(md, group)) {
            removeObjs.add(group);
            for (IMerlinObj iMerlinObj : group.getMembers()) {
                if (TransformAction.flattenRoots(md, iMerlinObj, addObjs, removeObjs)) continue;
                addObjs.add(iMerlinObj);
            }
            return true;
        }
        return false;
    }

    private static boolean isDuplicateRoot(MerlinData md, Composite<?> group) {
        return group instanceof Floor || md.getChildren().contains(group);
    }

    private static void modifySelElevatorComponents(MerlinData md, Set<IMerlinObj> objs) {
        ArrayList<AEgressComp> toRemove = new ArrayList<AEgressComp>();
        toRemove.addAll(theUtil.filter(objs, ElevatorDoor.class));
        toRemove.addAll(theUtil.filter(objs, ElevatorRoom.class));
        objs.removeAll(toRemove);
    }

    public static List<List<IMerlinObj>> transform(MerlinApp app, MerlinData md, Consumer<? super EgressRoom> toClean, Collection<? extends IMerlinObj> objs, int numCopies, TransformInfo ... xforms) {
        return TransformAction.transformImpl(app, md, toClean, objs, numCopies, xforms);
    }

    public static int getSubtractOptions(TransformInfo ... xforms) {
        int sopts = 0;
        boolean noScaling = Stream.of(xforms).map(ti -> ti.xform).allMatch(xform -> TransformUtil.findTransformLastToFirst(xform, TransformUtil.SCALING_FILTER) == null);
        if (noScaling) {
            sopts |= 1;
        }
        return sopts;
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<IMerlinObj>> transformImpl(MerlinApp app, MerlinData md, Consumer<? super EgressRoom> toClean, Collection<? extends IMerlinObj> objs, int numCopies, TransformInfo ... xforms) {
        void var13_22;
        assert (numCopies == 0 && xforms.length == 1 || xforms.length == numCopies);
        int sopts = TransformAction.getSubtractOptions(xforms);
        if (numCopies == 0) {
            Collection<IRestorable> rest = MerlinUtil.flatten(objs, IRestorable.class);
            Undo.insertUndoEntry_restore(md, rest);
            TransformInfo xform = xforms[0];
            ArrayList<EgressRoom> subtractors = new ArrayList<EgressRoom>();
            for (IMerlinGeomSrc src : TransformAction.getGeom(md, objs)) {
                src.transform(xform);
                if (!(src instanceof EgressRoom)) continue;
                subtractors.add((EgressRoom)src);
            }
            SubtractAction.subtract(app, md, sopts, toClean, subtractors);
            Collection<IEgressComp> sortable = FloorSortActions.getSortableObjs(md, objs);
            FloorSortActions.updateComponentFloors(md, sortable);
            return Collections.EMPTY_LIST;
        }
        LinkedIdentityHashSet<IMerlinObj> srcObjs = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)objs);
        Predicate<IMerlinObj> xformFilter = TransformAction.modifyCopyObjs(md, srcObjs);
        ArrayList<List<IMerlinObj>> newObjs = new ArrayList<List<IMerlinObj>>(numCopies);
        int copy = 0;
        TransformInfo[] src = xforms;
        int n = src.length;
        boolean bl = false;
        while (var13_22 < n) {
            TransformInfo ti = src[var13_22];
            LinkedIdentityHashMap<IMerlinObj, IMerlinObj> copyMap = new LinkedIdentityHashMap<IMerlinObj, IMerlinObj>();
            ArrayList<IMerlinObj> copiedObjs = new ArrayList<IMerlinObj>(objs.size());
            newObjs.add(copiedObjs);
            String copyDesc = String.format(Intl.intl("_%s"), ++copy);
            for (IMerlinObj obj : srcObjs) {
                IMerlinObj newObj = TransformAction.copy(md, copyMap, ti, xformFilter, obj);
                if (newObj == obj) continue;
                if (newObj instanceof INamed) {
                    String newName = ((INamed)((Object)newObj)).getName() + copyDesc;
                    ((INamed)((Object)newObj)).setName(newName);
                }
                Composite parent = (Composite)md.hierarchy.getParent(obj);
                Undo.insertUndoEntry_delete(md, parent, newObj);
                parent.add((ICompElement)newObj);
                copiedObjs.add(newObj);
            }
            TransformAction.fixRefs(srcObjs, copyMap);
            for (EgressRoom newRoom : MerlinUtil.flatten(copiedObjs, EgressRoom.class)) {
                newRoom.setColor(theUtil.newRandomColor());
            }
            ++var13_22;
        }
        ArrayList<IEgressComp> sortableComps = new ArrayList<IEgressComp>();
        for (List list : newObjs) {
            sortableComps.addAll(FloorSortActions.getSortableObjs(md, list));
        }
        FloorSortActions.updateComponentFloors(md, sortableComps);
        for (int m = 0; m < newObjs.size(); ++m) {
            ArrayList arrayList = new ArrayList((Collection)newObjs.get(m));
            for (int n2 = m + 1; n2 < newObjs.size(); ++n2) {
                arrayList.addAll((Collection)newObjs.get(n2));
            }
            Collection<EgressRoom> newXformedRooms = MerlinUtil.flatten(arrayList, EgressRoom.class);
            newXformedRooms.forEach(toClean);
            SubtractAction.subtract(app, md, sopts, toClean, newXformedRooms);
        }
        md.selection.clear();
        for (List list : newObjs) {
            for (IMerlinObj obj : list) {
                if (md.hierarchy.getParent(obj) == null) continue;
                md.selection.select(obj);
            }
        }
        return newObjs;
    }

    private static IMerlinObj copy(MerlinData md, Map<IMerlinObj, IMerlinObj> copyMap, TransformInfo ti, Predicate<IMerlinObj> xformFilter, IMerlinObj obj) {
        IMerlinObj copiedObj;
        if (obj instanceof Elevator) {
            copiedObj = TransformAction.copyElevator((Elevator)obj, ti, copyMap);
        } else if (obj instanceof QueuePath) {
            copiedObj = TransformAction.copyQueuePath(md, (QueuePath)obj, ti, copyMap);
        } else if (obj instanceof QueuePathNode) {
            copiedObj = TransformAction.copyQueuePathNode(md, (QueuePathNode)obj, ti);
        } else if (obj instanceof Composite) {
            Composite group = (Composite)obj;
            Composite newGroup = (Composite)group.clone();
            newGroup.clear();
            for (ICompElement child : group.getMembers()) {
                newGroup.add((ICompElement)TransformAction.copy(md, copyMap, ti, xformFilter, child));
            }
            copiedObj = newGroup;
        } else if (obj instanceof IMerlinGeomSrc) {
            IMerlinGeomSrc newObj = (IMerlinGeomSrc)((IMerlinGeomSrc)((Object)obj)).clone();
            if (xformFilter.test(obj)) {
                newObj.transform(ti);
            }
            copiedObj = (IMerlinObj)((Object)newObj);
        } else {
            copiedObj = (IMerlinObj)obj.clone();
        }
        copyMap.put(obj, copiedObj);
        return copiedObj;
    }

    private static QueuePathNode copyQueuePathNode(MerlinData md, QueuePathNode originalNode, TransformInfo ti) {
        QueuePathNode copiedNode = originalNode.clone();
        IGeomNode xFormGeom = copiedNode.getGeom().transform(ti);
        if (xFormGeom.getLocalGeom() instanceof Point) {
            Point3d pointLoc = ((Point)xFormGeom.getLocalGeom()).loc;
            GeomUtil.FindResult roomInfo = GeomUtil.findRoom(md, new Point3d(pointLoc.x, pointLoc.y, pointLoc.z + 1.0E-6), new Point3d(pointLoc.x, pointLoc.y, pointLoc.z - 1.0E-6), 1);
            if (roomInfo != null) {
                copiedNode.setLocation(roomInfo.room, roomInfo.faceNormal, pointLoc);
            } else {
                copiedNode.setLocation(null, GeomConstants.VEC3D_ZPOS, pointLoc);
            }
        }
        return copiedNode;
    }

    private static QueuePath copyQueuePath(MerlinData md, QueuePath obj, TransformInfo ti, Map<IMerlinObj, IMerlinObj> copyMap) {
        QueuePath copiedPath = obj.clone();
        copiedPath.clear();
        for (QueuePathNode originalNode : obj.getMembers(QueuePathNode.class)) {
            QueuePathNode copiedNode = TransformAction.copyQueuePathNode(md, originalNode, ti);
            copyMap.put(originalNode, copiedNode);
            copiedPath.add(copiedNode);
        }
        return copiedPath;
    }

    private static Elevator copyElevator(Elevator obj, TransformInfo ti, Map<IMerlinObj, IMerlinObj> copyMap) {
        Elevator newElevator = (Elevator)obj.clone();
        LinkedIdentityHashMap<ElevatorRoom, EgressRoom> roomClones = new LinkedIdentityHashMap<ElevatorRoom, EgressRoom>();
        for (ElevatorRoom er : obj.getMembers(ElevatorRoom.class)) {
            EgressRoom clone = er.clone(true, true, (Map)copyMap);
            clone.transform(ti);
            for (ElevatorDoor door : MerlinUtil.filter(clone.getDoors(), ElevatorDoor.class)) {
                door.transform(ti);
            }
            roomClones.put(er, clone);
            copyMap.put(er, clone);
            newElevator.add(clone);
            newElevator.setLevelData((ElevatorRoom)clone, obj.getLevelData(er));
        }
        newElevator.setDischargeRoom((ElevatorRoom)roomClones.get(obj.getDischargeRoom()));
        newElevator.setInitRoom((ElevatorRoom)roomClones.get(obj.getInitRoom()));
        if (!obj.getLevelPriority().isEmpty()) {
            List<ElevatorRoom> oldPriority = obj.getLevelPriority();
            ArrayList<ElevatorRoom> newPriority = new ArrayList<ElevatorRoom>(oldPriority.size());
            for (ElevatorRoom er : oldPriority) {
                newPriority.add((ElevatorRoom)roomClones.get(er));
            }
            newElevator.setLevelPriority(newPriority);
        }
        return newElevator;
    }

    private static Predicate<IMerlinObj> modifyCopyObjs(MerlinData md, Set<IMerlinObj> copyObjs) {
        IdentityHashSet<IMerlinObj> excludeObjs = new IdentityHashSet<IMerlinObj>();
        LinkedIdentityHashSet behaviorsInUse = new LinkedIdentityHashSet();
        Dependencies.getObjReferences(copyObjs, Behavior.class, Predicates.alwaysTrue(), (src, target) -> behaviorsInUse.add(target));
        if (!behaviorsInUse.isEmpty()) {
            LinkedIdentityHashSet<IMerlinObj> flattened = new LinkedIdentityHashSet<IMerlinObj>(MerlinUtil.flatten(copyObjs, IMerlinObj.class));
            LinkedIdentityHashSet copyBehaviors = behaviorsInUse;
            Iterator bit = copyBehaviors.iterator();
            while (bit.hasNext()) {
                Behavior behavior = (Behavior)bit.next();
                if (TransformAction.getCopyBehavior(behavior, flattened)) {
                    TransformAction.getExcludeCopyObjs(behavior, flattened, excludeObjs);
                    continue;
                }
                bit.remove();
            }
            for (Behavior behavior : copyBehaviors) {
                copyObjs.removeAll(behavior.getDeepMembers(IMerlinObj.class));
            }
            copyObjs.addAll(copyBehaviors);
        }
        return Filters.reject(excludeObjs);
    }

    private static boolean getCopyBehavior(Behavior behavior, Set<? extends IMerlinObj> flattenedCopyObjs) {
        if (flattenedCopyObjs.contains(behavior)) {
            return true;
        }
        for (IBehaviorAction action : behavior.getDeepMembers(IBehaviorAction.class)) {
            NamedMerlinObj ge;
            if (action instanceof GotoElevators) {
                ge = (GotoElevators)action;
                for (Elevator el : ((GotoElevators)ge).getElevators()) {
                    if (!flattenedCopyObjs.contains(el)) continue;
                    return true;
                }
                continue;
            }
            if (action instanceof GotoRooms) {
                GotoRooms gr = (GotoRooms)action;
                for (IEgressOccupiable room : gr.getRooms()) {
                    if (!flattenedCopyObjs.contains(room)) continue;
                    return true;
                }
                continue;
            }
            if (action instanceof GotoOccTarget) {
                GotoOccTarget gol = (GotoOccTarget)action;
                for (OccTarget target : gol.get(GotoOccTarget.PROP_TARGETS)) {
                    if (!flattenedCopyObjs.contains(target)) continue;
                    return true;
                }
                continue;
            }
            if (action instanceof GotoExits) {
                ge = (GotoExits)action;
                for (EgressDoor exit : ((GotoExits)ge).get(GotoExits.PROP_EXITS)) {
                    if (!flattenedCopyObjs.contains(exit)) continue;
                    return true;
                }
                continue;
            }
            if (!(action instanceof IMerlinGeomSrc) || !flattenedCopyObjs.contains(action)) continue;
            return true;
        }
        return false;
    }

    private static void getExcludeCopyObjs(Behavior behavior, Set<? extends IMerlinObj> flattenedCopyObjs, Set<IMerlinObj> excludeCopyObjs) {
        for (IBehaviorAction action : behavior.getDeepMembers(IBehaviorAction.class)) {
            if (!(action instanceof IMerlinGeomSrc) || flattenedCopyObjs.contains(action)) continue;
            excludeCopyObjs.add(action);
        }
    }

    private static void fixRefs(Collection<? extends IMerlinObj> copyObjs, Map<IMerlinObj, IMerlinObj> copyMap) {
        for (IMerlinObj obj : MerlinUtil.flatten(copyObjs, IMerlinObj.class)) {
            if ((obj = copyMap.get(obj)) == null) continue;
            if (obj instanceof EgressAgent) {
                TransformAction.fixRefs(copyMap, (EgressAgent)obj);
                continue;
            }
            if (obj instanceof Behavior) {
                TransformAction.fixRefs(copyMap, (Behavior)obj);
                continue;
            }
            if (!(obj instanceof OccSourceObj)) continue;
            TransformAction.fixRefs(copyMap, (OccSourceObj)obj);
        }
    }

    private static void fixRefs(Map<IMerlinObj, IMerlinObj> copyMap, OccSourceObj os) {
        IMerlinObj copy;
        IEgressComp comp = os.getComponent();
        if (comp != null && (copy = copyMap.get(comp)) instanceof IEgressComp) {
            os.set(OccSourceObj.PROP_COMPONENT, (IEgressComp)copy);
        }
        IUrn<Behavior> behaviors = os.get(OccSourceObj.PROP_BEHAVIOR_DIST);
        Map<Behavior, Double> dist = behaviors.getWeights();
        LinkedIdentityHashMap<Behavior, Double> newDist = null;
        for (Map.Entry<Behavior, Double> entry : dist.entrySet()) {
            IMerlinObj copy2 = copyMap.get(entry.getKey());
            if (!(copy2 instanceof Behavior)) continue;
            if (newDist == null) {
                newDist = new LinkedIdentityHashMap<Behavior, Double>(dist);
            }
            newDist.remove(entry.getKey());
            newDist.put((Behavior)copy2, entry.getValue());
        }
        if (newDist != null) {
            os.set(OccSourceObj.PROP_BEHAVIOR_DIST, UrnUtil.newUrn(newDist));
        }
    }

    private static void fixRefs(Map<IMerlinObj, IMerlinObj> copyMap, EgressAgent agent) {
        IMerlinObj cbehavior = copyMap.get(agent.getBehavior());
        if (cbehavior instanceof Behavior) {
            agent.setBehavior((Behavior)cbehavior);
        }
    }

    private static void fixRefs(Map<IMerlinObj, IMerlinObj> copyMap, Behavior behavior) {
        for (IBehaviorAction action : behavior.getDeepMembers(IBehaviorAction.class)) {
            NamedMerlinObj ge;
            if (action instanceof GotoExits) {
                ge = (GotoExits)action;
                Set<EgressDoor> oldExits = ((GotoExits)ge).get(GotoExits.PROP_EXITS);
                Set<EgressDoor> newExits = TransformAction.fixSetRefs(copyMap, oldExits, EgressDoor.class);
                ((GotoExits)ge).set(GotoExits.PROP_EXITS, newExits);
            }
            if (action instanceof GotoElevators) {
                ge = (GotoElevators)action;
                Set<Elevator> oldElevators = ((GotoElevators)ge).getElevators();
                Set<Elevator> newElevators = TransformAction.fixSetRefs(copyMap, oldElevators, Elevator.class);
                ((GotoElevators)ge).setElevators(newElevators);
                continue;
            }
            if (action instanceof GotoRooms) {
                GotoRooms gr = (GotoRooms)action;
                Set<IEgressOccupiable> oldRooms = gr.getRooms();
                Set<IEgressOccupiable> newRooms = TransformAction.fixSetRefs(copyMap, oldRooms, IEgressOccupiable.class);
                gr.setRooms(newRooms);
                continue;
            }
            if (!(action instanceof GotoOccTarget)) continue;
            GotoOccTarget gol = (GotoOccTarget)action;
            Set<OccTarget> oldObjs = gol.get(GotoOccTarget.PROP_TARGETS);
            Set<OccTarget> newObjs = TransformAction.fixSetRefs(copyMap, oldObjs, OccTarget.class);
            gol.set(GotoOccTarget.PROP_TARGETS, newObjs);
        }
    }

    private static <T> Set<T> fixSetRefs(Map<IMerlinObj, IMerlinObj> copyMap, Set<T> oldSet, Class<T> type) {
        if (TransformAction.containsAny(copyMap.keySet(), oldSet)) {
            LinkedIdentityHashSet newSet = new LinkedIdentityHashSet(oldSet.size());
            for (T obj : oldSet) {
                IMerlinObj newObj = copyMap.get(obj);
                if (type.isInstance(newObj)) {
                    obj = type.cast(newObj);
                }
                newSet.add(obj);
            }
            return newSet;
        }
        return oldSet;
    }

    private static <T> boolean containsAny(Set<T> coll, Collection<?> testObjs) {
        if (coll.isEmpty()) {
            return false;
        }
        for (Object obj : testObjs) {
            if (!coll.contains(obj)) continue;
            return true;
        }
        return false;
    }
}

