/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.Delete;
import merlin.actions.Undo;
import merlin.actions.geomops.SeparateGeom;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.util.BitOptions;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SubtractAction {
    public static final int OPT_EXCLUDE_SUBTRACT_COMPONENTS = 1;
    public static final int OPT_NO_SEPARATE_ROOMS = 2;
    public static final int OPT_FILE_LOAD = 4;

    public static void subtract(MerlinApp app, MerlinData md, int options, Consumer<? super EgressRoom> toClean, EgressRoom ... subComps) {
        SubtractAction.subtract(app, md, options, toClean, Arrays.asList(subComps));
    }

    public static void subtract(MerlinApp app, MerlinData md, int options, Consumer<? super EgressRoom> toClean, BiConsumer<? super EgressRoom, ? super EgressRoom> toSelect, EgressRoom ... subComps) {
        SubtractAction.subtract(app, md, options, toClean, toSelect, Arrays.asList(subComps));
    }

    public static void subtract(MerlinApp app, MerlinData md, int options, Consumer<? super EgressRoom> toClean, Collection<EgressRoom> subComps) {
        SubtractAction.subtract(app, md, options, toClean, (? super EgressRoom keyRoom, ? super EgressRoom childRoom) -> {}, subComps);
    }

    public static void subtract(MerlinApp app, MerlinData md, int options, Consumer<? super EgressRoom> toClean, BiConsumer<? super EgressRoom, ? super EgressRoom> toSelect, Collection<EgressRoom> subComps) {
        BitOptions opts = new BitOptions(options);
        Map<EgressRoom, List<EgressRoom>> subMap = SubtractAction.getReplaceMap(app, md, opts, subComps);
        if (subMap.isEmpty()) {
            return;
        }
        md.pauseUpdates();
        if (!opts.get(4L)) {
            Undo.begin(Intl.intl("Subtract"));
        }
        SubtractAction.performSubtract(subComps, subMap, opts, md, toClean, toSelect);
        if (!opts.get(4L)) {
            Undo.end(md);
        }
        md.resumeUpdates();
    }

    public static Map<EgressRoom, List<EgressRoom>> getReplaceMap(MerlinApp app, MerlinData md, int opts, Collection<EgressRoom> subComps) {
        return SubtractAction.getReplaceMap(app, md, new BitOptions(opts), subComps);
    }

    private static Map<EgressRoom, List<EgressRoom>> getReplaceMap(MerlinApp app, MerlinData md, BitOptions opts, Collection<EgressRoom> subComps) {
        Set exclusionsSet = Collections.EMPTY_SET;
        if (opts.get(1L)) {
            exclusionsSet = subComps instanceof Set ? (Set<Object>)subComps : new IdentityHashSet<EgressRoom>(subComps);
        }
        LinkedIdentityHashMap<EgressRoom, List<EgressRoom>> subMap = new LinkedIdentityHashMap<EgressRoom, List<EgressRoom>>();
        for (EgressRoom subComp : subComps) {
            List<EgressRoom> potSubtractors = SubtractAction.findNearComponents(md, subComp, exclusionsSet);
            for (EgressRoom potSubtractor : potSubtractors) {
                ArrayList<EgressRoom> potSubComps;
                EgressRoom keep = subComp;
                EgressRoom replace = potSubtractor;
                if (!potSubtractor.getModificationsAllowed()) {
                    keep = potSubtractor;
                    replace = subComp;
                }
                if ((potSubComps = (ArrayList<EgressRoom>)subMap.get(replace)) == null) {
                    potSubComps = new ArrayList<EgressRoom>();
                    subMap.put(replace, potSubComps);
                }
                potSubComps.add(keep);
            }
        }
        return subMap;
    }

    private static void performSubtract(Collection<EgressRoom> subComps, Map<EgressRoom, List<EgressRoom>> subMap, BitOptions opts, MerlinData md, Consumer<? super EgressRoom> toClean, BiConsumer<? super EgressRoom, ? super EgressRoom> toSelect) {
        LinkedIdentityHashSet toDelete = new LinkedIdentityHashSet();
        for (Map.Entry<EgressRoom, List<EgressRoom>> entry : subMap.entrySet()) {
            EgressRoom potSubtractor = entry.getKey();
            if (!potSubtractor.getModificationsAllowed()) continue;
            Object momento = potSubtractor.getRestoreObj();
            boolean subtracted = false;
            for (EgressRoom subtract : entry.getValue()) {
                subtracted |= potSubtractor.sub(subtract);
            }
            if (!subtracted) continue;
            if (!opts.get(4L)) {
                Undo.insertUndoEntry_restore(md, potSubtractor, momento, false);
            }
            if (!opts.get(2L)) {
                SeparateGeom.separate(md, Collections.singleton(potSubtractor), toClean, toSelect);
            }
            if (potSubtractor.getRoomArea() == 0.0) {
                toDelete.add(potSubtractor);
                continue;
            }
            toClean.accept(potSubtractor);
        }
        Delete.deleteAll(md, toDelete);
    }

    private static List<EgressRoom> findNearComponents(MerlinData md, final IEgressComp comp, final Set<EgressRoom> exclusions) {
        AABoxTest test = new AABoxTest(comp.getBounds(), 1.0E-6);
        final ArrayList<EgressRoom> nearComps = new ArrayList<EgressRoom>();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src instanceof EgressRoom && src != comp && !exclusions.contains(src)) {
                    nearComps.add((EgressRoom)src);
                }
            }
        };
        md.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        return nearComps;
    }
}

