/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.ReorderGroupOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SortAlphaAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SortAlphaAction(), Intl.intl("&Sort Alphabetically"));

    public SortAlphaAction() {
        SelectionObserver.add(this, Composite.class);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        MerlinSelectionModel sel = md.selection;
        assert (!sel.isEmpty());
        Set comps = sel.getSelected(Composite.class);
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Sort Groups"));
            for (Composite comp : comps) {
                ArrayList<ICompElement> oldOrder = new ArrayList<ICompElement>(comp.getMembers());
                List<ICompElement> newOrder = SortAlphaAction.sort(oldOrder);
                ReorderGroupOp op = new ReorderGroupOp(comp, oldOrder, newOrder);
                Undo.insertEntry(md, op.perform(sel));
            }
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    private static List<ICompElement> sort(Collection<? extends ICompElement> objs) {
        ArrayList<ICompElement> toSort = new ArrayList<ICompElement>(objs);
        Collections.sort(toSort, new Comparator<ICompElement>(){

            @Override
            public int compare(ICompElement ice1, ICompElement ice2) {
                if (ice1 instanceof Composite && !(ice2 instanceof Composite)) {
                    return -1;
                }
                if (!(ice1 instanceof Composite) && ice2 instanceof Composite) {
                    return 1;
                }
                String name1 = ice1.getName();
                String name2 = ice2.getName();
                return name1.compareTo(name2);
            }
        });
        return toSort;
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isEmpty(Composite.class));
    }
}

