/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.actions.Undo;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.Floor;

public class SetWorkingGroup {
    public static void setWorkingGroup(MerlinData md, Floor floor, GeomComposite<ICompElement> group) {
        ChangeWorkingGroupOp op = new ChangeWorkingGroupOp(floor, floor.getWorkingGeomGroup(), group);
        Undo.insertEntry(md, op.perform(md.selection));
    }

    private static class ChangeWorkingGroupOp
    implements Undo.UndoOp {
        private final Floor floor;
        private final GeomComposite<ICompElement> oldGroup;
        private final GeomComposite<ICompElement> newGroup;

        public ChangeWorkingGroupOp(Floor floor, GeomComposite<ICompElement> oldGroup, GeomComposite<ICompElement> newGroup) {
            this.floor = floor;
            this.oldGroup = oldGroup;
            this.newGroup = newGroup;
        }

        @Override
        public Undo.UndoOp perform(MerlinSelectionModel sel) {
            this.floor.setWorkingGeomGroup(this.newGroup);
            return new ChangeWorkingGroupOp(this.floor, this.newGroup, this.oldGroup);
        }
    }
}

