/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class SelectionObserver
implements IEventObserver {
    private Map<Class, List<IEventObserver>> d_observers = new LinkedHashMap<Class, List<IEventObserver>>();
    private static final SelectionObserver s_instance = new SelectionObserver();

    public static void add(IEventObserver observer, Class<?> ... types) {
        for (Class<?> type : types) {
            List<IEventObserver> observers = SelectionObserver.s_instance.d_observers.get(type);
            if (observers == null) {
                observers = new ArrayList<IEventObserver>();
                SelectionObserver.s_instance.d_observers.put(type, observers);
            }
            observers.add(observer);
        }
    }

    public SelectionObserver() {
        MerlinApp.getApp().getData().getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        LinkedIdentityHashSet affectedObservers = new LinkedIdentityHashSet();
        for (EventChannel<Object> channel : events.getAffectedChannels(Object.class, new Class[0])) {
            if (!channel.containsChange(MerlinData.SELECTION_CHANGED) && !channel.hasRemovedObjs() && !channel.hasAddedObjs()) continue;
            ArrayList observers = new ArrayList();
            theUtil.findObjectsForClass(this.d_observers, channel.getObjectType(), observers);
            for (List list : observers) {
                affectedObservers.addAll(list);
            }
        }
        for (IEventObserver observer : affectedObservers) {
            observer.update(events);
        }
    }
}

