/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.util.Dependencies;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class SelectReferencing
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectReferencing(), Intl.intl("Select Referencing Objects"));

    public SelectReferencing() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        ArrayList<Class<? extends IMerlinObj>> types = new ArrayList<Class<? extends IMerlinObj>>();
        for (Dependencies.Type type : Dependencies.Type.values()) {
            types.add(type.mtype);
        }
        this.setEnabled(md.selection.isExclusive(theUtil.toArray(types, Class.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        try {
            int types = 0;
            for (Dependencies.Type type : Dependencies.Type.values()) {
                if (md.selection.isDeepEmpty(type.mtype)) continue;
                types |= type.flag;
            }
            LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
            Dependencies.getObjReferences(md, types, obj -> merlinData.selection.isSelected(obj), (src, target) -> referencing.add(src));
            md.selection.set(referencing);
        }
        finally {
            md.endWrite();
        }
    }
}

