/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.OccProfile;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.theUtil;

public class RenameAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RenameAction(), Intl.intl("&Rename...,-,Rename selected objects"));

    public RenameAction() {
        SelectionObserver.add(this, INamed.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        String result;
        MerlinSelectionModel sel = md.selection;
        assert (!sel.isEmpty());
        assert (sel.isExclusive(INamed.class));
        Set<INamed> objs = sel.getSelected(INamed.class);
        INamed[] namedArr = new INamed[objs.size()];
        objs.toArray(namedArr);
        String name = namedArr[0].getName();
        String multiName = Intl.intl("<multiple>");
        for (int i = 1; i < namedArr.length; ++i) {
            if (name.equals(namedArr[i].getName())) continue;
            name = multiName;
            break;
        }
        if ((result = (String)JOptionPane.showInputDialog(app.getActiveFrame(), Intl.intl("Enter the new name:"), Intl.intl("Rename"), 3, null, null, name)) != null && result.length() > 0 && !result.equals(multiName)) {
            md.beginWrite();
            boolean allRenamed = RenameAction.rename(md, objs, result);
            md.endWrite();
            if (!allRenamed) {
                JOptionPane.showMessageDialog(null, Intl.intl("Not all objects could be renamed."), Intl.intl("Warning"), 2);
            }
        }
    }

    public static boolean rename(MerlinData md, Collection<? extends INamed> objs, String newName) {
        OccProfile renProf;
        if (objs.isEmpty()) {
            return true;
        }
        IdentityHashSet nonRenamable = new IdentityHashSet();
        IFilteredCollection<OccProfile> profiles = theUtil.filter(objs, OccProfile.class);
        if (profiles.size() > 1) {
            nonRenamable.addAll(profiles);
        } else if (profiles.size() == 1 && !newName.equals((renProf = (OccProfile)profiles.iterator().next()).getName())) {
            for (OccProfile occProfile : md.profiles.getDeepMembers(OccProfile.class)) {
                if (occProfile == renProf || !occProfile.getName().equals(newName)) continue;
                nonRenamable.add(renProf);
                break;
            }
        }
        ArrayList<INamed> renObjs = new ArrayList<INamed>(objs.size());
        for (INamed iNamed : objs) {
            if (nonRenamable.contains(iNamed)) continue;
            renObjs.add(iNamed);
        }
        if (renObjs.isEmpty()) {
            return false;
        }
        renObjs.trimToSize();
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(renObjs, newName, true);
        op.perform(md.selection);
        Undo.insertEntry(md, op.getReverseOp());
        Undo.end(md);
        return renObjs.size() == objs.size();
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(INamed.class));
    }

    private static class RenameOp
    implements Undo.UndoOp,
    Cloneable {
        private final List<INamed> d_objs;
        private final List<String> d_oldNames;
        private final String d_newName;
        private boolean d_ascend;

        public RenameOp(List<INamed> objs, String newName, boolean ascend) {
            this.d_objs = objs;
            this.d_oldNames = new ArrayList<String>(objs.size());
            for (INamed obj : objs) {
                if (obj instanceof Floor) {
                    this.d_oldNames.add(((Floor)obj).getBaseName());
                    continue;
                }
                this.d_oldNames.add(obj.getName());
            }
            this.d_newName = newName;
            this.d_ascend = ascend;
        }

        private Undo.UndoOp getReverseOp() {
            try {
                RenameOp clone = (RenameOp)this.clone();
                clone.d_ascend = !clone.d_ascend;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public Undo.UndoOp perform(MerlinSelectionModel sel) {
            Undo.UndoOp undo = this.getReverseOp();
            if (this.d_ascend) {
                for (int m = 0; m < this.d_objs.size(); ++m) {
                    INamed obj = this.d_objs.get(m);
                    obj.setName(this.d_newName);
                }
            } else {
                for (int m = this.d_objs.size() - 1; m >= 0; --m) {
                    INamed obj = this.d_objs.get(m);
                    String oldName = this.d_oldNames.get(m);
                    obj.setName(oldName);
                }
            }
            return undo;
        }
    }
}

