/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.geom.Rectangle2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.IOccNameGen;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.geom.AgentOverlapDetector;
import merlin.geom.Geometry;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.TriSurface;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.IUrnSampler;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class OccGenerator {
    public static final long BEHAVIOR_SEED = -37831743867739398L;
    public static final long PROFILE_SEED = -6149906044434231366L;
    public static final int OPT_OVERLAP = 1;
    public static final int OPT_FROM_EXISTING = 2;
    public static final UnitDouble DEF_SEARCH_TIMEOUT = new UnitDouble(0.125, SI.SECOND);
    public static final int DEF_MAX_NUM_TRIES = 200;
    private final MerlinData d_data;
    private final Random d_rgen;
    private final Collection<Model> d_pgeoms;
    private final double d_maxDiam;
    private final int d_maxNumTries;
    private final IUrn<OccProfile> d_profiles;
    private final IUrn<Behavior> d_behaviors;
    private TriSurface d_tris;
    private Map<OccLocation, EgressAgent> d_agents;
    private static final double kd = 2.0 / Math.pow(12.0, 0.25);
    private static final double kh = Math.sqrt(3.0) / 2.0;

    public OccGenerator(MerlinData md, Random rgen, Collection<Model> pgeoms, UnitDouble maxDiam, UnitDouble searchTimeout, int maxNumTries, IUrn<OccProfile> profiles, IUrn<Behavior> behaviors) {
        this.d_data = md;
        this.d_rgen = rgen;
        this.d_pgeoms = pgeoms;
        this.d_maxDiam = maxDiam.getValue(Geometry.LENGTH_UNIT);
        this.d_maxNumTries = maxNumTries;
        this.d_behaviors = behaviors;
        this.d_profiles = profiles;
        this.d_tris = new TriSurface();
        for (Model geom : this.d_pgeoms) {
            for (Face face : geom.getFaces()) {
                TriSurface tset = OccGenerator.getTris(face);
                this.d_tris.addTris(tset);
            }
        }
        this.d_agents = new LinkedHashMap<OccLocation, EgressAgent>();
    }

    public double getTotalArea() {
        return this.d_tris.totalWeight;
    }

    public static Collection<Model> getModels(Collection<? extends IEgressOccupiable> rooms) {
        ArrayList<Model> models = new ArrayList<Model>(rooms.size());
        for (IEgressOccupiable iEgressOccupiable : rooms) {
            models.add(iEgressOccupiable.getModel());
        }
        return models;
    }

    private static TriSurface getTris(Face pg) {
        TriSurface tset = new TriSurface();
        Triangulation ti = pg.triangulate(Face.NO_REFINEMENT);
        tset.addTris(ti.verts, ti.tris);
        return tset;
    }

    private static void distributeNames(Collection<EgressAgent> agentsColl, IOccNameGen nameGenerator) {
        if (agentsColl.isEmpty()) {
            return;
        }
        for (EgressAgent agent : agentsColl) {
            boolean female = false;
            String name = nameGenerator.nextName(female);
            agent.setName(name);
        }
    }

    public void reset() {
        this.d_agents.clear();
    }

    public boolean generate(int numOccs, int spacing, int options) {
        return this.generate(numOccs, spacing, options, null);
    }

    public boolean generate(int numOccs, int spacing, int options, Collection<EgressAgent> existingOccs) {
        if (numOccs == 0) {
            return true;
        }
        if (this.d_pgeoms.isEmpty() || this.d_tris.isEmpty()) {
            return false;
        }
        int count0 = this.d_agents.size();
        if (spacing == 0) {
            this.populateUniformly(numOccs, options, existingOccs);
        } else {
            this.populateRandomly(numOccs, options, existingOccs);
        }
        return this.d_agents.size() - count0 == numOccs;
    }

    public int getNumOccupants() {
        return this.d_agents.size();
    }

    public Collection<EgressAgent> finalizeData() {
        OccGenerator.distributeNames(this.d_agents.values(), this.d_data.occNameGen);
        return this.d_agents.values();
    }

    private void populateRandomly(int numAgents, int options, Collection<EgressAgent> existingOccs) {
        if (this.d_tris.isEmpty()) {
            return;
        }
        Supplier<Point3d> pointGen = this.d_tris.getPointGenerator(this.d_rgen);
        AgentOverlapDetector tempDet = new AgentOverlapDetector(this.d_data);
        boolean occsFromExisting = OccGenerator.test(options, 2);
        InfiniteUrn<OccProfile> profiles = null;
        IUrnSampler<OccProfile> profileSampler = null;
        InfiniteUrn<Behavior> behaviors = null;
        IUrnSampler<Behavior> behaviorSampler = null;
        Iterator<EgressAgent> existingOccsIt = null;
        LinkedHashSet<EgressAgent> toIgnoreOverlap = new LinkedHashSet<EgressAgent>();
        if (!occsFromExisting) {
            profiles = UrnUtil.makeInfinite(this.d_profiles);
            profileSampler = profiles.getSampler(new Random(-6149906044434231366L));
            behaviors = UrnUtil.makeInfinite(this.d_behaviors);
            behaviorSampler = behaviors.getSampler(new Random(-37831743867739398L));
        } else {
            existingOccsIt = existingOccs.iterator();
            toIgnoreOverlap.addAll(existingOccs);
        }
        long missCount = 0L;
        EgressAgent nextExistingOcc = null;
        while (numAgents > 0) {
            if (existingOccsIt != null && missCount == 0L) {
                nextExistingOcc = existingOccsIt.next();
            }
            if (this.populateRandomly(this.d_agents, pointGen, tempDet, occsFromExisting ? nextExistingOcc.getProfile() : profileSampler.getCurrentSample(), occsFromExisting ? nextExistingOcc.getBehavior() : behaviorSampler.getCurrentSample(), options, nextExistingOcc, Filters.accept(toIgnoreOverlap))) {
                if (!occsFromExisting) {
                    profileSampler.sampleNext();
                    behaviorSampler.sampleNext();
                } else {
                    toIgnoreOverlap.remove(nextExistingOcc);
                }
                --numAgents;
                missCount = 0L;
                continue;
            }
            if (++missCount < (long)this.d_maxNumTries) continue;
            return;
        }
    }

    private boolean populateRandomly(Map<OccLocation, EgressAgent> agents, Supplier<Point3d> getNextLoc, AgentOverlapDetector tempDet, OccProfile profile, Behavior behavior, int options, EgressAgent existingOcc, Predicate<EgressAgent> toIgnoreOverlap) {
        Point3d loc = getNextLoc.get();
        if (loc == null) {
            return false;
        }
        return this.addOccupant(agents, tempDet, profile, behavior, loc, options, existingOcc, toIgnoreOverlap);
    }

    private static double calcMinOccDensityNoOverlap(double diameter) {
        double radius = diameter * 0.5;
        return radius * radius * Math.sqrt(12.0);
    }

    public UnitDouble getMaxDensity() {
        double dens = OccGenerator.calcMinOccDensityNoOverlap(this.d_maxDiam);
        return new UnitDouble(dens, SIUS.unit(2));
    }

    public int getMaxNumOccs() {
        double density = 1.0 / this.getMaxDensity().get(SIUS.unit(2));
        long count = (long)Math.floor(density * this.d_tris.totalWeight);
        return (int)Math.min(count, Integer.MAX_VALUE);
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    private void populateUniformly(long numOccs, int options, Collection<EgressAgent> existingOccs) {
        int numAttempts;
        double radius = this.d_maxDiam * 0.5;
        ArrayList<FacePopulateInfo> popInfos = new ArrayList<FacePopulateInfo>(this.d_pgeoms.size());
        for (Model model : this.d_pgeoms) {
            for (Face face : model.getFaces()) {
                popInfos.add(OccGenerator.calcFacePopInfo(model, face, radius));
            }
        }
        double maxDensity = this.d_tris.totalWeight / (double)numOccs;
        double minDensity = OccGenerator.calcMinOccDensityNoOverlap(this.d_maxDiam);
        if (OccGenerator.test(options, 1)) {
            minDensity = 1.0E-6;
            numAttempts = 20;
        } else {
            numAttempts = 10;
        }
        if (maxDensity < minDensity) {
            maxDensity = minDensity;
        }
        if (theUtil.eq(maxDensity, minDensity, 0.0)) {
            numAttempts = 1;
        }
        LinkedHashMap<OccLocation, EgressAgent> agents = new LinkedHashMap<OccLocation, EgressAgent>(this.d_agents);
        for (int m = 0; m < numAttempts; ++m) {
            double occDensity = numAttempts == 1 ? maxDensity : theUtil.lerp(maxDensity, minDensity, (double)m / (double)(numAttempts - 1));
            agents.clear();
            this.populateUniformly(agents, popInfos, occDensity, (int)numOccs, options, existingOccs);
            if (agents.size() == (int)numOccs) break;
        }
        this.d_agents = agents;
    }

    private static FacePopulateInfo calcFacePopInfo(Model model, Face face, double radius) {
        Matrix4d lwXform;
        double longestEdgeLen = 0.0;
        EdgeUse longestEdge = null;
        FaceLoop loop = face.outerLoop();
        if (loop != null) {
            for (EdgeUse eu : loop.edges) {
                double len = eu.edge.curve.length();
                if (!(len > longestEdgeLen)) continue;
                longestEdgeLen = len;
                longestEdge = eu;
            }
        }
        if (longestEdge != null) {
            Vector3d x = longestEdge.getTangent(0.0);
            x.normalize();
            Vector3d z = Util3D.normalize(face.plane.getNormal());
            Vector3d y = Util3D.cross(z, x);
            Point3d origin = longestEdge.curve().get(0.5);
            origin.sub(Util3D.scale(x, radius));
            origin.add(Util3D.scale(y, radius + 1.0E-6));
            lwXform = new Matrix4d(1.0, 0.0, 0.0, origin.x, 0.0, 1.0, 0.0, origin.y, 0.0, 0.0, 1.0, origin.z, 0.0, 0.0, 0.0, 1.0);
            Matrix4d rot = new Matrix4d(x.x, y.x, z.x, 0.0, x.y, y.y, z.y, 0.0, x.z, y.z, z.z, 0.0, 0.0, 0.0, 0.0, 1.0);
            lwXform.mul(rot);
        } else {
            lwXform = Geometry.getLocalToWorldXform(face.plane);
        }
        Matrix4d wlXform = new Matrix4d();
        wlXform.invert(lwXform);
        AABox lbounds = new AABox();
        if (loop != null) {
            for (EdgeUse eu : loop.edges) {
                Point3d p = Util3D.xform(wlXform, eu.v1().loc);
                lbounds.add(p);
            }
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(lbounds.getMinX(), lbounds.getMinY(), lbounds.getWidth(), lbounds.getDepth());
        return new FacePopulateInfo(model, face, lwXform, bounds);
    }

    private Map<OccProfile, Deque<Pair<OccLocation, Long>>> queuePotentialUniformLocations(List<FacePopulateInfo> popInfos, double occDensityM, Set<OccProfile> allProfiles, int options, Predicate<EgressAgent> toIgnoreOverlap) {
        double circleDiameter = Math.sqrt(occDensityM) * kd;
        double height = circleDiameter * kh;
        double xdist = circleDiameter;
        double ydist = height;
        LinkedIdentityHashMap<OccProfile, ArrayList<Pair<OccLocation, Long>>> profileLocs = new LinkedIdentityHashMap<OccProfile, ArrayList<Pair<OccLocation, Long>>>();
        double halfXDist = 0.5 * xdist;
        Point3d loc = new Point3d();
        for (FacePopulateInfo popInfo : popInfos) {
            Rectangle2D bb = popInfo.localFaceBounds;
            long beginx = (long)Math.floor(bb.getMinX() / xdist);
            long beginy = (long)Math.floor(bb.getMinY() / ydist);
            long endx = (long)Math.ceil(bb.getMaxX() / xdist);
            long endy = (long)Math.ceil(bb.getMaxY() / ydist);
            if (beginx > endx || beginy > endy) continue;
            Matrix4d worldXform = popInfo.gridToFaceXform;
            for (long row = beginy; row <= endy; ++row) {
                double xoffset = 0.0;
                if (row % 2L != 0L) {
                    xoffset += halfXDist;
                }
                double y = ydist * (double)row;
                for (long col = beginx; col <= endx; ++col) {
                    double x = xoffset + xdist * (double)col;
                    loc.set(x, y, 0.0);
                    worldXform.transform(loc);
                    if (popInfo.model.testPointOnFace((Face)popInfo.face, (Point3d)loc).outside) continue;
                    for (OccProfile profile : allProfiles) {
                        long seed;
                        double angle;
                        OccLocation oloc = this.testLocation(profile, loc, angle = ((UnitDouble)profile.getDistVal(OccProfile.PROP_INIT_ORIENT, new Random(), seed = OccProfile.newSeed())).getValue(Geometry.ANGLE_UNIT), options, toIgnoreOverlap);
                        if (oloc == null) continue;
                        ArrayList<Pair<OccLocation, Long>> potLocs = (ArrayList<Pair<OccLocation, Long>>)profileLocs.get(profile);
                        if (potLocs == null) {
                            potLocs = new ArrayList<Pair<OccLocation, Long>>();
                            profileLocs.put(profile, potLocs);
                        }
                        potLocs.add(new Pair<OccLocation, Long>(oloc, seed));
                    }
                }
            }
        }
        IdentityHashMap<OccProfile, Deque<Pair<OccLocation, Long>>> queue = new IdentityHashMap<OccProfile, Deque<Pair<OccLocation, Long>>>();
        Random r = new Random();
        for (Map.Entry entry : profileLocs.entrySet()) {
            Collections.shuffle((List)entry.getValue(), r);
            queue.put((OccProfile)entry.getKey(), new ArrayDeque((Collection)entry.getValue()));
        }
        return queue;
    }

    private void populateUniformly(Map<OccLocation, EgressAgent> agents, List<FacePopulateInfo> popInfos, double occDensityM, int totalNumOccs, int options, Collection<EgressAgent> existingOccs) {
        OccProfile profile2;
        Deque<Pair<OccLocation, Long>> locs;
        LinkedIdentityHashSet<OccProfile> allProfiles = new LinkedIdentityHashSet<OccProfile>();
        LinkedHashMap profsToAgents = new LinkedHashMap();
        BiConsumer<EgressAgent, OccProfile> addToMap = (agent, prof) -> {
            ArrayDeque<EgressAgent> profAgents = (ArrayDeque<EgressAgent>)profsToAgents.get(prof);
            if (profAgents == null) {
                profAgents = new ArrayDeque<EgressAgent>();
            }
            profAgents.add((EgressAgent)agent);
            profsToAgents.put(prof, profAgents);
        };
        InfiniteUrn<OccProfile> profiles = null;
        IUrnSampler<OccProfile> profileSampler = null;
        InfiniteUrn<Behavior> behaviors = null;
        IUrnSampler<Behavior> behaviorSampler = null;
        Iterator profileIt = null;
        LinkedHashSet<EgressAgent> toIgnoreOverlap = new LinkedHashSet<EgressAgent>();
        EgressAgent nextExistingOcc = null;
        OccProfile nextProf = null;
        boolean fromExisting = OccGenerator.test(options, 2);
        if (fromExisting) {
            OccProfile.IsLocalProp<ICurve> localProp = new OccProfile.IsLocalProp<ICurve>(OccProfile.PROP_INIT_ORIENT);
            for (EgressAgent occ : existingOccs) {
                if (((Boolean)occ.getProperty(localProp)).booleanValue()) {
                    allProfiles.add(occ.getProfile());
                    addToMap.accept(occ, occ.getProfile());
                    continue;
                }
                allProfiles.add(occ.getProfile().getProfParent());
                addToMap.accept(occ, occ.getProfile().getProfParent());
            }
            profileIt = allProfiles.iterator();
            nextProf = (OccProfile)profileIt.next();
            nextExistingOcc = (EgressAgent)((Deque)profsToAgents.get(nextProf)).poll();
            toIgnoreOverlap.addAll(existingOccs);
        } else {
            this.d_profiles.getUnique(allProfiles);
            profiles = UrnUtil.makeInfinite(this.d_profiles);
            profileSampler = profiles.getSampler(new Random(-6149906044434231366L));
            behaviors = UrnUtil.makeInfinite(this.d_behaviors);
            behaviorSampler = behaviors.getSampler(new Random(-37831743867739398L));
        }
        Map<OccProfile, Deque<Pair<OccLocation, Long>>> profileLocs = this.queuePotentialUniformLocations(popInfos, occDensityM, allProfiles, options, Filters.accept(toIgnoreOverlap));
        AgentOverlapDetector tempDet = new AgentOverlapDetector(this.d_data);
        BiFunction<OccProfile, Iterator, OccProfile> getNextProfile = (profile, profileIterator) -> ((Deque)profsToAgents.get(profile)).isEmpty() && profileIterator.hasNext() ? (OccProfile)profileIterator.next() : profile;
        while (!profileLocs.isEmpty() && agents.size() < totalNumOccs && (locs = profileLocs.get(profile2 = fromExisting ? nextProf : profileSampler.getCurrentSample())) != null) {
            Behavior behavior;
            Pair<OccLocation, Long> testLocPair = locs.pop();
            OccLocation testLoc = (OccLocation)testLocPair.v1;
            long occSeed = (Long)testLocPair.v2;
            if (locs.isEmpty()) {
                profileLocs.remove(profile2);
            }
            if (!this.addOccupant(agents, tempDet, profile2, behavior = fromExisting ? nextExistingOcc.getBehavior() : behaviorSampler.getCurrentSample(), testLoc, options, occSeed, nextExistingOcc, Filters.accept(toIgnoreOverlap))) continue;
            if (!fromExisting) {
                profileSampler.sampleNext();
                behaviorSampler.sampleNext();
                continue;
            }
            toIgnoreOverlap.remove(nextExistingOcc);
            nextProf = getNextProfile.apply(profile2, profileIt);
            nextExistingOcc = (EgressAgent)((Deque)profsToAgents.get(nextProf)).poll();
        }
    }

    private OccLocation testLocation(OccProfile profile, Point3d loc, double angle, int options, Predicate<EgressAgent> toIgnoreOverlap) {
        boolean checkExisting = !OccGenerator.test(options, 1);
        Predicate<IEgressOccupiable> roomFilter = EgressAgent.getRoomFilter(profile);
        int foptions = 0;
        OccLocation oloc = this.d_data.findValidOccLocation(profile.getProperty(OccProfile.PROP_SHAPE), loc, new UnitDouble(this.d_maxDiam, Geometry.LENGTH_UNIT), angle, foptions, roomFilter, toIgnoreOverlap);
        return oloc.room == null || oloc.overlapsWalls || oloc.failsFilter || checkExisting && oloc.isOverlappingAgents() ? null : oloc;
    }

    private boolean addOccupant(Map<OccLocation, EgressAgent> agents, AgentOverlapDetector tempDet, OccProfile profile, Behavior behavior, Point3d loc, int options, EgressAgent existingOcc, Predicate<EgressAgent> toIgnoreOverlap) {
        long occSeed = OccProfile.newSeed();
        double angle = ((UnitDouble)profile.getDistVal(OccProfile.PROP_INIT_ORIENT, new Random(), occSeed)).getValue(Geometry.ANGLE_UNIT);
        OccLocation oloc = this.testLocation(profile, loc, angle, options, toIgnoreOverlap);
        if (oloc == null) {
            return false;
        }
        return this.addOccupant(agents, tempDet, profile, behavior, oloc, options, occSeed, existingOcc, toIgnoreOverlap);
    }

    private boolean addOccupant(Map<OccLocation, EgressAgent> agents, AgentOverlapDetector tempDet, OccProfile profile, Behavior behavior, OccLocation oloc, int options, long occSeed, EgressAgent existingOcc, Predicate<EgressAgent> toIgnoreOverlap) {
        double radius = this.d_maxDiam * 0.5;
        boolean checkNew = !OccGenerator.test(options, 1);
        double angle = ((UnitDouble)profile.getDistVal(OccProfile.PROP_INIT_ORIENT, new Random(), occSeed)).getValue(Geometry.ANGLE_UNIT);
        boolean checkAttachedPositions = true;
        if (checkNew && !tempDet.detectOverlap(profile.getProperty(OccProfile.PROP_SHAPE), oloc.point, radius, angle, checkAttachedPositions, toIgnoreOverlap).isEmpty() || agents.containsKey(oloc)) {
            return false;
        }
        boolean fromExisting = OccGenerator.test(options, 2);
        EgressAgent agent = fromExisting ? existingOcc : new EgressAgent(new OccProfile(profile), behavior, occSeed);
        String name = Intl.intl("Occupant");
        if (!fromExisting) {
            agent.setName(name);
        }
        if (fromExisting) {
            agent.setOrientSeed(occSeed);
        }
        agent.setLocation(oloc);
        agents.put(oloc, agent);
        tempDet.add(agent);
        return true;
    }

    public static void distributeAgents(MerlinData md, Collection<EgressAgent> agents, String newGroupName) {
        if (!agents.isEmpty()) {
            EgressAgentComp comp = new EgressAgentComp(newGroupName);
            comp.addAll(agents);
            Undo.insertUndoEntry_delete(md, md.agents, comp);
            md.agents.add(comp);
            md.selection.set(comp);
        }
    }

    public static void distributeBehavior(MerlinData md, Collection<EgressAgent> agents, IUrn<Behavior> dval, boolean addUndoEntries) {
        if (addUndoEntries) {
            Undo.insertUndoEntry_propRestore(md, agents, EgressAgent.BEHAVIOR);
        }
        InfiniteUrn<Behavior> urn = UrnUtil.makeInfinite(dval);
        IUrnSampler<Behavior> sampler = urn.getSampler(new Random(-37831743867739398L));
        for (EgressAgent agent : agents) {
            Behavior nextVal = sampler.sampleNext();
            agent.setProperty(EgressAgent.BEHAVIOR, nextVal);
        }
    }

    public static Map<EgressAgent, OccProfile> calcProfileDistribution(MerlinData md, Collection<EgressAgent> agents, IUrn<OccProfile> dval, boolean allowInvalidLocs) {
        Urn<OccProfile> urn = UrnUtil.makeFinite(dval, agents.size());
        ArrayList<OccProfile> sortedProfiles = new ArrayList<OccProfile>(urn.getValues());
        Collections.sort(sortedProfiles, new Comparator<OccProfile>(){

            @Override
            public int compare(OccProfile o1, OccProfile o2) {
                boolean restricted2;
                boolean restricted1 = EgressAgent.getRoomFilter(o1) != Filters.acceptAll(IEgressOccupiable.class);
                boolean bl = restricted2 = EgressAgent.getRoomFilter(o2) != Filters.acceptAll(IEgressOccupiable.class);
                if (restricted1 && !restricted2) {
                    return -1;
                }
                if (!restricted1 && restricted2) {
                    return 1;
                }
                return 0;
            }
        });
        int numTries = 10;
        Random r = new Random(-6149906044434231366L);
        ArrayList<EgressAgent> lagents = new ArrayList<EgressAgent>(agents);
        for (int o = 0; o < numTries; ++o) {
            Collections.shuffle(lagents, r);
            LinkedIdentityHashMap<EgressAgent, OccProfile> newProfileMatches = new LinkedIdentityHashMap<EgressAgent, OccProfile>();
            ArrayDeque<EgressAgent> remainingAgents = new ArrayDeque<EgressAgent>(lagents);
            for (int m = 0; m < sortedProfiles.size(); ++m) {
                OccProfile profile = (OccProfile)sortedProfiles.get(m);
                Predicate<IEgressOccupiable> roomFilter = EgressAgent.getRoomFilter(profile);
                int remAgentCount = remainingAgents.size();
                for (int n = 0; n < remAgentCount; ++n) {
                    EgressAgent agent = (EgressAgent)remainingAgents.removeFirst();
                    OccLocation oloc = agent.getLocInfo();
                    if (oloc.room == null || roomFilter.test(oloc.room)) {
                        newProfileMatches.put(agent, profile);
                        break;
                    }
                    remainingAgents.addLast(agent);
                }
                if (remainingAgents.size() != remAgentCount) continue;
                if (!allowInvalidLocs) break;
                newProfileMatches.put((EgressAgent)remainingAgents.removeFirst(), profile);
            }
            if (!remainingAgents.isEmpty()) continue;
            return newProfileMatches;
        }
        return null;
    }

    public static UnitDouble getMaxDiam(IUrn<OccProfile> profDist) {
        LinkedIdentityHashSet<OccProfile> profiles = new LinkedIdentityHashSet<OccProfile>();
        profDist.getUnique(profiles);
        return OccGenerator.getMaxDiam(profiles);
    }

    public static UnitDouble getMaxDiam(Collection<OccProfile> profiles) {
        return OccGenerator.getMax(profiles, OccProfile.PROP_DIAMETER);
    }

    private static <T> UnitDouble getMax(Collection<OccProfile> profiles, OccProfile.Prop<T> prop) {
        UnitDouble max = null;
        for (OccProfile prof : profiles) {
            UnitDouble curr = null;
            T obj = prof.getProperty(prop);
            if (obj instanceof ICurve) {
                ICurve curve = (ICurve)obj;
                curr = curve.getMax();
            } else if (obj instanceof UnitDouble) {
                curr = (UnitDouble)obj;
            } else assert (false);
            if (max != null && curr.compareTo(max) <= 0) continue;
            max = curr;
        }
        return max;
    }

    private static class FacePopulateInfo {
        public final Model model;
        public final Face face;
        public final Matrix4d gridToFaceXform;
        public final Rectangle2D localFaceBounds;

        public FacePopulateInfo(Model model, Face face, Matrix4d gridToFaceXform, Rectangle2D localFaceBounds) {
            this.model = model;
            this.face = face;
            this.gridToFaceXform = gridToFaceXform;
            this.localFaceBounds = localFaceBounds;
        }
    }
}

