/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;

public class NewAgentSeeds
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new NewAgentSeeds(), Intl.intl("Randomize,-,Generate new random seeds for occupant profiles"));

    public NewAgentSeeds() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData data = MerlinApp.getApp().getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(EgressAgent.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Randomize"));
            Set<EgressAgent> selObjs = md.selection.getDeepSelected(EgressAgent.class);
            if (selObjs.isEmpty()) {
                return;
            }
            Undo.insertUndoEntry_restore(md, new SeedRestorer(selObjs));
            for (EgressAgent agent : selObjs) {
                agent.newProfileSeed();
            }
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    private static class SeedRestorer
    implements IRestorable {
        private static final long serialVersionUID = -8492893212022263580L;
        Collection<EgressAgent> d_selAgents;

        public SeedRestorer(Collection<EgressAgent> selAgents) {
            this.d_selAgents = selAgents;
        }

        @Override
        public Object getRestoreObj() {
            LinkedIdentityHashMap<EgressAgent, Long> oldSeeds = new LinkedIdentityHashMap<EgressAgent, Long>();
            for (EgressAgent agent : this.d_selAgents) {
                long oldSeed = agent.getProfileSeed();
                oldSeeds.put(agent, oldSeed);
            }
            return oldSeeds;
        }

        @Override
        public void restoreFrom(Object obj) {
            assert (obj instanceof Map);
            Map oldSeeds = (Map)obj;
            for (Map.Entry entry : oldSeeds.entrySet()) {
                ((EgressAgent)entry.getKey()).setProfileSeed((Long)entry.getValue());
            }
        }
    }
}

