/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.egress.SimError;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.ModelConstrictor;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Triangulation;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.theTimer;

public class InfernoGeomBuilder {
    public static final UnitDouble DEF_MAX_EDGE_LENGTH = new UnitDouble(0.5, Geometry.LENGTH_UNIT);
    public static final Face.RefinementOptions DEF_FACE_REFINEMENT = Face.NO_REFINEMENT;
    public static final Param DEF_PARAM = new Param();
    private static final Logger LOGGER = Logger.getLogger(InfernoGeomBuilder.class.getName());
    private final List<Point3d> d_points;
    private final List<NavTriangle> d_tris;
    private final List<MarkedEdge> d_specialEdges;
    private static final IPrimProps s_constrProps = new IPrimProps.Edge(new Color(255, 255, 255, 0), 1.0, 255, 0);

    public InfernoGeomBuilder(List<Point3d> points, List<NavTriangle> tris, List<MarkedEdge> specialEdges) {
        this.d_points = points;
        this.d_tris = tris;
        this.d_specialEdges = specialEdges;
    }

    public List<Point3d> getPoints() {
        return Collections.unmodifiableList(this.d_points);
    }

    public List<NavTriangle> getTriangles() {
        return Collections.unmodifiableList(this.d_tris);
    }

    public List<MarkedEdge> getMarkedEdges() {
        return Collections.unmodifiableList(this.d_specialEdges);
    }

    public static InfernoGeomBuilder[] constructMeshes(List<InfernoGeom> igeoms, List<SimError> errors, double maxOccRadius, Param ... params) {
        int m;
        long beginTime = System.nanoTime();
        Model mainModel = new Model();
        InfernoGeomBuilder.addGeomToModel(mainModel, 0, igeoms);
        int offset = igeoms.size();
        InfernoGeomBuilder.getConstrictionGeom(mainModel, igeoms, maxOccRadius);
        InfernoGeomBuilder.addGeomToModel(mainModel, offset, igeoms);
        ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorCompletionService<Runnable> completionService = new ExecutorCompletionService<Runnable>(threadPool);
        Model[] models = new Model[params.length];
        models[0] = mainModel;
        for (m = 1; m < params.length; ++m) {
            models[m] = (Model)mainModel.clone();
        }
        for (m = 0; m < params.length; ++m) {
            ModelPreparer preparer = new ModelPreparer(models[m], params[m], m);
            completionService.submit(preparer, preparer);
        }
        int tasksSubmitted = params.length;
        int tasksExecuted = 0;
        ArrayList<ModelPreparer> modelPreparers = new ArrayList<ModelPreparer>();
        ArrayList<Triangulator> triangulators = new ArrayList<Triangulator>();
        while (tasksExecuted < tasksSubmitted) {
            Object submittedTask;
            ++tasksExecuted;
            try {
                Future future = completionService.take();
                submittedTask = future.get();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "InfernoGeomBuilder interrupted.");
                LOGGER.log(Level.SEVERE, e.toString(), e);
                return null;
            }
            catch (ExecutionException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                continue;
            }
            if (submittedTask instanceof ModelPreparer) {
                ModelPreparer mb = (ModelPreparer)submittedTask;
                modelPreparers.add(mb);
                int triangulatorIx = 0;
                for (Face face : mb.d_model.getFaces()) {
                    Triangulator tri = new Triangulator(mb.d_param, face, mb.d_ix, triangulatorIx++);
                    completionService.submit(tri, tri);
                    ++tasksSubmitted;
                }
                continue;
            }
            Triangulator triangulator = (Triangulator)submittedTask;
            triangulators.add(triangulator);
        }
        threadPool.shutdown();
        triangulators.sort(Comparator.comparingInt(t -> ((Triangulator)t).d_preparerIx).thenComparingInt(t -> t.d_triangulatorIx));
        InfernoGeomBuilder[] geomBuilders = new InfernoGeomBuilder[params.length];
        for (int m2 = 0; m2 < params.length; ++m2) {
            Param param = params[m2];
            geomBuilders[m2] = InfernoGeomBuilder.extractBuilder(param, modelPreparers, triangulators, igeoms, errors);
        }
        long endTime = System.nanoTime();
        LOGGER.log(Level.FINE, String.format("Mesh constructed in %.4f s%n", (double)(endTime - beginTime) * 1.0E-9));
        return geomBuilders;
    }

    private static void getConstrictionGeom(Model model, final List<InfernoGeom> igeoms, double maxRadius) {
        ModelConstrictor.IEdgeClassifier ecfr = new ModelConstrictor.IEdgeClassifier(){

            @Override
            public boolean isBoundary(Edge edge) {
                InfernoGeom ig = InfernoGeomBuilder.pickBestSource(igeoms, edge.groups);
                return ig != null && ig.type == InfernoType.BOUNDARY;
            }

            @Override
            public boolean isInternal(Edge edge) {
                InfernoGeom ig = InfernoGeomBuilder.pickBestSource(igeoms, edge.groups);
                return ig == null || InfernoGeomBuilder.isInternalEdgeType(ig.type);
            }

            @Override
            public boolean canSplit(Edge edge) {
                return true;
            }

            @Override
            public boolean isSplitTarget(Edge edge) {
                InfernoGeom ig = InfernoGeomBuilder.pickBestSource(igeoms, edge.groups);
                if (ig == null) {
                    return false;
                }
                switch (ig.type) {
                    case BOUNDARY: {
                        return true;
                    }
                }
                return false;
            }
        };
        List<List<Point3d>> constrictionEdges = ModelConstrictor.findConstrictionEdges(model, ecfr, maxRadius * 2.0);
        ArrayList<PolyLine> constrictionSegs = new ArrayList<PolyLine>();
        for (List<Point3d> list : constrictionEdges) {
            if (list.size() < 2) continue;
            constrictionSegs.add(new PolyLine(list.toArray(new Point3d[list.size()])));
        }
        if (!constrictionSegs.isEmpty()) {
            igeoms.add(new InfernoGeom(null, InfernoType.CONSTRICTION, thunderheadeng.geometry.objs.GeomUtil.group(constrictionSegs), s_constrProps));
        }
    }

    private static void addGeomToModel(Model model, int offset, List<InfernoGeom> igeoms) {
        for (int m = offset; m < igeoms.size(); ++m) {
            InfernoGeom ig = igeoms.get(m);
            IGeom geom = ig.geom;
            int groupid = m;
            if (ig.type.face) {
                for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
                    GeomUtil.addFaceToModel(face, model, groupid, 0.0, 0.0);
                }
                continue;
            }
            for (ICurve curve : thunderheadeng.geometry.objs.GeomUtil.explode(geom, ICurve.class)) {
                GeomUtil.addCurveToModel(curve, model, groupid, 0.0);
            }
        }
    }

    private static InfernoGeomBuilder extractBuilder(Param param, Collection<ModelPreparer> modelBuilders, Collection<Triangulator> triangulators, List<InfernoGeom> igeoms, List<SimError> errors) {
        Model model = null;
        for (ModelPreparer modelPreparer : modelBuilders) {
            if (modelPreparer.d_param != param) continue;
            model = modelPreparer.d_model;
            break;
        }
        ArrayList<Triangulator> modelTriangulators = new ArrayList<Triangulator>(model == null ? 10 : model.getFaces().size());
        for (Triangulator tri : triangulators) {
            if (tri.d_param != param) continue;
            modelTriangulators.add(tri);
        }
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<MarkedEdge> markedEdges = new ArrayList<MarkedEdge>();
        ArrayList<NavTriangle> navTris = new ArrayList<NavTriangle>();
        assert (model != null);
        if (model != null) {
            for (Edge edge : model.getEdges()) {
                int i1 = InfernoGeomBuilder.getPointIx(edge.v1.loc, linkedHashMap);
                int i2 = InfernoGeomBuilder.getPointIx(edge.v2.loc, linkedHashMap);
                InfernoGeom eSource = InfernoGeomBuilder.pickBestSource(igeoms, edge.groups);
                if (InfernoGeomBuilder.isInternalEdgeType(eSource.type)) continue;
                markedEdges.add(new MarkedEdge(eSource, i1, i2));
            }
        }
        for (Triangulator triangulator : modelTriangulators) {
            InfernoGeom[] sources = InfernoGeomBuilder.getSources(igeoms, ((Triangulator)triangulator).d_modelFace.groups);
            if (triangulator.d_triangulation == null || ((Triangulator)triangulator).d_triangulation.tris.length == 0) {
                InfernoGeom bestSource = InfernoGeomBuilder.pickBestSource(sources);
                if (bestSource == null || !(bestSource.source instanceof IMerlinObj)) {
                    LOGGER.log(Level.WARNING, "Triangulation failed");
                    continue;
                }
                String name = bestSource.source instanceof INamed ? ((INamed)((Object)bestSource.source)).getName() : bestSource.source.toString();
                Function<Point3d, String> format = p -> String.format("(%s, %s, %s)", Global.format(p.x), Global.format(p.y), Global.format(p.z));
                AABox bounds = triangulator.d_modelFace.getBounds();
                String msg = String.format(Intl.intl("Triangulation failed in room, \"%1$s\", in the region, {%2$s -> %3$s} m."), name, format.apply(bounds.getMin()), format.apply(bounds.getMax()));
                String fix = Intl.intl("Adjust the geometry of the room in this location or possibly redraw the room.");
                errors.add(new SimError(SimError.Level.MODERATE, msg, fix, (IMerlinObj)((Object)bestSource.source)));
                continue;
            }
            assert (sources.length > 0);
            Point3d[] points = ((Triangulator)triangulator).d_triangulation.verts;
            int[] tris = ((Triangulator)triangulator).d_triangulation.tris;
            for (int n = 0; n < tris.length; n += 3) {
                Point3d p1 = points[tris[n + 0]];
                Point3d p2 = points[tris[n + 1]];
                Point3d p3 = points[tris[n + 2]];
                int i1 = InfernoGeomBuilder.getPointIx(p1, linkedHashMap);
                int i2 = InfernoGeomBuilder.getPointIx(p2, linkedHashMap);
                int i3 = InfernoGeomBuilder.getPointIx(p3, linkedHashMap);
                navTris.add(new NavTriangle(sources, i1, i2, i3));
            }
        }
        ArrayList<Point3d> allPoints = new ArrayList<Point3d>(linkedHashMap.keySet());
        theTimer timer = new theTimer();
        NavModel nm = new NavModel(navTris, allPoints);
        InfernoGeomBuilder.ensureProperFaceOrient(nm);
        LOGGER.log(Level.FINE, String.format("Ensured proper face orient: %g s%n", timer.curr()));
        return new InfernoGeomBuilder(allPoints, navTris, markedEdges);
    }

    public static boolean ensureProperFaceOrient(NavModel model) {
        boolean modified = false;
        Collection<NavTriangle> downFaces = InfernoGeomBuilder.findFlatFacesThatPointDown(model);
        for (NavTriangle face : downFaces) {
            face.flipOrient();
            modified = true;
        }
        LinkedHashSet<NavTriangle> invalid = new LinkedHashSet<NavTriangle>();
        InfernoGeomBuilder.findInconsistentFaces(model, invalid, null);
        for (NavTriangle face : invalid) {
            face.flipOrient();
            modified = true;
        }
        if (modified) {
            LOGGER.log(Level.WARNING, String.format("Fixed face orientation: %d downward; %d side%n", downFaces.size(), invalid.size()));
        }
        return modified;
    }

    private static Collection<NavTriangle> findFlatFacesThatPointDown(NavModel m) {
        Collection downFaces = Collections.EMPTY_SET;
        Vector3d down = new Vector3d(0.0, 0.0, -1.0);
        double rad89 = 0.7766715171374766;
        for (NavTriangle f : m.tris) {
            if (!(m.getPlane(f).getNormal().angle(down) <= 0.7766715171374766)) continue;
            if (downFaces.isEmpty()) {
                downFaces = new ArrayDeque();
                LOGGER.log(Level.WARNING, "Downward facing face detected.");
            }
            downFaces.add(f);
        }
        return downFaces;
    }

    private static void findInconsistentFaces(NavModel m, Collection<NavTriangle> invalid, Collection<NavTriangle> unknown) {
        LinkedHashSet<NavTriangle> unknownFaces = new LinkedHashSet<NavTriangle>(m.tris);
        ArrayDeque<NavTriangle> goodFaces = new ArrayDeque<NavTriangle>();
        LinkedHashSet<NavTriangle> invalidFaces = new LinkedHashSet<NavTriangle>();
        Vector3d up = new Vector3d(0.0, 0.0, 1.0);
        Vector3d down = new Vector3d(0.0, 0.0, -1.0);
        double rad89 = 0.7766715171374766;
        for (NavTriangle f : unknownFaces) {
            Plane3d plane = m.getPlane(f);
            if (!(plane.getNormal().angle(up) <= 0.7766715171374766) && !(plane.getNormal().angle(down) <= 0.7766715171374766)) continue;
            goodFaces.add(f);
        }
        unknownFaces.removeAll(goodFaces);
        LinkedHashSet<NavTriangle> visited = new LinkedHashSet<NavTriangle>(goodFaces);
        ArrayDeque<ConnectedFace> toTest = new ArrayDeque<ConnectedFace>();
        for (NavTriangle f : goodFaces) {
            visited.add(f);
            for (ConnectedFace cf : InfernoGeomBuilder.getNeighborFaces(m, f, true)) {
                if (visited.contains(cf.face)) continue;
                toTest.add(cf);
            }
        }
        while (!toTest.isEmpty()) {
            ConnectedFace connection = (ConnectedFace)toTest.removeFirst();
            if (visited.contains(connection.face)) continue;
            int[] fromEdge = connection.fromEdge;
            boolean sameEdgeUse = InfernoGeomBuilder.getEdgeUse(connection.face, fromEdge);
            boolean testFaceIsGood = !sameEdgeUse ? connection.fromFaceIsGood : !connection.fromFaceIsGood;
            unknownFaces.remove(connection.face);
            if (!testFaceIsGood) {
                invalidFaces.add(connection.face);
            }
            visited.add(connection.face);
            for (ConnectedFace cf : InfernoGeomBuilder.getNeighborFaces(m, connection.face, testFaceIsGood)) {
                if (visited.contains(cf.face)) continue;
                toTest.add(cf);
            }
        }
        if (invalid != null) {
            invalid.addAll(invalidFaces);
        }
        if (unknown != null) {
            unknown.addAll(unknownFaces);
        }
    }

    private static boolean getEdgeUse(NavTriangle f, int[] e) {
        for (int m = 0; m < 3; ++m) {
            int v1 = f.getVert(m);
            int v2 = f.getVert((m + 1) % 3);
            if (v1 == e[0] && v2 == e[1]) {
                return true;
            }
            if (v1 != e[1] || v2 != e[0]) continue;
            return false;
        }
        throw new IllegalArgumentException("Face isn't using that edge.");
    }

    private static Collection<ConnectedFace> getNeighborFaces(NavModel model, NavTriangle f, boolean fIsGood) {
        ArrayList<ConnectedFace> neighbors = new ArrayList<ConnectedFace>(3);
        for (int m = 0; m < 3; ++m) {
            NavTriangle atri = model.getAdjTri(f, m);
            if (atri == null) continue;
            int[] edge = f.getEdge(m);
            neighbors.add(new ConnectedFace(fIsGood, edge, atri));
        }
        return neighbors;
    }

    private static boolean isInternalEdgeType(InfernoType type) {
        return !type.door && type != InfernoType.BOUNDARY;
    }

    private static int getPointIx(Point3d p, LinkedHashMap<Point3d, Integer> ptIxMap) {
        Integer ix = ptIxMap.get(p);
        if (ix == null) {
            ix = ptIxMap.size();
            ptIxMap.put(p, ix);
        }
        return ix;
    }

    public static InfernoGeom[] getSources(List<InfernoGeom> igeoms, int[] groupIds) {
        InfernoGeom[] sources = new InfernoGeom[groupIds.length];
        for (int m = 0; m < groupIds.length; ++m) {
            sources[m] = igeoms.get(groupIds[m]);
        }
        return sources;
    }

    public static InfernoGeom pickBestSource(List<InfernoGeom> igeoms, int[] groupIds) {
        return InfernoGeomBuilder.pickBestSource(InfernoGeomBuilder.getSources(igeoms, groupIds));
    }

    public static InfernoGeom pickBestSource(InfernoGeom[] sources) {
        InfernoGeom bestSource = null;
        for (InfernoGeom source : sources) {
            if (bestSource != null && source.type.priority >= bestSource.type.priority) continue;
            bestSource = source;
        }
        return bestSource;
    }

    private static final class ConnectedFace {
        public final boolean fromFaceIsGood;
        public final int[] fromEdge;
        public final NavTriangle face;

        public ConnectedFace(boolean fromFaceIsGood, int[] fromEdge, NavTriangle face) {
            this.fromFaceIsGood = fromFaceIsGood;
            this.fromEdge = fromEdge;
            this.face = face;
        }
    }

    private static class NavEdge {
        public final int e1;
        public final int e2;

        public NavEdge(int e1, int e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public int hashCode() {
            return 0x23498F3 ^ this.e1 + this.e2;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof NavEdge && ((NavEdge)obj).e1 == this.e1 && ((NavEdge)obj).e2 == this.e2 || ((NavEdge)obj).e1 == this.e2 && ((NavEdge)obj).e2 == this.e1;
        }
    }

    private static class NavModel {
        public final List<NavTriangle> tris;
        public final List<Point3d> verts;
        public final Map<NavEdge, NavTriangle[]> edgeAdj;

        public NavModel(List<NavTriangle> tris, List<Point3d> verts) {
            this.tris = tris;
            this.verts = verts;
            this.edgeAdj = NavModel.calcEdgeAdj(tris);
        }

        /*
         * Exception decompiling
         */
        private static Map<NavEdge, NavTriangle[]> calcEdgeAdj(List<NavTriangle> tris) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public NavTriangle getAdjTri(NavTriangle tri, int edgeIx) {
            NavEdge edge;
            switch (edgeIx) {
                case 0: {
                    edge = new NavEdge(tri.i1, tri.i2);
                    break;
                }
                case 1: {
                    edge = new NavEdge(tri.i2, tri.i3);
                    break;
                }
                default: {
                    edge = new NavEdge(tri.i3, tri.i1);
                }
            }
            NavTriangle[] atris = this.edgeAdj.get(edge);
            assert (atris != null);
            if (atris[0] == tri) {
                return atris[1];
            }
            if (atris[1] == tri) {
                return atris[0];
            }
            return null;
        }

        public Plane3d getPlane(NavTriangle tri) {
            return new Plane3d(true, this.verts.get(tri.i1), this.verts.get(tri.i2), this.verts.get(tri.i3));
        }
    }

    private static class Triangulator
    implements Runnable {
        private final Param d_param;
        private final Face d_modelFace;
        private Triangulation d_triangulation;
        public final int d_triangulatorIx;
        private final int d_preparerIx;

        public Triangulator(Param param, Face face, int preparerIx, int triangulatorIx) {
            this.d_param = param;
            this.d_modelFace = face;
            this.d_preparerIx = preparerIx;
            this.d_triangulatorIx = triangulatorIx;
        }

        @Override
        public void run() {
            this.d_triangulation = this.d_modelFace.triangulate(this.d_param.refOptions);
        }
    }

    private static class ModelPreparer
    implements Runnable {
        private final Param d_param;
        private final Model d_model;
        public final int d_ix;

        public ModelPreparer(Model model, Param param, int ix) {
            this.d_param = param;
            this.d_model = model;
            this.d_ix = ix;
        }

        @Override
        public void run() {
            this.d_model.divideEdges(this.d_param.maxEdgeLength.getValue(Geometry.LENGTH_UNIT));
        }
    }

    public static class MarkedEdge {
        public final InfernoGeom igeom;
        public final int i1;
        public final int i2;

        public MarkedEdge(InfernoGeom source, int i1, int i2) {
            this.igeom = source;
            this.i1 = i1;
            this.i2 = i2;
        }
    }

    public static class NavTriangle {
        public final InfernoGeom[] igeoms;
        public int i1;
        public int i2;
        public int i3;

        public NavTriangle(InfernoGeom[] sources, int v1, int v2, int v3) {
            this.igeoms = sources;
            this.i1 = v1;
            this.i2 = v2;
            this.i3 = v3;
        }

        public InfernoGeom getBestSource() {
            return InfernoGeomBuilder.pickBestSource(this.igeoms);
        }

        public int getVert(int ix) {
            switch (ix) {
                case 0: {
                    return this.i1;
                }
                case 1: {
                    return this.i2;
                }
            }
            return this.i3;
        }

        public int[] getEdge(int ix) {
            switch (ix) {
                case 0: {
                    return new int[]{this.i1, this.i2};
                }
                case 1: {
                    return new int[]{this.i2, this.i3};
                }
            }
            return new int[]{this.i3, this.i1};
        }

        public int[] getVerts() {
            return new int[]{this.i1, this.i2, this.i3};
        }

        public void flipOrient() {
            int temp = this.i1;
            this.i1 = this.i3;
            this.i3 = temp;
        }
    }

    public static class Param {
        public final UnitDouble maxEdgeLength;
        public final Face.RefinementOptions refOptions;

        public Param() {
            this(DEF_MAX_EDGE_LENGTH, DEF_FACE_REFINEMENT);
        }

        public Param(UnitDouble maxEdgeLength, Face.RefinementOptions refOptions) {
            this.maxEdgeLength = maxEdgeLength;
            this.refOptions = refOptions;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Param)) {
                return false;
            }
            Param p = (Param)obj;
            return this.maxEdgeLength.equals(p.maxEdgeLength) && this.refOptions.equals(p.refOptions);
        }
    }
}

