/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CompElementActions;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.util.Dependencies;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class EnableAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_ENABLE_HOOK = new UIHook(new EnableAction(true), Intl.intl("Enable"));
    public static final UIHook UI_DISABLE_HOOK = new UIHook(new EnableAction(false), Intl.intl("Disable"));
    private final boolean d_enable;

    public EnableAction(boolean enable) {
        this.d_enable = enable;
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.updateEnabled();
    }

    @Override
    public void update(Events events) {
        IEventRecord<ICompElement> evts = events.getEvents(ICompElement.class, new Class[0]);
        if (evts.hasChangedObjs(MerlinData.SELECTION_CHANGED, MerlinData.ENABLED) || evts.hasRemovedObjs() || evts.hasAddedObjs()) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        MerlinData md = MerlinApp.getApp().getData();
        Set sel = md.selection.getSelected(ICompElement.class);
        Set<Object> sharedProps = Composite.getPropTypes(0, sel);
        if (!sharedProps.contains(MerlinData.ENABLED)) {
            this.setEnabled(false);
            return;
        }
        Object val = Composite.getProperty(MerlinData.ENABLED, sel);
        if (this.d_enable) {
            this.setEnabled(!(val instanceof Boolean) || (Boolean)val == false);
        } else {
            this.setEnabled(!(val instanceof Boolean) || (Boolean)val != false);
        }
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        String undoName = this.d_enable ? Intl.intl("Enable") : Intl.intl("Disable");
        Set<ICompElement> sel = md.selection.getDeepSelected(ICompElement.class);
        Optional<Set<ICompElement>> allObjs = this.collectAndValidate(sel, app, md);
        if (allObjs.isPresent()) {
            md.beginWrite();
            Undo.begin(undoName);
            CompElementActions.setProperty(MerlinData.ENABLED, (Collection<? extends ICompElement>)allObjs.get(), this.d_enable);
            Undo.end(md);
            md.endWrite();
        }
    }

    private Optional<Set<ICompElement>> collectAndValidate(Set<ICompElement> sel, MerlinApp app, MerlinData md) {
        IFilteredCollection<AEgressComp> selectedComponents = theUtil.filter(sel, AEgressComp.class);
        IFilteredCollection<OccSourceObj> selectedOccSources = theUtil.filter(sel, OccSourceObj.class);
        IFilteredCollection<EgressAgent> selectedAgents = theUtil.filter(sel, EgressAgent.class);
        md.beginRead();
        LinkedHashSet<AMerlinObj> connectedObjs = new LinkedHashSet<AMerlinObj>();
        for (AEgressComp comp : selectedComponents) {
            connectedObjs.addAll(comp.getConnObjectsForEnable(md));
        }
        if (this.d_enable) {
            IEgressComp comp;
            for (OccSourceObj occSource : selectedOccSources) {
                comp = (IEgressComp)occSource.getProperty(OccSourceObj.PROP_COMPONENT);
                if (comp == null || !(comp instanceof AEgressComp) || ((AEgressComp)comp).isEnabled()) continue;
                connectedObjs.add((AEgressComp)comp);
                connectedObjs.remove(occSource);
            }
            for (EgressAgent agent : selectedAgents) {
                comp = agent.getRoom();
                if (comp == null || !(comp instanceof AEgressComp) || ((AEgressComp)comp).isEnabled()) continue;
                connectedObjs.add((AEgressComp)comp);
                connectedObjs.remove(agent);
            }
        }
        IFilteredCollection<AMerlinObj> connObjs = theUtil.filter(connectedObjs, o -> {
            if (!(o instanceof ICompElement)) {
                return false;
            }
            ICompElement el = (ICompElement)((Object)o);
            if (ICompElement.NOT_SUPPORTED.equals(el.getProperty(MerlinData.ENABLED)) || ICompElement.NON_UNIFORM.equals(el.getProperty(MerlinData.ENABLED))) {
                return false;
            }
            if ((Boolean)el.getProperty(MerlinData.ENABLED) == this.d_enable) {
                return false;
            }
            return !sel.contains(el);
        });
        md.endRead();
        if (!sel.isEmpty() && !this.d_enable) {
            LinkedHashSet referencing = new LinkedHashSet();
            md.beginRead();
            Dependencies.getObjReferences(md, IEgressComp.class, o -> selectedComponents.contains(o) || o instanceof AMerlinObj && connObjs.contains((AMerlinObj)((Object)o)), (source, target) -> {
                if (source instanceof IBehaviorAction) {
                    referencing.add((IBehaviorAction)source);
                }
            });
            Dependencies.getObjReferences(md, Elevator.class, o -> sel.contains(o), (source, target) -> {
                if (source instanceof IBehaviorAction) {
                    referencing.add((IBehaviorAction)source);
                }
            });
            md.endRead();
            if (!referencing.isEmpty()) {
                guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Objects cannot be disabled"), 17);
                GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
                gb.addRow(String.format(Intl.intl("Objects cannot be disabled, because they are referenced by %d behavior actions."), referencing.size()));
                gb.addRow(Intl.intl("Select referencing behavior actions?"));
                if (dlg.doModal() == 1) {
                    md.beginWrite();
                    md.selection.clear();
                    md.selection.selectAll(referencing);
                    md.endWrite();
                }
                return Optional.empty();
            }
        }
        if (!connObjs.isEmpty()) {
            String title;
            String msg;
            int choice;
            IFilteredCollection<EgressAgent> agents = theUtil.filter(connObjs, EgressAgent.class);
            IFilteredCollection<EgressRoom> rooms = theUtil.filter(connObjs, EgressRoom.class);
            IFilteredCollection<EgressCorridor> corridors = theUtil.filter(connObjs, EgressCorridor.class);
            IFilteredCollection<EgressDoor> doors = theUtil.filter(connObjs, EgressDoor.class);
            IFilteredCollection<OccSourceObj> occSources = theUtil.filter(connObjs, OccSourceObj.class);
            String connObjMsg = "";
            boolean addSep = false;
            if (!agents.isEmpty()) {
                connObjMsg = connObjMsg + String.format(agents.size() == 1 ? Intl.intl("%d occupant") : Intl.intl("%d occupants"), agents.size());
                addSep = true;
            }
            if (!rooms.isEmpty()) {
                if (addSep) {
                    connObjMsg = connObjMsg + ", ";
                }
                connObjMsg = connObjMsg + String.format(rooms.size() == 1 ? Intl.intl("%d room") : Intl.intl("%d rooms"), rooms.size());
                addSep = true;
            }
            if (!corridors.isEmpty()) {
                if (addSep) {
                    connObjMsg = connObjMsg + ", ";
                }
                connObjMsg = connObjMsg + String.format(corridors.size() == 1 ? Intl.intl("%d stair/ramp") : Intl.intl("%d stairs/ramps"), corridors.size());
                addSep = true;
            }
            if (!doors.isEmpty()) {
                if (addSep) {
                    connObjMsg = connObjMsg + ", ";
                }
                connObjMsg = connObjMsg + String.format(doors.size() == 1 ? Intl.intl("%d door") : Intl.intl("%d doors"), doors.size());
                addSep = true;
            }
            if (!occSources.isEmpty()) {
                if (addSep) {
                    connObjMsg = connObjMsg + ", ";
                }
                connObjMsg = connObjMsg + String.format(occSources.size() == 1 ? Intl.intl("%d occupant source") : Intl.intl("%d occupant sources"), occSources.size());
                addSep = true;
            }
            if ((choice = md.ui(() -> EnableAction.lambda$collectAndValidate$1227(app, msg = String.format(this.d_enable ? Intl.intl("Other connected objects (%s) will be enabled.\n Do you still want to enable selected objects?") : Intl.intl("Other connected objects (%s) will be disabled.\n Do you still want to disable selected objects?"), connObjMsg), title = this.d_enable ? Intl.intl("Enable?") : Intl.intl("Disable?"))).intValue()) != 0) {
                return Optional.empty();
            }
        }
        LinkedHashSet<ICompElement> collectedObjs = new LinkedHashSet<ICompElement>(sel);
        connObjs.forEach(o -> collectedObjs.add((ICompElement)((Object)o)));
        return Optional.of(collectedObjs);
    }

    private static /* synthetic */ Integer lambda$collectAndValidate$1227(MerlinApp merlinApp, String string, String string2) throws Exception {
        return JOptionPane.showConfirmDialog(merlinApp.getActiveFrame(), string, string2, 0);
    }
}

