/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.sim.KB;
import inferno.sim.OccSource;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import javax.vecmath.Point3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;

public class RendOccSource
implements IRenderer<OccSource> {
    @Override
    public void renderOpaque(GLView view, KB kb, OccSource obj) throws Exception {
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, OccSource obj) throws Exception {
        GL11.glPushAttrib(8197);
        GL11.glDisable(2896);
        AABox box = obj.getBounds();
        Point3d[][] faces = box.getFaces();
        GL11.glColor3d(0.0, 0.0, 0.0);
        GL11.glLineWidth(3.0f);
        for (int i = 0; i < faces.length; ++i) {
            for (int j = 0; j < faces[0].length - 1; ++j) {
                this.lineTo(faces[i][j], faces[i][j + 1]);
            }
            this.lineTo(faces[i][faces[0].length - 1], faces[i][0]);
        }
        if (view.testFilter(SEGMENTS.class)) {
            OccSource.GeomChoice[] lines;
            OccSource.GeomChoice[] tris = obj.getTris();
            if (tris.length > 0) {
                int m;
                GL11.glColor4d(0.0, 1.0, 0.0, 0.2);
                GL11.glBegin(4);
                for (OccSource.GeomChoice tri : tris) {
                    for (m = 0; m < 3; ++m) {
                        Point3d p = tri.geom[m];
                        this.vertex3d(p);
                    }
                }
                GL11.glEnd();
                GL11.glLineWidth(1.0f);
                GL11.glColor4d(0.0, 0.0, 0.0, 0.8);
                GL11.glBegin(1);
                for (OccSource.GeomChoice tri : tris) {
                    for (m = 0; m < 3; ++m) {
                        this.vertex3d(tri.geom[m]);
                        this.vertex3d(tri.geom[(m + 1) % 3]);
                    }
                }
                GL11.glEnd();
            }
            if ((lines = obj.getLineSegments()).length > 0) {
                GL11.glColor4d(0.0, 1.0, 0.0, 0.5);
                GL11.glLineWidth(3.0f);
                GL11.glBegin(1);
                for (OccSource.GeomChoice ls : lines) {
                    for (int m = 0; m < 2; ++m) {
                        this.vertex3d(ls.geom[m]);
                    }
                }
                GL11.glEnd();
            }
        }
        GL11.glPopAttrib();
    }

    @Override
    public AABox getBounds(OccSource obj) {
        return obj.getBounds();
    }

    private void lineTo(Point3d from, Point3d to) {
        GL11.glBegin(1);
        GL11.glVertex3d(from.x, from.y, from.z);
        GL11.glVertex3d(to.x, to.y, to.z);
        GL11.glEnd();
    }

    public static final class SEGMENTS {
    }
}

