/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.data2.IProps;
import inferno.data2.Occupant;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.vis.AbstractTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import thunderheadeng.util.Global;

public class LocallyQuickestTable
extends AbstractTable {
    private KB d_kb;
    private String d_selectedAgentName;
    private JPanel d_panel = new JPanel(new BorderLayout());
    private JLabel d_label = new JLabel("Showing results for: ");
    private int d_rowIndex;

    public LocallyQuickestTable(KB kb) {
        this.d_kb = kb;
        this.d_label.setFont(this.d_label.getFont().deriveFont(1));
        this.d_panel.add((Component)this.d_label, "North");
        this.d_panel.add((Component)new JScrollPane(this.d_table), "Center");
    }

    @Override
    public void initModel(String className) throws SecurityException, ClassNotFoundException {
        this.d_columnNames = new String[]{"local target", "global target", "local dist", "global dist", "total dist", "local time", "global time", "total time"};
        this.d_values = new Object[1][this.d_columnNames.length];
    }

    @Override
    public void update(List<Object> data) {
        if (data != null) {
            Serializable ser3;
            Serializable ser2;
            IProps props = this.d_kb.getProps();
            Occupant occ = (Occupant)data.get(0);
            Serializable ser = props.getDbgObj(occ, "LOCQUICKEST_TARGETINFO");
            List targetCosts = null;
            Map locQuickData = null;
            Map targetEvals = null;
            ILocalTarget best = null;
            Serializable ser0 = props.getDbgObj(occ, "LOCQUICKEST_TARGETCOSTS");
            if (ser0 != null) {
                targetCosts = (List)((Object)ser0);
            }
            if (ser != null) {
                locQuickData = (Map)((Object)ser);
                this.d_rowIndex = 0;
            }
            if ((ser2 = props.getDbgObj(occ, "LOCQUICKEST_TARGETEVALS")) != null) {
                targetEvals = (Map)((Object)ser2);
            }
            if ((ser3 = props.getDbgObj(occ, "LOCQUICKEST_BEST")) != null) {
                best = (ILocalTarget)((Object)ser3);
            }
            if (locQuickData != null && best != null && targetEvals != null) {
                this.addRows(occ, locQuickData, targetCosts, best, targetEvals);
                this.d_selectedAgentName = occ.name;
                this.updateLabel();
            }
            this.d_table.repaint();
        } else {
            this.d_values = new Object[1][this.d_columnNames.length];
            this.d_selectedAgentName = "";
            this.updateLabel();
            this.d_table.repaint();
        }
    }

    private void addRows(Occupant occ, Map<ILocalTarget, LocallyQuickest.TargetInfo> locQuickData, List<LocallyQuickest.TargetCostComparer> targetCosts, ILocalTarget best, Map<ILocalTarget, LocallyQuickest.TargetEval> targetEvals) {
        this.d_table.putClientProperty("HIGHLIGHTED_ROW", -1);
        this.d_values = new Object[locQuickData.size()][this.d_columnNames.length];
        for (Map.Entry<ILocalTarget, LocallyQuickest.TargetInfo> entry : locQuickData.entrySet()) {
            this.addRow(occ, entry.getKey(), entry.getValue(), this.findTcc(entry.getKey(), targetCosts), best, targetEvals.get(entry.getKey()));
        }
    }

    private LocallyQuickest.TargetCostComparer findTcc(ILocalTarget key, List<LocallyQuickest.TargetCostComparer> targetCosts) {
        if (targetCosts == null) {
            return null;
        }
        for (LocallyQuickest.TargetCostComparer tcc : targetCosts) {
            if (!tcc.target.equals(key)) continue;
            return tcc;
        }
        return null;
    }

    private void addRow(Occupant occ, ILocalTarget target, LocallyQuickest.TargetInfo targetInfo, LocallyQuickest.TargetCostComparer tcc, ILocalTarget best, LocallyQuickest.TargetEval targetEval) {
        if (target.equals(best)) {
            this.d_table.putClientProperty("HIGHLIGHTED_ROW", this.d_rowIndex);
        }
        int colIndex = 0;
        this.d_table.setValueAt(target, this.d_rowIndex, colIndex++);
        this.d_table.setValueAt(targetInfo.target, this.d_rowIndex, colIndex++);
        OccAgent agent = this.d_kb.getAgent(occ);
        if (tcc != null) {
            double tailDist = tcc.targetEval.getTailDist();
            double tailTime = tcc.targetEval.getTailTime(this.d_kb, agent);
            double locTimeEst = tcc.localTimeEst.getTotalTimeEst(LocallyQuickest.AdditionalTimeEstType.NONE);
            double locQ = (Double)tcc.localTimeEst.getLocalTimeEstimate((LocallyQuickest.AdditionalTimeEstType)LocallyQuickest.AdditionalTimeEstType.NONE).v1;
            double locT = (Double)tcc.localTimeEst.getLocalTimeEstimate((LocallyQuickest.AdditionalTimeEstType)LocallyQuickest.AdditionalTimeEstType.NONE).v2;
            double locTimeElevatorEst = tcc.localTimeEst.getTotalTimeEst(LocallyQuickest.AdditionalTimeEstType.TRANSPORT_DOOR);
            double locElQ = (Double)tcc.localTimeEst.getLocalTimeEstimate((LocallyQuickest.AdditionalTimeEstType)LocallyQuickest.AdditionalTimeEstType.TRANSPORT_DOOR).v1;
            double locElT = (Double)tcc.localTimeEst.getLocalTimeEstimate((LocallyQuickest.AdditionalTimeEstType)LocallyQuickest.AdditionalTimeEstType.TRANSPORT_DOOR).v2;
            this.d_table.setValueAt(Global.format(tcc.localDist), this.d_rowIndex, colIndex++);
            this.d_table.setValueAt(Global.format(tailDist), this.d_rowIndex, colIndex++);
            this.d_table.setValueAt(Global.format(tcc.localDist + tailDist), this.d_rowIndex, colIndex++);
            if (locTimeEst != locTimeElevatorEst) {
                this.d_table.setValueAt(Global.format(locTimeEst) + " (q: " + Global.format(locQ) + ", t: " + Global.format(locT) + ")" + " [elev: " + Global.format(locTimeElevatorEst) + " (q: " + Global.format(locElQ) + ", t: " + Global.format(locElT) + ")" + "]", this.d_rowIndex, colIndex++);
            } else {
                this.d_table.setValueAt(Global.format(locTimeEst) + " (q: " + Global.format(locQ) + ", t: " + Global.format(locT) + ")", this.d_rowIndex, colIndex++);
            }
            this.d_table.setValueAt(Global.format(tailTime), this.d_rowIndex, colIndex++);
            this.d_table.setValueAt(Global.format(locTimeEst + tailTime), this.d_rowIndex, colIndex++);
        } else {
            double tailDist = targetEval.getTailDist();
            double tailTime = targetEval.getTailTime(this.d_kb, agent);
            this.d_table.setValueAt(targetEval.pathLenEst, this.d_rowIndex, colIndex++);
            this.d_table.setValueAt(Global.format(tailDist), this.d_rowIndex, colIndex++);
            this.d_table.setValueAt(targetEval.pathLenEst + tailDist, this.d_rowIndex, colIndex++);
            this.d_table.setValueAt("NA", this.d_rowIndex, colIndex++);
            this.d_table.setValueAt(Global.format(tailTime), this.d_rowIndex, colIndex++);
            this.d_table.setValueAt("NA", this.d_rowIndex, colIndex++);
        }
        this.d_tableModel.fireTableDataChanged();
        ++this.d_rowIndex;
    }

    private void updateLabel() {
        this.d_label.setText("Showing results for: " + this.d_selectedAgentName);
    }

    public Component getPanel() {
        return this.d_panel;
    }
}

