/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.test.Prob;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

public class WriteFile {
    public static void addResults(Collection<Prob> Tests, PrintWriter pw) {
        for (Prob test : Tests) {
            WriteFile.addResult(test, pw);
        }
    }

    public static void addResult(Prob test, PrintWriter pw) {
        pw.printf("%d, \"%s\", \"%s\", %.2f, %.2f, %n", test.getStatus(), test.getName(), test.getExpl(), test.getSimTime(), test.getRunTime());
    }

    public static void printManualEntryTemplate(List<Prob> tests, PrintStream out) {
        out.printf("%-7s %-30s %s, %s, %s%n", "status,", "name,", "comments", "simTime", "runTime");
        for (Prob test : tests) {
            out.printf("%-7s \"%-30s\" %s, %s, %s%n", "-1,", test.getName() + ",", "<comments>", "<simTime>", "<runTime>");
        }
    }

    public static PrintWriter createWriter(String out) {
        Calendar cal = Calendar.getInstance();
        String[] time = new String[]{"year", "month", "date", "hour", "minute"};
        time[0] = Integer.toString(cal.get(1));
        time[1] = Integer.toString(cal.get(2) + 1);
        time[2] = Integer.toString(cal.get(5));
        time[3] = Integer.toString(cal.get(11));
        time[4] = Integer.toString(cal.get(12));
        String f = time[0];
        for (int i = 1; i < 5; ++i) {
            if (time[i].length() == 1) {
                time[i] = "0" + time[i];
            }
            f = f.concat("." + time[i]);
        }
        f = f.concat(".csv");
        File outFile = new File(out, f);
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(outFile), true);
            System.out.printf("Created output file %s %n", outFile.getPath());
            pw.println("status,name,comments,simTime,runTime");
            pw.flush();
            return pw;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

