/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.ANode;
import inferno.data2.WingedEdge;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.inverse.ASeek;
import inferno.sim.steering.inverse.BehaviorWeights;
import inferno.sim.steering.inverse.IdleSeparation;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class WanderRoom
extends ASeek {
    static final long serialVersionUID = 1L;
    private final Collection<ANode> d_rooms;
    private final List<DoorArea> d_inAreas;
    private final List<DoorArea> d_outAreas;
    private Vector3d d_seekDir;
    private final boolean d_prefersToStandStill;

    public WanderRoom(KB kb, OccAgent agent, Collection<ANode> rooms, boolean prefersToStandStill) {
        super(kb, agent, prefersToStandStill ? 0.0 : Double.NaN, null);
        this.d_rooms = rooms;
        this.d_inAreas = new ArrayList<DoorArea>();
        this.d_outAreas = new ArrayList<DoorArea>();
        this.d_prefersToStandStill = prefersToStandStill;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return null;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        ANode currRoom = agent.getOcc().curNode;
        boolean inTargetRoom = this.d_rooms.contains(currRoom);
        if (!inTargetRoom) {
            this.d_seekDir = null;
        }
        List<DoorArea> doorAreas = WanderRoom.getDoorAreas(currRoom, agent);
        ArrayList<DoorArea> inAreas = new ArrayList<DoorArea>();
        for (DoorArea doorArea : doorAreas) {
            if (!doorArea.contains(agent)) continue;
            inAreas.add(doorArea);
        }
        if (this.d_prefersToStandStill) {
            this.d_seekDir = new Vector3d(0.0, 0.0, 0.0);
        }
        if (inAreas.isEmpty() && this.d_seekDir == null) {
            double nearDistSq = Double.MAX_VALUE;
            for (DoorArea door : WanderRoom.getDoorAreas(currRoom, agent)) {
                Point3d p1 = door.door[0];
                Point3d p2 = door.door[1];
                double distsq = Inter2D.distSqToNearestPtOnLineSeg(p1.x, p1.y, p2.x, p2.y, agent.getPos().x, agent.getPos().y);
                if (theUtil.lt(distsq, nearDistSq, 1.0E-6)) {
                    inAreas.clear();
                    inAreas.add(door);
                    nearDistSq = distsq;
                    continue;
                }
                if (!theUtil.eq(distsq, nearDistSq, 1.0E-6)) continue;
                inAreas.add(door);
            }
        }
        if (inAreas.isEmpty()) {
            if (this.d_seekDir == null) {
                Random r = new Random(agent.getOcc().rseed ^ Double.doubleToLongBits(kb.getCurrentSimTime()));
                this.d_seekDir = Util3D.newRandomVector(r);
            }
        } else {
            Vector2d dir = new Vector2d(0.0, 0.0);
            for (DoorArea area : inAreas) {
                Iterator p1 = area.door[0];
                Point3d p2 = area.door[1];
                double nearDistSq = Inter2D.distSqToNearestPtOnLineSeg(((Point3d)((Object)p1)).x, ((Point3d)((Object)p1)).y, p2.x, p2.y, agent.getPos().x, agent.getPos().y);
                if (nearDistSq < agent.getGeometryRadius() * agent.getGeometryRadius()) {
                    dir.add(area.inDir);
                    continue;
                }
                Vector2d radialDir = new Vector2d(agent.getPos().x - area.center.x, agent.getPos().y - area.center.y);
                radialDir.normalize();
                if (agent.hasVehicle()) {
                    dir.add(area.inDir);
                    continue;
                }
                dir.add(radialDir);
            }
            double d = Util2D.safeNormalize(dir, 1.0E-6);
            if (d != 0.0) {
                for (DoorArea area : inAreas) {
                    if (!area.contains(agent) || !(area.inDir.dot(dir) < 0.0)) continue;
                    d = 0.0;
                    break;
                }
            }
            if (d == 0.0) {
                dir = new Vector2d(0.0, 0.0);
                for (DoorArea area : inAreas) {
                    dir.add(area.inDir);
                }
                d = Util2D.safeNormalize(dir, 1.0E-6);
                if (d == 0.0) {
                    Random r = new Random(agent.getOcc().rseed ^ Double.doubleToLongBits(kb.getCurrentSimTime()));
                    dir = Util2D.newRandomVec2D(r);
                }
            }
            this.d_seekDir = new Vector3d(dir.x, dir.y, 0.0);
        }
        LineSeg3D curve = new LineSeg3D(agent.getPos(), Util3D.add(agent.getPos(), (Tuple3d)this.d_seekDir));
        Predicate<WingedEdge> predicate = EdgeFilters.rejectAllDangerous(agent.getOcc().obeyOnewayDoors);
        return Util.generateSeekCurve(kb, agent, curve, curve.lengthSq() > 0.0, predicate);
    }

    @Override
    public void init(KB kb, OccInfo oi, IParametric3D seekCurve) {
        ANode wanderRoom = oi.oa.getOcc().curNode;
        this.d_inAreas.clear();
        this.d_outAreas.clear();
        for (DoorArea da : WanderRoom.getDoorAreas(wanderRoom, oi.oa)) {
            if (da.contains(oi.oa)) {
                this.d_inAreas.add(da);
                continue;
            }
            this.d_outAreas.add(da);
        }
        super.init(kb, oi, seekCurve);
    }

    @Override
    public BehaviorWeights getWeights(KB kb, OccInfo oi, boolean isSocialDistancing) {
        BehaviorWeights weights = super.getWeights(kb, oi, isSocialDistancing);
        if (!this.d_inAreas.isEmpty() && (double)oi.oa.getOcc().nodeSqueezeFactor != 1.0) {
            weights.avoidOccs = 0.0;
            weights.seekSep = 0.0;
        }
        return weights;
    }

    @Override
    public IdleSeparation getSeparation(KB kb, OccInfo oi) {
        return !this.d_inAreas.isEmpty() ? new IdleSeparation(false, 0.0) : new IdleSeparation(kb, oi, true);
    }

    private double getDirCost(KB kb, OccInfo oi, List<DoorArea> outAreas, Vector3d dir) {
        OccAgent agent = oi.oa;
        Point2d loc = WanderRoom.to2d(agent.getPos());
        double minStopDist = 0.0;
        double maxStopDist = 0.0;
        if (!outAreas.isEmpty()) {
            double stopAccel = agent.getMaxStopAccel(kb);
            minStopDist = OccAgent.calcStopDist(oi.cache.currVel, stopAccel);
            maxStopDist = OccAgent.calcStopDist(oi.cache.maxVel, stopAccel);
        }
        return this.getDirCost(kb, oi, outAreas, dir, loc, minStopDist, maxStopDist);
    }

    private double getDirCost(KB kb, OccInfo oi, List<DoorArea> outAreas, Vector3d dir, Point2d loc, double minStopDist, double maxStopDist) {
        if (dir == null) {
            return 0.5;
        }
        Vector2d testDir = new Vector2d(dir.x, dir.y);
        testDir.normalize();
        double maxCost = 0.0;
        for (DoorArea area : outAreas) {
            double[] isect = Inter2D.lineCircleIsect(loc.x, loc.y, testDir.x, testDir.y, area.center.x, area.center.y, area.radius, 1.0E-6);
            if (isect == null || isect[1] <= 0.0) continue;
            assert (isect[0] >= 0.0);
            double cost = InvSteerUtil.clampCost(KnownFuncs.linInterp(maxStopDist, 0.0, minStopDist, 1.0, isect[0]));
            if (!(cost > maxCost)) continue;
            maxCost = cost;
        }
        return maxCost;
    }

    @Override
    public double[] getCost(KB kb, OccInfo oi, Senses sense, SeekInfo seekInfo, Vector3d preferredDir, Vector3d dir) {
        double[] baseCost = super.getCost(kb, oi, sense, seekInfo, preferredDir, dir);
        double dirCost = this.getDirCost(kb, oi, this.d_outAreas, dir);
        return new double[]{Math.max(baseCost[0], dirCost), baseCost[1]};
    }

    public static List<DoorArea> getDoorAreas(ANode room, OccAgent agent) {
        ArrayList<DoorArea> areas = new ArrayList<DoorArea>();
        for (ANode door : room.getDoors()) {
            if (!WanderRoom.isAvoidDoor(door, room)) continue;
            theUtil.groupSequentialMatches(door.getDoorEdges(), d -> Util3D.vectorN(d.p1(), d.p2()), (dir1, dir2) -> dir1.epsilonEquals((Tuple3d)dir2, 1.0E-9), (group, offset, dirN) -> {
                DoorArea area = WanderRoom.getDoorArea(room, door, group, dirN, agent);
                if (area == null) {
                    return;
                }
                areas.add(area);
            });
        }
        areas.trimToSize();
        return areas;
    }

    private static boolean isAvoidDoor(ANode door, ANode room) {
        if (door.isExitDoor() || door.isPhysicallyClosed()) {
            return false;
        }
        ANode n1 = door.doorQueue.getR1();
        ANode n2 = door.doorQueue.getR2();
        return (n1 == room || n2 == room) && n1 != n2;
    }

    private static DoorArea getDoorArea(ANode room, ANode door, List<WingedEdge> doorEdges, Vector3d doorDirN, OccAgent agent) {
        WingedEdge medge = doorEdges.get(doorEdges.size() / 2);
        boolean doorDirPos = medge.getNode1() == room;
        Vector3d doorDir = doorDirPos ? doorDirN : Util3D.negate(doorDirN);
        Vector2d inDir = new Vector2d(-doorDir.y, doorDir.x);
        if (Util2D.safeNormalize(inDir, 1.0E-6) == 0.0) {
            return null;
        }
        Point3d p1 = doorEdges.get(0).p1();
        Point3d p2 = doorEdges.get(doorEdges.size() - 1).p2();
        double radius = 0.5 * Math.sqrt(WanderRoom.lengthSq2d(p1, p2));
        return new DoorArea(new Point3d[]{p1, p2}, WanderRoom.getMidPoint2d(p1, p2), radius += (double)agent.getOcc().comfortDist + agent.getOcc().bodyShape.getEnclosingRadius(), inDir);
    }

    private static double lengthSq2d(Point3d p1, Point3d p2) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return dx * dx + dy * dy;
    }

    private static Point2d getMidPoint2d(Point3d p1, Point3d p2) {
        return new Point2d((p1.x + p2.x) * 0.5, (p1.y + p2.y) * 0.5);
    }

    private static Point2d to2d(Point3d p) {
        return new Point2d(p.x, p.y);
    }

    public Collection<ANode> getRooms() {
        return this.d_rooms;
    }

    public static class DoorArea
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Point3d[] door;
        public final Point2d center;
        public final double radius;
        public final Vector2d inDir;

        public DoorArea(Point3d[] door, Point2d center, double radius, Vector2d inDir) {
            this.door = door;
            this.center = center;
            this.radius = radius;
            this.inDir = inDir;
        }

        public boolean contains(OccAgent oa) {
            double dx = this.center.x - oa.getPos().x;
            double dy = this.center.y - oa.getPos().y;
            double distsq = dx * dx + dy * dy;
            return distsq <= this.radius * this.radius;
        }
    }
}

