/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.ANode;
import inferno.data2.IAgentBodyShape;
import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.ConnectedMesh;
import inferno.geom.Inter;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.geom.ValueFld;
import inferno.sim.DoorQueue;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.OccSource;
import inferno.sim.path.EdgeFilters;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.inverse.ASeek;
import inferno.sim.steering.inverse.BehaviorWeights;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class SeekPathAwayFromDoors
extends ASeek
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final double DT_COLLISIONS = 1.0;
    private static final double DT_DISTMAPS = 1.0;
    private static final double HAPPY_GAP = 0.6;
    private static final double DIST_TOL = UnitDouble.convert(0.25, NonSI.FOOT, SI.METER);
    private static final double ANGLE_TOL = Math.toRadians(2.0);
    public final boolean avoidAllDoors;
    private double d_tNextDistMapCalc = 0.0;
    private double d_tNextCollCalc = 0.0;
    private Point3d d_lastLoc;
    private Point3d d_lastSeekPoint;
    private Point3d d_lastHitPoint;
    private Vector3d d_lastSeekDir;
    private DirDist[] d_dirs;
    private int d_lastDistMapId = -1;
    private double[] d_lastDistFromDoorsRange = new double[]{0.0, 0.0};
    private double d_currDistFromDoors = 0.0;
    private static final double[] angles = new double[]{Double.NaN, Math.toRadians(0.0), Math.toRadians(30.0), Math.toRadians(60.0), Math.toRadians(90.0), Math.toRadians(120.0), Math.toRadians(150.0), Math.toRadians(180.0), Math.toRadians(210.0), Math.toRadians(240.0), Math.toRadians(270.0), Math.toRadians(300.0), Math.toRadians(330.0)};

    public SeekPathAwayFromDoors(KB kb, OccAgent agent, boolean avoidAllDoors) {
        super(kb, agent, 1.0, null);
        this.avoidAllDoors = avoidAllDoors;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return null;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        double maxSpeed = OccAgent.getMaxVel(kb, agent.getOcc(), 0.0, null);
        double dist = this.d_lastDistFromDoorsRange[1] - this.d_currDistFromDoors;
        return dist / maxSpeed;
    }

    private boolean isSeekDirsDirty(KB kb, OccAgent agent, ValueFld distMap) {
        if (this.d_lastLoc == null || this.d_dirs == null || distMap.id != this.d_lastDistMapId && kb.getCurrentSimTime() >= this.d_tNextDistMapCalc) {
            return true;
        }
        double movedDistSq = agent.getPos().distanceSquared(this.d_lastLoc);
        return movedDistSq >= 1.0 || kb.getCurrentSimTime() >= this.d_tNextCollCalc && movedDistSq >= 0.010000000000000002;
    }

    public double getCurrDistFromDoors() {
        return this.d_currDistFromDoors;
    }

    public double[] getDistFromDoorsRange() {
        return this.d_lastDistFromDoorsRange;
    }

    @Override
    public BehaviorWeights getWeights(KB kb, OccInfo oi, boolean isSocialDistancing) {
        double dist;
        BehaviorWeights weights = super.getWeights(kb, oi, isSocialDistancing);
        if (this.d_lastHitPoint != null && (dist = oi.oa.getPos().distance(this.d_lastHitPoint)) < oi.oa.getShape().getEnclosingRadius() * 2.0) {
            weights.seek = KnownFuncs.linInterp(0.0, 2.0, oi.oa.getShape().getEnclosingRadius() * 2.0, weights.seek, dist);
        }
        return weights;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        double maxVel = OccAgent.getTotalMaxVel(kb, agent.getOcc());
        if (maxVel == 0.0) {
            return Util.generateSeekCurve(kb, agent, new LineSeg3D(agent.getPos(), agent.getPos()), false, Predicates.alwaysFalse());
        }
        ANode node = agent.getOcc().curNode;
        ANode.DistFldInfo distInfo = this.avoidAllDoors ? node.getAllDoorsDistMap(kb) : node.getDoorDistMap(kb);
        ValueFld distMap = distInfo.dists;
        Vector3d baseDir = this.d_lastSeekDir != null ? this.d_lastSeekDir : agent.getDirFacing();
        Predicate<WingedEdge> edgeFilter = Filters.and(EdgeFilters.rejectAllDangerous(agent.getOcc().obeyOnewayDoors), EdgeFilters.filterDoors(Filters.reject(node.getDoorsOutOfRoom())));
        if (this.isSeekDirsDirty(kb, agent, distMap)) {
            this.d_tNextCollCalc = kb.getCurrentSimTime();
            List<Vector3d> sampleDirs = Arrays.asList(InvSteerUtil.generateSampleDirs(kb, agent, baseDir, angles));
            Vector3d flowDir = distInfo.maxDistDirs.getValue(agent.getLoc());
            if (flowDir != null && flowDir.lengthSquared() > 0.0) {
                sampleDirs = new ArrayList<Vector3d>(sampleDirs);
                sampleDirs.add(flowDir);
            }
            DirDist[] dirs = new DirDist[sampleDirs.size()];
            for (int m = 0; m < sampleDirs.size(); ++m) {
                DirDist dist;
                Vector3d dir = sampleDirs.get(m);
                dirs[m] = dist = this.getMaxDistInDirection(kb, agent, dir, distMap);
            }
            assert (dirs[0].dir == null);
            double currDist = dirs[0].distFromDoors;
            Vector3d bdir = baseDir;
            Arrays.sort(dirs, (d1, d2) -> {
                int dcomp = Double.compare(d2.distFromDoors, d1.distFromDoors);
                if (dcomp != 0) {
                    return dcomp;
                }
                if (d1.dir == null) {
                    return -1;
                }
                if (d2.dir == null) {
                    return 1;
                }
                Vector3d dface = bdir;
                double a1 = Util.angle2d(d1.dir, dface);
                double a2 = Util.angle2d(d2.dir, dface);
                return Double.compare(a1, a2);
            });
            this.d_dirs = dirs;
            this.d_lastLoc = agent.getPos();
            this.d_lastDistMapId = distMap.id;
            this.d_lastDistFromDoorsRange = Arrays.copyOf(distMap.dataBounds, distMap.dataBounds.length);
            this.d_currDistFromDoors = currDist;
            this.d_tNextDistMapCalc = kb.getCurrentSimTime() + 1.0;
        }
        Point3d seekPt = this.d_lastSeekPoint;
        if (kb.getCurrentSimTime() >= this.d_tNextCollCalc) {
            DirDist bestDir = null;
            double bestDist = -1.7976931348623157E308;
            double maxDistTol = agent.getShape().getEnclosingRadius() * 1.5;
            DirDist standDir = null;
            for (DirDist dir : this.d_dirs) {
                if (dir.dir != null) continue;
                standDir = dir;
                break;
            }
            IdentityHashMap visCache = new IdentityHashMap();
            TriPoint aloc = agent.getLoc();
            Function<OccAgent, Boolean> calcVis = oa -> !kb.getMesh().isPathObstructed(aloc, oa.getLoc(), 0.0, edgeFilter);
            Predicate<OccAgent> visFilter = oa -> (Boolean)visCache.computeIfAbsent(oa, calcVis);
            DirDist[] collDirs = new DirDist[this.d_dirs.length];
            DirDist firstDistAtCollision = null;
            for (int m = 0; m < this.d_dirs.length; ++m) {
                double angle;
                double distTol;
                double distDiff;
                double angle2;
                double angle1;
                int comp;
                DirDist dir = this.d_dirs[m];
                if (theUtil.lt(dir.distFromDoors, bestDist, DIST_TOL)) break;
                DirDist distAtCollision = this.getDistAtFirstOccHit(kb, agent, node, distMap, dir, visFilter);
                if (Double.isNaN(distAtCollision.distFromDoors)) {
                    distAtCollision = dir;
                }
                collDirs[m] = distAtCollision;
                if (dir.dir != null && firstDistAtCollision == null) {
                    firstDistAtCollision = distAtCollision;
                }
                if ((comp = theUtil.compare(bestDist, distAtCollision.distFromDoors, DIST_TOL)) == 0 && (comp = theUtil.compare(angle1 = distAtCollision.dir != null ? Util.angle2d(distAtCollision.dir, baseDir) : 0.0, angle2 = bestDir.dir != null ? Util.angle2d(bestDir.dir, baseDir) : 0.0, ANGLE_TOL)) == 0) {
                    comp = Double.compare(bestDir.distAlongDir2d, distAtCollision.distAlongDir2d);
                }
                if (comp >= 0 || distAtCollision.dir != null && standDir != null && (distDiff = Math.abs(distAtCollision.distFromDoors - standDir.distFromDoors)) < maxDistTol && distDiff <= (distTol = KnownFuncs.linInterp(0.0, 0.0, Math.PI, maxDistTol, angle = Util.angle2d(baseDir, distAtCollision.dir)))) continue;
                bestDist = distAtCollision.distFromDoors;
                bestDir = distAtCollision;
            }
            if (bestDir.dir == null && this.d_dirs[0].dir != null && firstDistAtCollision != null) {
                boolean anySeeking = false;
                for (DirDist collDir : collDirs) {
                    if (collDir == bestDir || (anySeeking |= collDir.hitSeekingOccs)) break;
                }
                if (anySeeking) {
                    bestDir = firstDistAtCollision;
                }
            }
            seekPt = bestDir.dir == null ? null : bestDir.endPt;
            if (bestDir.dir != null && !this.avoidAllDoors && !this.keepFilling(kb, agent, bestDir, standDir, distMap)) {
                seekPt = null;
            }
            this.d_lastSeekPoint = seekPt;
            this.d_lastHitPoint = bestDir.hitPt;
            if (seekPt != null) {
                this.d_lastSeekDir = Util3D.vector(agent.getPos(), seekPt);
                if (Util3D.safeNormalize(this.d_lastSeekDir, 1.0E-12) == 0.0) {
                    this.d_lastSeekDir = agent.getDirFacing();
                }
            } else {
                this.d_lastSeekDir = agent.getDirFacing();
            }
            this.d_tNextCollCalc = kb.getCurrentSimTime() + 1.0;
        }
        LineSeg3D curve = seekPt == null ? new LineSeg3D(agent.getPos(), agent.getPos()) : new LineSeg3D(agent.getPos(), seekPt);
        return Util.generateSeekCurve(kb, agent, curve, curve.lengthSq() > 0.0, edgeFilter);
    }

    private boolean keepFilling(KB kb, OccAgent agent, DirDist bestDir, DirDist standDir, ValueFld distMap) {
        Set<OccAgent> group = SeekPathAwayFromDoors.getGroup(agent);
        ANode node = agent.getOcc().curNode;
        if (group.stream().anyMatch(a -> a.getOcc().tri.node != node)) {
            return true;
        }
        for (OccAgent waiting : agent.getWaitingOccs(kb)) {
            if (group.contains(waiting)) continue;
            return true;
        }
        double eradius = agent.getShape().getEnclosingRadius();
        double happyGap = Math.max(0.6, (double)agent.getOcc().comfortDist);
        double happySocialDist = agent.isSocialDistancingEnabled() ? (double)agent.getSocialDistance() + 0.6 : 0.0;
        double searchRadius = Math.max(happyGap + eradius, happySocialDist);
        ITest<AABox> test = OccLocator.testCyl(agent.getPos(), searchRadius * searchRadius, agent.getPos().z, agent.getPos().z + agent.getOcc().bodyShape.getHeight(), new Plane3d[0]);
        Vector3d seekDir = bestDir.dir;
        double happySocialDistSq = happySocialDist * happySocialDist;
        DirDist sdir = standDir;
        Predicate<OccAgent> getAvoidOcc = a -> {
            if (group.contains(a)) {
                return false;
            }
            if (Arrays.asList(a.getAvoidOccs()).contains(agent)) {
                return true;
            }
            double dist = Util.dist2d(agent.getPos(), a.getPos());
            double gap = dist - eradius - a.getShape().getEnclosingRadius();
            if (gap > happyGap && theUtil.ge(a.getPos().distanceSquared(agent.getPos()), happySocialDistSq, 1.0E-6)) {
                return false;
            }
            Vector3d dirToOcc = Util.vector2d(agent.getPos(), a.getPos());
            if (Util.dot2d(dirToOcc, seekDir) >= 0.0) {
                double aDistFromDoors = distMap.getValue(a.getLoc());
                return aDistFromDoors < dirDist.distFromDoors;
            }
            return true;
        };
        boolean[] tooClose = new boolean[]{false};
        try {
            kb.findOccs(test, true, (a, ctmt) -> {
                if (getAvoidOcc.test((OccAgent)a)) {
                    blArray[0] = true;
                    throw new CancellationException();
                }
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (tooClose[0]) {
            return true;
        }
        for (ANode door : node.getActiveDistanceMapDoors()) {
            double geomRadius;
            double dist;
            double maxRadius;
            if (door.getOccSources() != null) {
                maxRadius = -1.7976931348623157E308;
                for (OccSource source : door.getOccSources()) {
                    if (!(source.getMaxGeomRadius() > maxRadius)) continue;
                    maxRadius = source.getMaxGeomRadius();
                }
            } else {
                maxRadius = 0.0;
            }
            if (!((dist = Math.sqrt(door.getDoorGeom().distSqToProjectedPoint(agent.getPos()))) < maxRadius + (geomRadius = OccAgent.getGeomCollisionShape(agent.getOcc(), kb, agent.getLoc().p, false, false).getEnclosingRadius()))) continue;
            return true;
        }
        return false;
    }

    private static Set<OccAgent> getGroup(OccAgent agent) {
        IFormationLeaderAgent formationLeader = agent.getOcc().formationLeader;
        if (formationLeader != null) {
            return new IdentityHashSet<OccAgent>(formationLeader.getFormation());
        }
        return Collections.singleton(agent);
    }

    private DirDist getMaxDistInDirection(KB kb, OccAgent agent, Vector3d dir, ValueFld distMap) {
        if (dir == null) {
            double currDist = distMap.getValue(agent.getLoc());
            double distFromDoor = Double.isNaN(currDist) ? 0.0 : currDist;
            return new DirDist(dir, distFromDoor, 0.0, agent.getPos(), agent.getPos(), false);
        }
        ConnectedMesh.Tri startTri = distMap.mesh.find(agent.getPos());
        if (startTri == null) {
            return new DirDist(dir, 0.0, 0.0, agent.getPos(), agent.getPos(), false);
        }
        Vector3d dir2d = new Vector3d(dir.x, dir.y, 0.0);
        if (Util3D.safeNormalize(dir2d, 0.0) == 0.0) {
            return new DirDist(dir, distMap.getValue(startTri, agent.getPos()), 0.0, agent.getPos(), agent.getPos(), false);
        }
        ConnectedMesh.EdgeCrossing crossing = null;
        try {
            crossing = distMap.mesh.getCrossedEdges(startTri, agent.getPos(), dir2d, Double.MAX_VALUE);
        }
        catch (ConnectedMesh.CrossedEdgesException crossedEdgesException) {
            // empty catch block
        }
        if (crossing == null) {
            double testDist = 1.0;
            Point3d p2 = Util3D.linePoint(agent.getPos(), dir, testDist);
            Tri tri = kb.getMesh().getTri(p2);
            if (tri == null) {
                return new DirDist(dir, 0.0, 0.0, agent.getPos(), agent.getPos(), false);
            }
            double dist = distMap.getValue(new TriPoint(tri, p2));
            return new DirDist(dir, dist, 0.0, agent.getPos(), agent.getPos(), false);
        }
        double maxt = Math.max(0.0, crossing.t - agent.getGeomCollisionShape(kb, false, false).getDistToFront());
        while (crossing != null && crossing.t >= maxt) {
            crossing = crossing.parent;
        }
        if (crossing == null) {
            Point3d p2 = Util.projectAlongZEq(Util3D.linePoint(agent.getPos(), dir2d, maxt), startTri.plane);
            return new DirDist(dir, distMap.getValue(startTri, p2), maxt, p2, p2, false);
        }
        Point3d maxPt = Util.projectAlongZEq(Util3D.linePoint(crossing.enterLoc, dir2d, maxt - crossing.t), crossing.enterTri.plane);
        double maxDist = distMap.getValue(crossing.enterTri, maxPt);
        double distAlongDir = maxt;
        while (crossing != null && crossing.t > 0.0) {
            double v2;
            ConnectedMesh.Vertex e1 = crossing.edge.n1;
            ConnectedMesh.Vertex e2 = crossing.edge.n2;
            double et = Util3D.tOnLineSeg(e1.p, e2.p, crossing.enterLoc);
            double v1 = distMap.vertVals.applyAsDouble(e1.id);
            double dist = theUtil.lerp(v1, v2 = distMap.vertVals.applyAsDouble(e2.id), et);
            if (dist >= maxDist) {
                distAlongDir = crossing.t;
                maxDist = dist;
                maxPt = crossing.enterLoc;
            }
            crossing = crossing.parent;
        }
        return new DirDist(dir, maxDist, distAlongDir, maxPt, maxPt, false);
    }

    private DirDist getDistAtFirstOccHit(KB kb, OccAgent agent, ANode node, ValueFld dists, DirDist dir, Predicate<OccAgent> isVisible) {
        if (dir.dir == null) {
            return new DirDist(null, Double.NaN, 0.0, agent.getPos(), agent.getPos(), false);
        }
        Vector3d dirn = dir.dir;
        dirn = Util.vector2d(agent.getPos(), dir.endPt);
        double maxDist = dirn.length();
        if (maxDist == 0.0) {
            return dir;
        }
        Util.projectAlongZEq(agent.getOcc().tri.plane, dirn);
        if (Util3D.safeNormalize(dirn, 0.0) == 0.0) {
            return dir;
        }
        maxDist = Util.projectTAlongZ(dirn, maxDist);
        TriPoint aloc = agent.getLoc();
        try {
            Mesh.EdgeCrossing crossing = agent.getCrossedEdges(kb.getMesh(), aloc, dirn, Predicates.alwaysTrue(), maxDist);
            List<Mesh.EdgeCrossing> crossings = crossing != null ? crossing.flatten() : Collections.emptyList();
            maxDist = crossing != null && crossing.type.terminal ? crossing.t : maxDist;
            Point3d[] rect = SeekPathAwayFromDoors.getCollRect(agent, dirn, maxDist);
            Set<OccAgent> group = SeekPathAwayFromDoors.getGroup(agent);
            ArrayList<OccAgent> potentialCollAgents = new ArrayList<OccAgent>();
            kb.findOccs((ITest<AABox>)new RectAABoxTest(rect), true, (oa, ctmt) -> {
                if (oa.getOcc().curNode == node && !group.contains(oa) && isVisible.test((OccAgent)oa)) {
                    potentialCollAgents.add((OccAgent)oa);
                }
            });
            double testSpeed = OccAgent.getMaxVel(kb, agent.getOcc(), 0.0, dirn);
            Vector3d testVel = Util3D.scale(dirn, testSpeed);
            IAgentBodyShape shape = agent.getShape().orientTo(dirn);
            Pair<OccAgent, Double> hit = agent.getOccCollision(kb, maxDist / testSpeed, OccAgent::getShape, OccAgent::getVel, a -> a.getVel().length(), tp -> shape.moveTo((Point3d)tp), testVel, agent.getPos(), crossings, potentialCollAgents, isVisible, false, OccAgent.COLLIDE_ONLY_IF_VISIBLE);
            if (hit.v1 != null) {
                double dist = (Double)hit.v2 * testSpeed;
                TriPoint dest = Mesh.EdgeCrossing.find(aloc, dirn, crossing, dist);
                boolean hitOccSeeking = !((OccAgent)hit.v1).isWaiting(kb);
                Point3d endPt = agent.getCollisionFactor() == 0.0 ? dest.p : dir.endPt;
                return new DirDist(dirn, dists.getValue(dest), dist, dest.p, endPt, hitOccSeeking);
            }
        }
        catch (Mesh.CrossedEdgesException crossedEdgesException) {
            // empty catch block
        }
        return new DirDist(dirn, dir.distFromDoors, maxDist, dir.endPt, dir.endPt, false);
    }

    private static Point3d[] getCollRect(OccAgent agent, Vector3d dir, double maxt) {
        Point3d p = agent.getPos();
        dir = new Vector3d(dir.x, dir.y, 0.0);
        Util3D.safeNormalize(dir, 0.0);
        Vector3d ldir = new Vector3d(-dir.y, dir.x, p.z);
        double radius = agent.getShape().getEnclosingRadius();
        ldir.scale(radius);
        dir.scale(radius);
        Point3d p1 = new Point3d(p.x + ldir.x - dir.x, p.y + ldir.y - dir.y, p.z);
        Point3d p2 = new Point3d(p.x - ldir.x - dir.x, p.y - ldir.y - dir.y, p.z);
        dir.scale((maxt + radius) / radius);
        Point3d p3 = new Point3d(p.x - ldir.x + dir.x, p.y - ldir.y + dir.y, p.z);
        Point3d p4 = new Point3d(p.x + ldir.x + dir.x, p.y + ldir.y + dir.y, p.z);
        return new Point3d[]{p1, p2, p3, p4};
    }

    private static class DirDist
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Vector3d dir;
        public final double distFromDoors;
        public final double distAlongDir2d;
        public final Point3d hitPt;
        public final Point3d endPt;
        public final boolean hitSeekingOccs;

        public DirDist(Vector3d dir, double distFromDoors, double distAlongDir2d, Point3d hitPt, Point3d endPt, boolean hitSeekingOccs) {
            this.dir = dir;
            this.distFromDoors = distFromDoors;
            this.distAlongDir2d = distAlongDir2d;
            this.hitPt = hitPt;
            this.endPt = endPt;
            this.hitSeekingOccs = hitSeekingOccs;
        }

        public String toString() {
            return String.format("%s: distFromDoors=%g distAlongDir=%g hitSeekingOccs=%s", this.dir, this.distFromDoors, this.distAlongDir2d, Boolean.toString(this.hitSeekingOccs));
        }
    }

    private static class RectAABoxTest
    implements ITest<AABox> {
        public final Point3d[] rect;
        private final Point3d[] d_bbPoints = new Point3d[]{new Point3d(), new Point3d(), new Point3d(), new Point3d()};

        public RectAABoxTest(Point3d[] rect) {
            this.rect = rect;
        }

        @Override
        public Containment test(AABox bounds) {
            bounds.mmm(this.d_bbPoints[0]);
            bounds.Mmm(this.d_bbPoints[1]);
            bounds.MMm(this.d_bbPoints[2]);
            bounds.mMm(this.d_bbPoints[3]);
            return Inter.testRectRect2d(this.rect, this.d_bbPoints, 1.0E-6) ? Containment.INTERSECTS : Containment.OUTSIDE;
        }
    }
}

