/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.inverse.ASeek;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.WanderRoom;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Spline3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class Seek
extends ASeek {
    static final long serialVersionUID = 1L;
    private static final boolean SEEKSPEED_CURVATURE = false;
    private final PathFollow d_pathFollow;
    private WanderRoom d_currRoomWander;

    public Seek(KB kb, OccAgent agent, IPathPlanner pathPlanner, double arrivalRadius, Vector3d idleOrient) {
        this(kb, agent, arrivalRadius, new PathFollow(kb, agent, pathPlanner), idleOrient);
    }

    public Seek(KB kb, OccAgent agent, double arrivalRadius, PathFollow pathFollow, Vector3d idleOrient) {
        super(kb, agent, arrivalRadius, idleOrient);
        this.d_pathFollow = pathFollow;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
        this.d_pathFollow.getPathPlanner().doorCrossed(t, agent, queue);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return this.d_pathFollow;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return Double.MAX_VALUE;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        this.d_pathFollow.planPath(kb, agent);
        if (this.d_pathFollow.getSeek().isVirtual(agent.getOcc().curNode)) {
            WanderRoom wanderRoom = this.getCurrentRoomWander(kb, agent);
            SeekCurve curve = wanderRoom.generateSeekCurve(kb, agent);
            return new SeekCurve(curve.curve, curve.wallSlider, curve.transientPathFilter, false);
        }
        return InvSteerUtil.generateSeekCurve(kb, agent, this.d_pathFollow);
    }

    public WanderRoom getCurrentRoomWander(KB kb, OccAgent agent) {
        if (this.d_currRoomWander == null || !this.d_currRoomWander.getRooms().contains(agent.getOcc().curNode)) {
            this.d_currRoomWander = new WanderRoom(kb, agent, Collections.singleton(agent.getOcc().curNode), false);
        }
        return this.d_currRoomWander;
    }

    @Override
    protected double calcSeekSpeed(KB kb, OccInfo oi, IParametric3D seekCurve) {
        return super.calcSeekSpeed(kb, oi, seekCurve);
    }

    private double calcSeekSpeedCurvature(KB kb, OccInfo oi, IParametric3D seekCurve) {
        OccAgent agent = oi.oa;
        Vector3d currVel = new Vector3d(agent.getVel());
        currVel.z = 0.0;
        Vector3d seekDir = seekCurve.getTangent(0.0);
        seekDir.z = 0.0;
        Util.safeNormalize(seekDir, 1.0E-9);
        double minSpeed = oi.cache.maxVel;
        double accel = agent.getMaxStartAccel(kb);
        double currSpeed = oi.cache.currVel;
        double distCritical = OccAgent.calcStopDist(currSpeed, accel);
        ArrayList<Point3d> seekPoints = new ArrayList<Point3d>();
        this.d_pathFollow.getSeekPoints(kb, agent.getPos(), distCritical, true, true, seekPoints);
        assert (!seekPoints.isEmpty());
        if (seekCurve.isLinear()) {
            double minPathSpeed = Seek.getMinVel(kb, oi, accel, currSpeed, agent.getPos(), 0.0, seekPoints);
            if (minPathSpeed < minSpeed) {
                minSpeed = minPathSpeed;
            }
        } else {
            double segMinSpeed;
            double curveMinSpeed = Seek.getMinVel(kb, oi, accel, currSpeed, seekCurve);
            double minPathSpeed = Math.min(curveMinSpeed, segMinSpeed = Seek.getMinVel(kb, oi, accel, currSpeed, (Point3d)seekPoints.get(0), agent.getPos().distance((Point3d)seekPoints.get(0)), seekPoints.subList(1, seekPoints.size())));
            if (minPathSpeed < minSpeed) {
                minSpeed = minPathSpeed;
            }
        }
        return minSpeed;
    }

    private static double getMinVel(KB kb, OccInfo oi, double accel, double currSpeed, IParametric3D curve) {
        OccAgent agent = oi.oa;
        if (curve instanceof Spline3D.Quadratic) {
            Spline3D.Quadratic quad = (Spline3D.Quadratic)curve;
            Vector3d currDir = new Vector3d(oi.oa.getVel());
            currDir.z = 0.0;
            Util.safeNormalize(currDir, 1.0E-9);
            currDir.scale(0.01);
            Point3d c = Util3D.add(agent.getPos(), (Tuple3d)currDir);
            curve = Util.newCurve(agent.getPos(), c, quad.getC2(), quad.getP2());
        }
        int numSamplePoints = 15;
        ArrayList<Point3d> pointsList = new ArrayList<Point3d>(15);
        for (int m = 0; m < 15; ++m) {
            double t = (double)(m + 1) / 15.0;
            pointsList.add(curve.get(t));
        }
        return Seek.getMinVel(kb, oi, accel, currSpeed, agent.getPos(), 0.0, pointsList);
    }

    private static Shape toShape(IParametric3D curve) {
        if (curve instanceof Spline3D.Quadratic) {
            Spline3D.Quadratic quad = (Spline3D.Quadratic)curve;
            return new QuadCurve2D.Double(quad.getP1().x, quad.getP1().y, quad.getC1().x, quad.getC1().y, quad.getP2().x, quad.getP2().y);
        }
        if (curve instanceof Spline3D.Cubic) {
            Spline3D.Cubic cubic = (Spline3D.Cubic)curve;
            return new CubicCurve2D.Double(cubic.getP1().x, cubic.getP1().y, cubic.getC1().x, cubic.getC1().y, cubic.getC2().x, cubic.getC2().y, cubic.getP2().x, cubic.getP2().y);
        }
        Point3d p1 = curve.get(0.0);
        Point3d p2 = curve.get(1.0);
        return new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
    }

    private static double getMinVel(KB kb, OccInfo oi, double accel, double currSpeed, Point3d prevPt, double prevPtDist, List<Point3d> seekPoints) {
        OccAgent agent = oi.oa;
        double agentRadius = agent.getOccupantRadius();
        double minSpeed = oi.cache.maxVel;
        double prevLen = 0.0;
        Vector3d prevDir = new Vector3d();
        Vector3d nextDir = new Vector3d();
        Vector3d bisect = new Vector3d();
        double distTravelled = prevPtDist;
        for (int m = 0; m < seekPoints.size() - 1; ++m) {
            Point3d nextPt;
            double nextLen;
            Point3d currPt = seekPoints.get(m);
            if (prevLen == 0.0) {
                double pLen = Seek.vectorN(currPt, prevPt, prevDir);
                if (theUtil.eq0(pLen, 1.0E-6)) continue;
                prevLen = pLen;
            }
            if (theUtil.eq0(nextLen = Seek.vectorN(currPt, nextPt = seekPoints.get(m + 1), nextDir), 1.0E-6)) continue;
            distTravelled += prevLen;
            bisect.add(nextDir, prevDir);
            double dot = nextDir.dot(bisect);
            if (theUtil.gt0(dot, 1.0E-6)) {
                double maxSpeedToReachCurve;
                double bisectLen;
                double curveDist = Math.min(agentRadius, nextLen * 0.5);
                double r = (curveDist = Math.min(curveDist, prevLen * 0.5)) * (bisectLen = bisect.length()) / dot;
                double curveSpeed = Math.sqrt(accel * r);
                if (curveSpeed <= oi.cache.maxVel && (maxSpeedToReachCurve = InvSteerUtil.getMaxVel(kb, oi, currSpeed, curveSpeed, distTravelled)) < minSpeed) {
                    minSpeed = maxSpeedToReachCurve;
                }
            }
            prevPt = currPt;
            prevLen = nextLen;
            prevDir.negate(nextDir);
        }
        return minSpeed;
    }

    private static double vectorN(Point3d p1, Point3d p2, Vector3d outDir) {
        outDir.sub(p2, p1);
        return Util.safeNormalize(outDir, 1.0E-9);
    }

    @Override
    protected double getDistanceToDest(KB kb, OccAgent agent, IParametric3D seekCurve) {
        return this.d_pathFollow.getRemainingDistance(agent, true);
    }
}

