/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.ANode;
import inferno.data2.ai.RoomGoal;
import inferno.geom.SeekCurve;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import thunderheadeng.util.theUtil;

public class ElevatorSteeringBehavior
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;
    private RoomGoal.Instance d_roomGoalInst;
    private ISteeringBehavior d_steering;
    private ElevatorRoomIterator d_roomIterator;
    private boolean d_needsReset = false;
    private KB d_kb;

    public ElevatorSteeringBehavior(List<ANode> rooms, KB kb) {
        this.d_kb = kb;
        this.d_roomIterator = new ElevatorRoomIterator(rooms);
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
        if (this.d_steering != null) {
            this.d_steering.done(kb, occ, interrupted);
        }
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_steering.doorCrossed(t, agent, door);
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        this.tryInitSteering(kb, agent);
        while (true) {
            try {
                return this.d_steering.generateSeekCurve(kb, agent);
            }
            catch (LostException e) {
                if (this.initSteering(kb, agent)) continue;
                this.d_needsReset = true;
                SeekCurve curve = this.d_steering.generateSeekCurve(kb, agent);
                return curve;
            }
            break;
        }
    }

    private void reset(OccAgent occ) {
        if (this.d_steering != null) {
            this.d_steering.done(this.d_kb, occ, false);
        }
        this.d_steering = null;
        this.d_roomGoalInst = null;
        this.d_roomIterator.index = 0;
        this.d_needsReset = false;
    }

    private void tryInitSteering(KB kb, OccAgent agent) {
        if (this.d_needsReset) {
            this.reset(agent);
        }
        if (this.d_steering == null) {
            this.initSteering(kb, agent);
        }
    }

    private boolean initSteering(KB kb, OccAgent agent) {
        if (this.d_roomIterator.hasNext()) {
            RoomGoal roomGoal = new RoomGoal(this.d_roomIterator.nextRooms());
            this.d_roomGoalInst = roomGoal.begin(kb, agent);
            if (this.d_steering != null) {
                this.d_steering.done(kb, agent, false);
            }
            this.d_steering = this.d_roomGoalInst.generateSteeringBehavior(kb, agent);
            return true;
        }
        return false;
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        this.tryInitSteering(this.d_kb, agent);
        if (this.d_steering == null) {
            return null;
        }
        return this.d_steering.getPathFollow(agent);
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek, Predicate<OccAgent> agentFilter) {
        return this.d_steering.steer(world, agent, seek, agentFilter);
    }

    public RoomGoal.Instance getCurrentRoomGoal() {
        return this.d_roomGoalInst;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return this.d_steering.getTimeLimit(kb, agent);
    }

    private class ElevatorRoomIterator
    implements Iterator<ANode>,
    Serializable {
        static final long serialVersionUID = 1L;
        private List<ANode> rooms;
        private int index;

        public ElevatorRoomIterator(List<ANode> rooms) {
            this.rooms = rooms;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.rooms.size();
        }

        @Override
        public ANode next() {
            ANode ret = this.rooms.get(this.index);
            ++this.index;
            return ret;
        }

        public List<ANode> nextRooms() {
            ArrayList<ANode> ret = new ArrayList<ANode>();
            ANode curr = this.next();
            ret.add(curr);
            while (this.index < this.rooms.size() && theUtil.eq(curr.getGeometryBounds().getCenter().z, this.rooms.get((int)this.index).getGeometryBounds().getCenter().z, 0.001)) {
                curr = this.next();
                ret.add(curr);
            }
            return ret;
        }
    }
}

