/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.AvoidOccs;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class CornerBehavior {
    public static final int FILTERID = -1348979970;
    private static final double PREDICT_DISTANCE = 1.5;
    private static final double SIZE_MULTIPLIER = 1.5;
    private static final double WIDE_ANGLE_LIMIT = 1.0471975511965976;
    private static final double OVERSHOOT_ANGLE_LIMIT = 1.5707963267948966;
    private final List<Pair<OccAgent, Point3d>> d_nearOccPredictPositions = new ArrayList<Pair<OccAgent, Point3d>>();
    private Senses senses;
    private KB kb;
    private Vector3d flowDirection;

    public CornerBehavior(KB kb, OccInfo oi, SeekInfo seekInfo, Senses senses) {
        this.kb = kb;
        this.senses = senses;
        this.findFlowDirection(oi);
    }

    private void findFlowDirection(OccInfo oi) {
        Collection<OccAgent> nearOccs = this.senses.getNearOccs(-1348979970, oi);
        Vector3d flowDirection = new Vector3d();
        nearOccs.forEach(o -> {
            Vector3d occDir = new Vector3d();
            occDir.sub(o.getPos(), occInfo.oa.getPos());
            if (theUtil.ge0(Util.dot2d(occInfo.oa.getDirFacing(), occDir), 1.0E-6)) {
                flowDirection.add(o.getDirFacing());
            }
        });
        this.flowDirection = flowDirection;
    }

    public double[] getCost(Vector3d dir, OccInfo oi, SeekInfo seekInfo, boolean enableSeparation, double sepDist, Vector3d prefferedDir) {
        double maxVel;
        ArrayList<Pair<OccAgent, Double>> occHits = new ArrayList<Pair<OccAgent, Double>>(2);
        this.senses.senseNearestOccHits(this.kb, -1348979970, oi, dir, occHits, null, 1.5 * oi.shapeAgents.getEnclosingRadius(), 1.5);
        double angle = Inter.angleAbs(prefferedDir, dir);
        double overshootAngle = Inter.angleAbs(this.flowDirection, dir);
        this.filterNaN(occHits);
        if (occHits.isEmpty()) {
            if (theUtil.gt(angle, 1.0471975511965976, 1.0E-6) && theUtil.gt(overshootAngle, 1.5707963267948966, 1.0E-6)) {
                return new double[]{1.0, oi.cache.maxVel};
            }
            return new double[]{0.0, oi.cache.maxVel};
        }
        Pair firstHit = (Pair)occHits.get(0);
        double firstHitDist = AvoidOccs.getHitDist(this.kb, oi, dir, (OccAgent)firstHit.v1, (Double)firstHit.v2);
        double[] firstCost = AvoidOccs.getCost(this.kb, oi, seekInfo, (OccAgent)firstHit.v1, firstHitDist, enableSeparation, sepDist, maxVel = OccAgent.getMaxVel(this.kb, oi.oa.getOcc(), 0.0, dir));
        double[] ret = new double[]{firstCost[0], oi.cache.maxVel};
        if (Double.isNaN(ret[0])) {
            ret[0] = 0.0;
        }
        return ret;
    }

    private double[] compareToFlowDirection(Vector3d dir, OccInfo oi) {
        if (dir == null) {
            return new double[]{10.0, oi.cache.maxVel};
        }
        double angle = Inter.angleAbs(this.flowDirection, dir);
        return new double[]{2.0 * angle, oi.cache.maxVel};
    }

    private void filterNaN(List<Pair<OccAgent, Double>> occHits) {
        Iterator<Pair<OccAgent, Double>> iterator = occHits.iterator();
        while (iterator.hasNext()) {
            Pair<OccAgent, Double> occHit = iterator.next();
            if (!Double.isNaN((Double)occHit.v2)) continue;
            iterator.remove();
        }
    }
}

