/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.geodesics;

import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.Engine;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.steering.geodesics.GeodesicsJNI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theTimer;

public class GeodesicPlanner {
    public static final boolean isON = false;
    private Mesh mesh;
    private double[] points;
    private int[] faces;
    private int[] forcedBoundaryEdges;
    private Point3d[] debugPath;
    private static final boolean DEBUG_PRINT = true;

    public GeodesicPlanner(Mesh mesh) {
        this.mesh = mesh;
        if (!GeodesicsJNI.isMeshCreated()) {
            this.init();
        }
    }

    public Point3d[] getDebugPath() {
        return this.debugPath;
    }

    public void init() {
        this.createFacesAndPoints();
        GeodesicsJNI.createMesh(this.points, this.faces, this.forcedBoundaryEdges);
    }

    private void createFacesAndPoints() {
        int id;
        int i;
        Vertex[] verts = this.mesh.getVerts();
        Tri[] tris = this.mesh.getTris();
        WingedEdge[] boundaryEdges = this.mesh.getBoundaryEdges();
        this.points = new double[3 * (verts.length + 1)];
        this.faces = new int[3 * tris.length];
        this.forcedBoundaryEdges = new int[2 * boundaryEdges.length];
        for (i = 0; i < verts.length; ++i) {
            id = verts[i].id;
            this.points[3 * id] = verts[i].p.x;
            this.points[3 * id + 1] = verts[i].p.y;
            this.points[3 * id + 2] = verts[i].p.z;
        }
        for (i = 0; i < tris.length; ++i) {
            id = tris[i].id;
            this.faces[3 * id] = tris[i].v[0].id;
            this.faces[3 * id + 1] = tris[i].v[1].id;
            this.faces[3 * id + 2] = tris[i].v[2].id;
        }
        for (i = 0; i < boundaryEdges.length; ++i) {
            this.forcedBoundaryEdges[2 * i] = boundaryEdges[i].v1().id;
            this.forcedBoundaryEdges[2 * i + 1] = boundaryEdges[i].v2().id;
        }
    }

    private List<TriPoint> findPath(Point3d start, int startTriId, Point3d target, int targetTriId) {
        Engine.TIME_ACCUM.begin("GEO_JNI");
        Point3d[] path = GeodesicsJNI.findPath(start, startTriId, target, targetTriId);
        Engine.TIME_ACCUM.end("GEO_JNI");
        this.debugPath = path;
        Engine.TIME_ACCUM.begin("GEO_JAVA");
        theTimer timer = new theTimer();
        ArrayList<TriPoint> pointsList = new ArrayList<TriPoint>();
        TriConsumer<Tri, Point3d, WingedEdge> addPoint = (tri, p, edge) -> {
            if (edge != null && edge.isBoundary()) {
                edge = null;
            } else if (!pointsList.isEmpty() && ((TriPoint)pointsList.get(pointsList.size() - 1)).getEdge() == edge) {
                return;
            }
            pointsList.add(new TriPoint((Tri)tri, (Point3d)p, (WingedEdge)edge));
        };
        for (int i = path.length - 2; i >= 0; --i) {
            Tri lastTri;
            Point3d p0 = path[i + 1];
            Point3d p1 = path[i];
            WingedEdge sharedEdge = null;
            if (p0.epsilonEquals(p1, 1.0E-4)) continue;
            Tri sharedTri = this.getSharedTri(p0, p1);
            if (sharedTri == null) {
                System.out.println("Warning: possible unconnected triangle");
                continue;
            }
            if (!pointsList.isEmpty() && (sharedEdge = this.trianglesConnected(lastTri = ((TriPoint)pointsList.get((int)(pointsList.size() - 1))).tri, sharedTri)) == null) {
                ArrayList<Tri> triSubPath = this.getTriPath(lastTri, sharedTri);
                for (Tri t : triSubPath) {
                    pointsList.add(new TriPoint(t, p0));
                    ArrayList<TriEdge> adjEdges = this.getAdjacentEdges(t, p0);
                    for (TriEdge e : adjEdges) {
                        addPoint.accept(e.tri, p0, e.edge);
                    }
                }
            }
            if (!this.isVertex(p0)) {
                WingedEdge e0 = this.getEdge(p0);
                if (e0 == null) continue;
                addPoint.accept(sharedTri, p0, e0);
                continue;
            }
            if (sharedEdge == null) continue;
            addPoint.accept(sharedTri, p0, sharedEdge);
        }
        Tri lastTri = this.mesh.getTri(path[0]);
        WingedEdge lastEdge = this.getEdge(path[0]);
        addPoint.accept(lastTri, path[0], lastEdge);
        System.out.format("Geodesic Java: %g s%n", timer.curr());
        Engine.TIME_ACCUM.end("GEO_JAVA");
        return pointsList;
    }

    private ArrayList<TriEdge> getAdjacentEdges(Tri t, Point3d p) {
        WingedEdgeUse[] weu;
        ArrayList<TriEdge> ret = new ArrayList<TriEdge>();
        for (WingedEdgeUse eu : weu = t.eu) {
            WingedEdge w = eu.wedge;
            if (!this.isPointOnEdge(p, w)) continue;
            ret.add(new TriEdge(t, w));
        }
        return ret;
    }

    private WingedEdge trianglesConnected(Tri tri1, Tri tri2) {
        if (tri1 == null || tri2 == null) {
            return null;
        }
        WingedEdgeUse[] weu1 = tri1.eu;
        WingedEdgeUse[] weu2 = tri2.eu;
        for (WingedEdgeUse eu1 : weu1) {
            WingedEdge e1 = eu1.wedge;
            for (WingedEdgeUse eu2 : weu2) {
                WingedEdge e2 = eu2.wedge;
                if (e1.id != e2.id) continue;
                return e1;
            }
        }
        return null;
    }

    private boolean trianglesConnected2(Tri tri1, Tri tri2) {
        Vertex[] v1s = tri1.v;
        Vertex[] v2s = tri2.v;
        int sameCount = 0;
        for (Vertex v1 : v1s) {
            for (Vertex v2 : v2s) {
                if (v1.id != v2.id || ++sameCount != 2) continue;
                return true;
            }
        }
        return false;
    }

    private Tri getSharedTri(Point3d p0, Point3d p1) {
        List<Tri> tris0 = this.mesh.getTris(p0, 1.0E-6);
        List<Tri> tris1 = this.mesh.getTris(p1, 1.0E-6);
        for (Tri t : tris0) {
            if (!tris1.contains(t)) continue;
            return t;
        }
        System.out.println("Error: no shared tri: " + p0 + ", " + p1);
        return null;
    }

    private boolean isVertex(Point3d p) {
        for (Vertex v : this.mesh.getVerts()) {
            if (!v.p.equals(p)) continue;
            return true;
        }
        return false;
    }

    private WingedEdge getEdge(Point3d p) {
        List<Tri> tris0 = this.mesh.getTris(p, 1.0E-6);
        for (Tri t : tris0) {
            ArrayList<TriEdge> adj = this.getAdjacentEdges(t, p);
            if (adj.isEmpty()) continue;
            return adj.get((int)0).edge;
        }
        return null;
    }

    private boolean isPointOnEdge(Point3d p, WingedEdge w) {
        Point3d p1 = w.v1().p;
        Point3d p2 = w.v2().p;
        return p1.distance(p) + p.distance(p2) - p1.distance(p2) < 1.0E-10;
    }

    public PathGen.IPathResult getPath(Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter) {
        Pair<PathGen.GoalDest, TriPoint> target = goal.project(this.mesh.getShortenedEdges(radius), startPt);
        List<TriPoint> path = this.findPath(startPt, startTri.id, ((TriPoint)target.v2).p, ((TriPoint)target.v2).tri.id);
        if (path == null) {
            return new PathGen.PathFailure(1);
        }
        return new PathGen.PathSuccess(path, (PathGen.GoalDest)target.v1);
    }

    public static boolean edgesGoThroughtVertex(WingedEdge edge, WingedEdge edge2) {
        return edge.v1().id == edge2.v1().id || edge.v1().id == edge2.v2().id || edge.v2().id == edge2.v1().id || edge.v2().id == edge2.v2().id;
    }

    private ArrayList<Tri> getTriPath(Tri start, Tri target) {
        Tri currentTri;
        ArrayList<Tri> path = new ArrayList<Tri>();
        LinkedList<Tri> queue = new LinkedList<Tri>();
        HashSet<Tri> closed = new HashSet<Tri>();
        HashMap<Tri, Tri> parents = new HashMap<Tri, Tri>();
        queue.add(start);
        closed.add(start);
        boolean found = false;
        block0: while (!queue.isEmpty() && !found) {
            WingedEdgeUse[] eu;
            currentTri = (Tri)queue.poll();
            block1: for (WingedEdgeUse weu : eu = currentTri.eu) {
                Tri[] tris;
                if (found) continue block0;
                WingedEdge e = weu.wedge;
                for (Tri t : tris = e.getAdjTris()) {
                    if (t == null) continue;
                    if (t.id == target.id) {
                        found = true;
                        parents.put(target, currentTri);
                        continue block1;
                    }
                    if (t.id == currentTri.id || closed.contains(t)) continue;
                    queue.add(t);
                    closed.add(t);
                    parents.put(t, currentTri);
                }
            }
        }
        currentTri = target;
        path.add(0, target);
        boolean pathExtracted = false;
        while (!pathExtracted && (currentTri = (Tri)parents.get(currentTri)) != null) {
            path.add(0, currentTri);
            if (currentTri.id != start.id) continue;
            pathExtracted = true;
            break;
        }
        return path;
    }
}

