/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.SocialDistanceTransientWriter;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.UnorderedPair;

public class SocialDistanceAccumulatedWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private static final double UPDATE_INTERVAL = 0.5;
    private final KB d_kb;
    private final double d_detectionRadius;
    private final ConcurrentMap<OccAgent, Map<OccAgent, Double>> d_data;
    private final SerializedOutputStream d_strmOut;
    private final CSVWriter d_out;
    private final ConcurrentMap<OccAgent, Double> d_lastUpdate;

    public SocialDistanceAccumulatedWriter(KB kb, double detectionRadius) {
        this.d_kb = kb;
        this.d_detectionRadius = detectionRadius;
        this.d_data = new ConcurrentHashMap<OccAgent, Map<OccAgent, Double>>();
        this.d_lastUpdate = new ConcurrentHashMap<OccAgent, Double>();
        this.d_strmOut = new SerializedOutputStream(kb.getParams().out_sd_accumulated);
        this.d_out = new CSVWriter();
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_strmOut));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader() {
        for (Header header : Header.values()) {
            this.d_out.add(header.get());
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    private Pair<Integer, String> filterToTime(Map<OccAgent, Double> agentSdMap, double minTime) {
        Map<OccAgent, Double> overTime = agentSdMap.entrySet().stream().filter(entry -> (Double)entry.getValue() >= minTime).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List overTimeIds = overTime.keySet().stream().map(agent -> Integer.toString(agent.getOcc().getId())).collect(Collectors.toList());
        String ids = String.join((CharSequence)" ", overTimeIds);
        return new Pair<Integer, String>(overTime.size(), ids);
    }

    public void writeOuptut() {
        ArrayList sortedAgents = new ArrayList(this.d_data.keySet());
        Collections.sort(sortedAgents, (k1, k2) -> Integer.compare(k1.getId(), k2.getId()));
        for (OccAgent agent : sortedAgents) {
            this.d_out.add(agent.getOcc().getId());
            this.d_out.add(agent.getOcc().name);
            if (agent.getOcc().occupantGroup != null) {
                this.d_out.add(agent.getOcc().occupantGroup.getID());
            } else {
                this.d_out.addEmpty();
            }
            this.d_out.add(this.d_detectionRadius, 2);
            Map agentSdMap = (Map)this.d_data.get(agent);
            if (agentSdMap != null && !agentSdMap.isEmpty()) {
                ArrayList contacts = new ArrayList(agentSdMap.keySet());
                contacts.sort((o1, o2) -> -Double.compare((Double)agentSdMap.get(o1), (Double)agentSdMap.get(o2)));
                OccAgent longest = (OccAgent)contacts.get(0);
                this.d_out.add(longest.getId());
                this.d_out.add(longest.getName());
                this.d_out.add((Double)agentSdMap.get(longest), 2);
                Pair<Integer, String> over60 = this.filterToTime(agentSdMap, 60.0);
                this.d_out.add(over60.v1);
                this.d_out.add(over60.v2);
                Pair<Integer, String> over300 = this.filterToTime(agentSdMap, 300.0);
                this.d_out.add(over300.v1);
                this.d_out.add(over300.v2);
            } else {
                this.d_out.addEmpty();
                this.d_out.addEmpty();
                this.d_out.addEmpty();
                this.d_out.add(0);
                this.d_out.addEmpty();
                this.d_out.add(0);
                this.d_out.addEmpty();
            }
            this.d_out.nextRow();
        }
        this.d_out.flush();
    }

    public void update(boolean forceUpdateAll) {
        ConcurrentHashMap distMap = new ConcurrentHashMap(this.d_kb.getActiveAgents().size(), 0.75f, Runtime.getRuntime().availableProcessors());
        this.d_kb.getActiveAgents().parallelStream().forEach(agent -> {
            if (!this.d_data.containsKey(agent)) {
                this.d_data.put((OccAgent)agent, new HashMap());
                this.d_lastUpdate.put((OccAgent)agent, this.d_kb.getCurrentSimTime());
                return;
            }
            double dt = this.d_kb.getCurrentSimTime() - (Double)this.d_lastUpdate.get(agent);
            if (dt < 0.5 & !forceUpdateAll) {
                return;
            }
            List<OccAgent> nearOccs = this.d_kb.findOccs((ITest<AABox>)new BoundingSphere(agent.getPos(), this.d_detectionRadius), OccLocator.exclude(agent, Filters.acceptAll()), true);
            Mesh m = this.d_kb.getMesh();
            for (OccAgent nearOcc : nearOccs) {
                double distance = distMap.computeIfAbsent(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearOcc), upair -> SocialDistanceTransientWriter.getSocialDistance(m, (OccAgent)upair.v1, (OccAgent)upair.v2, this.d_detectionRadius));
                if (!Double.isFinite(distance) || !(distance <= this.d_detectionRadius)) continue;
                Map agentSdMap = (Map)this.d_data.get(agent);
                Double prevDt = (Double)agentSdMap.get(nearOcc);
                if (prevDt == null) {
                    prevDt = 0.0;
                }
                agentSdMap.put(nearOcc, prevDt + dt);
            }
            this.d_lastUpdate.put((OccAgent)agent, this.d_kb.getCurrentSimTime());
        });
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        ID(WriterIntl.intl("ID")),
        NAME(WriterIntl.intl("Name")),
        GROUP_ID(WriterIntl.intl("Group ID")),
        SD(WriterIntl.intl("SD (m)")),
        LONGEST_ID(WriterIntl.intl("Longest Occupant ID")),
        LONGEST_Name(WriterIntl.intl("Longest Occupant Name")),
        LONGEST_TIME(WriterIntl.intl("Longest Occupant Time (s)")),
        OVER_60(WriterIntl.intl("Occupants > 60s (count)")),
        OVER_60_ID(WriterIntl.intl("Occupants > 60s IDs")),
        OVER_300(WriterIntl.intl("Occupants > 300s (count)")),
        OVER_300_ID(WriterIntl.intl("Occupants > 300s IDs"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

