/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.ANode;
import inferno.data2.ElevatorLevel;
import inferno.data2.IElevator;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import thunderheadeng.util.IdentityHashSet;

public class RoomUsageWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private final List<IUsageElement> d_sortedNodes;
    private int d_initialOccupants;
    private KB d_kb;
    private final SerializedOutputStream d_roomUsageStream;
    private CSVWriter d_out;

    public RoomUsageWriter(KB kb) {
        this.d_kb = kb;
        ArrayList<IUsageElement> nodes = new ArrayList<IUsageElement>(kb.getNodes().size());
        IdentityHashSet<ANode> excludeNodes = new IdentityHashSet<ANode>(kb.getDoorNodes());
        excludeNodes.addAll(kb.getElevatorModel().getAllElevatorRooms());
        for (ANode node : kb.getNodes()) {
            if (excludeNodes.contains(node)) continue;
            nodes.add(new NodeUsage(node));
        }
        List<IElevator> elevators = kb.getElevatorModel().getElevators();
        for (IElevator elevator : elevators) {
            ANode dischargeNode = elevator.getTargetNode();
            ArrayList<ANode> elevatorNodes = new ArrayList<ANode>(elevator.getLevels().size());
            for (ElevatorLevel level : elevator.getLevels()) {
                elevatorNodes.add(level.pickupNode);
            }
            CompositeNodeUsage usage = new CompositeNodeUsage(dischargeNode, elevatorNodes);
            nodes.add(usage);
        }
        Collections.sort(nodes, new Comparator<IUsageElement>(){

            @Override
            public int compare(IUsageElement o1, IUsageElement o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.d_sortedNodes = nodes;
        this.d_initialOccupants = kb.getAgents().size();
        this.d_roomUsageStream = new SerializedOutputStream(kb.getParams().out_room_usage);
        this.d_out = new CSVWriter();
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_roomUsageStream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader() {
        Consumer<Object> headers = header -> this.d_out.add(header);
        headers.accept(Header.TIME);
        headers.accept(Header.REMAINING_TOTAL);
        headers.accept(Header.EXITED_TOTAL);
        for (IUsageElement n : this.d_sortedNodes) {
            String name = n.getName();
            headers.accept(name);
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void writeFrame(double t) {
        int exitCount = 0;
        for (IUsageElement n : this.d_sortedNodes) {
            exitCount += n.getExitedVia();
        }
        this.d_out.add(t, 2);
        this.d_out.add(this.d_kb.getAllAgentsEver().size() - exitCount);
        this.d_out.add(exitCount);
        for (IUsageElement n : this.d_sortedNodes) {
            this.d_out.add(n.getNumOccupants());
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    private static class CompositeNodeUsage
    implements IUsageElement,
    Serializable {
        static final long serialVersionUID = 1L;
        public ANode primary;
        public List<ANode> nodes;

        public CompositeNodeUsage(ANode primary, Collection<ANode> nodes) {
            this.primary = primary;
            this.nodes = new ArrayList<ANode>(nodes);
        }

        @Override
        public String getName() {
            return this.nodes.get((int)0).name;
        }

        @Override
        public int getNumOccupants() {
            int count = 0;
            for (ANode node : this.nodes) {
                count += node.getNumOccupants();
            }
            return count;
        }

        @Override
        public int getExitedVia() {
            return this.primary.getExitedVia();
        }
    }

    private static class NodeUsage
    implements IUsageElement,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ANode node;

        public NodeUsage(ANode node) {
            this.node = node;
        }

        @Override
        public String getName() {
            return this.node.name;
        }

        @Override
        public int getNumOccupants() {
            return this.node.getNumOccupants();
        }

        @Override
        public int getExitedVia() {
            return this.node.getExitedVia();
        }
    }

    private static interface IUsageElement {
        public String getName();

        public int getNumOccupants();

        public int getExitedVia();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        TIME(WriterIntl.intl("time(s)")),
        REMAINING_TOTAL(WriterIntl.intl("Remaining (Total)")),
        EXITED_TOTAL(WriterIntl.intl("Exited (Total)"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

