/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.PredefTag;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccStats;
import inferno.sim.Output;
import inferno.sim.Param;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class OccDataCumulativeWriter {
    public static CSVWriter open(Param p) throws FileNotFoundException {
        CSVWriter out = new CSVWriter();
        out.open(Output.openTxtStream(new SerializedOutputStream(p.out_occ_cumulative)));
        return out;
    }

    public static void close(CSVWriter out) {
        out.close();
    }

    public static void write(CSVWriter out, KB kb, OccStats stats) {
        ArrayList<TagSummary> tagSummaries = new ArrayList<TagSummary>();
        for (Tag tag : kb.getTags()) {
            if (tag.predefined) continue;
            boolean everTagged = tag.getAnyWereEverTagged();
            boolean everUntagged = tag.getAnyWereEverUntagged();
            if (!everTagged && !everUntagged) continue;
            tagSummaries.add(new TagSummary(tag, everTagged, everUntagged));
        }
        Tag exitTag = kb.getPredefTag(PredefTag.EXITED);
        out.add("id");
        out.add("name");
        out.add("exit time(s)");
        out.add("active time(s)");
        out.add("jam time total(s)");
        out.add("jam time max continuous(s)");
        out.add(String.format("%s jam time", Tri.Terrain.OPEN.description));
        out.add(String.format("%s jam time", Tri.Terrain.STAIR.description));
        out.add(String.format("%s jam time", Tri.Terrain.RAMP.description));
        out.add("start time(s)");
        out.add("finish time(s)");
        out.add("distance (m)");
        out.add("num attractors used");
        out.add("attractor time(s)");
        out.add("num occ targets used");
        out.add("occ target time(s)");
        for (TagSummary tag : tagSummaries) {
            String name = tag.tag.name;
            if (tag.tagged && tag.untagged) {
                out.add(String.format("%s time total(s)", name));
                out.add(String.format("tag:%s time last(s)", name));
                out.add(String.format("untag:%s time last(s)", name));
                continue;
            }
            if (tag.tagged) {
                out.add(String.format("%s time(s)", name));
                continue;
            }
            if (!tag.untagged) continue;
            out.add(String.format("untag:%s time(s)", name));
        }
        out.nextRow();
        out.flush();
        double d = kb.getCurrentSimTime();
        for (OccAgent oa : stats.getAllAgentsEver(kb)) {
            out.add(oa.getId());
            out.add(oa.getOcc().name);
            out.add(exitTag.getInfo((OccAgent)oa).tLastTagged, 3);
            out.add(stats.getActiveTime(oa), 3);
            out.add(stats.getSlowTimeTotal(oa), 3);
            out.add(stats.getSlowTimeMc(oa), 3);
            out.add(stats.getOpenSlowTimeTotal(oa), 3);
            out.add(stats.getStairsSlowTimeTotal(oa), 3);
            out.add(stats.getRampsSlowTimeTotal(oa), 3);
            out.add(stats.getStartTime(oa), 3);
            out.add(stats.getFinishTime(oa), 3);
            out.add(stats.getTravelDistance(oa), 3);
            out.add(stats.getNumAttractorsUsed(oa));
            out.add(stats.getTotalAttractorTime(oa), 3);
            out.add(stats.getNumOccTargetsUsed(oa));
            out.add(stats.getTotalOccTargetTime(oa), 3);
            for (TagSummary tag : tagSummaries) {
                Tag.Info ti = tag.tag.getInfo(oa);
                if (tag.tagged && tag.untagged) {
                    out.add(ti.getTAccum(d), 3);
                }
                if (tag.tagged) {
                    out.add(ti.tLastTagged, 3);
                }
                if (!tag.untagged) continue;
                out.add(ti.tLastUntagged == 0.0 ? Double.NaN : ti.tLastUntagged, 3);
            }
            out.nextRow();
        }
        out.flush();
    }

    private static class TagSummary {
        public final Tag tag;
        public final boolean tagged;
        public final boolean untagged;

        public TagSummary(Tag tag, boolean tagged, boolean untagged) {
            this.tag = tag;
            this.tagged = tagged;
            this.untagged = untagged;
        }
    }
}

