/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccGroup;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GroupInfoWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private KB d_kb;
    private Set<OccGroup> d_written;
    private final SerializedOutputStream d_strmOut;
    private final CSVWriter d_out;

    public GroupInfoWriter(KB kb) {
        this.d_kb = kb;
        this.d_written = new HashSet<OccGroup>();
        this.d_strmOut = new SerializedOutputStream(kb.getParams().out_group_info);
        this.d_out = new CSVWriter();
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_strmOut));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader() {
        for (Header header : Header.values()) {
            this.d_out.add(header.get());
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void writeFrame(double t) {
        for (OccGroup group : this.d_kb.getOccupantGroups()) {
            if (this.d_written.contains(group) || !group.isReady()) continue;
            this.d_written.add(group);
            this.d_out.add(group.getID());
            String groupMemberIDs = group.getMembers().stream().map(agent -> Integer.toString(agent.getOcc().getId())).collect(Collectors.joining(" "));
            this.d_out.add(groupMemberIDs);
            this.d_out.add(group.groupName);
            if (group.type != null) {
                this.d_out.add(group.type.groupTypeName);
            } else {
                this.d_out.addEmpty();
            }
            this.d_out.nextRow();
        }
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        GROUP_ID(WriterIntl.intl("Group ID")),
        OCC_IDS(WriterIntl.intl("Member IDs")),
        GROUP_NAME(WriterIntl.intl("Group Name")),
        GROUP_TYPE(WriterIntl.intl("Template Name"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

