/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.WingedEdge;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.DoorQueue;
import inferno.sim.DoorUsageSnapshot;
import inferno.sim.KB;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;

public class DoorUsageWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private final List<DoorUsageSnapshot> d_sortedSnapshots;
    private final List<ANode> d_sortedNodes;
    private KB d_kb;
    private final SerializedOutputStream d_doorUsageStream;
    private final CSVWriter d_out;

    public DoorUsageWriter(KB kb) {
        this.d_kb = kb;
        ArrayList<ANode> nodes = new ArrayList<ANode>(kb.getDoorNodes());
        Collections.sort(nodes, new Comparator<ANode>(){

            @Override
            public int compare(ANode o1, ANode o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        this.d_sortedNodes = nodes;
        ArrayList<DoorUsageSnapshot> snapshots = new ArrayList<DoorUsageSnapshot>(kb.getDoorNodes().size() * 2);
        for (ANode node : kb.getDoorNodes()) {
            DoorUsageWriter.getSnapshots(node, snapshots);
        }
        snapshots.trimToSize();
        Collections.sort(snapshots, new Comparator<DoorUsageSnapshot>(){

            @Override
            public int compare(DoorUsageSnapshot o1, DoorUsageSnapshot o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        this.d_sortedSnapshots = snapshots;
        this.d_doorUsageStream = new SerializedOutputStream(kb.getParams().out_door_usage);
        this.d_out = new CSVWriter();
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_doorUsageStream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader() {
        Consumer<Object> headers = header -> this.d_out.add(header);
        headers.accept(Header.TIME);
        headers.accept(Header.REMAINING_TOTAL);
        headers.accept(Header.EXITED_TOTAL);
        HashSet<ANode> metaPrinted = new HashSet<ANode>();
        for (DoorUsageSnapshot us : this.d_sortedSnapshots) {
            String s = us.name;
            headers.accept(s);
            if (metaPrinted.contains(us.node)) continue;
            headers.accept(String.format("%s %s", s, Header.WIDTH));
            headers.accept(String.format("%s %s", s, Header.TOTAL_BOUNDARY));
            metaPrinted.add(us.node);
        }
        if (this.d_kb.hasQueueingDoors()) {
            for (ANode n : this.d_sortedNodes) {
                if (!this.d_kb.isQueueingDoor(n)) continue;
                headers.accept(n.name.concat(" " + Header.Q.val.fileStr));
            }
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void writeFrame(double t) {
        int exitCount = 0;
        for (ANode n : this.d_sortedNodes) {
            exitCount += n.getExitedVia();
        }
        this.d_out.add(t, 4);
        this.d_out.add(this.d_kb.getAllAgentsEver().size() - exitCount);
        this.d_out.add(exitCount);
        HashSet<ANode> metaPrinted = new HashSet<ANode>();
        for (DoorUsageSnapshot us : this.d_sortedSnapshots) {
            int usage = us.updateUsage();
            this.d_out.add(usage);
            if (metaPrinted.contains(us.node)) continue;
            double fullWidth = us.node.getDoorGeom().length;
            double totalBoundary = fullWidth - us.node.doorQueue.getEffWidth();
            this.d_out.add(fullWidth, 3);
            this.d_out.add(totalBoundary, 3);
            metaPrinted.add(us.node);
        }
        if (this.d_kb.hasQueueingDoors()) {
            for (ANode n : this.d_sortedNodes) {
                if (!this.d_kb.isQueueingDoor(n)) continue;
                this.d_out.add(n.getNumOccupants());
            }
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    private static void getSnapshots(ANode node, List<DoorUsageSnapshot> snapshots) {
        DoorQueue dq = node.doorQueue;
        if (dq == null || dq.getNode().getDoorEdges().isEmpty()) {
            return;
        }
        if (!dq.isExitDoor()) {
            assert (dq.getR1() != null && dq.getR2() != null);
            Vector3d normal = DoorUsageWriter.getAvgPosNormalDir(node);
            String pLbl = DoorUsageWriter.getLabel(normal);
            normal.negate();
            String nLbl = DoorUsageWriter.getLabel(normal);
            String pName = String.format("%s %s", node.name, pLbl);
            String nName = String.format("%s %s", node.name, nLbl);
            String tName = node.name;
            snapshots.add(new DoorUsageSnapshot(node, pName, DoorDir.POSITIVE));
            snapshots.add(new DoorUsageSnapshot(node, nName, DoorDir.NEGATIVE));
            snapshots.add(new DoorUsageSnapshot(node, tName, null));
        } else {
            DoorDir dir = dq.getExitDir();
            snapshots.add(new DoorUsageSnapshot(node, node.name, dir));
        }
    }

    private static Vector3d getAvgPosNormalDir(ANode door) {
        if (door.getDoorEdges().isEmpty()) {
            return new Vector3d();
        }
        Vector3d result = new Vector3d();
        for (WingedEdge edge : door.getDoorEdges()) {
            Vector3d normal;
            Vector3d dir = Util3D.vector(edge.v1().p, edge.v2().p);
            double len = Util3D.safeNormalize(dir, 0.0);
            if (len == 0.0 || Util3D.safeNormalize(normal = Util3D.cross(GeomConstants.VEC3D_ZPOS, dir), 0.0) == 0.0) continue;
            normal.scale(len);
            result.add(normal);
        }
        Util3D.safeNormalize(result, 0.0);
        WingedEdge medge = door.getDoorEdges().get(door.getDoorEdges().size() / 2);
        assert (medge.t1 != null && medge.t2 != null);
        if (DoorDir.get(door, medge.t1) != DoorDir.POSITIVE) {
            result.negate();
        }
        return result;
    }

    private static String getLabel(Vector3d dir) {
        Vector2d vec = new Vector2d(dir.x, dir.y);
        vec.normalize();
        if (vec.x >= 0.5) {
            return Header.XP.val.fileStr;
        }
        if (vec.x < -0.5) {
            return Header.XN.val.fileStr;
        }
        if (vec.y >= 0.5) {
            return Header.YP.val.fileStr;
        }
        return Header.YN.val.fileStr;
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        TIME(WriterIntl.intl("time(s)")),
        REMAINING_TOTAL(WriterIntl.intl("Remaining (Total)")),
        EXITED_TOTAL(WriterIntl.intl("Exited (Total)")),
        WIDTH(WriterIntl.intl("width(m)")),
        TOTAL_BOUNDARY(WriterIntl.intl("total boundary(m)")),
        Q(WriterIntl.intl("(Q)")),
        XN(WriterIntl.intl("[-X]")),
        XP(WriterIntl.intl("[+X]")),
        YN(WriterIntl.intl("[-Y]")),
        YP(WriterIntl.intl("[+Y]"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

