/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.IAgentBodyShape;
import inferno.data2.OccTarget;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IAiCore;
import inferno.sim.path.EdgeFilters;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Point3d;

public interface IGoalAiCore
extends IAiCore {
    public IGoalInstance getCurrentGoalInstance(OccAgent var1);

    public Collection<ISeekArea> getSeekHistory();

    public ISeekArea getCurrentSeekArea(KB var1, OccAgent var2);

    default public ISeekArea getPreviousSeekArea(KB kb, OccAgent agent) {
        Collection<ISeekArea> history = this.getSeekHistory();
        if (this.isSeeking(kb, agent)) {
            if (history.isEmpty()) {
                return AiUtil.getInitSeekArea(agent);
            }
            return history.iterator().next();
        }
        if (history.size() < 2) {
            return AiUtil.getInitSeekArea(agent);
        }
        Iterator<ISeekArea> areaIt = history.iterator();
        areaIt.next();
        return areaIt.next();
    }

    public static ISeekArea calcCurrentSeekArea(IGoalAiCore core, KB kb, OccAgent agent, IGoalInstance ginst) {
        ISeekArea currSeek;
        if (ginst != null && (currSeek = ginst.getSeekArea(kb, agent)) != null) {
            return currSeek;
        }
        Collection<ISeekArea> history = core.getSeekHistory();
        if (history.isEmpty()) {
            return IGoalInstance.getCurrentAreaAsPoint(kb, agent);
        }
        return history.iterator().next();
    }

    public static OccTarget calcOccTargetInUse(KB kb, OccAgent agent, IGoalInstance ginst) {
        if (ginst.isSeeking(kb, agent)) {
            return null;
        }
        Point3d pos = agent.getPos();
        IAgentBodyShape shape = agent.getShape();
        return kb.getOccTargets().getReservations(agent).stream().filter(target -> target.asSeekArea().intersects(kb, shape, pos)).sorted((t1, t2) -> Double.compare(t1.location.p.distanceSquared(pos), t2.location.p.distanceSquared(pos))).filter(target -> !kb.getMesh().isPathObstructed(agent.getLoc(), target.location, 0.0, EdgeFilters.acceptAll())).findFirst().orElse(null);
    }
}

