/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.Flags;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;

public class StairInference
implements Serializable {
    private static final long serialVersionUID = -7473995407686774824L;
    private static final boolean GLOBAL_ENABLE = Flags.STAIR_INFERENCE_ENABLE.getValue();
    private static final StairInferenceData NONE = new StairInferenceData();
    private static final double TREAD_MAX = 0.33;
    private static final double TREAD_TOL = 1.0E-6;
    private static final boolean SLOPE_MAX_ENABLED = true;
    private static final double SLOPE_MAX = 1.19;
    private static final double SLOPE_DEFAULT = 0.6363636363636364;
    private transient StairInferenceData d_data = null;
    private static final double CACHE_TOL_DIST2 = 1.0E-6;

    private StairInferenceData getData(Mesh m, Occupant occ) {
        if (!GLOBAL_ENABLE) {
            return NONE;
        }
        if (this.d_data == null || this.d_data.loc == null || occ.loc != this.d_data.loc && occ.loc.distanceSquared(this.d_data.loc) > 1.0E-6) {
            this.d_data = StairInference.calcData(m, occ);
        }
        return this.d_data;
    }

    private static StairInferenceData calcData(Mesh m, Occupant occ) {
        Pair<WingedEdge, WingedEdge> b;
        double stepSearchDist = 0.165001;
        Pair<WingedEdge, WingedEdge> a = StairInference.getRefStep(m, occ.tri, occ.loc, occ.orient, stepSearchDist, new WingedEdge[0]);
        Pair<WingedEdge, WingedEdge> refStep = StairInference.chooseNearestStep(occ.loc, a, b = StairInference.getRefStep(m, occ.tri, occ.loc, Util3D.negate(occ.orient), stepSearchDist, new WingedEdge[0]));
        if (refStep == null) {
            return NONE;
        }
        Tri refTri = ((WingedEdge)refStep.v1).t1;
        Point3d refPt = Inter3D.nearestPointOnLineSeg(((WingedEdge)refStep.v1).p1(), ((WingedEdge)refStep.v1).p2(), occ.loc);
        Vector3d refDir = Util3D.vector(refPt, occ.loc);
        double treadSearchDist = 0.330001;
        a = StairInference.getRefStep(m, refTri, refPt, refDir, treadSearchDist, (WingedEdge)refStep.v1, (WingedEdge)refStep.v2);
        b = StairInference.getRefStep(m, refTri, refPt, Util3D.negate(refDir), treadSearchDist, (WingedEdge)refStep.v1, (WingedEdge)refStep.v2);
        Pair<WingedEdge, WingedEdge> runStep = StairInference.chooseNearestStep(refPt, a, b);
        if (runStep != null) {
            Point3d risePtA = refPt;
            Point3d risePtB = Inter3D.nearestPointOnLineSeg(((WingedEdge)refStep.v2).p1(), ((WingedEdge)refStep.v2).p2(), occ.loc);
            double dz = Math.abs(risePtB.z - risePtA.z);
            StepDir sdir = StairInference.getStepDirFromRefRiser(occ, dz, (WingedEdge)refStep.v1);
            Point3d treadPtA = Inter3D.nearestPointOnLineSeg(((WingedEdge)runStep.v1).p1(), ((WingedEdge)runStep.v1).p2(), refPt);
            double treadA = risePtA.distance(treadPtA);
            double treadB = risePtB.distance(treadPtA);
            double tread = Math.min(treadA, treadB);
            double slope = Math.abs(dz / tread);
            slope = Math.min(slope, 1.19);
            return new StairInferenceData(true, occ.loc, slope, sdir);
        }
        Point3d risePtA = refPt;
        Point3d risePtB = Inter3D.nearestPointOnLineSeg(((WingedEdge)refStep.v2).p1(), ((WingedEdge)refStep.v2).p2(), occ.loc);
        double dz = Math.abs(risePtB.z - risePtA.z);
        StepDir sdir = StairInference.getStepDirFromRefRiser(occ, dz, (WingedEdge)refStep.v1);
        return new StairInferenceData(true, occ.loc, 0.6363636363636364, sdir);
    }

    private static Pair<WingedEdge, WingedEdge> chooseNearestStep(Point3d pt, Pair<WingedEdge, WingedEdge> a, Pair<WingedEdge, WingedEdge> b) {
        if (a != null && b == null) {
            return a;
        }
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b != null) {
            Point3d pA = Inter3D.nearestPointOnLineSeg(((WingedEdge)a.v1).p1(), ((WingedEdge)a.v1).p2(), pt);
            Point3d pB = Inter3D.nearestPointOnLineSeg(((WingedEdge)b.v1).p1(), ((WingedEdge)b.v1).p2(), pt);
            if (pA.distanceSquared(pt) <= pB.distanceSquared(pt)) {
                return a;
            }
            return b;
        }
        return null;
    }

    private static Pair<WingedEdge, WingedEdge> getRefStep(Mesh m, Tri t, Point3d pt, Vector3d dir, double dist, WingedEdge ... skipEdges) {
        Vector3d ndir = Util3D.normalize(dir);
        Mesh.EdgeCrossing ec = m.getCrossedEdgesNoEx(t, pt, ndir, dist);
        if (ec == null) {
            return null;
        }
        List edges = ec.flatten().stream().map(edgeCrossing -> edgeCrossing.edge).filter(StairInference::isCrease).filter(edge -> !Arrays.stream(skipEdges).anyMatch(edge::equals)).limit(2L).collect(Collectors.toList());
        if (edges.size() == 2) {
            return new Pair<WingedEdge, WingedEdge>((WingedEdge)edges.get(0), (WingedEdge)edges.get(1));
        }
        return null;
    }

    private static StepDir getStepDirFromRefRiser(Occupant occ, double riserDz, WingedEdge nearestCrease) {
        boolean refStairGoesUp;
        Point3d nearPt = Inter3D.nearestPointOnLineSeg(nearestCrease.p1(), nearestCrease.p2(), occ.loc);
        Vector3d toRiser = Util3D.vector(occ.loc, nearPt);
        double angle = Util3D.angle(occ.orient, toRiser, Util3D.VEC3D_ZPOS);
        boolean refStairAhead = angle >= 0.0;
        boolean bl = refStairGoesUp = riserDz >= 0.0;
        if (refStairAhead && refStairGoesUp || !refStairAhead && !refStairGoesUp) {
            return StepDir.UP;
        }
        return StepDir.DOWN;
    }

    private static boolean isCrease(WingedEdge we) {
        Vector3d up = new Vector3d(0.0, 0.0, 1.0);
        if (we.t1 != null && we.t2 != null) {
            boolean isVerticalT1 = up.angle(we.t1.normal) >= 1.3;
            boolean isVerticalT2 = up.angle(we.t2.normal) >= 1.3;
            return isVerticalT1 ^ isVerticalT2;
        }
        return false;
    }

    public boolean isActive(Mesh m, Occupant occ) {
        return this.getData((Mesh)m, (Occupant)occ).enabled;
    }

    public double getSlope(Mesh m, Occupant occ) {
        return this.getData((Mesh)m, (Occupant)occ).slope;
    }

    public StepDir getStepDir(Mesh m, Occupant occ) {
        return this.getData((Mesh)m, (Occupant)occ).stepDir;
    }

    public static Vector3d convertGeomVectorToInferred(Vector3d raw, double inferredSlope) {
        Vector3d up = new Vector3d(0.0, 0.0, 1.0);
        Vector3d rotAxis = Util3D.cross(raw, up);
        double angle = Math.atan(inferredSlope);
        return Util3D.rotate(raw, rotAxis, angle);
    }

    public static double getMaxVelHorizComp(double maxVel, double slope) {
        return maxVel / Math.sqrt(slope * slope + 1.0);
    }

    private static class StairInferenceData {
        public final boolean enabled;
        public final Point3d loc;
        public final double slope;
        public final StepDir stepDir;

        public StairInferenceData() {
            this(false, null, Double.NaN, StepDir.UP);
        }

        public StairInferenceData(boolean enabled, Point3d loc, double slope, StepDir stepDir) {
            this.enabled = enabled;
            this.loc = loc;
            this.slope = slope;
            this.stepDir = stepDir;
        }
    }

    public static enum StepDir {
        UP,
        DOWN;

    }
}

