/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.CylinderShape;
import inferno.data2.IAgentBodyShape;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.ObjectTracker;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccProfileSim;
import inferno.sim.VehicleBody;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.util.Pair;

public class OccTracker
extends ObjectTracker<OccAgent, Changes> {
    static final long serialVersionUID = 1L;
    private final KB d_kb;
    private final Map<ITrackerObj, Integer> d_objs = new LinkedHashMap<ITrackerObj, Integer>();
    private final Map<OccAgent, PolygonShape> d_agentVehicleShapes = new IdentityHashMap<OccAgent, PolygonShape>();
    private final Map<OccAgent, Integer> d_vehicleIds = new IdentityHashMap<OccAgent, Integer>();

    public OccTracker(KB kb) {
        this.d_kb = kb;
    }

    public int generateOccId() {
        return this.d_kb.generateOccId();
    }

    public static VehicleBody getVehicleBody(OccAgent agent) {
        PolygonShape vshape = OccTracker.getVehicleShape(agent);
        return vshape != null ? vshape.vehicleBody : null;
    }

    public static PolygonShape getVehicleShape(OccAgent agent) {
        return agent.hasVehicle() ? agent.getVehicle().getShape() : null;
    }

    public Integer getVehicleId(OccAgent agent) {
        return this.d_vehicleIds.get(agent);
    }

    public int getObjId(ITrackerObj obj) {
        return this.d_objs.getOrDefault(obj, -1);
    }

    public void getTrackedObjs(Collection<? extends OccAgent> agents, boolean newOnly, Consumer<ITrackerObj> newObjs) {
        Consumer<ITrackerObj> addObj = obj -> {
            if (obj == null) {
                return;
            }
            this.d_objs.computeIfAbsent((ITrackerObj)obj, s -> {
                Integer id = this.d_objs.size();
                if (newOnly) {
                    newObjs.accept((ITrackerObj)s);
                }
                return id;
            });
            if (!newOnly) {
                newObjs.accept((ITrackerObj)obj);
            }
        };
        for (OccAgent occAgent : agents) {
            BiConsumer<Boolean, Boolean> addShape = (vehicle, realistic) -> {
                Pair<ITrackerShape, Boolean> tshape = OccTracker.getTrackerShape(agent, vehicle, realistic);
                addObj.accept((ITrackerObj)tshape.v1);
            };
            addShape.accept(false, false);
            addShape.accept(false, true);
            addShape.accept(true, false);
            addShape.accept(true, true);
            Occupant occ = occAgent.getOcc();
            addObj.accept(occ.occupantGroup != null ? new TrackedGroup(occ.occupantGroup) : null);
            addObj.accept(occ.parentProfile != null ? new TrackedProfile(occ.parentProfile) : null);
            BehaviorSim behavior = OccTracker.getCurrentBehavior(occ);
            addObj.accept(behavior != null ? new TrackedBehavior(behavior) : null);
        }
    }

    public static BehaviorSim getCurrentBehavior(Occupant occ) {
        return !occ.behaviorStack.isEmpty() ? occ.behaviorStack.peek().behavior : occ.behavior;
    }

    public static Pair<ITrackerShape, Boolean> getTrackerShape(OccAgent agent, boolean vehicle, boolean realistic) {
        IAgentBodyShape shape = agent.getOcc().bodyShape;
        if (realistic) {
            if (!vehicle && agent.getOcc().avatar != null) {
                Point3d offset = GeomConstants.PNT3D_ORIGIN;
                if (shape instanceof PolygonShape) {
                    offset = ((PolygonShape)shape).vehicleBody.occAvatarOffset;
                }
                return new Pair<ITrackerShape, Boolean>(new RealisticShape(agent.getOcc().avatar, offset, true), true);
            }
            if (shape instanceof PolygonShape) {
                PolygonShape pshape = (PolygonShape)shape;
                if (pshape.vehicleBody.avatar != null && !pshape.vehicleBody.avatar.isEmpty()) {
                    return new Pair<ITrackerShape, Boolean>(new RealisticShape(pshape.vehicleBody.avatar, pshape.vehicleBody.origin, false), false);
                }
                return new Pair<Object, Boolean>(null, false);
            }
            return new Pair<Object, Boolean>(null, !vehicle);
        }
        if (shape instanceof CylinderShape) {
            return new Pair<ITrackerShape, Boolean>(new CylShape((CylinderShape)shape), true);
        }
        if (shape instanceof PolygonShape) {
            return new Pair<ITrackerShape, Boolean>(new VehicleBodyShape((PolygonShape)shape), false);
        }
        assert (false);
        return new Pair<Object, Boolean>(null, !vehicle);
    }

    @Override
    public Changes beginUpdate(Collection<? extends OccAgent> currentActiveAgents, Collection<OccAgent> added, Collection<OccAgent> removed) {
        this.getAddsAndRemoves(currentActiveAgents, added, removed, agent -> agent.isDone() && agent.getOcc().removeWhenFinished);
        Changes changes = new Changes();
        for (OccAgent occAgent : currentActiveAgents) {
            PolygonShape prevShape;
            PolygonShape currShape = OccTracker.getVehicleShape(occAgent);
            if (currShape == (prevShape = this.d_agentVehicleShapes.get(occAgent))) continue;
            if (prevShape != null) {
                Integer id = this.d_vehicleIds.remove(occAgent);
                assert (id != null);
                changes.removedVehicleProxies.add(new Pair<OccAgent, Integer>(occAgent, id));
            }
            if (currShape != null) {
                int id = this.generateOccId();
                this.d_vehicleIds.put(occAgent, id);
                changes.addedVehicleProxies.add(new Pair<OccAgent, Integer>(occAgent, id));
                this.d_agentVehicleShapes.put(occAgent, currShape);
                continue;
            }
            this.d_agentVehicleShapes.remove(occAgent);
        }
        for (OccAgent occAgent : removed) {
            Integer vehicleId = this.getVehicleId(occAgent);
            if (vehicleId == null) continue;
            changes.removedVehicleProxies.add(new Pair<OccAgent, Integer>(occAgent, vehicleId));
        }
        this.getTrackedObjs(currentActiveAgents, true, changes.addedTrackedObjs::add);
        return changes;
    }

    @Override
    public void endUpdate(Collection<? extends OccAgent> removedObjs) {
        super.endUpdate(removedObjs);
        this.d_vehicleIds.keySet().removeAll(removedObjs);
        this.d_agentVehicleShapes.keySet().removeAll(removedObjs);
    }

    public Set<OccAgent> getOccs() {
        return this.getObjs();
    }

    public static class CylShape
    implements ITrackerShape,
    Serializable {
        static final long serialVersionUID = 1L;
        public final double radius;
        public final double height;

        public CylShape(CylinderShape cshape) {
            this.radius = cshape.getOccRadius();
            this.height = cshape.getHeight();
        }

        public CylShape(double radius, double height) {
            this.radius = radius;
            this.height = height;
        }

        public int hashCode() {
            return Objects.hash(this.radius, this.height);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CylShape)) {
                return false;
            }
            CylShape c = (CylShape)obj;
            return c.radius == this.radius && c.height == this.height;
        }
    }

    public static class PolyShape
    implements IPolyShape,
    Serializable {
        static final long serialVersionUID = 1L;
        public final double height;
        public final Point3d[] points;

        public PolyShape(double height, Point3d[] points) {
            this.height = height;
            this.points = points;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PolyShape)) {
                return false;
            }
            PolyShape pshape = (PolyShape)obj;
            return pshape.height == this.height && Arrays.equals(pshape.points, this.points);
        }

        public int hashCode() {
            return 0x7F9A83 ^ Objects.hash(this.height, Arrays.hashCode(this.points));
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public Point3d[] getPoints() {
            return this.points;
        }
    }

    public static class VehicleBodyShape
    implements IPolyShape,
    Serializable {
        static final long serialVersionUID = 1L;
        public final VehicleBody body;

        public VehicleBodyShape(PolygonShape shape) {
            this.body = shape.vehicleBody;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VehicleBodyShape)) {
                return false;
            }
            VehicleBodyShape pshape = (VehicleBodyShape)obj;
            return pshape.body == this.body;
        }

        public int hashCode() {
            return 0x7F9A83 ^ System.identityHashCode(this.body);
        }

        @Override
        public double getHeight() {
            return this.body.height;
        }

        @Override
        public Point3d[] getPoints() {
            return this.body.innerPoints;
        }
    }

    public static interface IPolyShape
    extends ITrackerShape {
        public double getHeight();

        public Point3d[] getPoints();
    }

    public static class RealisticShape
    implements ITrackerShape,
    Serializable {
        static final long serialVersionUID = 1L;
        public final String model;
        public final Point3d offset;
        public final boolean isHuman;

        public RealisticShape(String model, Point3d offset, boolean isHuman) {
            this.model = model;
            this.offset = offset;
            this.isHuman = isHuman;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RealisticShape)) {
                return false;
            }
            RealisticShape pshape = (RealisticShape)obj;
            return pshape.isHuman == this.isHuman && pshape.offset.equals(this.offset) && pshape.model.equals(this.model);
        }

        public int hashCode() {
            return 0x9A883 ^ Objects.hash(this.model, this.offset, this.isHuman);
        }
    }

    public static class TrackedProfile
    extends ATrackerSharedObj<OccProfileSim> {
        static final long serialVersionUID = 1L;

        public TrackedProfile(OccProfileSim profile) {
            super(profile);
        }

        @Override
        public int getMaxNumColors() {
            return 1;
        }

        @Override
        public Object getColor(int ix) {
            return ((OccProfileSim)this.obj).getProperty(OccProfileSim.PROP_COLOR);
        }

        @Override
        public String getName() {
            return ((OccProfileSim)this.obj).getName();
        }

        @Override
        public TrackerType getType() {
            return TrackerType.PROFILE;
        }
    }

    public static class TrackedGroup
    extends ATrackerSharedObj<OccGroup> {
        static final long serialVersionUID = 1L;

        public TrackedGroup(OccGroup group) {
            super(group);
        }

        @Override
        public int getMaxNumColors() {
            return 2;
        }

        @Override
        public Object getColor(int ix) {
            switch (ix) {
                case 0: {
                    return ((OccGroup)this.obj).color;
                }
                case 1: {
                    return ((OccGroup)this.obj).templateColor;
                }
            }
            return ((OccGroup)this.obj).color;
        }

        @Override
        public String getName() {
            return ((OccGroup)this.obj).groupName;
        }

        @Override
        public TrackerType getType() {
            return TrackerType.GROUP;
        }
    }

    public static class TrackedBehavior
    extends ATrackerSharedObj<BehaviorSim> {
        static final long serialVersionUID = 1L;

        public TrackedBehavior(BehaviorSim behavior) {
            super(behavior);
        }

        @Override
        public int getMaxNumColors() {
            return 1;
        }

        @Override
        public Object getColor(int ix) {
            return ((BehaviorSim)this.obj).color;
        }

        @Override
        public String getName() {
            return ((BehaviorSim)this.obj).name;
        }

        @Override
        public TrackerType getType() {
            return TrackerType.BEHAVIOR;
        }
    }

    public static abstract class ATrackerSharedObj<T>
    implements ITrackerSharedObj {
        static final long serialVersionUID = 1L;
        public final T obj;

        public ATrackerSharedObj(T obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return Objects.hash(this.obj);
        }

        public boolean equals(Object arg0) {
            return arg0 == this || arg0 instanceof ATrackerSharedObj && Objects.equals(((ATrackerSharedObj)arg0).obj, this.obj);
        }
    }

    public static interface ITrackerSharedObj
    extends ITrackerObj {
        public String getName();

        public int getMaxNumColors();

        public Object getColor(int var1);
    }

    public static interface ITrackerShape
    extends ITrackerObj {
        @Override
        default public TrackerType getType() {
            return TrackerType.SHAPE;
        }
    }

    public static interface ITrackerObj
    extends Serializable {
        public TrackerType getType();
    }

    public static enum TrackerType {
        SHAPE,
        GROUP,
        BEHAVIOR,
        PROFILE;

    }

    public static class Changes {
        public final List<Pair<OccAgent, Integer>> removedVehicleProxies = new ArrayList<Pair<OccAgent, Integer>>();
        public final List<Pair<OccAgent, Integer>> addedVehicleProxies = new ArrayList<Pair<OccAgent, Integer>>();
        public final List<ITrackerObj> addedTrackedObjs = new ArrayList<ITrackerObj>();

        public boolean isEmpty() {
            return this.removedVehicleProxies.isEmpty() && this.addedVehicleProxies.isEmpty() && this.addedTrackedObjs.isEmpty();
        }
    }
}

