/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.DoorGeom;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.data2.ai.IProgressNote;
import inferno.data2.value.ConstFunction1d;
import inferno.data2.value.IFunction1d;
import inferno.data2.value.PiecewiseFunction1d;
import inferno.sim.BehaviorSim;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;

public class OccSource
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(OccSource.class.getName());
    private final String d_name;
    private final ANode d_component;
    private final AABox d_bounds;
    private final IFunction1d d_flowrate;
    private final IUrn<OccProfileSim> d_profUrn;
    private final IUrn<BehaviorSim> d_behaviorUrn;
    private final IUrn<OccGroupType> d_groupUrn;
    private final KB d_kb;
    private final Random d_occCreatorRand;
    private Random d_occGroupRand;
    private final boolean d_enforceFlowrate;
    private final double d_finishTime;
    private final double d_minGeomRadius;
    private final double d_maxGeomRadius;
    private final double[] d_velRange;
    private final NameGenerator d_nameGenerator;
    private int d_numReleasedOccs = 0;
    private boolean d_stuck = false;
    private GeomChoice[] d_tris;
    private GeomChoice[] d_lineSegments;
    private OccGroup d_groupToRelease;
    private static final Predicate<Tri> TRI_FILTER = t -> t.node.getElevatorLevel() == null;

    public OccSource(String name, AABox bounds, IFunction1d flowrate, IUrn<OccProfileSim> profUrn, IUrn<BehaviorSim> behaviorUrn, boolean enforceFlowrate, ANode component, IUrn<OccGroupType> groupUrn, KB kb) {
        this.d_name = name;
        this.d_bounds = bounds;
        this.d_flowrate = flowrate;
        this.d_profUrn = profUrn;
        this.d_behaviorUrn = behaviorUrn;
        this.d_groupUrn = groupUrn;
        this.d_enforceFlowrate = enforceFlowrate;
        this.d_component = component;
        if (component != null) {
            component.addOccSource(this);
        }
        this.d_kb = kb;
        this.d_occCreatorRand = new Random();
        this.d_finishTime = this.findFinishTime();
        double[] minMaxGeomRadii = this.findMinMaxGeomRadii();
        this.d_minGeomRadius = minMaxGeomRadii[0];
        this.d_maxGeomRadius = minMaxGeomRadii[1];
        this.d_velRange = this.findMinMaxVel();
        int maxOccCount = (int)Math.round(this.d_flowrate.getAUC(0.0, kb.getParams().max_time));
        this.d_nameGenerator = new NameGenerator(this.d_name + "_", String.valueOf(maxOccCount).length(), false);
    }

    public String getName() {
        return this.d_name;
    }

    public AABox getBounds() {
        return this.d_bounds;
    }

    public void update(Engine engine, double dt) {
        double currentSimTime = engine.getKB().getCurrentSimTime();
        if (this.isFinished(currentSimTime)) {
            this.finish();
            return;
        }
        double shouldRelease = this.d_flowrate.getAUC(0.0, currentSimTime + dt) - (double)this.d_numReleasedOccs;
        int toRelease = (int)Math.round(shouldRelease);
        if (toRelease > 0) {
            OccGroupType groupType;
            if (this.d_occGroupRand == null) {
                this.d_occGroupRand = new Random(this.newSeed());
            }
            if (this.d_groupToRelease == null && (groupType = this.d_groupUrn.getValue(this.d_occGroupRand)) != null && !groupType.isNoGroupType) {
                this.d_groupToRelease = groupType.createEmptyGroup(engine.getKB());
            }
            this.d_stuck = true;
            for (int i = 0; i < toRelease; ++i) {
                this.d_stuck &= !this.releaseOccupant(engine);
                ++this.d_numReleasedOccs;
                if (this.d_groupToRelease == null || !this.d_groupToRelease.isReady()) continue;
                this.d_groupToRelease = null;
            }
        } else {
            double fr = this.d_flowrate.get(currentSimTime);
            if (fr == 0.0) {
                this.d_stuck = false;
            }
        }
    }

    private void finish() {
        if (this.d_groupToRelease != null) {
            this.d_groupToRelease.setIsReady(true);
            this.d_groupToRelease = null;
        }
    }

    private boolean releaseOccupant(Engine engine) {
        Point3d loc;
        OccProfileSim prof;
        long occSeed = this.newSeed();
        this.d_occCreatorRand.setSeed(occSeed);
        BehaviorSim behavior = null;
        if (this.d_groupToRelease != null) {
            prof = this.d_groupToRelease.getNextProfile(this.d_occCreatorRand);
            if (prof == null) {
                prof = this.d_profUrn.getValue(this.d_occCreatorRand);
            }
            behavior = this.d_groupToRelease.getInitOccs() != null && !this.d_groupToRelease.getInitOccs().isEmpty() ? this.d_groupToRelease.getInitOccs().get((int)0).behavior : (!this.d_groupToRelease.getMembers().isEmpty() ? this.d_groupToRelease.getMembers().iterator().next().getOcc().behavior : this.d_behaviorUrn.getValue(this.d_occCreatorRand));
        } else {
            prof = this.d_profUrn.getValue(this.d_occCreatorRand);
            behavior = this.d_behaviorUrn.getValue(this.d_occCreatorRand);
        }
        String newName = this.d_nameGenerator.generateName();
        Random rand = new Random();
        int maxTrials = 10;
        ArrayList attemptedLocs = new ArrayList();
        Predicate<Occupant> testOcc = !this.d_enforceFlowrate ? occ -> this.d_kb.isOccValid((Occupant)occ, true, true) : occ -> {
            boolean[] isectBoundary = new boolean[]{false};
            OccAgent[] isectOcc = new OccAgent[]{null};
            double[] nearestOccDistSq = new double[]{Double.POSITIVE_INFINITY};
            try {
                this.d_kb.testOccLocation((Occupant)occ, true, true, iobj -> {
                    if (iobj instanceof WingedEdge) {
                        blArray[0] = true;
                        throw new CancellationException();
                    }
                    OccAgent iocc = (OccAgent)iobj;
                    double distSq = occupant.loc.distance(iocc.getPos());
                    if (distSq < nearestOccDistSq[0]) {
                        occAgentArray[0] = iocc;
                        dArray[0] = distSq;
                    }
                });
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (!isectBoundary[0] && isectOcc[0] != null) {
                attemptedLocs.add(new Pair<Point3d, Double>(occ.loc, nearestOccDistSq[0]));
            }
            return !isectBoundary[0] && isectOcc[0] == null;
        };
        Consumer<Occupant> addOcc = newOcc -> {
            OccAgent newAgent = this.d_kb.createAgent((Occupant)newOcc, true);
            newAgent.init(this.d_kb, this.d_kb.getParams());
            engine.agentAdded(newAgent);
            this.d_nameGenerator.registerName(newAgent.getName());
            if (this.d_groupToRelease != null) {
                if (this.d_groupToRelease.isInitialized()) {
                    this.d_groupToRelease.joinInstantly(engine.getKB(), newAgent);
                } else {
                    this.d_groupToRelease.addOccOnInit(newAgent.getOcc());
                }
            }
        };
        for (int tryLoc = 1; tryLoc <= maxTrials && (loc = this.newLoc()) != null; ++tryLoc) {
            Occupant newOcc2 = this.d_kb.createOcc(prof, behavior, occSeed, loc, rand, newName, testOcc);
            if (newOcc2 == null) continue;
            addOcc.accept(newOcc2);
            return true;
        }
        if (!attemptedLocs.isEmpty()) {
            Point3d bestLoc = (Point3d)((Pair)attemptedLocs.stream().max((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$releaseOccupant$327(thunderheadeng.util.Pair thunderheadeng.util.Pair ), (Lthunderheadeng/util/Pair;Lthunderheadeng/util/Pair;)I)()).get()).v1;
            Occupant newOcc3 = this.d_kb.createOcc(prof, behavior, occSeed, bestLoc, rand, newName, Predicates.alwaysTrue());
            assert (newOcc3 != null);
            if (newOcc3 != null) {
                addOcc.accept(newOcc3);
                return true;
            }
        }
        return false;
    }

    private double findFinishTime() {
        if (this.d_flowrate instanceof ConstFunction1d) {
            return this.d_flowrate.get(0.0) == 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
        }
        if (this.d_flowrate instanceof PiecewiseFunction1d) {
            PiecewiseFunction1d func = (PiecewiseFunction1d)this.d_flowrate;
            if (func.y.length == 0) {
                return 0.0;
            }
            if (func.y[func.y.length - 1] != 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            for (int i = func.y.length - 1; i >= 0; --i) {
                if (func.y[i] == 0.0) continue;
                return func.x[i + 1];
            }
        }
        assert (false);
        return Double.POSITIVE_INFINITY;
    }

    private Point3d newLoc() {
        this.initGeom();
        if (this.d_component != null && this.d_component.isDoor()) {
            if (this.d_component.isExitDoor() || this.d_component.getOnewayDir() != null || this.isElevatorDoor(this.d_component)) {
                return this.sampleDoorPoint(true);
            }
            return this.sampleDoorPoint(false);
        }
        if (this.d_tris.length > 0) {
            Point3d[] t = this.sampleTri();
            assert (t != null);
            return this.samplePointInTri(t);
        }
        if (this.d_lineSegments.length > 0) {
            Point3d[] ls = this.sampleLineSeg();
            assert (ls != null);
            return this.sampleLineSegPoint(ls[0], ls[1]);
        }
        return null;
    }

    public GeomChoice[] getTris() {
        return this.d_tris != null ? this.d_tris : new GeomChoice[]{};
    }

    public GeomChoice[] getLineSegments() {
        return this.d_lineSegments != null ? this.d_lineSegments : new GeomChoice[]{};
    }

    private boolean isElevatorDoor(ANode component) {
        return this.getElevatorExitRoom(component) != null;
    }

    private ANode getElevatorExitRoom(ANode component) {
        if (component.doorQueue.getR1().getElevatorLevel() != null) {
            return component.doorQueue.getR2();
        }
        if (component.doorQueue.getR2().getElevatorLevel() != null) {
            return component.doorQueue.getR1();
        }
        return null;
    }

    private long newSeed() {
        return this.d_kb.getOccSourceRGen().nextLong();
    }

    public Set<OccProfileSim> getAllProfiles() {
        return this.getProfiles(true);
    }

    public Set<OccProfileSim> getProfiles(boolean fromBehaviors) {
        if (this.d_groupUrn == null && !fromBehaviors) {
            return Collections.unmodifiableSet(this.d_profUrn.getWeights().keySet());
        }
        LinkedIdentityHashSet<OccProfileSim> allProfs = new LinkedIdentityHashSet<OccProfileSim>((Collection<OccProfileSim>)this.d_profUrn.getWeights().keySet());
        if (this.d_groupUrn != null) {
            for (OccGroupType groupType : this.d_groupUrn.getWeights().keySet()) {
                if (groupType.profileMap == null) continue;
                allProfs.addAll(groupType.profileMap.keySet());
            }
        }
        if (fromBehaviors) {
            IdentityHashSet visited = new IdentityHashSet();
            for (BehaviorSim behavior : this.getBehaviors()) {
                behavior.getReferencedProfiles(visited, allProfs::add);
            }
        }
        return allProfs;
    }

    public List<Double> getAllGeomAndOccRadii() {
        LinkedHashSet radii = new LinkedHashSet();
        this.getFutureProfileValues(OccProfileSim.PROP_SHAPE, shapeGen -> {
            shapeGen.getAllWidths(true, w -> radii.add(w / 2.0));
            shapeGen.getAllWidths(false, w -> radii.add(w / 2.0));
        });
        return new ArrayList<Double>(radii);
    }

    public <T> void getFutureProfileValues(OccProfileSim.IOccProp<T> prop, Consumer<? super T> result) {
        for (OccProfileSim prof : this.getProfiles(false)) {
            T val = prof.getProp(prop);
            result.accept(val);
        }
        IdentityHashSet visited = new IdentityHashSet();
        for (BehaviorSim behavior : this.getBehaviors()) {
            behavior.getFutureProfileValues(visited, prop, result);
        }
    }

    private double[] findMinMaxGeomRadii() {
        return this.findMinMaxValue(OccProfileSim.PROP_SHAPE, shape -> {
            double[] wr = shape.getWidthRange(true);
            wr[0] = wr[0] * 0.5;
            wr[1] = wr[1] * 0.5;
            return wr;
        });
    }

    /*
     * Exception decompiling
     */
    private double[] findMinMaxVel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> double[] findMinMaxValue(OccProfileSim.IOccProp<T> prop, Function<T, double[]> getRange) {
        double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        this.getFutureProfileValues(prop, val -> {
            double[] r = (double[])getRange.apply(val);
            dArray[0] = Math.min(range[0], r[0]);
            dArray[1] = Math.max(range[1], r[1]);
        });
        return range;
    }

    public boolean isFinished(double currentSimTime) {
        return currentSimTime > this.d_finishTime;
    }

    public double getMinGeomRadius() {
        return this.d_minGeomRadius;
    }

    public double getMaxGeomRadius() {
        return this.d_maxGeomRadius;
    }

    public double getMinVel() {
        return this.d_velRange[0];
    }

    public double getMaxVel() {
        return this.d_velRange[1];
    }

    private static <T> Set<T> getUnique(IUrn<T> urn) {
        LinkedIdentityHashSet unique = new LinkedIdentityHashSet();
        urn.getUnique(unique);
        return unique;
    }

    public Set<OccProfileSim> getProfiles() {
        return OccSource.getUnique(this.d_profUrn);
    }

    public Set<BehaviorSim> getBehaviors() {
        return OccSource.getUnique(this.d_behaviorUrn);
    }

    public double getFinishTime() {
        return this.d_finishTime;
    }

    public IFunction1d getFlowrate() {
        return this.d_flowrate;
    }

    public double getFlowrate(double currentSimTime) {
        return this.d_flowrate.get(currentSimTime);
    }

    private Point3d sampleLineSegPoint(Point3d p1, Point3d p2) {
        double t = this.d_occCreatorRand.nextDouble();
        return Util3D.linesegPoint(p1, p2, t);
    }

    private Point3d sampleDoorPoint(boolean shift) {
        DoorGeom dg = this.d_component.getDoorGeom();
        assert (dg != null);
        Pair<Integer, Point3d> sampledPt = dg.get(this.d_occCreatorRand.nextDouble());
        Point3d loc = (Point3d)sampledPt.v2;
        if (!shift) {
            return loc;
        }
        WingedEdge doorEdge = dg.edges.get((Integer)sampledPt.v1);
        Point3d p1 = doorEdge.p1();
        Point3d p2 = doorEdge.p2();
        Vector3d v = Util3D.vector(p1, p2);
        Vector3d perp = new Vector3d(-v.y, v.x, v.z);
        perp.normalize();
        perp.scale(0.1);
        Point3d shiftedP = new Point3d(loc);
        shiftedP.add(perp);
        double side = doorEdge.whichSide(shiftedP, 0.0);
        Tri t = side > 0.0 ? doorEdge.t1 : doorEdge.t2;
        Iterator<ANode> it = this.d_component.getAdjacentNodes().iterator();
        ANode room = it.next();
        boolean wrongSide = false;
        if (!this.d_component.isExitDoor()) {
            boolean sameRoom = !it.hasNext();
            DoorDir doorDir = this.d_component.getOnewayDir();
            if (doorDir != null) {
                if (!sameRoom) {
                    room = this.d_component.doorQueue.dest(doorDir);
                    wrongSide = !OccSource.isInRoom(room, t);
                } else {
                    Tri dest = doorDir.equals((Object)DoorDir.POSITIVE) ? doorEdge.t1 : doorEdge.t2;
                    wrongSide = !dest.containsExact(shiftedP);
                }
            } else {
                ANode elevExitRoom = this.getElevatorExitRoom(this.d_component);
                if (elevExitRoom != null) {
                    wrongSide = !OccSource.isInRoom(elevExitRoom, t);
                }
            }
        } else {
            boolean bl = wrongSide = !OccSource.isInRoom(room, t);
        }
        if (wrongSide) {
            shiftedP = new Point3d(loc);
            perp.scale(-1.0);
            shiftedP.add(perp);
        }
        return shiftedP;
    }

    private static boolean isInRoom(ANode room, Tri tri) {
        return tri != null ? tri.node == room : false;
    }

    private void initGeom() {
        this.initTris();
        if (this.d_lineSegments == null) {
            if (this.d_tris.length == 0) {
                this.initLineSegments();
            } else {
                this.d_lineSegments = new GeomChoice[0];
            }
        }
    }

    private static boolean isArea(AABox box) {
        return !theUtil.eq0(box.getWidth(), 1.0E-6) && !theUtil.eq0(box.getDepth(), 1.0E-6);
    }

    private void initTris() {
        if (this.d_tris != null) {
            return;
        }
        if (this.d_component != null && this.d_component.isDoor() || this.d_component == null && !OccSource.isArea(this.d_bounds)) {
            this.d_tris = new GeomChoice[0];
            return;
        }
        if (this.d_component != null) {
            this.d_tris = new GeomChoice[this.d_component.getMesh().size()];
            int ix = 0;
            for (Tri t : this.d_component.getMesh()) {
                this.d_tris[ix++] = new GeomChoice(t);
            }
        } else {
            this.d_tris = theUtil.toArray(OccSource.getRegionTris(this.d_kb, this.d_bounds), GeomChoice.class);
        }
        if (this.d_tris.length == 0) {
            this.d_kb.getParams().err.printf("[b9a8f] Could not generate triangles for occupant source%n", new Object[0]);
        }
        OccSource.finalizeChoices(this.d_tris);
    }

    private void initLineSegments() {
        if (this.d_lineSegments != null) {
            return;
        }
        if (this.d_component != null && !this.d_component.isDoor() || this.d_component == null && OccSource.isArea(this.d_bounds)) {
            this.d_lineSegments = new GeomChoice[0];
            return;
        }
        if (this.d_component != null) {
            this.d_lineSegments = new GeomChoice[this.d_component.getDoorEdges().size()];
            int ix = 0;
            for (WingedEdge edge : this.d_component.getDoorEdges()) {
                this.d_lineSegments[ix++] = new GeomChoice(edge);
            }
        } else {
            this.d_lineSegments = theUtil.toArray(OccSource.getRegionLineSegments(this.d_kb, this.d_bounds), GeomChoice.class);
        }
        if (this.d_lineSegments.length == 0) {
            this.d_kb.getParams().err.printf("[a83f4] Could not generate line segments for occupant source%n", new Object[0]);
        }
        OccSource.finalizeChoices(this.d_lineSegments);
    }

    private static void finalizeChoices(GeomChoice[] choices) {
        double totSize = 0.0;
        for (GeomChoice tc : choices) {
            totSize += tc.size;
        }
        double its = 1.0 / totSize;
        double size = 0.0;
        for (GeomChoice tc : choices) {
            tc.size = size += tc.size * its;
        }
    }

    private Point3d[] sampleTri() {
        return OccSource.sampleGeom(this.d_occCreatorRand, this.d_tris);
    }

    private Point3d[] sampleLineSeg() {
        return OccSource.sampleGeom(this.d_occCreatorRand, this.d_lineSegments);
    }

    private static Point3d[] sampleGeom(Random random, GeomChoice[] choices) {
        if (choices.length == 0) {
            return null;
        }
        GeomChoice finder = new GeomChoice(0.0, new Point3d[0]);
        finder.size = random.nextDouble();
        int ix = Arrays.binarySearch(choices, finder);
        if (ix < 0) {
            ix = -1 - ix;
        }
        return choices[ix].geom;
    }

    private Point3d samplePointInTri(Point3d[] tri) {
        Point3d loc = new Point3d();
        double r1 = this.d_occCreatorRand.nextDouble();
        double r2 = this.d_occCreatorRand.nextDouble();
        double c1 = 1.0 - Math.sqrt(r1);
        double c2 = Math.sqrt(r1) * (1.0 - r2);
        double c3 = Math.sqrt(r1) * r2;
        double x = c1 * tri[0].x + c2 * tri[1].x + c3 * tri[2].x;
        double y = c1 * tri[0].y + c2 * tri[1].y + c3 * tri[2].y;
        double z = c1 * tri[0].z + c2 * tri[1].z + c3 * tri[2].z;
        loc.set(x, y, z);
        return loc;
    }

    private static void isectAABoxTris(AABox bounds, List<Tri> tris, Consumer<Face> result) {
        int[] boxid = new int[]{10463731};
        try {
            Model model = new Model();
            boolean added = false;
            for (Tri tri : tris) {
                added |= model.addPolygonFace(0, new Plane3d(tri.plane.x, tri.plane.y, tri.plane.z, tri.plane.w), tri.v[0].p, tri.v[1].p, tri.v[2].p);
            }
            if (!added) {
                return;
            }
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                if (plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList())) continue;
                return;
            }
            for (Face eface : model.getFaces(0)) {
                Point3d tp = model.findPointInFace(eface);
                if (tp == null || !bounds.contains(tp, 1.0E-6)) continue;
                result.accept(eface);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void isectAABoxFacesTri(AABox bounds, Tri tri, Consumer<Edge> result) {
        int[] boxid = new int[]{10463731};
        try {
            Model model = new Model();
            if (!model.addPolygonFace(0, new Plane3d(tri.plane.x, tri.plane.y, tri.plane.z, tri.plane.w), tri.v[0].p, tri.v[1].p, tri.v[2].p)) {
                return;
            }
            boolean anyAdded = false;
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                anyAdded |= plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList());
            }
            if (!anyAdded) {
                return;
            }
            IntPredicate gtest = g -> g != boxid[0];
            for (Edge edge : model.getEdges(boxid[0])) {
                if (!NmtUtil.testGroups(edge.groups, gtest)) continue;
                result.accept(edge);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static List<GeomChoice> getRegionTris(KB kb, AABox region) {
        if (!region.isValid()) {
            return Collections.emptyList();
        }
        List<Tri> tris = kb.getMesh().findTris(new AABoxTest(region, 1.0E-6), TRI_FILTER);
        LinkedHashMap<Point3d, Integer> pmap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> resultTris = new ArrayList<Integer>();
        ArrayList faces = new ArrayList();
        OccSource.isectAABoxTris(region, tris, faces::add);
        for (Face face : faces) {
            try {
                if (face.triangulate(Face.NO_REFINEMENT, pmap, resultTris)) continue;
                LOGGER.log(Level.SEVERE, "[0xab98f] Couldn't triangulate part of occ source region");
            }
            catch (Throwable t) {
                TeciLogging.log(LOGGER, t);
            }
        }
        ArrayList points = new ArrayList(pmap.keySet());
        ArrayList<GeomChoice> result = new ArrayList<GeomChoice>();
        int m = 0;
        while (m < resultTris.size()) {
            Point3d[] t = new Point3d[3];
            for (int n = 0; n < 3; ++n) {
                t[n] = (Point3d)points.get((Integer)resultTris.get(m++));
            }
            double area = Util3D.simplePolygonArea(Arrays.asList(t));
            result.add(new GeomChoice(area, t));
        }
        return result;
    }

    private static List<GeomChoice> getRegionLineSegments(KB kb, AABox region) {
        if (!region.isValid()) {
            return Collections.emptyList();
        }
        List<Tri> tris = kb.getMesh().findTris(new AABoxTest(region, 1.0E-6), TRI_FILTER);
        ArrayList<GeomChoice> resultEdges = new ArrayList<GeomChoice>();
        for (Tri tri : tris) {
            ArrayList edges = new ArrayList();
            OccSource.isectAABoxFacesTri(region, tri, edges::add);
            for (Edge edge : edges) {
                resultEdges.add(new GeomChoice(edge.v1.loc.distance(edge.v2.loc), edge.v1.loc, edge.v2.loc));
            }
        }
        return resultEdges;
    }

    public IProgressNote getProgress(KB kb) {
        if (this.isFinished(kb.getCurrentSimTime())) {
            return IProgressNote.PROGRESSING;
        }
        return this.d_stuck ? IProgressNote.NOT_PROGRESSING : IProgressNote.PROGRESSING;
    }

    public ANode getComponent() {
        return this.d_component;
    }

    public IUrn<OccProfileSim> getProfileUrn() {
        return this.d_profUrn;
    }

    public IUrn<BehaviorSim> getBehaviorUrn() {
        return this.d_behaviorUrn;
    }

    public boolean isEnforceFlowrate() {
        return this.d_enforceFlowrate;
    }

    public IUrn<OccGroupType> getGroupUrn() {
        return this.d_groupUrn;
    }

    private static /* synthetic */ int lambda$releaseOccupant$327(Pair l1, Pair l2) {
        return Double.compare((Double)l1.v2, (Double)l2.v2);
    }

    public static class GeomChoice
    implements Serializable,
    Comparable<GeomChoice> {
        static final long serialVersionUID = 1L;
        public final Point3d[] geom;
        public double size;

        public GeomChoice(Tri t) {
            this(t.getArea(), t.v[0].p, t.v[1].p, t.v[2].p);
        }

        public GeomChoice(WingedEdge door) {
            this(door.base.n1.p.distance(door.base.n2.p), door.base.n1.p, door.base.n2.p);
        }

        public GeomChoice(double area, Point3d ... geom) {
            this.geom = geom;
            this.size = area;
        }

        @Override
        public int compareTo(GeomChoice o) {
            return Double.compare(this.size, o.size);
        }
    }
}

