/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.value.IFunction1d;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.Param;
import java.io.Serializable;

public interface IDoorFlowrate {
    public static final SpecificFlow SPECIFIC_FLOW = new SpecificFlow();
    public static final Fixed UNLIMITED = new Fixed(Double.POSITIVE_INFINITY);
    public static final SFPEFromDensity SFPE_FROM_DENSITY = new SFPEFromDensity();
    public static final SFPESpecificFlow SFPE_SPECIFIC_FLOW = new SFPESpecificFlow();

    public double getMaxFlowrate(KB var1, DoorQueue var2, DoorDir var3);

    public boolean isFinite(KB var1);

    public static class SFPEFromDensity
    implements IDoorFlowrate,
    Serializable {
        static final long serialVersionUID = 1L;
        private static final IFunction1d SFPE = KnownFuncs.getSFPEFundamentalDiagram(0.0);

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SFPEFromDensity;
        }

        @Override
        public boolean isFinite(KB kb) {
            return true;
        }

        @Override
        public double getMaxFlowrate(KB kb, DoorQueue queue, DoorDir dir) {
            if (queue.isExitDoor() && dir != DoorDir.getExitDir(queue.getNode())) {
                return 0.0;
            }
            double effWidth = queue.getEffWidth();
            if (effWidth == 0.0) {
                return 0.0;
            }
            ANode prevRoom = queue.src(dir);
            double density = (double)prevRoom.getCorrespondingNumOccupants() / prevRoom.getArea();
            Param p = kb.getParams();
            density = Math.max(density, p.door_flow_density_min);
            density = Math.min(density, p.door_flow_density_max);
            double k = KnownFuncs.kForNode(prevRoom);
            double specFlow = KnownFuncs.getSpecificFlow(density, k, SFPE);
            return specFlow * effWidth;
        }
    }

    public static class SFPESpecificFlow
    implements IDoorFlowrate,
    Serializable {
        static final long serialVersionUID = 1L;
        private static final IFunction1d SFPE = KnownFuncs.getSFPEFundamentalDiagram(0.0);
        private static final double MAX_DENSITY = 1.8796992481203008;

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SFPESpecificFlow;
        }

        @Override
        public boolean isFinite(KB kb) {
            return true;
        }

        @Override
        public double getMaxFlowrate(KB kb, DoorQueue queue, DoorDir dir) {
            if (queue.isExitDoor() && dir != DoorDir.getExitDir(queue.getNode())) {
                return 0.0;
            }
            double effWidth = queue.getEffWidth();
            if (effWidth == 0.0) {
                return 0.0;
            }
            ANode prevRoom = queue.src(dir);
            double k = KnownFuncs.kForNode(prevRoom);
            double specFlow = KnownFuncs.getSpecificFlow(1.8796992481203008, k, SFPE);
            return specFlow * effWidth;
        }
    }

    public static class SpecificFlow
    implements IDoorFlowrate,
    Serializable {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SpecificFlow;
        }

        @Override
        public double getMaxFlowrate(KB kb, DoorQueue queue, DoorDir dir) {
            return kb.getParams().specific_flowrate_max * queue.getEffWidth();
        }

        @Override
        public boolean isFinite(KB kb) {
            return !Double.isInfinite(kb.getParams().specific_flowrate_max);
        }
    }

    public static class Fixed
    implements IDoorFlowrate,
    Serializable {
        static final long serialVersionUID = 1L;
        public final double flowrate;

        public Fixed(double flowrate) {
            this.flowrate = flowrate;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Fixed && ((Fixed)obj).flowrate == this.flowrate;
        }

        @Override
        public double getMaxFlowrate(KB kb, DoorQueue queue, DoorDir dir) {
            return this.flowrate;
        }

        @Override
        public boolean isFinite(KB kb) {
            return !Double.isInfinite(this.flowrate);
        }
    }
}

