/*
 * Decompiled with CFR 0.152.
 */
package inferno.finite;

import java.util.Map;
import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import javax.vecmath.Point3d;

public class T3 {
    public static GMatrix getK(Point3d n1, Point3d n2, Point3d n3) {
        GMatrix b = T3.getB(n1, n2, n3);
        GMatrix k = new GMatrix(3, 3);
        k.mulTransposeLeft(b, b);
        GMatrix detJScale = new GMatrix(3, 3);
        detJScale.setScale(T3.detJ(n1, n2, n3) / 2.0);
        k.mul(detJScale);
        return k;
    }

    public static GVector getF(Point3d n1, Point3d n2, Point3d n3) {
        double f = T3.detJ(n1, n2, n3) / 6.0;
        double[] fvector = new double[]{f, f, f};
        return new GVector(fvector, 3);
    }

    public static void addKToGlobal(GMatrix k, GMatrix elemK, Point3d[] elemVerts, Map<Point3d, Integer> vertToDof) {
        for (int i = 0; i < 3; ++i) {
            if (!vertToDof.containsKey(elemVerts[i])) continue;
            int row = vertToDof.get(elemVerts[i]);
            for (int j = 0; j < 3; ++j) {
                if (!vertToDof.containsKey(elemVerts[j])) continue;
                int col = vertToDof.get(elemVerts[j]);
                double coef = k.getElement(row, col);
                k.setElement(row, col, coef + elemK.getElement(i, j));
            }
        }
    }

    public static void addFToGlobal(GVector f, GVector elemF, Point3d[] elemVerts, Map<Point3d, Integer> vertToDof) {
        for (int i = 0; i < 3; ++i) {
            if (!vertToDof.containsKey(elemVerts[i])) continue;
            int row = vertToDof.get(elemVerts[i]);
            double coef = f.getElement(row);
            f.setElement(row, coef + elemF.getElement(i));
        }
    }

    private static GMatrix getB(Point3d n1, Point3d n2, Point3d n3) {
        double[] jCoef = new double[]{n1.x - n3.x, n1.y - n3.y, n2.x - n3.x, n2.y - n3.y};
        GMatrix j = new GMatrix(2, 2, jCoef);
        GMatrix jInv = new GMatrix(2, 2);
        jInv.invert(j);
        GMatrix b = new GMatrix(2, 3);
        b.setElement(0, 0, jInv.getElement(0, 0));
        b.setElement(0, 1, jInv.getElement(0, 1));
        b.setElement(0, 2, -jInv.getElement(0, 0) - jInv.getElement(0, 1));
        b.setElement(1, 0, jInv.getElement(1, 0));
        b.setElement(1, 1, jInv.getElement(1, 1));
        b.setElement(1, 2, -jInv.getElement(1, 0) - jInv.getElement(1, 1));
        return b;
    }

    private static double detJ(Point3d n1, Point3d n2, Point3d n3) {
        return (n1.x - n3.x) * (n2.y - n3.y) - (n2.x - n3.x) * (n1.y - n3.y);
    }
}

