/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.seekarea;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.RoomGoal;
import inferno.data2.seekarea.ASeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ASeek;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.SeekPathAwayFromDoors;
import inferno.sim.steering.inverse.WanderRoom;
import inferno.sim.steering.inverse.WanderRoomSafe;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public class RoomSeekArea
extends ASeekArea {
    private static final long serialVersionUID = 1L;
    public final Collection<ANode> rooms;

    public RoomSeekArea(Collection<ANode> rooms) {
        this(rooms, 2);
    }

    public RoomSeekArea(Collection<ANode> rooms, int options) {
        super(options);
        this.rooms = rooms;
    }

    @Override
    public boolean isEqual(ISeekArea obj) {
        if (obj == this) {
            return true;
        }
        if (!super.isEqual(obj)) {
            return false;
        }
        RoomSeekArea rsa = (RoomSeekArea)obj;
        return GoalUtil.setsEqual(this.rooms, rsa.rooms);
    }

    @Override
    public ISteeringBehavior getIdleSteer(KB kb, OccAgent agent) {
        return SteerUtil.newIdleSteer(kb, agent, () -> this.getIdleSeek(kb, agent), () -> this.getSfpeBackupPoint(kb, agent));
    }

    protected ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
        boolean avoidAllDoors = false;
        if (occ.getOcc().requiresAssistance) {
            BehaviorSim.BehaviorInProgress behavior = occ.getOcc().behaviorStack.peek();
            for (int m = behavior.goalIndex + 1; m < behavior.behavior.size(); ++m) {
                IGoal goal = behavior.behavior.get(m);
                if (goal instanceof DetachGoal) {
                    avoidAllDoors = true;
                    break;
                }
                if (goal instanceof ChangeBehaviorGoal) {
                    for (BehaviorSim b : ((ChangeBehaviorGoal)goal).getAllTargetBehaviors()) {
                        if (b.deepContainsAny(ISeekGoal.class)) break;
                    }
                    continue;
                }
                if (goal instanceof ISeekGoal) break;
            }
        }
        return this.getIdleSeek(kb, occ, avoidAllDoors);
    }

    protected ISeekCalc getIdleSeek(KB kb, OccAgent occ, boolean avoidAllDoors) {
        Predicate<ANode> wanderFilter = r -> r.getRadiusModifier() != null && r.getRadiusModifier() == 0.0 && r.getMaxOccupants() != Integer.MAX_VALUE;
        ASeek wander = this.rooms.stream().anyMatch(wanderFilter) ? new WanderRoom(kb, occ, this.rooms, false) : new SeekPathAwayFromDoors(kb, occ, avoidAllDoors);
        IPathPlanner backupPlanner = new RoomGoal(this.rooms).getPathPlanner(kb, occ);
        if (occ.getOcc().occupantGroup == null) {
            return new WanderRoomSafe(wander, this.rooms, backupPlanner);
        }
        return new RegroupPlanner.RegroupPlannerWanderRoomSafe(occ, kb, wander, this.rooms, backupPlanner);
    }

    @Override
    public Collection<ANode> getDestinationRooms() {
        return this.rooms;
    }

    @Override
    public boolean isUrgent(KB kb, OccAgent occ) {
        if (super.isUrgent(kb, occ)) {
            return true;
        }
        for (ANode node : this.rooms) {
            if (node.getElevatorLevel() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public TriPoint getDestinationLoc(KB kb, OccAgent occ) {
        return null;
    }

    protected Pair<ITpSource, Vector3d> getSfpeBackupPoint(KB kb, OccAgent occ) {
        Supplier<ANode> getRoom = () -> {
            if (this.rooms.contains(occAgent.getOcc().curNode)) {
                return occAgent.getOcc().curNode;
            }
            return this.rooms.iterator().next();
        };
        ANode seekRoom = getRoom.get();
        List<Tri> tris = seekRoom.getMesh();
        if (tris.isEmpty()) {
            return new Pair<TriPoint, Object>(occ.getLoc(), null);
        }
        Tri tri = tris.get(0);
        return new Pair<TriPoint, Object>(new TriPoint(tri, tri.center), null);
    }

    @Override
    public boolean contains(KB kb, TriPoint p) {
        return this.rooms.contains(p.tri.node);
    }
}

