/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.seekarea;

import inferno.data2.ANode;
import inferno.data2.OccTarget;
import inferno.data2.TriPoint;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.OccTargetGoal;
import inferno.data2.seekarea.ASeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.OccTargetSteeringBehavior;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OccTargetsSeekArea
extends ASeekArea {
    private static final long serialVersionUID = 1L;
    public final OccTargetGoal.DistancePref distPref;
    public final OccTargetGoal.PriorityPref priorityPref;
    public final List<OccTarget> targets;
    private OccTargetSteeringBehavior d_behavior;

    public OccTargetsSeekArea(OccTargetGoal.DistancePref distPref, OccTargetGoal.PriorityPref priorityPref, List<OccTarget> targets, int options) {
        super(options);
        this.distPref = distPref;
        this.priorityPref = priorityPref;
        this.targets = targets;
    }

    @Override
    public boolean isEqual(ISeekArea obj) {
        if (obj == this) {
            return true;
        }
        if (!super.isEqual(obj)) {
            return false;
        }
        OccTargetsSeekArea tsa = (OccTargetsSeekArea)obj;
        return tsa.distPref == this.distPref && tsa.priorityPref == this.priorityPref && GoalUtil.setsEqual(tsa.targets, this.targets);
    }

    @Override
    public OccTargetSteeringBehavior getIdleSteer(KB kb, OccAgent occ) {
        this.d_behavior = new OccTargetSteeringBehavior(kb, occ, this.distPref, this.priorityPref, this.targets);
        return this.d_behavior;
    }

    @Override
    public Collection<ANode> getDestinationRooms() {
        return Collections.emptyList();
    }

    @Override
    public TriPoint getDestinationLoc(KB kb, OccAgent occ) {
        if (this.d_behavior == null) {
            return null;
        }
        OccTarget target = this.d_behavior.getCurrentTarget();
        if (target != null) {
            return target.location;
        }
        return null;
    }

    @Override
    public boolean contains(KB kb, TriPoint p) {
        if (this.d_behavior == null) {
            return false;
        }
        OccTarget target = this.d_behavior.getCurrentTarget();
        if (target != null) {
            return target.asSeekArea().contains(kb, p);
        }
        return false;
    }
}

