/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class WaitUntilInsideGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private final Collection<ANode> d_goals;

    public WaitUntilInsideGoal(Collection<ANode> goals) {
        this.d_goals = goals;
    }

    public int hashCode() {
        return 0x224221 + GoalUtil.setHashCode(this.d_goals);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitUntilInsideGoal && GoalUtil.setsEqual(this.d_goals, ((WaitUntilInsideGoal)obj).d_goals);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public Collection<ANode> getGoals() {
        return this.d_goals;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private WaitUntilInsideGoal waitUntilInsideGoal;
        private ANode d_reachedNode;

        public Instance(WaitUntilInsideGoal waitUntilInsideGoal) {
            this.waitUntilInsideGoal = waitUntilInsideGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.waitUntilInsideGoal;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public ISeekArea update(KB kb, OccAgent agent) {
            if (this.waitUntilInsideGoal.d_goals.contains(agent.getOcc().curNode)) {
                this.d_reachedNode = agent.getOcc().curNode;
            }
            return null;
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            if (this.d_reachedNode != null) {
                return new RoomSeekArea(Collections.singleton(this.d_reachedNode));
            }
            return null;
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            if (this.d_reachedNode != null) {
                return null;
            }
            return IIdleGoalInstance.super.getIdleInfo(kb, agent);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.d_reachedNode != null;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            assert (this.d_reachedNode != null);
            return this.getSeekArea(kb, occ);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

