/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.AttachToAgentGoal;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.PassiveModeGoal;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.simple.WaitInPlace;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;

public class WaitForAssistanceGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 37965232822695345L;
    public final Set<AssistedEvacTeam> teams;

    public WaitForAssistanceGoal(AssistedEvacTeam ... teams) {
        this(Sets.fromArrayLIHS(teams));
    }

    public WaitForAssistanceGoal(Collection<AssistedEvacTeam> teams) {
        this.teams = teams instanceof Set ? (Set<Object>)teams : new LinkedIdentityHashSet<AssistedEvacTeam>(teams);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitForAssistanceGoal && ((WaitForAssistanceGoal)obj).teams.equals(this.teams);
    }

    public int hashCode() {
        return 0x1F332FE ^ this.teams.hashCode();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        AssistedEvacTeam.AssistInfo info = this.getInfo(kb, agent);
        for (AssistedEvacTeam team : this.teams) {
            team.addClient(info);
        }
        return new Instance(this);
    }

    private AssistedEvacTeam.AssistInfo getInfo(KB kb, OccAgent agent) {
        AttachToAgentGoal g1 = new AttachToAgentGoal(agent, kb);
        PassiveModeGoal g2 = new PassiveModeGoal(agent, kb);
        return new AssistedEvacTeam.AssistInfo(agent, g1, g2);
    }

    public static class Instance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private WaitForAssistanceGoal waitForAssistanceGoal;

        public Instance(WaitForAssistanceGoal waitForAssistanceGoal) {
            this.waitForAssistanceGoal = waitForAssistanceGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            return WaitInPlace.INSTANCE;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.waitForAssistanceGoal;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (occ.getAssistedEvacClientModule().isPresent()) {
                return occ.getAssistedEvacClientModule().get().isFullyOccupied();
            }
            return false;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IProgressNote.NOT_PROGRESSING;
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

