/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.PointSeekArea;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.steering.ISteeringBehavior;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import thunderheadeng.util.Pair;

public interface IGoalInstance {
    public static final IdleInfo UNKNOWN_IDLE_STATUS = new IdleInfo(Double.POSITIVE_INFINITY);

    public IGoal getGoal();

    default public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
        return false;
    }

    public ISteeringBehavior generateSteeringBehavior(KB var1, OccAgent var2);

    public boolean isReached(KB var1, OccAgent var2);

    public ISeekArea end(KB var1, OccAgent var2);

    default public boolean isSeeking(KB kb, OccAgent agent) {
        return this.getIdleInfo(kb, agent) == null;
    }

    public IdleInfo getIdleInfo(KB var1, OccAgent var2);

    public ISeekArea getSeekArea(KB var1, OccAgent var2);

    public IProgressNote getProgress(KB var1, OccAgent var2);

    public void doorCrossed(OccAgent var1, DoorQueue var2);

    default public void preMove(KB kb, OccAgent agent, double dt) {
    }

    default public ISeekArea update(KB kb, OccAgent agent) {
        return null;
    }

    default public void processLost(KB kb, OccAgent agent) {
    }

    default public boolean isAlwaysTerminal() {
        return false;
    }

    default public boolean wasImmediate() {
        return this.getGoal().isImmediate();
    }

    public boolean canInterrupt(KB var1, OccAgent var2);

    default public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
        RoomSeekArea area = null;
        if (this.isSeeking(kb, agent)) {
            area = IGoalInstance.getCurrentAreaAsRoom(kb, agent);
        }
        return new Pair<RoomSeekArea, Object>(area, null);
    }

    default public boolean resume(KB kb, OccAgent agent, Object resumePacket) {
        return false;
    }

    public static IdleInfo idleStatus(double endTime) {
        return new IdleInfo(endTime);
    }

    public static IdleInfo unknownIdleStatus() {
        return UNKNOWN_IDLE_STATUS;
    }

    public static PointSeekArea getCurrentAreaAsPoint(KB kb, OccAgent agent) {
        return new PointSeekArea(agent.getLoc(), 0.5, 0);
    }

    public static RoomSeekArea getCurrentAreaAsRoom(KB kb, OccAgent agent) {
        ISeekArea currArea = AiUtil.getCurrentSeekArea(kb, agent);
        ANode currRoom = agent.getOcc().curNode;
        Collection<ANode> rooms = currArea.getDestinationRooms().contains(currRoom) ? currArea.getDestinationRooms() : Collections.singleton(currRoom);
        return new RoomSeekArea(rooms);
    }

    public static class IdleInfo {
        public final double idleEndTime;

        public IdleInfo(double idleEndTime) {
            this.idleEndTime = idleEndTime;
        }
    }
}

