/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.TriPoint;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.AttachToAgentGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.PassiveModeGoal;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.PointSeekArea;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.geom.Util;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.path.PathGen;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.simple.Arrive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;

public class AssistOccupantsGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final AssistedEvacTeam team;

    public AssistOccupantsGoal(AssistedEvacTeam team) {
        this.team = team;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AssistOccupantsGoal && ((AssistOccupantsGoal)obj).team == this.team;
    }

    public int hashCode() {
        return 0x6384FE ^ System.identityHashCode(this.team);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this, kb, agent);
    }

    public static class Instance
    implements ISeekGoalInstance,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final AssistOccupantsGoal d_goal;
        private static final PrintState PRINT_STATE = PrintState.NONE;
        private static final double CALC_STEP = 1.0;
        private AssistSingleOccupantGoal currentGoal;
        private PriorityQueue<AssistSingleOccupantGoal> goals;
        private KB kb;
        private OccAgent agent;
        private boolean isFinished = false;
        private boolean isWaiting = false;
        private boolean needsNewSteering;
        private boolean checkingReservation;
        private AssistedEvacClientAgent goToAgent;
        private AssistSingleOccupantGoal newCurrentGoal;
        private Map<OccAgent, Double> distanceMap;
        private AssistSingleOccupantGoal toReserveGoal;
        private OccAgent toCancelReservation;
        private AssistedEvacClientAgent toAttachToAgent;
        private boolean includesSingleAgentGoals = true;
        private ArrayList<AssistSingleOccupantGoal> teamGoals;
        private boolean teamIsFinished;
        private ISteeringBehavior waitGoalBehavior;
        private ANode d_waitingRoom;
        private ArrayList<AssistSingleOccupantGoal> myReservations;
        private boolean endCurrentGoal = false;
        private boolean turnPassive = false;
        private Pair<Point3d, ISteeringBehavior> idleSeek;
        private double nextCalcTime = Double.NEGATIVE_INFINITY;

        public Instance(AssistOccupantsGoal goal, KB kb, OccAgent agent) {
            this.d_goal = goal;
            this.kb = kb;
            this.agent = agent;
            this.distanceMap = new IdentityHashMap<OccAgent, Double>();
            this.teamGoals = new ArrayList();
            this.myReservations = new ArrayList();
            this.goals = new PriorityQueue();
            this.d_waitingRoom = agent.getOcc().curNode;
            this.d_goal.team.addAssistant(agent);
        }

        @Override
        public AssistOccupantsGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        private void addGoal(AssistSingleOccupantGoal g) {
            assert (!this.goals.contains(g));
            this.goals.add(g);
        }

        private void addManyGoals(Collection<AssistSingleOccupantGoal> g) {
            assert (!Util.containsAny(this.goals, g));
            this.goals.addAll(g);
        }

        private void addTeamGoal(AssistSingleOccupantGoal g) {
            assert (!this.teamGoals.contains(g));
            this.teamGoals.add(g);
        }

        private void addManyTeamGoals(Collection<AssistSingleOccupantGoal> g) {
            assert (!Util.containsAny(this.teamGoals, g));
            this.teamGoals.addAll(g);
        }

        public void addGoals(Collection<AssistedEvacTeam.AssistInfo> assistInfo) {
            if (assistInfo.isEmpty()) {
                return;
            }
            for (AssistedEvacTeam.AssistInfo ainfo : assistInfo) {
                AssistSingleOccupantGoal g = new AssistSingleOccupantGoal(this.d_goal.team, ainfo, this.agent, this.kb);
                this.addGoal(g);
            }
            this.isFinished = false;
            this.isWaiting = false;
            this.teamIsFinished = false;
        }

        public void removeGoals(Collection<OccAgent> agents) {
            Set<Object> agentSet = agents instanceof Set ? (Set<Object>)agents : new IdentityHashSet<OccAgent>(agents);
            Predicate<AssistSingleOccupantGoal> removeCond = g -> agentSet.contains(((AssistSingleOccupantGoal)g).getGoToAgent());
            this.goals.removeIf(removeCond);
            this.teamGoals.removeIf(removeCond);
            this.myReservations.removeIf(removeCond);
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            if (this.isWaiting()) {
                if (this.waitGoalBehavior == null) {
                    this.waitGoalBehavior = kb.getParams().reactive_steering ? new RoomSeekArea(Collections.singleton(this.d_waitingRoom)).getIdleSteer(kb, occ) : new Arrive(occ.getLoc(), null);
                }
                return this.waitGoalBehavior;
            }
            if (this.currentGoal == null) {
                if (this.idleSeek == null || !((Point3d)this.idleSeek.v1).epsilonEquals(occ.getPos(), 1.0E-6)) {
                    if (this.idleSeek != null && this.idleSeek.v2 != null) {
                        ((ISteeringBehavior)this.idleSeek.v2).done(kb, occ, false);
                    }
                    this.idleSeek = new Pair<Point3d, ISteeringBehavior>(occ.getPos(), new PointSeekArea(occ.getLoc(), 1.0, 0).getIdleSteer(kb, occ));
                }
                return (ISteeringBehavior)this.idleSeek.v2;
            }
            return this.currentGoal.getCurrentGoal().generateSteeringBehavior(kb, occ);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.isFinished && this.teamIsFinished;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            this.d_goal.team.removeAssistant(occ);
            this.printState(() -> "Agent " + occAgent.getOcc().name + " finished assisting occupants");
            return this.getSeekArea(kb, occ);
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            if (this.isWaiting()) {
                return IGoalInstance.unknownIdleStatus();
            }
            return null;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            if (this.currentGoal == null) {
                return this.isWaiting ? IProgressNote.PROGRESSING : IProgressNote.NOT_PROGRESSING;
            }
            if (this.currentGoal.state.equals((Object)AssistSingleOccupantGoalState.PASSIVE_MODE)) {
                return IProgressNote.NOT_PROGRESSING;
            }
            return this.currentGoal.attachToAgentGoalInstance.getProgress(kb, occ);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            this.distanceMap.clear();
            if (this.toReserveGoal != null) {
                if (this.toCancelReservation != null) {
                    this.cancelReservation(this.toCancelReservation);
                    this.toCancelReservation = null;
                }
                this.makeReservation(this.toReserveGoal);
                return;
            }
            if (this.toAttachToAgent != null) {
                if (this.toAttachToAgent.attachAgent(agent, this.currentGoal.getAttachPoint())) {
                    this.printState(() -> "vehicle " + this.toAttachToAgent + " attached to agent " + occAgent.getOcc().name);
                }
                this.toAttachToAgent = null;
            }
            if (this.currentGoal != null) {
                this.currentGoal.getCurrentGoal().preMove(kb, agent, dt);
                if (this.currentGoal.state.equals((Object)AssistSingleOccupantGoalState.ATTACH_TO_AGENT) && this.currentGoal.getCurrentGoal().isReached(kb, agent)) {
                    this.printState(() -> "agent " + occAgent.getOcc().name + " is attached to " + ((AssistSingleOccupantGoal)this.currentGoal).getGoToAgent().getOcc().name + ", turn passive mode on");
                    this.endCurrentGoal = true;
                    this.turnPassive = true;
                }
                if (this.currentGoal.isReached(kb, agent)) {
                    this.endCurrentGoal = true;
                }
            } else {
                this.getNewCurrentGoal();
            }
        }

        private void printState(Supplier<String> message) {
            if (PRINT_STATE == PrintState.ALL || PRINT_STATE == PrintState.SELECTED && this.agent.isSelected()) {
                System.out.println(this.kb.getCurrentSimTime() + "\t" + message.get());
            }
        }

        @Override
        public ISeekArea update(KB kb, OccAgent agent) {
            boolean beforeIdling = this.isWaiting();
            Supplier<ISeekArea> getEndSeekArea = () -> {
                boolean nowIdling = this.isWaiting();
                if (nowIdling && !beforeIdling) {
                    return IGoalInstance.getCurrentAreaAsRoom(kb, agent);
                }
                return null;
            };
            if (!this.isFinished && this.currentGoal == null && this.goals.isEmpty()) {
                if (this.d_goal.team.isFinished()) {
                    this.isFinished = true;
                } else {
                    this.isWaiting = true;
                }
                this.needsNewSteering = true;
                if (this.teamGoals.isEmpty()) {
                    return getEndSeekArea.get();
                }
            }
            if (this.endCurrentGoal) {
                this.currentGoal.getCurrentGoal().end(kb, agent);
                this.endCurrentGoal = false;
                this.needsNewSteering = true;
                if (this.turnPassive) {
                    this.currentGoal.state = AssistSingleOccupantGoalState.PASSIVE_MODE;
                    this.turnPassive = false;
                    this.toAttachToAgent = this.goToAgent;
                    this.checkingReservation = false;
                    this.printState(() -> "Agent" + occAgent.getOcc().name + " turning passive");
                } else {
                    this.goals.remove(this.currentGoal);
                    this.d_goal.team.removeClient(this.currentGoal.getGoToAgent());
                    this.setWaitingRoom(((AssistSingleOccupantGoal)this.currentGoal).getGoToAgent().getOcc().curNode, agent);
                    this.printState(() -> "Agent" + occAgent.getOcc().name + " turning active again after: " + ((AssistSingleOccupantGoal)this.currentGoal).getGoToAgent().getOcc().name);
                    this.currentGoal = null;
                }
            }
            this.updateGoals();
            if (!this.goals.isEmpty()) {
                this.isFinished = false;
            }
            if (this.isFinished) {
                boolean teamIsFinished = true;
                for (AssistSingleOccupantGoal g : this.teamGoals) {
                    if (!g.getGoToAgent().getAssistedEvacClientModule().get().isFullyOccupied()) {
                        teamIsFinished = false;
                    }
                    if (this.shouldDetach(g) || g.getGoToAgent().getAssistedEvacClientModule().get().isFullyReserved()) continue;
                    this.isFinished = false;
                    this.toReserveGoal = g;
                }
                this.teamIsFinished = teamIsFinished;
                return getEndSeekArea.get();
            }
            if (this.checkingReservation) {
                Supplier<AssistSingleOccupantGoal> getSwitchToGoal;
                AssistSingleOccupantGoal nextGoal;
                this.printState(() -> "Agent " + occAgent.getOcc().name + " checking reservation: " + this.goToAgent.getOcc().name);
                AssistedEvacClientAgent.AttachmentTpSrc goToSpot = this.goToAgent.getReservedSpot(agent);
                if (goToSpot == null) {
                    this.needsNewSteering = true;
                    this.printState(() -> "Agent " + occAgent.getOcc().name + " no free spot at: " + this.goToAgent.getOcc().name);
                    return getEndSeekArea.get();
                }
                if (this.goToAgent.isPartiallyReserved() && (nextGoal = (getSwitchToGoal = () -> {
                    AssistSingleOccupantGoal nextGoal = this.findClosestPartiallyOccupiedGoal();
                    if (nextGoal == null) {
                        nextGoal = this.findClosestSingleAgentGoal();
                        if (nextGoal == null) {
                            this.printState(() -> "Agent " + occAgent.getOcc().name + " will assist a partially reserved agent: " + this.goToAgent.getOcc().name);
                            return null;
                        }
                        return nextGoal;
                    }
                    AssistSingleOccupantGoal ngoal = nextGoal;
                    this.printState(() -> "Agent " + occAgent.getOcc().name + " considering assisting: " + ((AssistSingleOccupantGoal)assistSingleOccupantGoal).getGoToAgent().getOcc().name);
                    int myMissing = this.goToAgent.getMissingAttachedAgentsCount();
                    int theirMissing = nextGoal.getGoToAgent().getAssistedEvacClientModule().get().getMissingAttachedAgentsCount();
                    if (theirMissing < myMissing || theirMissing == myMissing && nextGoal.getGoToAgent().getAssistedEvacClientModule().get().getAttachedAgentsCount() > this.goToAgent.getAttachedAgentsCount()) {
                        return nextGoal;
                    }
                    BiFunction<OccAgent, OccAgent, Double> getDistToClient = (oa, client) -> {
                        IGoalInstance ginst = AiUtil.getCurrentGoalInstance(oa);
                        assert (ginst instanceof Instance);
                        if (!(ginst instanceof Instance)) {
                            return Double.POSITIVE_INFINITY;
                        }
                        return ((Instance)ginst).getDistanceTo((OccAgent)client);
                    };
                    double myDistance = Double.MAX_VALUE;
                    for (OccAgent oa2 : this.goToAgent.getReservedSpots()) {
                        double d = getDistToClient.apply(oa2, nextGoal.getGoToAgent());
                        if (!(d < myDistance)) continue;
                        myDistance = d;
                    }
                    double theirDistance = Double.MAX_VALUE;
                    for (OccAgent oa3 : nextGoal.getGoToAgent().getAssistedEvacClientModule().get().getReservedSpots()) {
                        double d = getDistToClient.apply(oa3, this.goToAgent.getOccAgent());
                        if (!(d < theirDistance)) continue;
                        theirDistance = d;
                    }
                    double mdist = myDistance;
                    double tdist = theirDistance;
                    this.printState(() -> "Agent " + occAgent.getOcc().name + " my dist: " + mdist + " their dist: " + tdist);
                    if (myDistance < theirDistance || myDistance == theirDistance && nextGoal.getGoToAgent().getPriority(kb) > this.goToAgent.getOccAgent().getPriority(kb)) {
                        return nextGoal;
                    }
                    this.printState(() -> "Agent " + occAgent.getOcc().name + " will wait at " + this.goToAgent.getOcc().name);
                    return null;
                }).get()) != null) {
                    this.toReserveGoal = nextGoal;
                    this.toCancelReservation = this.goToAgent.getOccAgent();
                    this.printState(() -> "Agent " + occAgent.getOcc().name + " will switch to " + ((AssistSingleOccupantGoal)assistSingleOccupantGoal).getGoToAgent().getOcc().name);
                }
                if (this.toReserveGoal == null) {
                    this.needsNewSteering = true;
                    this.currentGoal = this.newCurrentGoal;
                    this.isWaiting = false;
                    this.goals.remove(this.currentGoal);
                    this.printState(() -> "Agent " + occAgent.getOcc().name + " assisting: " + ((AssistSingleOccupantGoal)this.currentGoal).getGoToAgent().getOcc().name + " at spot: " + goToSpot.getTriPoint());
                    this.checkingReservation = this.currentGoal.getGoToAgent().getAssistedEvacClientModule().get().isPartiallyReserved();
                } else if (this.currentGoal != null) {
                    this.currentGoal.reset();
                    assert (!this.teamGoals.contains(this.currentGoal));
                    this.addGoal(this.currentGoal);
                    this.currentGoal = null;
                }
            }
            return getEndSeekArea.get();
        }

        private AssistSingleOccupantGoal findClosestPartiallyOccupiedGoal() {
            AssistSingleOccupantGoal possibleNextGoal = null;
            ArrayList<AssistSingleOccupantGoal> temp = new ArrayList<AssistSingleOccupantGoal>();
            while (!this.goals.isEmpty()) {
                AssistSingleOccupantGoal g = this.goals.poll();
                OccAgent a = g.getGoToAgent();
                if (!a.equals(this.goToAgent.getOccAgent()) && a.getAssistedEvacClientModule().get().isPartiallyReserved()) {
                    possibleNextGoal = g;
                    temp.add(g);
                    break;
                }
                temp.add(g);
            }
            this.addManyGoals(temp);
            return possibleNextGoal;
        }

        private AssistSingleOccupantGoal findClosestSingleAgentGoal() {
            if (!this.includesSingleAgentGoals) {
                return null;
            }
            AssistSingleOccupantGoal possibleNextGoal = null;
            ArrayList<AssistSingleOccupantGoal> temp = new ArrayList<AssistSingleOccupantGoal>();
            while (!this.goals.isEmpty()) {
                AssistSingleOccupantGoal g = this.goals.poll();
                OccAgent a = g.getGoToAgent();
                if (!a.equals(this.goToAgent.getOccAgent()) && a.getAssistedEvacClientModule().get().getMissingReservationCount() == 1) {
                    possibleNextGoal = g;
                    temp.add(g);
                    break;
                }
                temp.add(g);
            }
            this.addManyGoals(temp);
            return possibleNextGoal;
        }

        private boolean isTeamGoal(AssistSingleOccupantGoal g) {
            return g.getGoToAgent().getAssistedEvacClientModule().get().isFullyReserved() || this.shouldDetach(g);
        }

        private void updateGoals() {
            AssistSingleOccupantGoal g;
            boolean includesSingleAgentGoals = false;
            ArrayList<AssistSingleOccupantGoal> newTeamGoals = new ArrayList<AssistSingleOccupantGoal>();
            Iterator<AssistSingleOccupantGoal> it = this.goals.iterator();
            while (it.hasNext()) {
                g = it.next();
                if (this.isTeamGoal(g)) {
                    it.remove();
                    if (!this.isClient(g)) continue;
                    newTeamGoals.add(g);
                    continue;
                }
                if (g.getGoToAgent().getAssistedEvacClientModule().get().getRequiredAttachedAgentsCount() != 1) continue;
                includesSingleAgentGoals = true;
            }
            this.includesSingleAgentGoals = includesSingleAgentGoals;
            it = this.teamGoals.iterator();
            while (it.hasNext()) {
                g = it.next();
                if (this.isTeamGoal(g)) continue;
                it.remove();
                this.addGoal(g);
            }
            this.addManyTeamGoals(newTeamGoals);
        }

        private boolean shouldDetach(AssistSingleOccupantGoal singleGoal) {
            return this.shouldDetach(singleGoal.getGoToAgent());
        }

        public boolean shouldDetach(OccAgent goToAgent) {
            return !this.isClient(goToAgent) || goToAgent.getAssistedEvacClientModule().isPresent() && goToAgent.getAssistedEvacClientModule().get().shouldDetach();
        }

        private boolean isClient(OccAgent goToAgent) {
            return this.d_goal.team.clients.containsKey(goToAgent);
        }

        private boolean isClient(AssistSingleOccupantGoal singleGoal) {
            return this.isClient(singleGoal.getGoToAgent());
        }

        private void getNewCurrentGoal() {
            if (this.goals.isEmpty()) {
                return;
            }
            this.calcDistances();
            AssistSingleOccupantGoal newGoal = this.goals.peek();
            this.makeReservation(newGoal);
        }

        private void makeReservation(AssistSingleOccupantGoal newGoal) {
            this.goToAgent = newGoal.ainfo.agent.getAssistedEvacClientModule().get();
            this.printState(() -> "Agent " + this.agent.getOcc().name + " reserving spot: " + this.goToAgent.getOcc().name);
            this.goToAgent.requestReservation(this.agent, this.getDistanceTo(this.goToAgent.getOccAgent()));
            this.myReservations.add(newGoal);
            this.checkingReservation = true;
            this.toReserveGoal = null;
            this.newCurrentGoal = newGoal;
        }

        private void cancelReservation(OccAgent goToAgent) {
            if (goToAgent.getAssistedEvacClientModule().get().cancelReservation(this.agent)) {
                this.printState(() -> "Agent " + this.agent.getOcc().name + " canceling reservation with " + occAgent.getOcc().name);
            }
        }

        private void calcDistances() {
            if (this.kb.getCurrentSimTime() < this.nextCalcTime) {
                return;
            }
            this.nextCalcTime = this.kb.getCurrentSimTime() + 1.0;
            PriorityQueue<AssistSingleOccupantGoal> newQueue = new PriorityQueue<AssistSingleOccupantGoal>();
            for (AssistSingleOccupantGoal g : new ArrayList<AssistSingleOccupantGoal>(this.goals)) {
                g.distance = this.getDistanceTo(g.getGoToAgent());
                newQueue.add(g);
            }
            this.goals = newQueue;
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            if (this.isWaiting()) {
                return null;
            }
            if (this.currentGoal == null) {
                return IGoalInstance.getCurrentAreaAsPoint(kb, occ);
            }
            return this.currentGoal.getCurrentGoal().getSeekArea(kb, occ);
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            if (this.needsNewSteering) {
                this.needsNewSteering = false;
                return true;
            }
            if (this.currentGoal == null) {
                return false;
            }
            return this.currentGoal.getCurrentGoal().needsNewSteeringBehavior(kb, occ);
        }

        public String toString() {
            if (this.currentGoal != null) {
                return this.currentGoal.toString();
            }
            return "Assist occupants: no current goal";
        }

        public Double getDistanceTo(OccAgent goToAgent) {
            return this.distanceMap.computeIfAbsent(goToAgent, a -> {
                TriPoint tp = new TriPoint(occAgent.getOcc().tri, occAgent.getOcc().loc);
                Shortest planner = new Shortest(new PathGen.PointGoal(tp), false);
                if (planner.getPath(this.kb, this.agent, true) == null) {
                    return Double.POSITIVE_INFINITY;
                }
                return planner.getPath(this.kb, this.agent, true).length(false);
            });
        }

        public boolean isWaiting() {
            return this.isWaiting || this.isFinished && !this.teamIsFinished;
        }

        private void reAddGoal(AssistSingleOccupantGoal g) {
            if (!this.goals.contains(g)) {
                this.teamGoals.remove(g);
                this.addGoal(g);
            } else assert (!this.teamGoals.contains(g));
        }

        @Override
        public void processLost(KB kb, OccAgent agent) {
            this.myReservations.forEach(r -> {
                this.cancelReservation(((AssistSingleOccupantGoal)r).getGoToAgent());
                this.reAddGoal((AssistSingleOccupantGoal)r);
            });
            this.currentGoal = null;
            this.setWaitingRoom(agent.getOcc().curNode, agent);
        }

        private void setWaitingRoom(ANode room, OccAgent agent) {
            ANode aNode = this.d_waitingRoom = room != null ? room : agent.getOcc().curNode;
            if (this.waitGoalBehavior != null) {
                this.waitGoalBehavior.done(this.kb, agent, false);
            }
            this.waitGoalBehavior = null;
        }

        public OccAgent getCurrentClient() {
            return this.currentGoal == null ? null : this.currentGoal.getGoToAgent();
        }

        private static enum PrintState {
            ALL,
            NONE,
            SELECTED;

        }

        public static enum AssistSingleOccupantGoalState {
            ATTACH_TO_AGENT,
            PASSIVE_MODE;

        }

        public static class AssistSingleOccupantGoal
        implements Serializable,
        Comparable<AssistSingleOccupantGoal> {
            private static final long serialVersionUID = -2265054545928777934L;
            public final AssistedEvacTeam team;
            public final AssistedEvacTeam.AssistInfo ainfo;
            private final int priority;
            private final KB kb;
            private final OccAgent agent;
            public double distance;
            private AttachToAgentGoal.AttachToAgentGoalInstance attachToAgentGoalInstance;
            private PassiveModeGoal.PassiveModeGoalInstance passiveModeGoalInstance;
            private AssistSingleOccupantGoalState state;
            private boolean isReachedByAny;

            public AssistSingleOccupantGoal(AssistedEvacTeam team, AssistedEvacTeam.AssistInfo ainfo, OccAgent agent, KB kb) {
                this.team = team;
                this.ainfo = ainfo;
                this.kb = kb;
                this.agent = agent;
                this.priority = team.clientOrder.getOrDefault(ainfo.agent.getId(), Integer.MAX_VALUE);
                this.reset();
            }

            private void reset() {
                this.distance = 0.0;
                this.attachToAgentGoalInstance = null;
                this.passiveModeGoalInstance = null;
                this.isReachedByAny = false;
                this.state = AssistSingleOccupantGoalState.ATTACH_TO_AGENT;
            }

            private OccAgent getGoToAgent() {
                return this.ainfo.agent;
            }

            private ITpSource getAttachPoint() {
                this.initAttachToAgentGoalInstance();
                return this.attachToAgentGoalInstance.getGoToAgentGoalInstance().getGoal().ptSrc;
            }

            private boolean isReached(KB kb, OccAgent occ) {
                switch (this.state) {
                    case ATTACH_TO_AGENT: {
                        return false;
                    }
                    case PASSIVE_MODE: {
                        this.initPassiveModeGoalInstance();
                        boolean ret = this.passiveModeGoalInstance.isReached(kb, occ);
                        if (ret) {
                            this.isReachedByAny = true;
                        }
                        return ret;
                    }
                }
                assert (false);
                return false;
            }

            public IGoalInstance getCurrentGoal() {
                switch (this.state) {
                    case ATTACH_TO_AGENT: {
                        this.initAttachToAgentGoalInstance();
                        return this.attachToAgentGoalInstance;
                    }
                    case PASSIVE_MODE: {
                        this.initPassiveModeGoalInstance();
                        return this.passiveModeGoalInstance;
                    }
                }
                assert (false);
                return null;
            }

            @Override
            public int compareTo(AssistSingleOccupantGoal other) {
                int comp = this.compareByAttachedOccs(other);
                if (comp != 0) {
                    return comp;
                }
                if (this.team.clientOrder.isEmpty()) {
                    return this.compareByDistance(other);
                }
                return this.orderByInputPreference(other);
            }

            private int compareByAttachedOccs(AssistSingleOccupantGoal other) {
                return other.ainfo.agent.getAssistedEvacClientModule().get().getAttachedAgentsCount() - this.ainfo.agent.getAssistedEvacClientModule().get().getAttachedAgentsCount();
            }

            private int orderByInputPreference(AssistSingleOccupantGoal other) {
                int result = Integer.compare(this.priority, other.priority);
                if (result == 0) {
                    return this.compareByDistance(other);
                }
                return result;
            }

            private int compareByDistance(AssistSingleOccupantGoal other) {
                return Double.compare(this.distance, other.distance);
            }

            public String toString() {
                return this.agent.getOcc().name + "->" + this.getGoToAgent().getOcc().name;
            }

            private void initAttachToAgentGoalInstance() {
                if (this.attachToAgentGoalInstance != null) {
                    return;
                }
                this.attachToAgentGoalInstance = this.ainfo.attach.begin(this.kb, this.agent);
            }

            private void initPassiveModeGoalInstance() {
                if (this.passiveModeGoalInstance != null) {
                    return;
                }
                this.passiveModeGoalInstance = this.ainfo.passive.begin(this.kb, this.agent);
            }
        }
    }
}

