/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import thunderheadeng.util.IdentityHashSet;

public class Tag
implements Serializable {
    static final long serialVersionUID = 1L;
    public final String name;
    public final String desc;
    public final boolean predefined;
    private final Set<OccAgent> d_occCounts;
    private final Map<OccAgent, Info> d_stats;
    private static final Function<OccAgent, Info> newStats = a -> new Info();
    private static final Info s_emptyStats = new Info();

    public Tag(String name, String desc, boolean predefined) {
        this.name = name;
        this.desc = desc;
        this.predefined = predefined;
        this.d_occCounts = new IdentityHashSet<OccAgent>();
        this.d_stats = new IdentityHashMap<OccAgent, Info>();
    }

    public String toString() {
        return String.format("Tag: %s", this.name);
    }

    public synchronized void tag(double t, OccAgent agent) {
        Info stats = this.d_stats.computeIfAbsent(agent, newStats);
        this.d_occCounts.add(agent);
        ++stats.count;
        stats.tLastTagged = Double.isInfinite(stats.tLastTagged) ? t : Math.max(t, stats.tLastTagged);
    }

    public synchronized void untag(double t, OccAgent agent) {
        Info stats = this.d_stats.computeIfAbsent(agent, newStats);
        --stats.count;
        if (stats.count <= 0) {
            this.d_occCounts.remove(agent);
        }
        stats.tLastUntagged = Math.max(t, stats.tLastUntagged);
        if (stats.tLastTagged < stats.tLastUntagged) {
            Info info = stats;
            info.tAccum = info.tAccum + (stats.tLastUntagged - stats.tLastTagged);
        }
    }

    public boolean isTagged(OccAgent agent) {
        return this.d_occCounts.contains(agent);
    }

    public int getTaggedCount() {
        return this.d_occCounts.size();
    }

    public Set<OccAgent> getTaggedAgents() {
        return this.d_occCounts;
    }

    public Info getInfo(OccAgent agent) {
        return this.d_stats.getOrDefault(agent, s_emptyStats);
    }

    public boolean getAnyWereEverTagged() {
        return this.d_stats.values().stream().anyMatch(s -> Double.isFinite(s.tLastTagged));
    }

    public boolean getAnyWereEverUntagged() {
        return this.d_stats.values().stream().anyMatch(s -> s.tLastUntagged != 0.0);
    }

    public static class Info
    implements Serializable {
        static final long serialVersionUID = 1L;
        public double tLastTagged = Double.POSITIVE_INFINITY;
        public double tLastUntagged = 0.0;
        private double tAccum = 0.0;
        private int count = 0;

        public double getTAccum(double currTime) {
            double t = this.tAccum;
            if (this.count > 0) {
                assert (!Double.isInfinite(this.tLastTagged));
                assert (this.tLastTagged == 0.0 || this.tLastTagged > this.tLastUntagged);
                t += currTime - this.tLastTagged;
            }
            return t;
        }
    }
}

