/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Occupant;
import inferno.data2.value.IFunction1d;
import inferno.sim.KnownFuncs;
import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Vector3d;
import thunderheadeng.util.theUtil;

public class SlopeSpeed
implements Serializable {
    static final long serialVersionUID = 1L;
    public final IFunction1d upSpeed;
    public final IFunction1d upFundamental;
    public final IFunction1d downSpeed;
    public final IFunction1d downFundamental;

    public SlopeSpeed(IFunction1d upSpeed, IFunction1d upFundamental, IFunction1d downSpeed, IFunction1d downFundamental) {
        this.upFundamental = upFundamental;
        this.upSpeed = upSpeed;
        this.downFundamental = downFundamental;
        this.downSpeed = downSpeed;
    }

    public int hashCode() {
        return 0xF1238FA ^ Objects.hash(this.upSpeed, this.upFundamental, this.downSpeed, this.downFundamental);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SlopeSpeed && ((SlopeSpeed)obj).upSpeed.equals(this.upSpeed) && ((SlopeSpeed)obj).downSpeed.equals(this.downSpeed) && ((SlopeSpeed)obj).upFundamental.equals(this.upFundamental) && ((SlopeSpeed)obj).downFundamental.equals(this.downFundamental);
    }

    public boolean isUniform() {
        return this.upSpeed == this.downSpeed && this.upFundamental == this.downFundamental;
    }

    public double getMaxSpeed(Occupant occ, double density, Vector3d travelDir) {
        IFunction1d fund;
        IFunction1d frac;
        if (this.isUniform()) {
            frac = this.upSpeed;
            fund = this.upFundamental;
        } else {
            travelDir = SlopeSpeed.getTravelDir(occ, travelDir);
            Vector3d triNormal = occ.tri.normal;
            double dot = travelDir.x * triNormal.x + travelDir.y * triNormal.y;
            if (theUtil.le0(dot, 1.0E-6)) {
                frac = this.upSpeed;
                fund = this.upFundamental;
            } else {
                frac = this.downSpeed;
                fund = this.downFundamental;
            }
        }
        return SlopeSpeed.getMaxSpeed(occ, density, frac, fund);
    }

    private static Vector3d getTravelDir(Occupant occ, Vector3d dir) {
        if (dir != null) {
            return dir;
        }
        if (occ.vel.lengthSquared() > 0.0) {
            return occ.vel;
        }
        return occ.orient;
    }

    public double getAbsoluteMaxSpeed(Occupant occ, double density) {
        double speed1 = SlopeSpeed.getMaxSpeed(occ, density, this.upSpeed, this.upFundamental);
        if (this.isUniform()) {
            return speed1;
        }
        double speed2 = SlopeSpeed.getMaxSpeed(occ, density, this.downSpeed, this.downFundamental);
        return Math.max(speed1, speed2);
    }

    private static double getMaxSpeed(Occupant occ, double density, IFunction1d frac, IFunction1d fund) {
        if (occ.tri != null) {
            return KnownFuncs.getSlopedSpeed(occ.maxVel, !occ.movingTerrainPref.standing, frac, fund, occ.tri.getSpeedModifier(), KnownFuncs.getTerrainSlope(occ.tri), density);
        }
        return occ.maxVel;
    }
}

