/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.QBaseQueue;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.PathGen;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class QPath
implements Serializable {
    static final long serialVersionUID = 1L;
    private QBaseQueue d_parent;
    private List<OccAgent> d_occupants = new LinkedList<OccAgent>();
    private List<OccAgent> d_pendingOccs = new LinkedList<OccAgent>();
    private List<OccAgent> d_removeFromPending = new LinkedList<OccAgent>();
    private Map<OccAgent, LinkedList<TriPoint>> d_occPaths = new LinkedIdentityHashMap<OccAgent, LinkedList<TriPoint>>();
    private LinkedList<TriPoint> d_occPoints = new LinkedList();
    private Map<Point3d, Integer> d_occPointFPs = new LinkedIdentityHashMap<Point3d, Integer>();
    private Map<OccAgent, Integer> d_numFollowPointsPassed = new LinkedIdentityHashMap<OccAgent, Integer>();
    private Map<OccAgent, Double> d_occDistPreference = new LinkedIdentityHashMap<OccAgent, Double>();
    private List<TriPoint> d_pathPoints = new ArrayList<TriPoint>();
    public TriPoint d_pathHead;
    public Set<OccAgent> d_unprocessedOccupants = Collections.synchronizedSet(new LinkedIdentityHashSet());
    public Set<OccAgent> d_removeOccupants = Collections.synchronizedSet(new LinkedIdentityHashSet());
    private boolean d_followPath = false;
    private List<String> d_restrictedProfiles;
    private double d_pathLength = 0.0;
    private IDistributedVal<UnitDouble> d_customPathSpacing = new ConstantCurve(new UnitDouble(1.0, SI.METER));
    private double d_occReachedRadius = 0.5;
    private double d_occHeadRadius = 0.5;

    public QPath(KB kb, List<TriPoint> p) {
        this.d_pathPoints.addAll(p);
        this.d_pathHead = this.d_pathPoints.get(0);
        this.d_pathLength = PathGen.getPathLength(p);
    }

    private TriPoint findPoint(KB kb, Point3d point, double tol) {
        Point3d newPoint = new Point3d(point);
        Tri tri = kb.getMesh().getTri(newPoint, new Point3d(newPoint.x, newPoint.y, newPoint.z + tol), new Point3d(newPoint.x, newPoint.y, newPoint.z - tol));
        if (tri == null) {
            return null;
        }
        return new TriPoint(tri, newPoint);
    }

    public void setParentSubUnit(QBaseQueue parent) {
        this.d_parent = parent;
    }

    public QBaseQueue getParentQueue() {
        return this.d_parent;
    }

    public void setFollowPath(boolean follow) {
        this.d_followPath = follow;
    }

    public boolean getFollowPath() {
        return this.d_followPath;
    }

    public void setRestrictedProfiles(List<String> profiles) {
        this.d_restrictedProfiles = profiles;
    }

    public List<String> getAcceptedProfiles() {
        return this.d_restrictedProfiles;
    }

    public boolean isAcceptedProfile(String profile) {
        return this.d_restrictedProfiles != null && !this.d_restrictedProfiles.contains(profile);
    }

    public void setCustomSpacing(IDistributedVal<UnitDouble> spacing) {
        this.d_customPathSpacing = spacing;
    }

    public double getPathLength() {
        return this.d_pathLength;
    }

    public int getNumOccupants() {
        return this.d_occupants.size() + this.d_pendingOccs.size();
    }

    public List<TriPoint> getPoints() {
        return this.d_pathPoints;
    }

    public TriPoint getFollowPathCheckLoc(OccAgent occ) {
        if (this.d_followPath && (this.d_pendingOccs.contains(occ) || this.d_occPaths.get(occ).getLast() == this.d_pathPoints.get(this.d_pathPoints.size() - 1))) {
            return this.d_pathPoints.get(this.d_pathPoints.size() - 2);
        }
        return null;
    }

    public double getEndPointRadius(OccAgent occ) {
        if (!this.d_followPath && this.d_pendingOccs.contains(occ)) {
            return this.d_occHeadRadius * 3.0;
        }
        if (this.d_followPath && (this.d_pendingOccs.contains(occ) || this.d_occPaths.get(occ).getLast() == this.d_pathPoints.get(this.d_pathPoints.size() - 1))) {
            return this.d_pathPoints.get((int)(this.d_pathPoints.size() - 1)).p.distance(this.d_pathPoints.get((int)(this.d_pathPoints.size() - 2)).p);
        }
        return this.d_occReachedRadius;
    }

    public TriPoint getEndPoint() {
        if (this.d_occPoints.size() > 0) {
            return this.d_occPoints.getLast();
        }
        return this.d_pathHead;
    }

    public LinkedList<TriPoint> generateOccPath(KB kb, OccAgent occ) {
        LinkedList<TriPoint> triPoints;
        if (this.d_occPoints.isEmpty()) {
            this.d_occPoints.add(this.d_pathHead);
            this.d_occPointFPs.put(this.d_pathHead.p, 0);
            TriPoint generatedPoint = this.d_pathHead;
            triPoints = this.createOccPathFromHead(occ, generatedPoint, 0);
        } else {
            GenPointResult result = this.generateOccPoint(kb, occ);
            TriPoint generatedPoint = result.point;
            this.d_occPointFPs.put(generatedPoint.p, result.forePoint);
            triPoints = this.createOccPathFromHead(occ, generatedPoint, result.forePoint);
        }
        return triPoints;
    }

    private LinkedList<TriPoint> createOccPathFromHead(OccAgent occ, TriPoint generatedPoint, int forePoint) {
        LinkedList<TriPoint> triPoints = new LinkedList<TriPoint>();
        triPoints.add(generatedPoint);
        if (this.d_followPath) {
            int end = this.d_pathPoints.size() - 1;
            if (this.d_numFollowPointsPassed.get(occ) != null) {
                end -= this.d_numFollowPointsPassed.get(occ).intValue();
            }
            for (int i = forePoint + 1; i <= end; ++i) {
                triPoints.add(this.d_pathPoints.get(i));
            }
        }
        return triPoints;
    }

    private GenPointResult generateOccPoint(KB kb, OccAgent occ) {
        int occIndex = this.d_occupants.indexOf(occ);
        if (this.d_occPoints.getLast().p == this.d_pathPoints.get((int)(this.d_pathPoints.size() - 1)).p) {
            GenPointResult generatedPoint = new GenPointResult(this.d_pathPoints.get(this.d_pathPoints.size() - 1), this.d_pathPoints.size() - 1);
            return generatedPoint;
        }
        Function<Double, GenPointResult> generateNextPoint = dist -> {
            int AIndex = this.d_occPointFPs.get(this.d_occPoints.getLast().p);
            double distRemaining = dist;
            ListIterator<TriPoint> pointIt = this.d_pathPoints.listIterator(AIndex + 1);
            Point3d prev = this.d_occPoints.getLast().p;
            while (pointIt.hasNext()) {
                TriPoint curr = pointIt.next();
                double pointDist = curr.p.distance(prev);
                if (theUtil.eq(pointDist, distRemaining, 1.0E-6)) {
                    return new GenPointResult(curr, pointIt.previousIndex());
                }
                if (pointDist > distRemaining) {
                    Point3d newPoint = Util3D.linesegPoint(prev, curr.p, distRemaining / pointDist);
                    TriPoint tp = this.findPoint(kb, newPoint, 1.0);
                    if (tp == null) {
                        return new GenPointResult(curr, pointIt.previousIndex());
                    }
                    return new GenPointResult(tp, pointIt.previousIndex() - 1);
                }
                distRemaining -= pointDist;
                prev = curr.p;
            }
            return new GenPointResult(this.d_pathPoints.get(this.d_pathPoints.size() - 1), this.d_pathPoints.size() - 1);
        };
        double dist2 = 0.9;
        if (this.d_occDistPreference.containsKey(occ)) {
            dist2 = this.d_occDistPreference.get(occ);
        } else if (occ.isSocialDistancingEnabled()) {
            dist2 = occ.getSocialDistance();
            this.d_occDistPreference.put(occ, dist2);
        } else {
            Random rnd = kb.getTimeBasedRandom(occ.getOcc(), 2351565019130L);
            dist2 = this.d_customPathSpacing.getValue(rnd).getValue(SI.METER);
            this.d_occDistPreference.put(occ, dist2);
        }
        if (occ.getGroup().isPresent()) {
            dist2 *= (double)(occ.getGroup().get().getCurrentSize() / 2 + 1);
        } else if (occIndex > 0 && this.d_occupants.get(occIndex - 1).getGroup().isPresent()) {
            dist2 *= (double)(this.d_occupants.get(occIndex - 1).getGroup().get().getCurrentSize() / 2 + 1);
        }
        GenPointResult generatedPoint = generateNextPoint.apply(dist2);
        this.d_occPoints.add(generatedPoint.point);
        return generatedPoint;
    }

    public void enqueueOccupant(KB kb, OccAgent occ) {
        this.d_parent.setEnqueued(occ, this);
        LinkedList<TriPoint> path = new LinkedList<TriPoint>();
        if (!this.d_followPath) {
            if (this.d_occPoints.size() == 0) {
                this.generateOccPath(kb, occ);
            }
            path.add(this.d_occPoints.getLast());
            this.d_occPaths.put(occ, path);
            this.d_pendingOccs.add(occ);
        } else {
            path = new LinkedList();
            path.add(this.d_pathPoints.get(this.d_pathPoints.size() - 1));
            this.d_pendingOccs.add(occ);
            this.d_occPaths.put(occ, path);
        }
    }

    public void dequeueOccupant(KB kb, OccAgent removeOcc) {
        this.d_occupants.remove(removeOcc);
        this.d_occDistPreference.remove(removeOcc);
        this.d_occPaths.remove(removeOcc);
        this.d_numFollowPointsPassed.remove(removeOcc);
        this.d_occPoints.clear();
        if (this.d_occupants.size() > 0) {
            for (OccAgent occ : this.d_occupants) {
                LinkedList<TriPoint> path = this.generateOccPath(kb, occ);
                this.d_occPaths.put(occ, path);
            }
        }
    }

    public void update(KB kb) {
        if (!this.d_unprocessedOccupants.isEmpty()) {
            this.processOccupants(kb);
        }
        if (!this.d_removeFromPending.isEmpty()) {
            this.recalculatePending(kb);
        }
        for (OccAgent occ : this.d_removeOccupants) {
            if (this.d_unprocessedOccupants.contains(occ)) {
                this.d_unprocessedOccupants.remove(occ);
                continue;
            }
            if (this.d_pendingOccs.contains(occ)) {
                this.d_pendingOccs.remove(occ);
                this.d_occPaths.remove(occ);
                continue;
            }
            if (!this.d_occupants.contains(occ)) continue;
            this.dequeueOccupant(kb, occ);
        }
        this.d_removeOccupants.clear();
        if (this.d_occupants.size() > 0) {
            if (this.d_followPath) {
                OccAgent headOcc = this.d_occupants.get(0);
                if (headOcc.getLoc().p.distance(this.d_pathPoints.get((int)0).p) < this.getEndPointRadius(headOcc) && headOcc.isSlow(kb) && this.d_parent.tryServiceAccept(headOcc, this)) {
                    this.dequeueOccupant(kb, headOcc);
                }
            } else if (this.d_parent.tryServiceAccept(this.d_occupants.get(0), this)) {
                this.dequeueOccupant(kb, this.d_occupants.get(0));
            }
        }
    }

    private void processOccupants(KB kb) {
        ArrayList<OccAgent> unproc = new ArrayList<OccAgent>(this.d_unprocessedOccupants);
        Collections.sort(unproc, (a1, a2) -> Integer.compare(a1.getId(), a2.getId()));
        for (OccAgent occ : unproc) {
            this.enqueueOccupant(kb, occ);
        }
        this.d_unprocessedOccupants.clear();
    }

    private void recalculatePending(KB kb) {
        LinkedList<OccAgent> sortedUnpOccs = new LinkedList<OccAgent>();
        LinkedList<Double> sortedUnpDists = new LinkedList<Double>();
        for (OccAgent remOcc : this.d_removeFromPending) {
            double currentDist = 1.0;
            if (this.d_followPath) {
                if (this.d_pathPoints.size() == 1) {
                    currentDist = remOcc.getLoc().p.distance(this.d_occPaths.get((Object)remOcc).getLast().p);
                } else if (this.d_pathPoints.size() > 1) {
                    currentDist = remOcc.getLoc().p.distance(this.d_pathPoints.get((int)(this.d_pathPoints.size() - 2)).p);
                }
            } else {
                currentDist = remOcc.getLoc().p.distance(this.d_occPaths.get((Object)remOcc).getLast().p);
            }
            if (sortedUnpOccs.isEmpty()) {
                sortedUnpOccs.add(remOcc);
                sortedUnpDists.add(currentDist);
                continue;
            }
            boolean added = false;
            for (int j = 0; j < sortedUnpOccs.size(); ++j) {
                if (!(currentDist < (Double)sortedUnpDists.get(j))) continue;
                sortedUnpDists.add(j, currentDist);
                sortedUnpOccs.add(j, remOcc);
                added = true;
                break;
            }
            if (added) continue;
            sortedUnpDists.add(currentDist);
            sortedUnpOccs.add(remOcc);
        }
        for (OccAgent occ : sortedUnpOccs) {
            this.d_occupants.add(occ);
            this.d_removeFromPending.remove(occ);
            LinkedList<TriPoint> path = this.generateOccPath(kb, occ);
            this.d_occPaths.put(occ, path);
        }
        if (!this.d_followPath && this.d_pendingOccs.size() > 0) {
            LinkedList<TriPoint> path = new LinkedList<TriPoint>();
            path.add(this.d_occPoints.getLast());
            for (OccAgent pOcc : this.d_pendingOccs) {
                this.d_occPaths.put(pOcc, path);
            }
        }
    }

    public TriPoint getOccupantTriPoint(OccAgent occ) {
        if (this.d_unprocessedOccupants.contains(occ)) {
            return occ.getLoc();
        }
        return this.d_occPaths.get(occ).getLast();
    }

    public TriPoint getLastOccPoint() {
        if (this.d_occPoints.isEmpty()) {
            return this.d_pathHead;
        }
        int i = this.d_occupants.size() - 1;
        if (i < 0) {
            i = 0;
        }
        return this.d_occPoints.get(i);
    }

    public boolean tryIncrementOccTriPoint(KB kb, OccAgent occ) {
        if (this.d_followPath && this.d_pathPoints.contains(this.d_occPaths.get(occ).getLast())) {
            this.d_numFollowPointsPassed.putIfAbsent(occ, 0);
            this.d_numFollowPointsPassed.put(occ, this.d_numFollowPointsPassed.get(occ) + 1);
            if (this.d_pathPoints.get(this.d_pathPoints.size() - 1) == this.d_occPaths.get(occ).getLast() && this.d_pendingOccs.contains(occ)) {
                this.d_removeFromPending.add(occ);
                this.d_pendingOccs.remove(occ);
                this.d_parent.setQPath(occ, this);
                occ.getGroup().ifPresent(group -> {
                    for (OccAgent member : group.getMembers()) {
                        if (member == occ) continue;
                        this.d_parent.setQPath(member, this);
                    }
                });
                return true;
            }
        } else if (!this.d_followPath && this.d_pendingOccs.contains(occ)) {
            this.d_removeFromPending.add(occ);
            this.d_pendingOccs.remove(occ);
            this.d_parent.setQPath(occ, this);
            return false;
        }
        if (this.d_occPaths.get(occ).size() == 1) {
            return false;
        }
        this.d_occPaths.get(occ).removeLast();
        return true;
    }

    public int getEnqueuedOccCount() {
        return this.d_occupants.size() + this.d_pendingOccs.size();
    }

    public int getUnprocessedOccCount() {
        return this.d_unprocessedOccupants.size();
    }

    public void addUnprocessedOccupant(OccAgent oa) {
        this.d_unprocessedOccupants.add(oa);
    }

    public IDistributedVal<?> getPathSpacingDistribution() {
        return this.d_customPathSpacing;
    }

    protected IDistributedVal<UnitDouble> getSpacingDist() {
        return this.d_customPathSpacing;
    }

    public int compare(OccAgent occ1, OccAgent occ2) {
        if (occ1 == occ2) {
            return 0;
        }
        OccAgent leader2 = this.d_parent.getLeaderOfOcc(occ2);
        if (leader2 == occ1) {
            return -1;
        }
        OccAgent leader1 = this.d_parent.getLeaderOfOcc(occ1);
        if (leader1 == occ2) {
            return 1;
        }
        if (leader1 != null) {
            occ1 = leader1;
        }
        if (leader2 != null) {
            occ2 = leader2;
        }
        if (occ1 == occ2) {
            return 0;
        }
        return Integer.compare(this.d_occupants.indexOf(occ1), this.d_occupants.indexOf(occ2));
    }

    public boolean isOccHeadStuck(KB kb) {
        if (this.d_occupants.size() > 0 && this.d_occupants.get(0).isSlow(kb)) {
            return true;
        }
        return this.d_occupants.size() == 0 && this.d_pendingOccs.size() > 0 && this.d_pendingOccs.get(0).isSlow(kb) && !this.d_pendingOccs.get(0).isWaiting(kb);
    }

    public void markRemoveOccupant(OccAgent occ) {
        this.d_removeOccupants.add(occ);
    }

    private static class GenPointResult {
        public TriPoint point;
        public int forePoint;

        GenPointResult(TriPoint p, int fp) {
            this.point = p;
            this.forePoint = fp;
        }
    }
}

