/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.QMetaQueue;
import inferno.data2.QPath;
import inferno.data2.QServicePoint;
import inferno.data2.TriPoint;
import inferno.data2.ai.IProgressNote;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.steering.Shortest;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.actions.WriteMesh;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;

public class QBaseQueue
extends QMetaQueue
implements Serializable {
    static final long serialVersionUID = 1L;
    private final String d_name;
    private final Color d_color;
    private List<String> d_restrictedProfiles;
    private boolean d_occupantsStuck = false;
    private List<QServicePoint> d_services = new ArrayList<QServicePoint>();
    private Map<OccAgent, QServicePoint> d_occServiceMap = new LinkedIdentityHashMap<OccAgent, QServicePoint>();
    private List<QPath> d_paths;
    private List<QPath> d_hotPaths = new ArrayList<QPath>();
    private Map<OccAgent, QPath> d_occPathsMap = new LinkedIdentityHashMap<OccAgent, QPath>();
    private final Map<OccGroup, OccAgent> d_groupLeaders = new LinkedIdentityHashMap<OccGroup, OccAgent>();
    private final Map<OccAgent, QMetaQueue.ProcessOption> d_unprocessedLeaderContenders = new LinkedIdentityHashMap<OccAgent, QMetaQueue.ProcessOption>();
    private Map<OccAgent, Stack<TriPoint>> d_occDestinations = new LinkedIdentityHashMap<OccAgent, Stack<TriPoint>>();
    private Set<OccAgent> d_occReady = new IdentityHashSet<OccAgent>();
    private Set<OccAgent> d_needsNewSteering = new IdentityHashSet<OccAgent>();
    private Map<OccAgent, TriPoint> d_lastKnownSteeringDest = new IdentityHashMap<OccAgent, TriPoint>();
    private Set<OccAgent> d_idlingAgents = new IdentityHashSet<OccAgent>();
    private double d_avgServiceTime = 1.0;
    private double d_serviceCommitmentDist = 10.0;

    public QBaseQueue(String name, Color color, List<String> restrictedProfiles, List<QServicePoint> services, List<QPath> queues, QMetaQueue parent, QMetaQueue.QBalancingType bType, IUrn<Integer> sortUrn) {
        super(bType, sortUrn);
        this.d_name = name;
        this.d_color = color;
        this.d_restrictedProfiles = restrictedProfiles;
        this.d_services = services;
        this.d_paths = queues;
        for (QServicePoint service : this.d_services) {
            service.setParent(this);
        }
        for (QPath queue : this.d_paths) {
            queue.setParentSubUnit(this);
        }
        if (this.d_services.size() > 0) {
            double avgTime = 0.0;
            for (QServicePoint service : this.d_services) {
                avgTime += service.getAvgWaitTime();
            }
            this.d_avgServiceTime = avgTime / (double)this.d_services.size();
        }
    }

    public String getName() {
        return this.d_name;
    }

    public Color getColor() {
        return this.d_color;
    }

    @Override
    public int getNumPaths() {
        return this.d_paths.size();
    }

    public IProgressNote checkProgress() {
        if (this.d_occupantsStuck) {
            return IProgressNote.NOT_PROGRESSING;
        }
        return IProgressNote.PROGRESSING;
    }

    public QServicePoint getService(OccAgent agent, boolean checkGroupLeader) {
        OccAgent leader;
        if (checkGroupLeader && agent.getGroup().isPresent() && (leader = this.d_groupLeaders.get(agent.getGroup().get())) != null) {
            agent = leader;
        }
        return this.d_occServiceMap.get(agent);
    }

    public void updateProgress(KB kb, double dt) {
        this.d_occupantsStuck = true;
        boolean servicesEmpty = true;
        for (QServicePoint serv : this.d_services) {
            if (serv.getServicingOcc() == null) continue;
            servicesEmpty = false;
        }
        boolean allOccsStuck = true;
        for (QPath path : this.d_paths) {
            if (path.getNumOccupants() == 0 || path.isOccHeadStuck(kb)) continue;
            allOccsStuck = false;
            break;
        }
        if (servicesEmpty && allOccsStuck) {
            this.d_occupantsStuck = true;
            return;
        }
        this.d_occupantsStuck = false;
    }

    public JSONObject toJSON(Map<IDistributedVal<?>, Integer> distributions) {
        JSONObject obj = new JSONObject();
        obj.put("name", this.d_name);
        obj.put("color", WriteMesh.convertColorToJSON(this.d_color));
        JSONArray qProfs = new JSONArray();
        for (String string : this.d_restrictedProfiles) {
            qProfs.add(string);
        }
        obj.put("restrictedProfs", qProfs);
        JSONArray queues = new JSONArray();
        for (QPath path : this.d_paths) {
            JSONObject qObj = new JSONObject();
            qObj.put("followpath", path.getFollowPath());
            qObj.put("spacingIndex", distributions.get(path.getSpacingDist()).toString());
            JSONArray pathProfs = new JSONArray();
            if (path.getAcceptedProfiles() != null) {
                for (String prof : path.getAcceptedProfiles()) {
                    pathProfs.add(prof);
                }
            }
            qObj.put("restrictedProfs", pathProfs);
            JSONArray qPoints = new JSONArray();
            for (TriPoint p : path.getPoints()) {
                qPoints.add(p.p.toString());
            }
            qObj.put("points", qPoints);
            queues.add(qObj);
        }
        obj.put("paths", queues);
        JSONArray jSONArray = new JSONArray();
        for (QServicePoint serv : this.d_services) {
            JSONObject servObj = new JSONObject();
            servObj.put("point", serv.getLocation().toString());
            servObj.put("distindex", distributions.get(serv.getWaitTimeDist()).toString());
            jSONArray.add(servObj);
        }
        obj.put("services", jSONArray);
        if (this.getDistributionUrn() == null) {
            obj.put("sortindex", "null");
            obj.put("sorting", "auto");
        } else {
            obj.put("sortindex", distributions.get(this.getDistributionUrn()));
            obj.put("sorting", "dist");
        }
        return obj;
    }

    public List<QServicePoint> getServicePoints() {
        return this.d_services;
    }

    public List<QPath> getPaths() {
        return this.d_paths;
    }

    public List<QPath> getOccLineQueue() {
        return this.d_paths;
    }

    public TriPoint getFollowPathCheckLoc(OccAgent occ) {
        if (this.d_occPathsMap.containsKey(occ)) {
            return this.d_occPathsMap.get(occ).getFollowPathCheckLoc(occ);
        }
        return null;
    }

    public double getEndPointRadius(OccAgent occ) {
        if (this.d_occPathsMap.containsKey(occ)) {
            return this.d_occPathsMap.get(occ).getEndPointRadius(occ);
        }
        return 0.5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getOccupantReady(OccAgent occ, boolean removeIfReady) {
        Set<OccAgent> set = this.d_occReady;
        synchronized (set) {
            if (removeIfReady) {
                return this.d_occReady.remove(occ);
            }
            return this.d_occReady.contains(occ);
        }
    }

    public OccAgent getLeaderOfOcc(OccAgent occ) {
        Optional<OccGroup> ogroup = occ.getGroup();
        if (!ogroup.isPresent()) {
            return null;
        }
        OccGroup group = ogroup.get();
        if (group.getLeader() != null) {
            return group.getLeader();
        }
        return this.d_groupLeaders.get(group);
    }

    public TriPoint getOccupantTriPoint(OccAgent occ, OccAgent leader) {
        if (leader != null) {
            if (this.d_occDestinations.get(leader) != null) {
                return this.d_occDestinations.get(leader).peek();
            }
            if (this.d_occPathsMap.get(leader) != null) {
                return this.d_occPathsMap.get(leader).getOccupantTriPoint(leader);
            }
            return occ.getLoc();
        }
        if (this.d_occDestinations.get(occ) != null) {
            return this.d_occDestinations.get(occ).peek();
        }
        if (this.d_occPathsMap.get(occ) != null) {
            return this.d_occPathsMap.get(occ).getOccupantTriPoint(occ);
        }
        return occ.getLoc();
    }

    public boolean tryIncrementOccTriPoint(KB kb, OccAgent occ) {
        if (this.d_occDestinations.get(occ) != null) {
            if (this.d_occDestinations.get(occ).size() == 1) {
                return false;
            }
            this.d_occDestinations.get(occ).pop();
            return true;
        }
        if (this.d_occPathsMap.get(occ) != null) {
            return this.d_occPathsMap.get(occ).tryIncrementOccTriPoint(kb, occ);
        }
        return false;
    }

    @Override
    public QMetaQueue.ProcessOption processOccupant(KB kb, OccAgent occ) {
        Optional<OccGroup> ogroup = occ.getGroup();
        boolean temporary = false;
        OccAgent groupLeader = null;
        if (this.d_restrictedProfiles.contains(occ.getOcc().parentProfile.getName())) {
            return null;
        }
        if (ogroup.isPresent()) {
            OccGroup group = ogroup.get();
            if (group.getLeader() != null) {
                QPath leaderPath = this.d_occPathsMap.get(group.getLeader());
                if (leaderPath != null) {
                    return new QMetaQueue.ProcessOption(false, group.getLeader(), leaderPath, 0.0);
                }
                if (group.getLeader() != occ) {
                    return new QMetaQueue.ProcessOption(false, group.getLeader(), null, Double.MAX_VALUE);
                }
                groupLeader = group.getLeader();
            } else {
                OccAgent leader = this.d_groupLeaders.get(group);
                if (leader != null) {
                    assert (this.d_occPathsMap.containsKey(leader));
                    return new QMetaQueue.ProcessOption(false, leader, this.d_occPathsMap.get(leader), 0.0);
                }
                temporary = true;
            }
        }
        if (!this.d_paths.isEmpty()) {
            QPath chosenQ = null;
            double waitTime = Double.MAX_VALUE;
            switch (this.getBalancingType()) {
                case TIME: {
                    int qIndex = -1;
                    for (int i = 0; i < this.d_paths.size(); ++i) {
                        double thisWaitTime;
                        if (!this.d_paths.get(i).isAcceptedProfile(occ.getOcc().parentProfile.getName())) continue;
                        int occNum = this.d_paths.get(i).getEnqueuedOccCount();
                        Predicate<PathChange> filter = Shortest.getPathFilter(kb, occ, false);
                        PathGen.IPathResult pathResult = PathGen.getPath(kb.getMesh(), occ.getLoc().tri, null, null, occ.getLoc().p, new PathGen.PointGoal(this.d_paths.get(i).getEndPoint()), occ.getOcc().bodyShape.getGeomRadius(), Double.MAX_VALUE, filter, null);
                        if (!pathResult.isSuccessful()) continue;
                        double dist = pathResult.getLength();
                        if (this.d_paths.get(i).getFollowPath()) {
                            dist += this.d_paths.get(i).getPathLength();
                        }
                        if (!((thisWaitTime = (double)occ.getOcc().maxVel * dist + (double)(occ.getOcc().maxVel * (float)occNum * 2.0f) + (double)occNum * this.d_avgServiceTime) < waitTime)) continue;
                        qIndex = i;
                        waitTime = thisWaitTime;
                    }
                    if (qIndex == -1) break;
                    chosenQ = this.d_paths.get(qIndex);
                    break;
                }
                case PROBABILITY: {
                    Random rnd = kb.getTimeBasedRandom(occ.getOcc(), 718363257163948952L);
                    int chosenNum = this.getDistributionUrn().getValue(rnd);
                    chosenQ = this.d_paths.get(chosenNum);
                    break;
                }
                case PROFILE: {
                    break;
                }
                default: {
                    chosenQ = this.d_paths.get(0);
                }
            }
            if (chosenQ != null) {
                return new QMetaQueue.ProcessOption(temporary, groupLeader, chosenQ, waitTime);
            }
            return null;
        }
        return null;
    }

    public boolean tryServiceAccept(OccAgent occ, QPath q) {
        QServicePoint chosenS = null;
        double chosenDist = 999999.0;
        for (QServicePoint service : this.d_services) {
            double thisDist = occ.getLoc().p.distance(service.getLocation().p);
            if (service.getServicingOcc() != null || !(thisDist < chosenDist) || service.getLocation() == null) continue;
            chosenS = service;
            chosenDist = thisDist;
        }
        if (chosenS != null) {
            Stack<TriPoint> singleStack = new Stack<TriPoint>();
            singleStack.add(chosenS.getLocation());
            this.d_occDestinations.put(occ, singleStack);
            this.d_occServiceMap.put(occ, chosenS);
            this.d_occPathsMap.remove(occ);
            chosenS.setReady(false);
            chosenS.setServicingOcc(occ);
            if (q != null) {
                this.d_hotPaths.add(q);
            }
            return true;
        }
        return false;
    }

    protected void setEnqueued(OccAgent occ, QPath path) {
        this.d_occReady.remove(occ);
        this.d_occPathsMap.put(occ, path);
    }

    protected void setQPath(OccAgent occ, QPath path) {
        occ.getOcc().qpath = path;
    }

    protected boolean tryDischargeOccupant(OccAgent occ) {
        if (this.getNext() != null) {
            return false;
        }
        Consumer<OccAgent> dischargeOcc = o -> {
            this.d_occReady.add((OccAgent)o);
            this.setQPath((OccAgent)o, null);
        };
        dischargeOcc.accept(occ);
        this.d_occDestinations.remove(occ);
        this.d_occServiceMap.remove(occ);
        this.d_idlingAgents.remove(occ);
        this.d_lastKnownSteeringDest.remove(occ);
        if (occ.getGroup().isPresent()) {
            OccGroup group = occ.getGroup().get();
            for (OccAgent member : group.getMembers()) {
                if (member == occ) continue;
                dischargeOcc.accept(member);
            }
            this.d_groupLeaders.remove(group);
        }
        return true;
    }

    public void update(KB kb, double dt) {
        boolean bl;
        if (!this.d_unprocessedLeaderContenders.isEmpty()) {
            LinkedIdentityHashMap<OccGroup, List> groups = new LinkedIdentityHashMap<OccGroup, List>();
            for (Map.Entry<OccAgent, QMetaQueue.ProcessOption> entry : this.d_unprocessedLeaderContenders.entrySet()) {
                groups.computeIfAbsent(entry.getKey().getGroup().get(), g -> new ArrayList()).add(entry);
            }
            for (Map.Entry<OccAgent, QMetaQueue.ProcessOption> entry : groups.entrySet()) {
                List competitors = (List)((Object)entry.getValue());
                Map.Entry winner = competitors.size() == 1 ? (Map.Entry)competitors.iterator().next() : (Map.Entry)competitors.stream().min((c1, c2) -> {
                    int comp = Double.compare(((QMetaQueue.ProcessOption)c1.getValue()).waitTime, ((QMetaQueue.ProcessOption)c2.getValue()).waitTime);
                    if (comp != 0) {
                        return comp;
                    }
                    return Integer.compare(((OccAgent)c1.getKey()).getOcc().id, ((OccAgent)c2.getKey()).getOcc().id);
                }).get();
                ((QMetaQueue.ProcessOption)winner.getValue()).chosenQ.addUnprocessedOccupant((OccAgent)winner.getKey());
                this.d_groupLeaders.put((OccGroup)((Object)entry.getKey()), (OccAgent)winner.getKey());
            }
            this.d_unprocessedLeaderContenders.clear();
        }
        LinkedIdentityHashSet<OccAgent> travelingOccupants = new LinkedIdentityHashSet<OccAgent>();
        LinkedIdentityHashSet<QServicePoint> openServices = new LinkedIdentityHashSet<QServicePoint>();
        boolean bl2 = true;
        for (QServicePoint sp : this.d_services) {
            sp.update(kb, dt);
        }
        for (QPath olq : this.d_paths) {
            olq.update(kb);
            if (olq.getNumOccupants() == 0) continue;
            bl = false;
        }
        for (QServicePoint sp : this.d_services) {
            if (sp.getServicingOcc() != null && !sp.getIsOccupantWaiting()) {
                travelingOccupants.add(sp.getServicingOcc());
                continue;
            }
            if (sp.getServicingOcc() != null || !sp.isReady() || sp.getIsOccupantWaiting()) continue;
            openServices.add(sp);
        }
        this.CheckNearbyOpenService(travelingOccupants, openServices, bl);
        this.CheckServiceSwaps(travelingOccupants);
        this.updateProgress(kb, dt);
        for (QPath olq : this.d_hotPaths) {
            this.d_paths.remove(olq);
            this.d_paths.add(olq);
        }
        this.d_hotPaths.clear();
        this.updateSteeringTracker(kb);
    }

    private void CheckNearbyOpenService(Set<OccAgent> travelingOccupants, Set<QServicePoint> openServices, boolean checkCloserEmpties) {
        if (checkCloserEmpties && travelingOccupants.size() > 0 && openServices.size() > 0) {
            for (QServicePoint sp : openServices) {
                OccAgent closestOcc = null;
                for (OccAgent occ : travelingOccupants) {
                    double distToIncumbent;
                    double distToOpen = occ.getLoc().p.distance(sp.getLocation().p);
                    if (!(distToOpen < (distToIncumbent = occ.getLoc().p.distance(this.d_occServiceMap.get((Object)occ).getLocation().p))) || !(distToOpen < this.d_serviceCommitmentDist)) continue;
                    closestOcc = occ;
                }
                if (closestOcc == null) continue;
                QServicePoint occS = this.d_occServiceMap.get(closestOcc);
                occS.setReady(true);
                occS.setServicingOcc(null);
                sp.setServicingOcc(closestOcc);
                sp.setReady(false);
                this.d_occServiceMap.put(closestOcc, sp);
                Stack<TriPoint> dest = new Stack<TriPoint>();
                dest.add(sp.getLocation());
                this.d_occDestinations.put(closestOcc, dest);
                break;
            }
        }
    }

    private void CheckServiceSwaps(Set<OccAgent> travelingOccupants) {
        if (travelingOccupants.size() > 1) {
            Iterator<OccAgent> iterator = travelingOccupants.iterator();
            while (iterator.hasNext()) {
                OccAgent occ1;
                OccAgent closest = occ1 = iterator.next();
                double dist_occ1ToOcc1Dest = occ1.getLoc().p.distance(this.d_occServiceMap.get((Object)occ1).getLocation().p);
                for (OccAgent occ2 : travelingOccupants) {
                    if (occ1 == occ2) continue;
                    double dist_occ1ToOcc2Dest = occ1.getLoc().p.distance(this.d_occServiceMap.get((Object)occ2).getLocation().p);
                    double dist_occ2ToOcc1Dest = occ2.getLoc().p.distance(this.d_occServiceMap.get((Object)occ1).getLocation().p);
                    double dist_occ2ToOcc2Dest = occ2.getLoc().p.distance(this.d_occServiceMap.get((Object)occ2).getLocation().p);
                    if (!(dist_occ1ToOcc2Dest < dist_occ1ToOcc1Dest) || !(dist_occ2ToOcc1Dest < dist_occ2ToOcc2Dest)) continue;
                    closest = occ2;
                    dist_occ1ToOcc1Dest = dist_occ2ToOcc1Dest;
                }
                if (closest == occ1) continue;
                QServicePoint occS = this.d_occServiceMap.get(occ1);
                QServicePoint otherS = this.d_occServiceMap.get(closest);
                otherS.setServicingOcc(occ1);
                this.d_occServiceMap.put(occ1, otherS);
                occS.setServicingOcc(closest);
                this.d_occServiceMap.put(closest, occS);
                Stack<TriPoint> dest = new Stack<TriPoint>();
                dest.add(otherS.getLocation());
                this.d_occDestinations.put(occ1, dest);
                Stack<TriPoint> otherDest = new Stack<TriPoint>();
                otherDest.add(occS.getLocation());
                this.d_occDestinations.put(closest, otherDest);
            }
        }
    }

    private void updateSteeringTracker(KB kb) {
        this.d_needsNewSteering.clear();
        for (OccAgent occ : this.d_occDestinations.keySet()) {
            if (!this.checkNeedsSteeringUpdate(kb, occ)) continue;
            this.d_needsNewSteering.add(occ);
        }
        for (OccAgent occ : this.d_occPathsMap.keySet()) {
            if (!this.checkNeedsSteeringUpdate(kb, occ)) continue;
            this.d_needsNewSteering.add(occ);
        }
    }

    private boolean checkNeedsSteeringUpdate(KB kb, OccAgent occ) {
        OccAgent leader = this.getLeaderOfOcc(occ);
        TriPoint destination = this.getOccupantTriPoint(occ, leader);
        TriPoint lastKnownSteeringDest = this.d_lastKnownSteeringDest.get(occ);
        if (destination == null) {
            return false;
        }
        if (lastKnownSteeringDest != destination) {
            this.d_lastKnownSteeringDest.put(occ, destination);
            return true;
        }
        double checkDist = this.getEndPointRadius(occ);
        TriPoint fpCheckLoc = this.getFollowPathCheckLoc(occ);
        if (leader != null && occ != leader) {
            checkDist *= 2.0;
        }
        double dist = occ.getLoc().p.distance(lastKnownSteeringDest.p);
        boolean arrived = false;
        arrived = fpCheckLoc != null ? dist < 0.7 && occ.getLoc().p.distance(fpCheckLoc.p) < checkDist : dist < checkDist;
        boolean bl = arrived = arrived && !kb.getMesh().isPathObstructed(occ.getLoc(), lastKnownSteeringDest, 0.0, EdgeFilters.acceptAll());
        if (arrived) {
            if (this.tryIncrementOccTriPoint(kb, occ)) {
                if (this.isOccupantIdling(occ)) {
                    this.d_idlingAgents.remove(occ);
                }
                return true;
            }
            if (this.isOccupantIdling(occ)) {
                return false;
            }
            this.d_idlingAgents.add(occ);
            return true;
        }
        if (this.isOccupantIdling(occ)) {
            this.d_idlingAgents.remove(occ);
            return true;
        }
        return false;
    }

    public TriPoint getLastKnownSteeringDest(OccAgent occ, OccAgent leader) {
        if (leader != null) {
            occ = leader;
        }
        return this.d_lastKnownSteeringDest.get(occ);
    }

    public boolean isOccupantIdling(OccAgent occ) {
        return this.d_idlingAgents.contains(occ);
    }

    public boolean shouldOccupantUpdateSteering(OccAgent occ, OccAgent leader) {
        if (leader != null) {
            occ = leader;
        }
        return this.d_needsNewSteering.contains(occ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnprocessedOccupant(OccAgent occ, QMetaQueue.ProcessOption choice) {
        if (choice.leader != null && choice.leader != occ) {
            return;
        }
        if (this.d_occPathsMap.containsKey(occ)) {
            return;
        }
        if (choice.temporary) {
            Map<OccAgent, QMetaQueue.ProcessOption> map = this.d_unprocessedLeaderContenders;
            synchronized (map) {
                this.d_unprocessedLeaderContenders.put(occ, choice);
            }
        } else {
            choice.chosenQ.addUnprocessedOccupant(occ);
        }
    }

    public void markRemoveOccupant(OccAgent occ) {
        if (this.d_occPathsMap.containsKey(occ)) {
            this.d_occPathsMap.get(occ).markRemoveOccupant(occ);
            this.d_occPathsMap.remove(occ);
        }
        if (this.d_lastKnownSteeringDest.containsKey(occ)) {
            this.d_lastKnownSteeringDest.remove(occ);
        }
    }

    public boolean isOccupantServicing(OccAgent agent) {
        return this.d_occServiceMap.containsKey(agent);
    }

    public boolean canInterruptOccupant(OccAgent agent) {
        return !this.isOccupantServicing(agent) && this.d_occPathsMap.containsKey(agent);
    }
}

